// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_TREEROWREFERENCE_H
#define _GTKMM_TREEROWREFERENCE_H

#include <glibmm.h>

/* $Id: treerowreference.hg,v 1.1 2002/08/05 18:41:59 murrayc Exp $ */

/* treerowreference.h
 *
 * Copyright (C) 2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

extern "C" { typedef struct _GtkTreeRowReference GtkTreeRowReference; }

#include <gtkmm/treemodel.h>
#include <gtkmm/treepath.h>


namespace Gtk
{

/** Typedefed as Gtk::TreeModel::RowReference.
 * This reference will keep pointing to
 * the node pointed to by the Path, so long as it exists.  It listens to all
 * signals emitted by the Model, and updates its Path appropriately.
 * @ingroup TreeView
*/
class TreeRowReference
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef TreeRowReference CppObjectType;
  typedef GtkTreeRowReference BaseObjectType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

private:

  
public:
  TreeRowReference(const Glib::RefPtr<TreeModel> model, const TreeModel::Path& path);
  ~TreeRowReference();

  ///The same as is_valid().
  operator bool();

  
  /** Returns a path that the row reference currently points to, or <tt>0</tt> if the
   * path pointed to is no longer valid.
   * @return A current path, or <tt>0</tt>.
   */
  TreeModel::Path get_path() const;

  ///The same as operator bool.
  
  /** Returns TRUE if the %reference is non-NULL and refers to a current valid
   * path.
   * @return TRUE if %reference points to a valid path.
   */
  bool is_valid() const;

  GtkTreeRowReference* gobj() { return gobject_; }
  const GtkTreeRowReference* gobj() const { return gobject_; }

protected:
  GtkTreeRowReference* gobject_;

private:
  // noncopyable
  TreeRowReference(const TreeRowReference&);
  TreeRowReference& operator=(const TreeRowReference&);


};

} //namespace Gtk


#endif /* _GTKMM_TREEROWREFERENCE_H */

