// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_TREESORTABLE_H
#define _GTKMM_TREESORTABLE_H

#include <glibmm.h>

/* $Id: treesortable.hg,v 1.11 2002/12/02 19:00:42 murrayc Exp $ */


/* Copyright (C) 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/interface.h>
#include <gtkmm/enums.h>
#include <gtkmm/treemodelcolumn.h>
#include <gtkmm/treemodel.h>
#include <gtkmm/treeiter.h>
#include <gtk/gtktreesortable.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkTreeSortable GtkTreeSortable;
typedef struct _GtkTreeSortableClass GtkTreeSortableClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class TreeSortable_Class; } // namespace Gtk
namespace Gtk
{

/**
 * @ingroup TreeView
*/

class TreeSortable : public Glib::Interface
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef TreeSortable CppObjectType;
  typedef TreeSortable_Class CppClassType;
  typedef GtkTreeSortable BaseObjectType;
  typedef GtkTreeSortableIface BaseClassType;

private:
  friend class TreeSortable_Class;
  static CppClassType treesortable_class_;

  // noncopyable
  TreeSortable(const TreeSortable&);
  TreeSortable& operator=(const TreeSortable&);

protected:
  TreeSortable(); // you must derive from this class
  explicit TreeSortable(GtkTreeSortable* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~TreeSortable();

  static void add_interface(GType gtype_implementer);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  GtkTreeSortable*       gobj()       { return reinterpret_cast<GtkTreeSortable*>(gobject_); }
  const GtkTreeSortable* gobj() const { return reinterpret_cast<GtkTreeSortable*>(gobject_); }

private:


public:
  enum { DEFAULT_SORT_COLUMN_ID = -1 };

  
  /** Fills in @a sort_column_id and @a order with the current sort column and the
   * order, if applicable.  If the sort column is not set, then FALSE is returned,
   * and the values in @a sort_column_id and @a order are unchanged.
   * @param sort_column_id The sort column id to be filled in.
   * @param order The Gtk::SortType to be filled in.
   * @return <tt>true</tt>, if the sort column has been set.
   */
  bool get_sort_column_id(int& sort_column_id, SortType& order) const;

  
  /** Sets the current sort column to be @a sort_column_id.  The @a sortable will
   * resort itself to reflect this change, after emitting a
   * GtkTreeSortable::sort_column_changed signal.  If @a sort_column_id is
   * Gtk::TREE_SORTABLE_DEFAULT_SORT_COLUMN_ID, then the default sort function
   * will be used, if it is set.
   * @param sort_column_id The sort column id to set.
   * @param order The sort order of the column.
   */
  void set_sort_column_id(const TreeModelColumnBase& sort_column_id, SortType order);
  
  /** Sets the current sort column to be @a sort_column_id.  The @a sortable will
   * resort itself to reflect this change, after emitting a
   * GtkTreeSortable::sort_column_changed signal.  If @a sort_column_id is
   * Gtk::TREE_SORTABLE_DEFAULT_SORT_COLUMN_ID, then the default sort function
   * will be used, if it is set.
   * @param sort_column_id The sort column id to set.
   * @param order The sort order of the column.
   */
  void set_sort_column_id(int sort_column_id, SortType order);

  typedef SigC::Slot2<int, const Gtk::TreeModel::iterator&, const Gtk::TreeModel::iterator&> SlotCompare;

  
  void set_sort_func(const TreeModelColumnBase& sort_column_id, const SlotCompare& slot);
  void set_sort_func(int sort_column_id, const SlotCompare& slot);
  void set_default_sort_func(const SlotCompare& slot);

  
  /** Returns <tt>true</tt> if the model has a default sort function.  This is used
   * primarily by GtkTreeViewColumns in order to determine if a model can go back
   * to the default state, or not.
   * @return <tt>true</tt>, if the model has a default sort function.
   */
  bool has_default_sort_func() const;

  
  /** Emits a GtkTreeSortable::sort_column_changed signal on
   */
  void sort_column_changed();
  
  /**
   * @par Prototype:
   * <tt>void %sort_column_changed()</tt>
   */
  Glib::SignalProxy0<void> signal_sort_column_changed();


protected:
  
  
  //TODO_API:  _WRAP_VFUNC(void sort_column_changed() const, sort_column_changed)


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
  virtual bool get_sort_column_id_vfunc(int* sort_column_id, SortType* order);
  virtual void set_sort_column_id_vfunc(int sort_column_id, SortType order);
  virtual void set_sort_func_vfunc(int sort_column_id, GtkTreeIterCompareFunc func, void* data, GtkDestroyNotify destroy);
  virtual void set_default_sort_func_vfunc(GtkTreeIterCompareFunc func, void* data, GtkDestroyNotify destroy);
  virtual bool has_default_sort_func_vfunc();

  //Default Signal Handlers::
  virtual void on_sort_column_changed();


};

} // namespace Gtk


namespace Glib
{

/** @relates Gtk::TreeSortable */
Glib::RefPtr<Gtk::TreeSortable> wrap(GtkTreeSortable* object, bool take_copy = false);

} // namespace Glib

#endif /* _GTKMM_TREESORTABLE_H */

