// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_COLORBUTTON_H
#define _GTKMM_COLORBUTTON_H


#include <glibmm.h>

/* $Id: colorbutton.hg,v 1.5 2005/11/30 14:10:49 murrayc Exp $ */

/* colorbutton.h
 *
 * Copyright (C) 2003 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/button.h>
#include <gdkmm/color.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkColorButton GtkColorButton;
typedef struct _GtkColorButtonClass GtkColorButtonClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class ColorButton_Class; } // namespace Gtk
namespace Gtk
{

/** A button to launch a color selection dialog.
 *
 * The GtkColorButton is a button which displays the currently selected color an allows to
 * open a color selection dialog to change the color. It is suitable widget for selecting a
 * color in a preference dialog.
 *
 * @ingroup Widgets
 */

class ColorButton : public Button
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef ColorButton CppObjectType;
  typedef ColorButton_Class CppClassType;
  typedef GtkColorButton BaseObjectType;
  typedef GtkColorButtonClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~ColorButton();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class ColorButton_Class;
  static CppClassType colorbutton_class_;

  // noncopyable
  ColorButton(const ColorButton&);
  ColorButton& operator=(const ColorButton&);

protected:
  explicit ColorButton(const Glib::ConstructParams& construct_params);
  explicit ColorButton(GtkColorButton* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  GtkColorButton*       gobj()       { return reinterpret_cast<GtkColorButton*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const GtkColorButton* gobj() const { return reinterpret_cast<GtkColorButton*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
  virtual void on_color_set();
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


private:

public:

  /** Creates a new color button.
   * 
   * This creates a widget in the form of a small button containing a swatch representing
   * the current selected color. When the button is clicked, a color-selection dialog will
   * open, allowing the user to select a color. The swatch will be updated to reflect the
   * new color when the user finishes.
   *
   * @newin2p4
   */
  ColorButton();
  
  
  /** Creates a new color button with a predefined color.
   * 
   * Same as Gtk::ColorButton::ColorButton(). Additionally takes a Gdk::Color and
   * initializes the button with this color. Equivalent to calling set_color(@a color)
   * after the default constructor.
   *
   * @param color A Gdk::Color to set the current color with.
   *
   * @newin2p4
   */
  explicit ColorButton(const Gdk::Color& color);

  
  /** Sets the current color to be @a color .
   * 
   * @newin2p4
   * @param color A Gdk::Color to set the current color with.
   */
  void set_color(const Gdk::Color& color);
  
  /** Sets the current opacity to be @a alpha . 
   * 
   * @newin2p4
   * @param alpha An integer between 0 and 65535.
   */
  void set_alpha(guint16 alpha);
  
  /** Returns a copy of the the current color.
   * 
   * Changes to the return value will have no effect on the Gtk::ColorButton.
   *
   * @return A Gdk::Color representing the current internal color of the Gtk::ColorButton.
   *
   * @newin2p4
   */
  Gdk::Color get_color() const;
  
  
  /** Returns the current alpha value.
   * @return An integer between 0 and 65535.
   * 
   * @newin2p4.
   */
  guint16 get_alpha() const;
  
  /** Sets whether or not the color button should use the alpha channel.
   * 
   * @newin2p4
   * @param use_alpha <tt>true</tt> if color button should use alpha channel, <tt>false</tt> if not.
   */
  void set_use_alpha(bool use_alpha = true);
  
  /** Does the color selection dialog use the alpha channel?
   * @return <tt>true</tt> if the color sample uses alpha channel, <tt>false</tt> if not.
   * 
   * @newin2p4.
   */
  bool get_use_alpha() const;
  
  /** Sets the title for the color selection dialog.
   * 
   * @newin2p4
   * @param title String containing new window title.
   */
  void set_title(const Glib::ustring& title);
  
  /** Gets the title of the color selection dialog.
   * 
   * @newin2p4
   * @return The title.
   */
  Glib::ustring get_title() const;

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether or not to give the color an alpha value.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_use_alpha() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether or not to give the color an alpha value.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_use_alpha() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The title of the color selection dialog.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Glib::ustring> property_title() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The title of the color selection dialog.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_title() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The selected color.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Gdk::Color> property_color() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The selected color.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Gdk::Color> property_color() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The selected opacity value (0 fully transparent, 65535 fully opaque).
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<guint16> property_alpha() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The selected opacity value (0 fully transparent, 65535 fully opaque).
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<guint16> property_alpha() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  /** The color_set signal is emitted when the user selects a color. When handling this signal,
   * use get_color() and get_alpha() to find out which color 
   * was just selected.
   */
  
/**
   * @par Prototype:
   * <tt>void %color_set()</tt>
   */

  Glib::SignalProxy0< void > signal_color_set();
                    

};


} // namespace Gtk


namespace Glib
{
  /** @relates Gtk::ColorButton
   * @param object The C instance
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   */
  Gtk::ColorButton* wrap(GtkColorButton* object, bool take_copy = false);
} //namespace Glib


#endif /* _GTKMM_COLORBUTTON_H */

