// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_TOOLTIP_H
#define _GTKMM_TOOLTIP_H


#include <glibmm.h>

/* Copyright (C) 2007 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/object.h>
#include <gdkmm/pixbuf.h>
#include <gtkmm/enums.h>
#include <gtkmm/widget.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkTooltip GtkTooltip;
typedef struct _GtkTooltipClass GtkTooltipClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class Tooltip_Class; } // namespace Gtk
namespace Gtk
{


class Tooltip : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Tooltip CppObjectType;
  typedef Tooltip_Class CppClassType;
  typedef GtkTooltip BaseObjectType;
  typedef GtkTooltipClass BaseClassType;

private:  friend class Tooltip_Class;
  static CppClassType tooltip_class_;

private:
  // noncopyable
  Tooltip(const Tooltip&);
  Tooltip& operator=(const Tooltip&);

protected:
  explicit Tooltip(const Glib::ConstructParams& construct_params);
  explicit Tooltip(GtkTooltip* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Tooltip();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GtkTooltip*       gobj()       { return reinterpret_cast<GtkTooltip*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GtkTooltip* gobj() const { return reinterpret_cast<GtkTooltip*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GtkTooltip* gobj_copy();

private:


public:

  
  /** Sets the text of the tooltip to be @a markup , which is marked up
   * with the Pango text markup language.
   * If @a markup  is <tt>0</tt>, the label will be hidden.
   * 
   * @newin2p12
   * @param markup A markup string (see Pango markup format) or <tt>0</tt>.
   */
  void set_markup(const Glib::ustring& markup);
  
  /** Sets the text of the tooltip to be @a text . If @a text  is <tt>0</tt>, the label
   * will be hidden. See also gtk_tooltip_set_markup().
   * 
   * @newin2p12
   * @param text A text string or <tt>0</tt>.
   */
  void set_text(const Glib::ustring& markup);
  
  /** Sets the icon of the tooltip (which is in front of the text) to be
   *  @a pixbuf .  If @a pixbuf  is <tt>0</tt>, the image will be hidden.
   * 
   * @newin2p12
   * @param pixbuf A Gdk::Pixbuf, or <tt>0</tt>.
   */
  void set_icon(const Glib::RefPtr<Gdk::Pixbuf>& pixbuf);
  
  /** Sets the icon of the tooltip (which is in front of the text) to be
   * the stock item indicated by @a stock_id  with the size indicated
   * by @a size .  If @a stock_id  is <tt>0</tt>, the image will be hidden.
   * 
   * @newin2p12
   * @param stock_id A stock icon name, or <tt>0</tt>.
   * @param size A stock icon size.
   */
  void set_icon_from_stock(const StockID& stock_id, IconSize size);
  
  /** Replaces the widget packed into the tooltip with @a custom_widget .  
   * By default a box with a Gtk::Image and Gtk::Label is embedded in 
   * the tooltip, which can be configured using gtk_tooltip_set_markup() 
   * and gtk_tooltip_set_icon().
   * 
   * @newin2p12
   * @param custom_widget A Gtk::Widget.
   */
  void set_custom(Widget& custom_widget);

  
  static void trigger_tooltip_query(const Glib::RefPtr<Gdk::Display>& display);


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace Gtk


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gtk::Tooltip
   */
  Glib::RefPtr<Gtk::Tooltip> wrap(GtkTooltip* object, bool take_copy = false);
}


#endif /* _GTKMM_TOOLTIP_H */

