// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_TOOLPALETTE_H
#define _GTKMM_TOOLPALETTE_H


#include <glibmm.h>

/* Copyright (C) 2009 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/container.h>
#include <gtkmm/toolitem.h>
#include <gtkmm/orientable.h>
#include <gtkmm/adjustment.h>
#include <gtkmm/toolitemgroup.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkToolPalette GtkToolPalette;
typedef struct _GtkToolPaletteClass GtkToolPaletteClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class ToolPalette_Class; } // namespace Gtk
namespace Gtk
{

/** @addtogroup gtkmmEnums Enums and Flags */

/**
 * @ingroup gtkmmEnums
 * @par Bitwise operators:
 * <tt>%ToolPaletteDragTargets operator|(ToolPaletteDragTargets, ToolPaletteDragTargets)</tt><br>
 * <tt>%ToolPaletteDragTargets operator&(ToolPaletteDragTargets, ToolPaletteDragTargets)</tt><br>
 * <tt>%ToolPaletteDragTargets operator^(ToolPaletteDragTargets, ToolPaletteDragTargets)</tt><br>
 * <tt>%ToolPaletteDragTargets operator~(ToolPaletteDragTargets)</tt><br>
 * <tt>%ToolPaletteDragTargets& operator|=(ToolPaletteDragTargets&, ToolPaletteDragTargets)</tt><br>
 * <tt>%ToolPaletteDragTargets& operator&=(ToolPaletteDragTargets&, ToolPaletteDragTargets)</tt><br>
 * <tt>%ToolPaletteDragTargets& operator^=(ToolPaletteDragTargets&, ToolPaletteDragTargets)</tt><br>
 */
enum ToolPaletteDragTargets
{
  TOOL_PALETTE_DRAG_ITEMS = 1 << 0,
  TOOL_PALETTE_DRAG_GROUPS = 1 << 1
};

/** @ingroup gtkmmEnums */
inline ToolPaletteDragTargets operator|(ToolPaletteDragTargets lhs, ToolPaletteDragTargets rhs)
  { return static_cast<ToolPaletteDragTargets>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gtkmmEnums */
inline ToolPaletteDragTargets operator&(ToolPaletteDragTargets lhs, ToolPaletteDragTargets rhs)
  { return static_cast<ToolPaletteDragTargets>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gtkmmEnums */
inline ToolPaletteDragTargets operator^(ToolPaletteDragTargets lhs, ToolPaletteDragTargets rhs)
  { return static_cast<ToolPaletteDragTargets>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup gtkmmEnums */
inline ToolPaletteDragTargets operator~(ToolPaletteDragTargets flags)
  { return static_cast<ToolPaletteDragTargets>(~static_cast<unsigned>(flags)); }

/** @ingroup gtkmmEnums */
inline ToolPaletteDragTargets& operator|=(ToolPaletteDragTargets& lhs, ToolPaletteDragTargets rhs)
  { return (lhs = static_cast<ToolPaletteDragTargets>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup gtkmmEnums */
inline ToolPaletteDragTargets& operator&=(ToolPaletteDragTargets& lhs, ToolPaletteDragTargets rhs)
  { return (lhs = static_cast<ToolPaletteDragTargets>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup gtkmmEnums */
inline ToolPaletteDragTargets& operator^=(ToolPaletteDragTargets& lhs, ToolPaletteDragTargets rhs)
  { return (lhs = static_cast<ToolPaletteDragTargets>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::ToolPaletteDragTargets> : public Glib::Value_Flags<Gtk::ToolPaletteDragTargets>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{


/** A ToolPalette allows you to add ToolItems to a palette-like container with 
 * various categories and drag and drop support.
 *
 * ToolItems cannot be added directly to a ToolPalette - instead they are added 
 * to a ToolItemGroup which can than be added to a ToolPalette. To add a 
 * ToolItemGroup to a ToolPalette, use Gtk::Container::add(). 
 *
 * The easiest way to use drag and drop with ToolPalette is to call 
 * add_drag_dest() with the desired drag source palette and the desired drag 
 * target widget. Then get_drag_item() can be used to get the dragged item in 
 * the "drag-data-received" signal handler of the drag target.
 *
 * @ingroup Widgets
 * @ingroup Containers
 */

class ToolPalette
: public Container,
  public Orientable
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef ToolPalette CppObjectType;
  typedef ToolPalette_Class CppClassType;
  typedef GtkToolPalette BaseObjectType;
  typedef GtkToolPaletteClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~ToolPalette();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class ToolPalette_Class;
  static CppClassType toolpalette_class_;

  // noncopyable
  ToolPalette(const ToolPalette&);
  ToolPalette& operator=(const ToolPalette&);

protected:
  explicit ToolPalette(const Glib::ConstructParams& construct_params);
  explicit ToolPalette(GtkToolPalette* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  GtkToolPalette*       gobj()       { return reinterpret_cast<GtkToolPalette*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const GtkToolPalette* gobj() const { return reinterpret_cast<GtkToolPalette*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


private:

  
public:
  ToolPalette();

//This conversion is needed because of https://bugzilla.gnome.org/show_bug.cgi?id=567729#c37
 

  void set_group_position(ToolItemGroup& group, int position);
  
  void set_exclusive(ToolItemGroup& group, bool exclusive);
  
  void set_expand(ToolItemGroup& group, bool expand = true);

  
  int get_group_position(ToolItemGroup& group) const;
  
  bool get_exclusive(ToolItemGroup& group) const;
  
  bool get_expand(ToolItemGroup& group);

  
  void set_icon_size(IconSize icon_size);
  
  void unset_icon_size();
  
  void set_style(ToolbarStyle style);
  
  void unset_style();

  
  IconSize get_icon_size();
  
  ToolbarStyle get_style() const;

  
  ToolItem* get_drop_item(int x, int y);

//This conversion is needed because of https://bugzilla.gnome.org/show_bug.cgi?id=567729#c37
 

  ToolItemGroup* get_drop_group(int x, int y);
  
  const ToolItemGroup* get_drop_group(int x, int y) const;

  
  ToolItem* get_drag_item(const SelectionData& selection);
  
  const ToolItem* get_drag_item(const SelectionData& selection) const;

  
  void set_drag_source(ToolPaletteDragTargets targets);
  
  void add_drag_dest(Gtk::Widget& widget, DestDefaults flags, ToolPaletteDragTargets targets, Gdk::DragAction actions);

  
  Adjustment* get_hadjustment();
  
  const Adjustment* get_hadjustment() const;
  
  Adjustment* get_vadjustment ();
  
  const Adjustment* get_vadjustment () const;


  static TargetEntry get_drag_target_item();
  
  static TargetEntry get_drag_target_group();
  
  //TODO: Ignore this? It's in many widgets and seems internals.
  //Ignore action signal: _WRAP_SIGNAL(void set_scroll_adjustments(Adjustment* hadjustment, Adjustment* vadjustment), "set-scroll-adjustments")

  //gtkmmproc error: icon-size : property defs lookup failed.
  //gtkmmproc error: icon-size-set : property defs lookup failed.
  //gtkmmproc error: toolbar-style : property defs lookup failed.
  //gtkmmproc error: exclusive : property defs lookup failed.


};

} // namespace Gtk


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gtk::ToolPalette
   */
  Gtk::ToolPalette* wrap(GtkToolPalette* object, bool take_copy = false);
} //namespace Glib


#endif /* _GTKMM_TOOLPALETTE_H */

