// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_UIMANAGER_H
#define _GTKMM_UIMANAGER_H

#include <glibmm.h>

/* $Id: uimanager.hg,v 1.7 2004/02/14 13:52:00 murrayc Exp $ */

/* Copyright (C) 2003 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/widget.h>
#include <gtkmm/action.h>
#include <gtkmm/actiongroup.h>
#include <gtkmm/uimanager.h>
 

#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkUIManager GtkUIManager;
typedef struct _GtkUIManagerClass GtkUIManagerClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class UIManager_Class; } // namespace Gtk
namespace Gtk
{

/** @addtogroup gtkmmEnums Enums and Flags */

/**
 * @ingroup gtkmmEnums
 * @par Bitwise operators:
 * <tt>%UIManagerItemType operator|(UIManagerItemType, UIManagerItemType)</tt><br>
 * <tt>%UIManagerItemType operator&(UIManagerItemType, UIManagerItemType)</tt><br>
 * <tt>%UIManagerItemType operator^(UIManagerItemType, UIManagerItemType)</tt><br>
 * <tt>%UIManagerItemType operator~(UIManagerItemType)</tt><br>
 * <tt>%UIManagerItemType& operator|=(UIManagerItemType&, UIManagerItemType)</tt><br>
 * <tt>%UIManagerItemType& operator&=(UIManagerItemType&, UIManagerItemType)</tt><br>
 * <tt>%UIManagerItemType& operator^=(UIManagerItemType&, UIManagerItemType)</tt><br>
 */
enum UIManagerItemType
{
  UI_MANAGER_AUTO = 0,
  UI_MANAGER_MENUBAR = 1 << 0,
  UI_MANAGER_MENU = 1 << 1,
  UI_MANAGER_TOOLBAR = 1 << 2,
  UI_MANAGER_PLACEHOLDER = 1 << 3,
  UI_MANAGER_POPUP = 1 << 4,
  UI_MANAGER_MENUITEM = 1 << 5,
  UI_MANAGER_TOOLITEM = 1 << 6,
  UI_MANAGER_SEPARATOR = 1 << 7,
  UI_MANAGER_ACCELERATOR = 1 << 8
};

/** @ingroup gtkmmEnums */
inline UIManagerItemType operator|(UIManagerItemType lhs, UIManagerItemType rhs)
  { return static_cast<UIManagerItemType>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gtkmmEnums */
inline UIManagerItemType operator&(UIManagerItemType lhs, UIManagerItemType rhs)
  { return static_cast<UIManagerItemType>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gtkmmEnums */
inline UIManagerItemType operator^(UIManagerItemType lhs, UIManagerItemType rhs)
  { return static_cast<UIManagerItemType>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup gtkmmEnums */
inline UIManagerItemType operator~(UIManagerItemType flags)
  { return static_cast<UIManagerItemType>(~static_cast<unsigned>(flags)); }

/** @ingroup gtkmmEnums */
inline UIManagerItemType& operator|=(UIManagerItemType& lhs, UIManagerItemType rhs)
  { return (lhs = static_cast<UIManagerItemType>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup gtkmmEnums */
inline UIManagerItemType& operator&=(UIManagerItemType& lhs, UIManagerItemType rhs)
  { return (lhs = static_cast<UIManagerItemType>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup gtkmmEnums */
inline UIManagerItemType& operator^=(UIManagerItemType& lhs, UIManagerItemType rhs)
  { return (lhs = static_cast<UIManagerItemType>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::UIManagerItemType> : public Glib::Value_Flags<Gtk::UIManagerItemType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{


class UIManager : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef UIManager CppObjectType;
  typedef UIManager_Class CppClassType;
  typedef GtkUIManager BaseObjectType;
  typedef GtkUIManagerClass BaseClassType;

private:  friend class UIManager_Class;
  static CppClassType uimanager_class_;

private:
  // noncopyable
  UIManager(const UIManager&);
  UIManager& operator=(const UIManager&);

protected:
  explicit UIManager(const Glib::ConstructParams& construct_params);
  explicit UIManager(GtkUIManager* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~UIManager();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GtkUIManager*       gobj()       { return reinterpret_cast<GtkUIManager*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GtkUIManager* gobj() const { return reinterpret_cast<GtkUIManager*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GtkUIManager* gobj_copy();

private:


  UIManager();
public:
  
  static Glib::RefPtr<UIManager> create();


  /** Sets the "add_tearoffs" property, which controls whether menus 
   * generated by this Gtk::UIManager will have tearoff menu items. 
   * 
   * Note that this only affects regular menus. Generated popup 
   * menus never have tearoff menu items.
   * 
   * Since: 2.4
   * @param add_tearoffs Whether tearoff menu items are added.
   */
  void set_add_tearoffs(bool add_tearoffs = true);
  
  /** Returns whether menus generated by this Gtk::UIManager
   * will have tearoff menu items.
   * @return Whether tearoff menu items are added
   * 
   * Since: 2.4.
   */
  bool get_add_tearoffs() const;
  
  /** Inserts an action group into the list of action groups associated 
   * with @a self . Actions in earlier groups hide actions with the same 
   * name in later groups. 
   * 
   * Since: 2.4
   * @param action_group The action group to be inserted.
   * @param pos The position at which the group will be inserted.
   */
  void insert_action_group(const Glib::RefPtr<ActionGroup>& action_group, int pos = 0);
  
  /** Removes an action group from the list of action groups associated 
   * with @a self .
   * 
   * Since: 2.4
   * @param action_group The action group to be removed.
   */
  void remove_action_group(const Glib::RefPtr<ActionGroup>& action_group);

  
  /** Returns the list of action groups associated with @a self .
   * @return A G::List of action groups. The list is owned by GTK+ 
   * and should not be modified.
   * 
   * Since: 2.4.
   */
  Glib::ListHandle< Glib::RefPtr<ActionGroup> > get_action_groups();
  
  /** Returns the list of action groups associated with @a self .
   * @return A G::List of action groups. The list is owned by GTK+ 
   * and should not be modified.
   * 
   * Since: 2.4.
   */
  Glib::ListHandle< Glib::RefPtr<const ActionGroup> > get_action_groups() const;
  
  
  /** Returns the Gtk::AccelGroup associated with @a self .
   * @return The Gtk::AccelGroup.
   * 
   * Since: 2.4.
   */
  Glib::RefPtr<AccelGroup> get_accel_group();
  
  /** Returns the Gtk::AccelGroup associated with @a self .
   * @return The Gtk::AccelGroup.
   * 
   * Since: 2.4.
   */
  Glib::RefPtr<const AccelGroup> get_accel_group() const;
  
  /** Looks up a widget by following a path. 
   * The path consists of the names specified in the XML description of the UI. 
   * separated by '/'. Elements which don't have a name or action attribute in 
   * the XML (e.g. &lt;popup&gt;) can be addressed by their XML element name 
   * (e.g. "popup"). The root element ("/ui") can be omitted in the path.
   * @param path A path.
   * @return The widget found by following the path, or <tt>0</tt> if no widget
   * was found.
   * 
   * Since: 2.4.
   */
  Widget* get_widget(const Glib::ustring& path);
  
  /** Looks up a widget by following a path. 
   * The path consists of the names specified in the XML description of the UI. 
   * separated by '/'. Elements which don't have a name or action attribute in 
   * the XML (e.g. &lt;popup&gt;) can be addressed by their XML element name 
   * (e.g. "popup"). The root element ("/ui") can be omitted in the path.
   * @param path A path.
   * @return The widget found by following the path, or <tt>0</tt> if no widget
   * was found.
   * 
   * Since: 2.4.
   */
  const Widget* get_widget(const Glib::ustring& path) const;

  
  Glib::SListHandle<Widget*> get_toplevels(UIManagerItemType types);
  
  Glib::SListHandle<const Widget*> get_toplevels(UIManagerItemType types) const;
                 
  
  /** Looks up an action by following a path. See gtk_ui_manager_get_widget()
   * for more information about paths.
   * @param path A path.
   * @return The action whose proxy widget is found by following the path, 
   * or <tt>0</tt> if no widget was found.
   * 
   * Since: 2.4.
   */
  Glib::RefPtr<Action> get_action(const Glib::ustring& path);
  
  /** Looks up an action by following a path. See gtk_ui_manager_get_widget()
   * for more information about paths.
   * @param path A path.
   * @return The action whose proxy widget is found by following the path, 
   * or <tt>0</tt> if no widget was found.
   * 
   * Since: 2.4.
   */
  Glib::RefPtr<const Action> get_action(const Glib::ustring& path) const;
  
  guint add_ui_from_string(const Glib::ustring& buffer);
  
  
  /** Parses a file containing a UI definition and 
   * merges it with the current contents of @a self .
   * @param filename The name of the file to parse.
   * @param error Return location for an error.
   * @return The merge id for the merged UI. The merge id can be used
   * to unmerge the UI with gtk_ui_manager_remove_ui(). If an error occurred,
   * the return value is 0.
   * 
   * Since: 2.4.
   */
  guint add_ui_from_file(const Glib::ustring& filename);

//TODO: Is top=true a good default?
  typedef guint ui_merge_id;
  
  /** Adds a UI element to the current contents of @a self . 
   * 
   * If @a type  is Gtk::UI_MANAGER_AUTO, GTK+ inserts a menuitem, toolitem or 
   * separator if such an element can be inserted at the place determined by 
   *  @a path . Otherwise @a type  must indicate an element that can be inserted at 
   * the place determined by @a path .
   * 
   * Since: 2.4
   * @param merge_id The merge id for the merged UI, see gtk_ui_manager_new_merge_id().
   * @param path A path.
   * @param name The name for the added UI element.
   * @param action The name of the action to be proxied, or <tt>0</tt> to add a separator.
   * @param type The type of UI element to add.
   * @param top If <tt>true</tt>, the UI element is added before its siblings, otherwise it 
   * is added after its siblings.
   */
  void add_ui(ui_merge_id merge_id, const Glib::ustring& path, const Glib::ustring& name, const Glib::ustring& action, UIManagerItemType type, bool top = true);
  
  /** Unmerges the part of @a self &lt;!-- --&gt;s content identified by @a merge_id .
   * 
   * Since: 2.4
   * @param merge_id A merge id as returned by gtk_ui_manager_add_ui_from_string().
   */
  void remove_ui(ui_merge_id merge_id);
  
  /** Creates a UI definition of the merged UI.
   * @return A newly allocated string containing an XML representation of 
   * the merged UI.
   * 
   * Since: 2.4.
   */
  Glib::ustring get_ui() const;
  
  /** Makes sure that all pending updates to the UI have been completed.
   * 
   * This may occasionally be necessary, since Gtk::UIManager updates the 
   * UI in an idle function. A typical example where this function is
   * useful is to enforce that the menubar and toolbar have been added to 
   * the main window before showing it:
   * @code
   * 
   * gtk_container_add (GTK_CONTAINER (window), vbox); 
   * g_signal_connect (merge, "add_widget", 
   * G_CALLBACK (add_widget), vbox);
   * gtk_ui_manager_add_ui_from_file (merge, "my-menus");
   * gtk_ui_manager_add_ui_from_file (merge, "my-toolbars");
   * gtk_ui_manager_ensure_update (merge);  
   * gtk_widget_show (window);
   * 
   * @endcode
   * 
   * Since: 2.4
   */
  void ensure_update();
  
  /** Returns an unused merge id, suitable for use with 
   * gtk_ui_manager_add_ui().
   * @return An unused merge id.
   * 
   * Since: 2.4.
   */
  ui_merge_id new_merge_id();


  Glib::SignalProxy1< void,Widget* > signal_add_widget();

  
  Glib::SignalProxy0< void > signal_actions_changed();

  
  Glib::SignalProxy2< void,const Glib::RefPtr<Action>&,Widget* > signal_connect_proxy();

  
  Glib::SignalProxy2< void,const Glib::RefPtr<Action>&,Widget* > signal_disonnect_proxy();

  
  Glib::SignalProxy1< void,const Glib::RefPtr<Action>& > signal_pre_activate();

  
  Glib::SignalProxy1< void,const Glib::RefPtr<Action>& > signal_post_activate();


    /** You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_add_tearoffs() ;

  /** You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_add_tearoffs() const;

    /** You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_ui() const;


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  virtual void on_add_widget(Widget* widget);
  virtual void on_actions_changed();


};

} // namespace Gtk


namespace Glib
{
  /** @relates Gtk::UIManager
   * @param object The C instance
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   */
  Glib::RefPtr<Gtk::UIManager> wrap(GtkUIManager* object, bool take_copy = false);
}


#endif /* _GTKMM_UIMANAGER_H */

