// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _PANGOMM_RENDERER_H
#define _PANGOMM_RENDERER_H

#include <glibmm.h>

/* $Id: renderer.hg,v 1.1 2004/12/01 11:46:29 murrayc Exp $ */

/* renderer.h
 *
 * Copyright(C) 2004 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or(at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include <glibmm/object.h>
#include <pangomm/context.h>
#include <pangomm/glyphstring.h>
#include <pangomm/layout.h>
#include <pangomm/layoutline.h>
#include <pangomm/types.h> //For Matrix.


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _PangoRenderer PangoRenderer;
typedef struct _PangoRendererClass PangoRendererClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Pango
{ class Renderer_Class; } // namespace Pango
namespace Pango
{


/** @addtogroup pangommEnums Enums and Flags */

/**
 * @ingroup pangommEnums
 */
enum RenderPart
{
  RENDER_PART_FOREGROUND,
  RENDER_PART_BACKGROUND,
  RENDER_PART_UNDERLINE,
  RENDER_PART_STRIKETHROUGH
};

} // namespace Pango


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Pango::RenderPart> : public Glib::Value_Enum<Pango::RenderPart>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Pango
{


/** TODO.
 */

class Renderer : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Renderer CppObjectType;
  typedef Renderer_Class CppClassType;
  typedef PangoRenderer BaseObjectType;
  typedef PangoRendererClass BaseClassType;

private:  friend class Renderer_Class;
  static CppClassType renderer_class_;

private:
  // noncopyable
  Renderer(const Renderer&);
  Renderer& operator=(const Renderer&);

protected:
  explicit Renderer(const Glib::ConstructParams& construct_params);
  explicit Renderer(PangoRenderer* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Renderer();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  PangoRenderer*       gobj()       { return reinterpret_cast<PangoRenderer*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const PangoRenderer* gobj() const { return reinterpret_cast<PangoRenderer*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  PangoRenderer* gobj_copy();

private:

 
protected:
 
public:

  //TODO: Should some of these parameters be const?:
  
  void draw_layout(const Glib::RefPtr<Layout>& layout, int x, int y);
  
  void draw_layout_line(const Glib::RefPtr<LayoutLine>& line, int x, int y);
  
  void draw_glyphs(const Glib::RefPtr<Font>& font, const GlyphString& glyphs, int x, int y);
  
  void draw_rectangle(RenderPart part, int x, int y, int width, int height);
  
  void draw_error_underline(int x, int y, int width, int height);
  
  void draw_trapezoid(RenderPart part, double y1, double x11, double x21, double y2, double x12, double x22);
  
  void draw_glyph(const Glib::RefPtr<Font>& font, Glyph glyph, double x, double y);

  
  void activate();
  
  void deactivate();

  
  void part_changed(RenderPart part);

  
  void set_color(RenderPart part, const Color& color);
  //TODO: _WRAP_METHOD(Color get_color(RenderPart part) const, pango_renderer_get_color)

  
  void set_matrix(const Matrix& matrix);
  //TOOD: _WRAP_METHOD(Matrix get_matrix(), pango_renderer_get_matrix)


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} /* namespace Pango */


namespace Glib
{
  /** @relates Pango::Renderer
   * @param object The C instance
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   */
  Glib::RefPtr<Pango::Renderer> wrap(PangoRenderer* object, bool take_copy = false);
}


#endif /* _PANGOMM_RENDERER_H */

