// Generated by gtkmmproc -- DO NOT MODIFY!


#include <gdkmm/display.h>
#include <gdkmm/private/display_p.h>

#include <gdk/gdkenumtypes.h>
// -*- c++ -*-
/* $Id: display.ccg,v 1.5 2005/01/05 17:30:16 murrayc Exp $ */

/*
 *
 * Copyright 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gdkmm/window.h>
#include <gdk/gdkdisplay.h>

namespace Gdk
{

bool Display::set_selection_owner(const Glib::RefPtr<Window>& owner, Glib::ustring& selection, guint32 time_, bool send_event)
{
  return gdk_selection_owner_set_for_display(gobj(), owner->gobj(), Gdk::AtomString::to_c_type(selection), time_, (gboolean)send_event);
}

Glib::RefPtr<Window> Display::get_selection_owner(const Glib::ustring& selection)
{
  return Glib::wrap( (GdkWindowObject*)gdk_selection_owner_get_for_display(gobj(), Gdk::AtomString::to_c_type(selection)) , true);
}

void Display::selection_send_notify(guint32 requestor, Glib::ustring& selection, Glib::ustring& target, Glib::ustring& property, guint32 time_)
{
  gdk_selection_send_notify_for_display(gobj(), requestor, Gdk::AtomString::to_c_type(selection), Gdk::AtomString::to_c_type(target), Gdk::AtomString::to_c_type(property), time_);
}

void Display::get_pointer(Glib::RefPtr<Screen>& screen, int& x, int& y, ModifierType& mask)
{
  GdkScreen* cScreen = 0;
  GdkModifierType cMask = (GdkModifierType)mask;
  gdk_display_get_pointer(gobj(), &cScreen, &x, &y, &cMask);
  screen = Glib::wrap(cScreen);
  mask = (ModifierType)cMask;
}

void Display::get_pointer(int& x, int& y, ModifierType& mask)
{
  GdkModifierType cMask = (GdkModifierType)mask;
  gdk_display_get_pointer(gobj(), 0, &x, &y, &cMask);
  mask = (ModifierType)cMask;
}


Glib::RefPtr<Window> Display::get_window_at_pointer()
{

  Glib::RefPtr<Window> retvalue = Glib::wrap((GdkWindowObject*)(gdk_display_get_window_at_pointer(gobj(), 0, 0)));

  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<const Window> Display::get_window_at_pointer() const
{

  Glib::RefPtr<const Window> retvalue = Glib::wrap((GdkWindowObject*)(gdk_display_get_window_at_pointer(const_cast<GdkDisplay*>(gobj()), 0, 0)));

  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

GdkDisplayPointerHooks*  Display::unset_pointer_hooks()
{
  return gdk_display_set_pointer_hooks(gobj(), 0 /* See GDK docs */);  
}

 void Display::store_clipboard(const Glib::RefPtr<Gdk::Window>& clipboard_window, guint32 time_)
 {
   gdk_display_store_clipboard(gobj(), clipboard_window->gobj(), time_, 0 /* see the C docs */, 0);
 }
  
 void Display::store_clipboard(const Glib::RefPtr<Gdk::Window>& clipboard_window, guint32 time_, const Glib::StringArrayHandle& targets)
 {
   //Put it into a real container that we can use:
   std::vector<Glib::ustring> targets_copy = targets;
   
   //Create array of target GdkAtoms from target strings:
   if(!targets_copy.empty())
   {
     GdkAtom* pAtoms = new GdkAtom[targets_copy.size()];
     
     for(guint i = 0; i < targets_copy.size(); ++i)
     {
       *pAtoms = Gdk::AtomString::to_c_type(targets_copy[i]);
     }
 
     gdk_display_store_clipboard(gobj(), clipboard_window->gobj(), time_, 0 /* see the C docs */, 0);
     
     delete[] pAtoms;
   }
 }

} //Gdk


namespace
{


static void Display_signal_closed_callback(GdkDisplay* self, gboolean p0,void* data)
{
  using namespace Gdk;
  typedef sigc::slot< void,bool > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(p0
);
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }
}

static const Glib::SignalProxyInfo Display_signal_closed_info =
{
  "closed",
  (GCallback) &Display_signal_closed_callback,
  (GCallback) &Display_signal_closed_callback
};


} // anonymous namespace


namespace Glib
{

Glib::RefPtr<Gdk::Display> wrap(GdkDisplay* object, bool take_copy)
{
  return Glib::RefPtr<Gdk::Display>( dynamic_cast<Gdk::Display*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Gdk
{


/* The *_Class implementation: */

const Glib::Class& Display_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &Display_Class::class_init_function;

    // This is actually just optimized away, apparently with no harm.
    // Make sure that the parent type has been created.
    //CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gdk_display_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:
  }

  return *this;
}

void Display_Class::class_init_function(void* g_class, void* class_data)
{
  BaseClassType *const klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);

#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
  klass->closed = &closed_callback;
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
}

#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
void Display_Class::closed_callback(GdkDisplay* self, gboolean p0)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj && obj->is_derived_())
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try // Trap C++ exceptions which would normally be lost because this is a C callback.
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      // Call the virtual member method, which derived classes might override.
      obj->on_closed(p0
);
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

    // Call the original underlying C function:
    if(base && base->closed)
      (*base->closed)(self, p0);
  }
}
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


Glib::ObjectBase* Display_Class::wrap_new(GObject* object)
{
  return new Display((GdkDisplay*)object);
}


/* The implementation: */

GdkDisplay* Display::gobj_copy()
{
  reference();
  return gobj();
}

Display::Display(const Glib::ConstructParams& construct_params)
:
  Glib::Object(construct_params)
{}

Display::Display(GdkDisplay* castitem)
:
  Glib::Object((GObject*)(castitem))
{}

Display::~Display()
{}


Display::CppClassType Display::display_class_; // initialize static member

GType Display::get_type()
{
  return display_class_.init().get_type();
}

GType Display::get_base_type()
{
  return gdk_display_get_type();
}


Display::Display()
:
  Glib::ObjectBase(0), //Mark this class as gtkmmproc-generated, rather than a custom class, to allow vfunc optimisations.
  Glib::Object(Glib::ConstructParams(display_class_.init()))
{
  }

Glib::RefPtr<Display> Display::open(const Glib::ustring& display_name)
{

  Glib::RefPtr<Display> retvalue = Glib::wrap(gdk_display_open(display_name.c_str()));

  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}


Glib::ustring Display::get_name() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(gdk_display_get_name(const_cast<GdkDisplay*>(gobj())));
}

int Display::get_n_screens() const
{
  return gdk_display_get_n_screens(const_cast<GdkDisplay*>(gobj()));
}

Glib::RefPtr<Screen> Display::get_screen(int screen_num)
{

  Glib::RefPtr<Screen> retvalue = Glib::wrap(gdk_display_get_screen(gobj(), screen_num));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;

}

Glib::RefPtr<const Screen> Display::get_screen(int screen_num) const
{
  return const_cast<Display*>(this)->get_screen(screen_num);
}

Glib::RefPtr<Screen> Display::get_default_screen()
{

  Glib::RefPtr<Screen> retvalue = Glib::wrap(gdk_display_get_default_screen(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;

}

Glib::RefPtr<const Screen> Display::get_default_screen() const
{
  return const_cast<Display*>(this)->get_default_screen();
}

void Display::pointer_ungrab(guint32 timestamp)
{
gdk_display_pointer_ungrab(gobj(), timestamp); 
}

void Display::keyboard_ungrab(guint32 timestamp)
{
gdk_display_keyboard_ungrab(gobj(), timestamp); 
}

bool Display::pointer_is_grabbed() const
{
  return gdk_display_pointer_is_grabbed(const_cast<GdkDisplay*>(gobj()));
}

void Display::beep()
{
gdk_display_beep(gobj()); 
}

void Display::sync()
{
gdk_display_sync(gobj()); 
}

void Display::close()
{
gdk_display_close(gobj()); 
}

Glib::ListHandle< Glib::RefPtr<Device> > Display::list_devices()
{
  return Glib::ListHandle< Glib::RefPtr<Device> >(gdk_display_list_devices(gobj()), Glib::OWNERSHIP_NONE);
}

Glib::ListHandle< Glib::RefPtr<const Device> > Display::list_devices() const
{
  return Glib::ListHandle< Glib::RefPtr<const Device> >(gdk_display_list_devices(const_cast<GdkDisplay*>(gobj())), Glib::OWNERSHIP_NONE);
}

GdkEvent* Display::get_event()
{
  return gdk_display_get_event(gobj());
}

const GdkEvent* Display::get_event() const
{
  return const_cast<Display*>(this)->get_event();
}

GdkEvent* Display::peek_event()
{
  return gdk_display_peek_event(gobj());
}

GdkEvent* Display::peek_event() const
{
  return const_cast<Display*>(this)->peek_event();
}

void Display::put_event(GdkEvent* event)
{
gdk_display_put_event(gobj(), event); 
}

void Display::add_client_message_filter(Glib::ustring& message_type, GdkFilterFunc func, gpointer data)
{
gdk_display_add_client_message_filter(gobj(), Gdk::AtomString::to_c_type(message_type), func, data); 
}

void Display::set_double_click_time(guint msec)
{
gdk_display_set_double_click_time(gobj(), msec); 
}

void Display::set_double_click_distance(guint distance)
{
gdk_display_set_double_click_distance(gobj(), distance); 
}

Glib::RefPtr<Display> Display::get_default()
{

  Glib::RefPtr<Display> retvalue = Glib::wrap(gdk_display_get_default());

  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}


Glib::RefPtr<Device> Display::get_core_pointer()
{

  Glib::RefPtr<Device> retvalue = Glib::wrap(gdk_display_get_core_pointer(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;

}

Glib::RefPtr<const Device> Display::get_core_pointer() const
{

  Glib::RefPtr<const Device> retvalue = Glib::wrap(gdk_display_get_core_pointer(const_cast<GdkDisplay*>(gobj())));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;

}

Glib::RefPtr<Window> Display::get_window_at_pointer(int& win_x, int& win_y)
{

  Glib::RefPtr<Window> retvalue = Glib::wrap((GdkWindowObject*)(gdk_display_get_window_at_pointer(gobj(), &win_x, &win_y)));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;

}

Glib::RefPtr<const Window> Display::get_window_at_pointer(int& win_x, int& win_y) const
{
  return const_cast<Display*>(this)->get_window_at_pointer(win_x, win_y);
}

void Display::warp_pointer(const Glib::RefPtr<Screen>& screen, int x, int y)
{
gdk_display_warp_pointer(gobj(), Glib::unwrap(screen), x, y); 
}

GdkDisplayPointerHooks* Display::set_pointer_hooks(const GdkDisplayPointerHooks* new_hooks)
{
  return gdk_display_set_pointer_hooks(gobj(), new_hooks);
}

Glib::RefPtr<Display> Display::open_default_libgtk_only()
{

  Glib::RefPtr<Display> retvalue = Glib::wrap(gdk_display_open_default_libgtk_only());

  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}


guint32 Display::get_drag_protocol(guint32 xid, GdkDragProtocol& protocol)
{
  return gdk_drag_get_protocol_for_display(gobj(), xid, &(protocol));
}

GdkKeymap* Display::get_keymap()
{
  return gdk_keymap_get_for_display(gobj());
}

const GdkKeymap* Display::get_keymap() const
{
  return const_cast<Display*>(this)->get_keymap();
}

Glib::RefPtr<Pixmap> Display::lookup_pixmap(NativeWindow anid)
{
  return Glib::wrap((GdkPixmapObject*)(gdk_pixmap_lookup_for_display(gobj(), (GdkNativeWindow)(anid))));
}

Glib::RefPtr<const Pixmap> Display::lookup_pixmap(NativeWindow anid) const
{
  return const_cast<Display*>(this)->lookup_pixmap(anid);
}

void Display::flush()
{
gdk_display_flush(gobj()); 
}

bool Display::supports_cursor_alpha() const
{
  return gdk_display_supports_cursor_alpha(const_cast<GdkDisplay*>(gobj()));
}

bool Display::supports_cursor_color() const
{
  return gdk_display_supports_cursor_color(const_cast<GdkDisplay*>(gobj()));
}

guint Display::get_default_cursor_size() const
{
  return gdk_display_get_default_cursor_size(const_cast<GdkDisplay*>(gobj()));
}

void Display::get_maximal_cursor_size(guint& width, guint& height)
{
gdk_display_get_maximal_cursor_size(gobj(), &(width), &(height)); 
}

Glib::RefPtr<Window> Display::get_default_group()
{

  Glib::RefPtr<Window> retvalue = Glib::wrap((GdkWindowObject*)(gdk_display_get_default_group(gobj())));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;

}

Glib::RefPtr<const Window> Display::get_default_group() const
{
  return const_cast<Display*>(this)->get_default_group();
}

bool Display::supports_selection_notification() const
{
  return gdk_display_supports_selection_notification(const_cast<GdkDisplay*>(gobj()));
}

bool Display::request_selection_notification(const Glib::ustring& selection)
{
  return gdk_display_request_selection_notification(gobj(), Gdk::AtomString::to_c_type(selection));
}

bool Display::supports_clipboard_persistence() const
{
  return gdk_display_supports_clipboard_persistence(const_cast<GdkDisplay*>(gobj()));
}


Glib::SignalProxy1< void,bool > Display::signal_closed()
{
  return Glib::SignalProxy1< void,bool >(this, &Display_signal_closed_info);
}


#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
void Gdk::Display::on_closed(bool is_error)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->closed)
    (*base->closed)(gobj(),static_cast<int>(is_error));
}
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED

#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED


} // namespace Gdk


