/* This file is part of libccc
 *
 * AUTHORS
 *     Sven Herzberg  <herzi@gnome-de.org>
 *
 * Copyright (C) 2007  Sven Herzberg
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef CALLGRIND_HELPERS_H
#define CALLGRIND_HELPERS_H

#include <cc-config.h>
#include <glib/gmacros.h>

#ifdef HAVE_CALLGRIND
#include <valgrind/callgrind.h>
#endif

#ifndef CALLGRIND_DUMP_STATS
#define CALLGRIND_DUMP_STATS            G_STMT_START {} G_STMT_END;
#endif

#ifndef CALLGRIND_DUMP_STATS_AT
#define CALLGRIND_DUMP_STATS_AT(loc)    G_STMT_START {} G_STMT_END;
#endif

#ifndef CALLGRIND_ZERO_STATS
#define CALLGRIND_ZERO_STATS            G_STMT_START {} G_STMT_END;
#endif

#ifndef CALLGRIND_TOGGLE_COLLECT
#define CALLGRIND_TOGGLE_COLLECT        G_STMT_START {} G_STMT_END;
#endif

#ifndef CALLGRIND_START_INSTRUMENTATION
#define CALLGRIND_START_INSTRUMENTATION G_STMT_START {} G_STMT_END;
#endif

#ifndef CALLGRIND_STOP_INSTRUMENTATION
#define CALLGRIND_STOP_INSTRUMENTATION  G_STMT_START {} G_STMT_END;
#endif

/* Manual:
 *
 * Usually you want to debug test cases like this:
 *
 * START_TEST(test_some_feature)
 * {
 *         // last preparations
 *
 *         CALLGRIND_START_INSTRUMENTATION;
 *         CALLGRIND_ZERO_STATS;
 *         // perform the real test
 *         CALLGRIND_DUMP_STATS_AT(test_some_feature);
 *         CALLGRIND_STOP_INSTRUMENTATION;
 *
 *         fail_unless (condition);
 *
 *         // cleanup
 * }
 * END_TEST
 *
 * This will allow the callgrind-m-ccc script to actually collect pretty useful
 * data for each of the tests.
 */

G_END_DECLS

#endif /* !CALLGRIND_HELPERS_H */
