/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <string.h>
#include "jg_jnu.h"
#include <libebook/e-contact.h>
#include "org_gnu_libebook_EContactField.h"
#ifdef __cplusplus
extern "C" 
{
#endif

/*
 * Class:     org_gnu_libebook_EContactField
 * Method:    e_contact_field_id
 */
JNIEXPORT jint JNICALL Java_org_gnu_libebook_EContactField_e_1contact_1field_1id
(JNIEnv *env, jclass cls, jstring field_name)
{
    int fieldEnumId;
    char* field_name_g = (char*)(*env)->GetStringUTFChars(env, field_name, 0);
    fieldEnumId = e_contact_field_id(field_name_g);
    (*env)->ReleaseStringUTFChars(env, field_name, field_name_g);

    return (jint)fieldEnumId;
}

/*
 * Class:     org_gnu_libebook_EContactField
 * Method:    e_contact_pretty_name
 */
JNIEXPORT jstring JNICALL Java_org_gnu_libebook_EContactField_e_1contact_1pretty_1name
(JNIEnv *env, jclass cls, jint field_id)
{
    char const *field_pretty_name = e_contact_pretty_name((int)field_id);
    return (*env)->NewStringUTF(env, field_pretty_name);
}

#ifdef __cplusplus
}

#endif
