/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <string.h>
#include "jg_jnu.h"
#include "gtk_java.h"
#include <libebook/e-book.h>
#include "org_gnu_libedataserver_ESourceGroup.h"
#ifdef __cplusplus
extern "C" 
{
#endif

/*
 * Class:     org.gnu.libedataserver.ESourceGroup
 * Method:    e_source_group_new
 */
JNIEXPORT jobject JNICALL Java_org_gnu_libedataserver_ESourceGroup_e_1source_1group_1new
(JNIEnv *env, jclass cls, jstring name, jstring base_uri)
{
    const char* name_g = (char*)(*env)->GetStringUTFChars(env, name, 0);
    const char* base_uri_g = (char*)(*env)->GetStringUTFChars(env, base_uri, 0);
    ESourceGroup *ret = e_source_group_new(name_g, base_uri_g);

    (*env)->ReleaseStringUTFChars(env, name, name_g);
    (*env)->ReleaseStringUTFChars(env, base_uri, base_uri_g);

    return getGObjectHandle(env, ret);
}

/*
 * Class:     org.gnu.libedataserver.ESourceGroup
 * Method:    e_source_group_new_from_xml
 */
JNIEXPORT jobject JNICALL Java_org_gnu_libedataserver_ESourceGroup_e_1source_1group_1new_1from_1xml
(JNIEnv *env, jclass cls, jstring xml)
{
    const char* xml_g = (char*)(*env)->GetStringUTFChars(env, xml, 0);
    ESourceGroup *ret = e_source_group_new_from_xml(xml_g);
    (*env)->ReleaseStringUTFChars(env, xml, xml_g);
    return getGObjectHandle(env, ret);
}


/*
 * Class:     org.gnu.libedataserver.ESourceGroup
 * Method:    e_source_group_set_name
 */
JNIEXPORT void JNICALL Java_org_gnu_libedataserver_ESourceGroup_e_1source_1group_1set_1name
(JNIEnv *env, jclass cls, jobject obj, jstring name)
{
    char* name_g = (char*)(*env)->GetStringUTFChars(env, name, 0);
    ESourceGroup *e_source_group_g = (ESourceGroup*)getPointerFromHandle(env, obj);
    e_source_group_set_name(e_source_group_g, name_g);
    (*env)->ReleaseStringUTFChars(env, name, name_g);
}


/*
 * Class:     org.gnu.libedataserver.ESourceGroup
 * Method:    e_source_group_set_base_uri
 */
JNIEXPORT void JNICALL Java_org_gnu_libedataserver_ESourceGroup_e_1source_1group_1set_1base_1uri
(JNIEnv *env, jclass cls, jobject obj, jstring base_uri)
{
    char* base_uri_g = (char*)(*env)->GetStringUTFChars(env, base_uri, 0);
    ESourceGroup *e_source_group_g = (ESourceGroup*)getPointerFromHandle(env, obj);
    e_source_group_set_base_uri(e_source_group_g, base_uri_g);
    (*env)->ReleaseStringUTFChars(env, base_uri, base_uri_g);
}

/*
 * Class:     org.gnu.libedataserver.ESourceGroup
 * Method:    e_source_group_set_readonly
 */
JNIEXPORT void JNICALL Java_org_gnu_libedataserver_ESourceGroup_e_1source_1group_1set_1readonly
(JNIEnv *env, jclass cls, jobject obj, jboolean readonly)
{
    ESourceGroup *e_source_group_g = (ESourceGroup*)getPointerFromHandle(env, obj);
    e_source_group_set_readonly(e_source_group_g, readonly);
}


/*
 * Class:     org.gnu.libedataserver.ESourceGroup
 * Method:    e_source_group_peek_uid
 */
JNIEXPORT jstring JNICALL Java_org_gnu_libedataserver_ESourceGroup_e_1source_1group_1peek_1uid
(JNIEnv *env, jclass cls, jobject obj)
{
    ESourceGroup *e_source_group_g = (ESourceGroup*)getPointerFromHandle(env, obj);
    return (*env)->NewStringUTF(env, e_source_group_peek_uid(e_source_group_g));
}

/*
 * Class:     org.gnu.libedataserver.ESourceGroup
 * Method:    e_source_group_peek_name
 */
JNIEXPORT jstring JNICALL Java_org_gnu_libedataserver_ESourceGroup_e_1source_1group_1peek_1name
(JNIEnv *env, jclass cls, jobject obj)
{
    ESourceGroup *e_source_group_g = (ESourceGroup*)getPointerFromHandle(env, obj);
    return (*env)->NewStringUTF(env, e_source_group_peek_name(e_source_group_g));
}

/*
 * Class:     org.gnu.libedataserver.ESourceGroup
 * Method:    e_source_group_peek_base_uri
 */
JNIEXPORT jstring JNICALL Java_org_gnu_libedataserver_ESourceGroup_e_1source_1group_1peek_1base_1uri
(JNIEnv *env, jclass cls, jobject obj)
{
    ESourceGroup *e_source_group_g = (ESourceGroup*)getPointerFromHandle(env, obj);
    return (*env)->NewStringUTF(env, e_source_group_peek_base_uri(e_source_group_g));
}

/*
 * Class:     org.gnu.libedataserver.ESourceGroup
 * Method:    e_source_group_get_readonly
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_libedataserver_ESourceGroup_e_1source_1group_1get_1readonly
(JNIEnv *env, jclass cls, jobject obj)
{
    ESourceGroup *e_source_group_g = (ESourceGroup*)getPointerFromHandle(env, obj);
    return e_source_group_get_readonly(e_source_group_g);
}


/*
 * Class:     org.gnu.libedataserver.ESourceGroup
 * Method:    e_source_group_peek_sources
 */
JNIEXPORT jobjectArray JNICALL Java_org_gnu_libedataserver_ESourceGroup_e_1source_1group_1peek_1sources
(JNIEnv *env, jclass cls, jobject obj)
{
    ESourceGroup *e_source_group_g = (ESourceGroup*)getPointerFromHandle(env, obj);
    return getGObjectHandlesFromGSListAndRef(env, e_source_group_peek_sources(e_source_group_g));
}

/*
 * Class:     org.gnu.libedataserver.ESourceGroup
 * Method:    e_source_group_peek_source_by_uid
 */
JNIEXPORT jobject JNICALL Java_org_gnu_libedataserver_ESourceGroup_e_1source_1group_1peek_1source_1by_1uid
(JNIEnv *env, jclass cls, jobject obj, jstring uid)
{
    ESourceGroup *e_source_group_g = (ESourceGroup*)getPointerFromHandle(env, obj);
    char* uid_g = (char*)(*env)->GetStringUTFChars(env, uid, 0);
    jobject result = getGObjectHandle(env, e_source_group_peek_source_by_uid(e_source_group_g, uid_g));
    (*env)->ReleaseStringUTFChars(env, uid, uid_g);
    return result;
}

/*
 * Class:     org.gnu.libedataserver.ESourceGroup
 * Method:    e_source_group_peek_source_by_name
 */
JNIEXPORT jobject JNICALL Java_org_gnu_libedataserver_ESourceGroup_e_1source_1group_1peek_1source_1by_1name
(JNIEnv *env, jclass cls, jobject obj, jstring name)
{
    ESourceGroup *e_source_group_g = (ESourceGroup*)getPointerFromHandle(env, obj);
    char* name_g = (char*)(*env)->GetStringUTFChars(env, name, 0);
    ESource *e_source = e_source_group_peek_source_by_name(e_source_group_g, name_g);
    (*env)->ReleaseStringUTFChars(env, name, name_g);
    return getGObjectHandle(env, e_source);
}

/*
 * Class:     org.gnu.libedataserver.ESourceGroup
 * Method:    e_source_group_add_source
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_libedataserver_ESourceGroup_e_1source_1group_1add_1source
(JNIEnv *env, jclass cls, jobject obj, jobject source, jint position)
{
    ESourceGroup *e_source_group_g = (ESourceGroup*)getPointerFromHandle(env, obj);
    ESource *e_source_g = (ESource*)getPointerFromHandle(env, source);

    return e_source_group_add_source(e_source_group_g, e_source_g, position);
}

/*
 * Class:     org.gnu.libedataserver.ESourceGroup
 * Method:    e_source_group_remove_source
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_libedataserver_ESourceGroup_e_1source_1group_1remove_1source
(JNIEnv *env, jclass cls, jobject obj, jobject source)
{
    ESourceGroup *e_source_group_g = (ESourceGroup*)getPointerFromHandle(env, obj);
    ESource *e_source_g = (ESource*)getPointerFromHandle(env, source);

    return e_source_group_remove_source(e_source_group_g, e_source_g);
}

/*
 * Class:     org.gnu.libedataserver.ESourceGroup
 * Method:    e_source_group_remove_source_by_uid
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_libedataserver_ESourceGroup_e_1source_1group_1remove_1source_1by_1uid
(JNIEnv *env, jclass cls, jobject obj, jstring uid)
{
    ESourceGroup *e_source_group_g = (ESourceGroup*)getPointerFromHandle(env, obj);
    char* uid_g = (char*)(*env)->GetStringUTFChars(env, uid, 0);
    jboolean result = e_source_group_remove_source_by_uid(e_source_group_g, uid_g);
    (*env)->ReleaseStringUTFChars(env, uid, uid_g);
    return result;
}

/*
 * Class:     org.gnu.libedataserver.ESourceGroup
 * Method:    e_source_group_to_xml
 */
JNIEXPORT jstring JNICALL Java_org_gnu_libedataserver_ESourceGroup_e_1source_1group_1to_1xml
(JNIEnv *env, jclass cls, jobject obj)
{
    ESourceGroup *e_source_group_g = (ESourceGroup*)getPointerFromHandle(env, obj);
    return (*env)->NewStringUTF(env, e_source_group_to_xml(e_source_group_g));
}

#ifdef __cplusplus
}

#endif
