/* GNOME DB libary
 * Copyright (C) 2000 Chris Wiegand
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __gda_bindings_cpp_gdaBatchH
#define __gda_bindings_cpp_gdaBatchH

#include "gdaIncludes.h"

namespace gda
{

	class Batch
	{
	      public:
		Batch ();
		Batch (GdaBatch * a);
		~Batch ();

		GdaBatch *getCStruct ();
		void setCStruct (GdaBatch * job);

		gboolean loadFile (const gchar * filename, gboolean clean);
		void addCommand (const gchar * cmd);
		void clear ();

		bool start ();
		void stop ();
		gboolean isRunning ();

		Connection *getConnection ();
		void setConnection (Connection * cnc);
		gboolean getTransactionMode ();
		void setTransactionMode (gboolean mode);

	      private:
		  GdaBatch * _gda_batch;
		Connection *cnc;

	};

};

#endif
