# Note that this is NOT a relocatable package
# defaults for redhat
%define name	libgda
%define ver	0.8.101

%define  RELEASE 1
%define  rel     %{?CUSTOM_RELEASE} %{!?CUSTOM_RELEASE:%RELEASE}

Summary: GNU Data Access
Name: 		%name
Version:	%ver
Release: 	%rel
Copyright: 	GPL
Group: 		Applications/Databases
Source:		ftp://ftp.gnome-db.org/pub/gnome-db/sources/%{ver}/%{name}-%{ver}.tar.gz
BuildRoot: 	%{_tmppath}/%{name}-%{ver}-root
URL: 		http://www.gnome-db.org
BuildPrereq: GConf-devel >= 0.11, libxml-devel >= 1.8 , oaf-devel >= 0.6, ORBit-devel >= 0.5, glib-devel >= 1.2, gtk+-devel >= 1.2
%define add_incs -I/usr/include/popt -I/usr/include/tcl -I/usr/include/gdbm
%description
GNU Data Access is an attempt to provide uniform access to
different kinds of data sources (databases, information
servers, mail spools, etc).
It is a complete architecture that provides all you need to
access your data.

libgda was part of the GNOME-DB project
(http://www.gnome.org/projects/gnome-db), but has been
separated from it to allow non-GNOME applications to be
developed based on it.

%package devel
Summary: GNU Data Access Development
Group: 		Applications/Databases
Requires:	%name = %{PACKAGE_VERSION}

%description devel
GNU Data Access is an attempt to provide uniform access to
 different kinds of data sources (databases, information
 servers, mail spools, etc).
 It is a complete architecture that provides all you need to
 access your data.
 .
 libgda was part of the GNOME-DB project
 (http://www.gnome.org/projects/gnome-db), but has been
 separated from it to allow non-GNOME applications to be
 developed based on it.

%package -n gda-odbc
Summary: GDA ODBC Provider
Group:		Applications/Databases
Requires:	%name = %{PACKAGE_VERSION}
BuildPrereq:	unixODBC-devel >= 1.8.12

%description -n gda-odbc
GNU Data Access is an attempt to provide uniform access to
 different kinds of data sources (databases, information
 servers, mail spools, etc).
 It is a complete architecture that provides all you need to
 access your data.
 .
 libgda was part of the GNOME-DB project
 (http://www.gnome.org/projects/gnome-db), but has been
 separated from it to allow non-GNOME applications to be
 developed based on it.

 This package includes the GDA ODBC provider

%package -n gda-postgres
Summary: GDA PostgreSQL Provider
Group:		Applications/Databases
Requires:	%name = %{PACKAGE_VERSION}
BuildPrereq:	postgresql-devel >= 6.5

%description -n gda-postgres
GNU Data Access is an attempt to provide uniform access to
 different kinds of data sources (databases, information
 servers, mail spools, etc).
 It is a complete architecture that provides all you need to
 access your data.
 .
 libgda was part of the GNOME-DB project
 (http://www.gnome.org/projects/gnome-db), but has been
 separated from it to allow non-GNOME applications to be
 developed based on it.

 This package includes the GDA PostgreSQL provider

%package -n gda-mysql
Summary: GDA MySQL Provider
Group:		Applications/Databases
Requires:	%name = %{PACKAGE_VERSION}
BuildPrereq:	mysql-devel >= 3.22

%description -n gda-mysql
GNU Data Access is an attempt to provide uniform access to
 different kinds of data sources (databases, information
 servers, mail spools, etc).
 It is a complete architecture that provides all you need to
 access your data.
 .
 libgda was part of the GNOME-DB project
 (http://www.gnome.org/projects/gnome-db), but has been
 separated from it to allow non-GNOME applications to be
 developed based on it.

 This package includes the GDA MySQL provider

%changelog
* Thu May 31 2001 Serge Pavlovsky <pal@re.com.ua>
- Cleaned

* Sat Sep 2 2000 Rodrigo Moya <rodrigo@linuxave.net>
- Initial spec imported from old GNOME-DB spec

%prep
%setup

%build

# libtool workaround for alphalinux
%ifarch alpha
  ARCH_FLAGS="--host=alpha-redhat-linux"
%endif

export CFLAGS="%optflags %add_incs" 
# Needed for snapshot releases.
if [ ! -f configure ]; then
  ./autogen.sh $ARCH_FLAGS --prefix=%{_prefix} --with-odbc=%{_prefix} --with-postgres=yes --with-mysql=yes
else
  ./configure $ARCH_FLAGS --prefix=%{_prefix} --with-odbc=%{_prefix} --with-postgres=yes --with-mysql=yes
fi

if [ "$SMP" != "" ]; then
  (make "MAKE=make -k -j $SMP"; exit 0)
  make
else
  make
fi

%install
rm -rf $RPM_BUILD_ROOT

make DESTDIR=%{buildroot} install
%find_lang %name --with-gnome

%clean
rm -rf $RPM_BUILD_ROOT

%post -p /sbin/ldconfig
							  
%postun -p /sbin/ldconfig
							  
%files -f %{name}.lang
%defattr(-, root, root)
%doc AUTHORS COPYING ChangeLog NEWS README
%{_bindir}/gda-default-srv
%{_bindir}/gda-test
%{_bindir}/gda-run
%{_libdir}/lib*.so.*
%{_datadir}/gnome/html/*
%{_datadir}/gda
%{_datadir}/oaf/GNOME_GDA_Provider_Default.oaf
%{_datadir}/idl/*

%files devel
%defattr(-, root, root)

%{_bindir}/gda-build*
%{_bindir}/gda-config
%{_libdir}/lib*.*a
%{_libdir}/lib*.so
%{_includedir}/*

%files -n gda-odbc
%defattr(-, root, root)

%{_bindir}/gda-odbc-srv
%{_datadir}/oaf/GNOME_GDA_Provider_ODBC.oaf

%files -n gda-postgres
%defattr(-, root, root)

%{_bindir}/gda-postgres-srv
%{_datadir}/oaf/GNOME_GDA_Provider_Postgres.oaf

%files -n gda-mysql
%defattr(-, root, root)

%{_bindir}/gda-mysql-srv
%{_datadir}/oaf/GNOME_GDA_Provider_MySQL.oaf
