// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _LIBGNOMEDBMM_DATASTORE_H
#define _LIBGNOMEDBMM_DATASTORE_H


#include <glibmm.h>

// -*- C++ -*- // 

/* datastore.hg
 * 
 * Copyright 2006 libgnomedbmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
 

#include <glibmm/object.h>
#include <gtkmm/treemodel.h>
#include <libgdamm/datamodel.h>
#include <libgdamm/dataproxy.h>
#include <libgdamm/value.h>

#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GnomeDbDataStore GnomeDbDataStore;
typedef struct _GnomeDbDataStoreClass GnomeDbDataStoreClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Db
{ class DataStore_Class; } // namespace Db

} // namespace Gnome
namespace Gnome
{

namespace Db
{


class DataStore : public Glib::Object, public Gtk::TreeModel
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef DataStore CppObjectType;
  typedef DataStore_Class CppClassType;
  typedef GnomeDbDataStore BaseObjectType;
  typedef GnomeDbDataStoreClass BaseClassType;

private:  friend class DataStore_Class;
  static CppClassType datastore_class_;

private:
  // noncopyable
  DataStore(const DataStore&);
  DataStore& operator=(const DataStore&);

protected:
  explicit DataStore(const Glib::ConstructParams& construct_params);
  explicit DataStore(GnomeDbDataStore* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~DataStore();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GnomeDbDataStore*       gobj()       { return reinterpret_cast<GnomeDbDataStore*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GnomeDbDataStore* gobj() const { return reinterpret_cast<GnomeDbDataStore*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GnomeDbDataStore* gobj_copy();

private:

protected:
  explicit DataStore(const Glib::RefPtr<Gda::DataModel>& model);
  
public:
  
  static Glib::RefPtr<DataStore> create(const Glib::RefPtr<Gda::DataModel>& model);


  /** Stores a value in the @a store  data model.
   * @param iter The considered row.
   * @param col The considered column.
   * @param value The value to store (gets copied).
   * @return <tt>true</tt> on succes.
   */
  bool set_value(const Gtk::TreeModel::iterator& iter, int col, const Gda::Value& value);

  // We renamed delete/undelete to erase/unerase in C++ because delete is a
  // C++ keyword.
  
  /** Marks the row pointed by @a iter  to be deleted
   * @param iter The considered row.
   */
  void erase(const Gtk::TreeModel::iterator& iter);
  
  /** Remove the "to be deleted" mark the row pointed by @a iter , if it existed.
   * @param iter The considered row.
   */
  void unerase(const Gtk::TreeModel::iterator& iter);
  
  /** Appends a new row.
   * @param iter An unset Gtk::TreeIter to set to the appended row.
   * @return <tt>true</tt> if no error occurred.
   */
  bool append(Gtk::TreeModel::iterator& iter);

  
  /** 
   * @return The internal Gda::DataProxy being used by @a store .
   */
  Glib::RefPtr<Gda::DataProxy> get_proxy();
  
  /** 
   * @return The internal Gda::DataProxy being used by @a store .
   */
  Glib::RefPtr<const Gda::DataProxy> get_proxy() const;

  
  /** Get the number of the row represented by @a iter 
   * @param iter A valid Gtk::TreeIter.
   * @return The row number, or -1 if an error occurred.
   */
  int get_row_from_iter(const Gtk::TreeModel::iterator& iter) const;

   
  /** Sets @a iter  to the first row where all the values in @a values  at the columns identified at
   *  @a cols_index  match. If the row can't be identified, then the contents of @a iter  is not modified.
   * 
   * NOTE: the @a cols_index  array MUST contain a column index for each value in @a values 
   * @param iter An unset Gtk::TreeIter to set to the requested row.
   * @param values A list of G::Value values.
   * @param cols_index An array of <tt>int</tt> containing the column number to match each value of @a values .
   * @return <tt>true</tt> if the row has been identified @a iter  was set.
   */
  bool get_iter_from_values(Gtk::TreeModel::iterator& iter, const Glib::SListHandle<Gda::Value>& values, const Glib::ArrayHandle<int>& cols_index) const;

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Gda::DataModel> > property_model() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_prepend_null_entry() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_prepend_null_entry() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Gda::DataProxy> > property_proxy() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace Db

} // namespace Gnome


namespace Glib
{
  /** @relates Gnome::Db::DataStore
   * @param object The C instance
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   */
  Glib::RefPtr<Gnome::Db::DataStore> wrap(GnomeDbDataStore* object, bool take_copy = false);
}


#endif /* _LIBGNOMEDBMM_DATASTORE_H */

