// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _LIBGNOMEDBMM_DATAWIDGET_H
#define _LIBGNOMEDBMM_DATAWIDGET_H


#include <glibmm.h>

// -*- C++ -*- // 

/* datawidget.h
 * 
 * Copyright 2006 libgnomedbmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <libgnomedb/gnome-db-data-widget.h>

#include <glibmm/interface.h>
#include <gtkmm/actiongroup.h>

#include <libgdamm/datamodel.h>
#include <libgdamm/dataproxy.h>
#include <libgdamm/datamodeliter.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GnomeDbDataWidget GnomeDbDataWidget;
typedef struct _GnomeDbDataWidgetClass GnomeDbDataWidgetClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Db
{ class DataWidget_Class; } // namespace Db

} // namespace Gnome
namespace Gnome
{

namespace Db
{

/** @addtogroup libgnomedbmmEnums Enums and Flags */

/**
 * @ingroup libgnomedbmmEnums
 */
enum Action
{
  ACTION_NEW_DATA,
  ACTION_WRITE_MODIFIED_DATA,
  ACTION_DELETE_SELECTED_DATA,
  ACTION_UNDELETE_SELECTED_DATA,
  ACTION_RESET_DATA,
  ACTION_MOVE_FIRST_RECORD,
  ACTION_MOVE_PREV_RECORD,
  ACTION_MOVE_NEXT_RECORD,
  ACTION_MOVE_LAST_RECORD,
  ACTION_MOVE_FIRST_CHUNCK,
  ACTION_MOVE_PREV_CHUNCK,
  ACTION_MOVE_NEXT_CHUNCK,
  ACTION_MOVE_LAST_CHUNCK
};

} // namespace Db

} // namespace Gnome


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gnome::Db::Action> : public Glib::Value_Enum<Gnome::Db::Action>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Db
{

/**
 * @ingroup libgnomedbmmEnums
 */
enum DataWidgetWriteMode
{
  DATA_WIDGET_WRITE_ON_DEMAND,
  DATA_WIDGET_WRITE_ON_ROW_CHANGE,
  DATA_WIDGET_WRITE_ON_VALUE_ACTIVATED,
  DATA_WIDGET_WRITE_ON_VALUE_CHANGE
};

} // namespace Db

} // namespace Gnome


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gnome::Db::DataWidgetWriteMode> : public Glib::Value_Enum<Gnome::Db::DataWidgetWriteMode>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Db
{


/** Base class to control data-bound widgets.
 * This is a common interface inherited by some data-bound widgets which have the following in common:
 * - The data to display in the widget is contained in a Gda::DataModel object (a "source" of data).
 * - If the "source" Gda::DataModel allows it, modifications can be made (modifying existing rows, adding new rows, or removing some rows). Those modifications are internally stored in a Gda::DataProxy object. (note that a Gda::DataProxy object is always created, except if the "source" data model is itself a Gda::DataProxy object).
 * - The widget also internally uses a Gda::DataModelIter object which represents the current "selected" row (the selected row, or the one displayed).
 * - Writing back the modifications stored in the Gda::DataProxy to the "source" data model is by default done only when requested, but can be specified as otherwise (see set_write_mode()).
 */

class DataWidget : public Glib::Interface
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef DataWidget CppObjectType;
  typedef DataWidget_Class CppClassType;
  typedef GnomeDbDataWidget BaseObjectType;
  typedef GnomeDbDataWidgetIface BaseClassType;

private:
  friend class DataWidget_Class;
  static CppClassType datawidget_class_;

  // noncopyable
  DataWidget(const DataWidget&);
  DataWidget& operator=(const DataWidget&);

protected:
  DataWidget(); // you must derive from this class
  explicit DataWidget(GnomeDbDataWidget* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~DataWidget();

  static void add_interface(GType gtype_implementer);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GnomeDbDataWidget*       gobj()       { return reinterpret_cast<GnomeDbDataWidget*>(gobject_); }

  ///Provides access to the underlying C GObject.  
  const GnomeDbDataWidget* gobj() const { return reinterpret_cast<GnomeDbDataWidget*>(gobject_); }

private:


  // This does not belong to this class
  

public:
  
  /** Get a pointer to the Gda::DataProxy being used by @a iface 
   * @return A Gda::DataProxy pointer.
   */
  Glib::RefPtr<Gda::DataProxy> get_proxy();
  
  /** Get a pointer to the Gda::DataProxy being used by @a iface 
   * @return A Gda::DataProxy pointer.
   */
  Glib::RefPtr<const Gda::DataProxy> get_proxy() const;

  
  /** Shows the data at @a column  in the data model @a iface  operates on
   * @param column Column number to show.
   */
  void column_show(int column);
  
  /** Hides the data at @a column  in the data model @a iface  operates on
   * @param column Column number to hide.
   */
  void column_hide(int column);
  
  /** Sets if the data entry in the @a iface  widget at @a column  (in the data model @a iface  operates on) can be edited or not.
   * @param column Column number of the data.
   * @param editable Whether the data entry can be edited.
   */
  void column_set_editable(int column, bool editable = true);
  
  /** Sets if the data entry in the @a iface  widget at @a column  (in the data model @a iface  operates on) must show its
   * actions menu or not.
   * @param column Column number of the data.
   * @param show_actions Whether to show the actions menu.
   */
  void column_show_actions(int column, bool show_actions = true);

  
  /** Each widget imlplementing the Gnome::DbDataWidget interface provides actions. Actions can be triggered
   * using the perform_action() method, but using this method allows for the creation of
   * toolbars, menus, etc calling these actions.
   * 
   * The actions are among: 
   * &lt;itemizedlist&gt;&lt;listitem&gt;Data edition actions: "ActionNew", "ActionCommit", 
   * "ActionDelete, "ActionUndelete, "ActionReset", &lt;/listitem&gt;
   * &lt;listitem&gt;Record by record moving: "ActionFirstRecord", "ActionPrevRecord", 
   * "ActionNextRecord", "ActionLastRecord",&lt;/listitem&gt;
   * &lt;listitem&gt;Chuncks of records moving: "ActionFirstChunck", "ActionPrevChunck", 
   * "ActionNextChunck", "ActionLastChunck".&lt;/listitem&gt;&lt;/itemizedlist&gt;
   * @return The Gtk::ActionGroup with all the possible actions on the widget.
   */
  Glib::RefPtr<Gtk::ActionGroup> get_actions_group();
  
  /** Each widget imlplementing the Gnome::DbDataWidget interface provides actions. Actions can be triggered
   * using the perform_action() method, but using this method allows for the creation of
   * toolbars, menus, etc calling these actions.
   * 
   * The actions are among: 
   * &lt;itemizedlist&gt;&lt;listitem&gt;Data edition actions: "ActionNew", "ActionCommit", 
   * "ActionDelete, "ActionUndelete, "ActionReset", &lt;/listitem&gt;
   * &lt;listitem&gt;Record by record moving: "ActionFirstRecord", "ActionPrevRecord", 
   * "ActionNextRecord", "ActionLastRecord",&lt;/listitem&gt;
   * &lt;listitem&gt;Chuncks of records moving: "ActionFirstChunck", "ActionPrevChunck", 
   * "ActionNextChunck", "ActionLastChunck".&lt;/listitem&gt;&lt;/itemizedlist&gt;
   * @return The Gtk::ActionGroup with all the possible actions on the widget.
   */
  Glib::RefPtr<const Gtk::ActionGroup> get_actions_group() const;
 
  
  /** Forces the widget to perform the selected @a action , as if the user
   * had pressed on the corresponding action button in the @a iface  widget,
   * if the corresponding action is possible and if the @a iface  widget
   * supports the action.
   * @param action A Gnome::DbAction action.
   */
  void perform_action(Action action);

  
  /** Get the Gda::DataModelIter object which contains all the parameters which in turn contain the actual
   * data stored in @a iface . When the user changes what's displayed or what's selected (depending on the
   * actual widget) in @a iface , then the parameter's values change as well.
   * @return The Gda::ParameterList object for data (not a new object).
   */
  Glib::RefPtr<Gda::DataModelIter> get_current_data();
  
  /** Get the Gda::DataModelIter object which contains all the parameters which in turn contain the actual
   * data stored in @a iface . When the user changes what's displayed or what's selected (depending on the
   * actual widget) in @a iface , then the parameter's values change as well.
   * @return The Gda::ParameterList object for data (not a new object).
   */
  Glib::RefPtr<const Gda::DataModelIter> get_current_data() const;

  
  /** Get the current Gda::DataModel used by @a iface 
   * @return The Gda::DataModel, or <tt>0</tt> if there is none.
   */
  Glib::RefPtr<Gda::DataModel> get_gda_model();
  
  /** Get the current Gda::DataModel used by @a iface 
   * @return The Gda::DataModel, or <tt>0</tt> if there is none.
   */
  Glib::RefPtr<const Gda::DataModel> get_gda_model() const;

  
  /** Sets the data model which is used by @a iface .
   * @param model A valid Gda::DataModel.
   */
  void set_gda_model(const Glib::RefPtr<Gda::DataModel>& model);

  
  DataWidgetWriteMode get_write_mode() const;
  
  void set_write_mode(DataWidgetWriteMode mode);

  // Qualify DataProxy fully here so that it is found by the generated code
  // (in the default signal handler)
   

/**
   * @par Prototype:
   * <tt>void %proxy_changed(const Glib::RefPtr<Gnome::Gda::DataProxy>& proxy)</tt>
   */

  Glib::SignalProxy1< void,const Glib::RefPtr<Gnome::Gda::DataProxy>& > signal_proxy_changed();


protected:
  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual Glib::RefPtr<Gda::DataProxy> get_proxy_vfunc();
#endif //GLIBMM_VFUNCS_ENABLED

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual void col_set_show_vfunc(int column, bool shown);
#endif //GLIBMM_VFUNCS_ENABLED

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual void set_column_editable_vfunc(int column, bool editable);
#endif //GLIBMM_VFUNCS_ENABLED

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual void show_column_actions_vfunc(int column, bool show_actions);
#endif //GLIBMM_VFUNCS_ENABLED

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual Glib::RefPtr<Gtk::ActionGroup> get_actions_group_vfunc();
#endif //GLIBMM_VFUNCS_ENABLED

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual GdaDataModelIter* get_data_set_vfunc();
#endif //GLIBMM_VFUNCS_ENABLED

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual Glib::RefPtr<Gda::DataModel> get_gda_model_vfunc();
#endif //GLIBMM_VFUNCS_ENABLED

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual void set_gda_model_vfunc(const Glib::RefPtr<Gda::DataModel>& model);
#endif //GLIBMM_VFUNCS_ENABLED


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
  virtual void on_proxy_changed(const Glib::RefPtr<Gnome::Gda::DataProxy>& proxy);
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace Db

} // namespace Gnome


namespace Glib
{
  /** @relates Gnome::Db::DataWidget
   * @param object The C instance
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   */
  Glib::RefPtr<Gnome::Db::DataWidget> wrap(GnomeDbDataWidget* object, bool take_copy = false);

} // namespace Glib


#endif /* _LIBGNOMEDBMM_DATAWIDGET_H */

