/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <sys/types.h>
#include <gdk/gdk.h>
#include "jg_jnu.h"

#ifdef __cplusplus
extern "C" 
{
#endif


GdkEventType GdkEventDND_get_type (GdkEventDND * cptr) 
{
    return cptr->type;
}

/*
 * Class:     org.gnu.gdk.EventDND
 * Method:    getType
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_EventDND_getType (JNIEnv *env, jclass cls, jobject obj) 
{
    GdkEventDND *obj_g = (GdkEventDND *)getPointerFromHandle(env, obj);
    return (jint) (GdkEventDND_get_type (obj_g));
}

GdkWindow * GdkEventDND_get_window (GdkEventDND * cptr) 
{
    return cptr->window;
}

/*
 * Class:     org.gnu.gdk.EventDND
 * Method:    getWindow
 */
JNIEXPORT jobject JNICALL Java_org_gnu_gdk_EventDND_getWindow (JNIEnv *env, jclass cls, jobject obj) 
{
    GdkEventDND *obj_g = (GdkEventDND *)getPointerFromHandle(env, obj);
    return getHandleFromPointer(env, GdkEventDND_get_window (obj_g));
}

gboolean GdkEventDND_get_send_event (GdkEventDND * cptr) 
{
    return cptr->send_event;
}

/*
 * Class:     org.gnu.gdk.EventDND
 * Method:    getSendEvent
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gdk_EventDND_getSendEvent (JNIEnv *env, jclass cls, 
    jobject obj) 
{
    GdkEventDND *obj_g = (GdkEventDND *)getPointerFromHandle(env, obj);
    return (jboolean) (GdkEventDND_get_send_event (obj_g));
}

GdkDragContext * GdkEventDND_get_context (GdkEventDND * cptr) 
{
    return cptr->context;
}

/*
 * Class:     org.gnu.gdk.EventDND
 * Method:    getContext
 */
JNIEXPORT jobject JNICALL Java_org_gnu_gdk_EventDND_getContext (JNIEnv *env, jclass cls, jobject obj) 
{
	GdkEventDND *obj_g = (GdkEventDND *)getPointerFromHandle(env, obj);
    return getHandleFromPointer(env, GdkEventDND_get_context (obj_g));
}

time_t GdkEventDND_get_time (GdkEventDND * cptr) 
{
    return cptr->time;
}

/*
 * Class:     org.gnu.gdk.EventDND
 * Method:    getTime
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_EventDND_getTime (JNIEnv *env, jclass cls, jobject obj) 
{
    GdkEventDND *obj_g = (GdkEventDND *)getPointerFromHandle(env, obj);
    return (jint)GdkEventDND_get_time (obj_g);
}

gshort GdkEventDND_get_x_root (GdkEventDND * cptr) 
{
    return cptr->x_root;
}

/*
 * Class:     org.gnu.gdk.EventDND
 * Method:    getXRoot
 */
JNIEXPORT jshort JNICALL Java_org_gnu_gdk_EventDND_getXRoot (JNIEnv *env, jclass cls, jobject obj) 
{
    GdkEventDND *obj_g = (GdkEventDND *)getPointerFromHandle(env, obj);
    return (jshort) (GdkEventDND_get_x_root (obj_g));
}

gshort GdkEventDND_get_y_root (GdkEventDND * cptr) 
{
    return cptr->y_root;
}

/*
 * Class:     org.gnu.gdk.EventDND
 * Method:    getYRoot
 */
JNIEXPORT jshort JNICALL Java_org_gnu_gdk_EventDND_getYRoot (JNIEnv *env, jclass cls, jobject obj) 
{
    GdkEventDND *obj_g = (GdkEventDND *)getPointerFromHandle(env, obj);
    return (jshort) (GdkEventDND_get_y_root (obj_g));
}


#ifdef __cplusplus
}

#endif
