/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <glib.h>
#include <gdk/gdkpixbuf.h>
#include "jg_jnu.h"

#ifdef __cplusplus
extern "C" 
{
#endif

/*
 * Class:     org.gnu.glib.Value
 * Method:    g_value_init
 * Signature: (I)Lorg/gnu/glib/Handle;
 */
JNIEXPORT jobject JNICALL Java_org_gnu_glib_Value_g_1value_1init (JNIEnv *env, jclass cls, 
    jint type) 
{
    GValue *value_g = (GValue *) g_malloc(sizeof(GValue));
	value_g->g_type = 0;
    value_g = g_value_init (value_g,(GType)type);
    return getHandleFromPointer(env, value_g);
}

/*
 * Class:     org.gnu.glib.Value
 * Method:    g_value_type
 * Signature: (I)Lorg/gnu/glib/Handle;
 */
JNIEXPORT jint JNICALL Java_org_gnu_glib_Value_g_1value_1type (JNIEnv *env, jclass cls, jobject value)
{
    GValue *value_g = (GValue *)getPointerFromHandle(env, value);
    return G_VALUE_TYPE(value_g);
}

/*
 * Class:     org.gnu.glib.Value
 * Method:    g_value_copy
 * Signature: (Lorg/gnu/glib/Handle;)Lorg/gnu/glib/Handle;
 */
JNIEXPORT jobject JNICALL Java_org_gnu_glib_Value_g_1value_1copy (JNIEnv *env, jclass cls, jobject srcValue) 
{
    GValue *srcValue_g = (GValue *)getPointerFromHandle(env, srcValue);
    GValue *destValue = NULL;
    g_value_copy (srcValue_g, destValue);
    return getHandleFromPointer(env, destValue);
}

/*
 * Class:     org.gnu.glib.Value
 * Method:    g_value_reset
 * Signature: (Lorg/gnu/glib/Handle;)Lorg/gnu/glib/Handle;
 */
JNIEXPORT jobject JNICALL Java_org_gnu_glib_Value_g_1value_1reset (JNIEnv *env, jclass cls, jobject value) 
{
    GValue *value_g = (GValue *)getPointerFromHandle(env, value);
    return getHandleFromPointer(env, g_value_reset (value_g));
}

/*
 * Class:     org.gnu.glib.Value
 * Method:    g_value_unset
 * Signature: (Lorg/gnu/glib/Handle;)V
 */
JNIEXPORT void JNICALL Java_org_gnu_glib_Value_g_1value_1unset (JNIEnv *env, jclass cls, jobject value) 
{
    GValue *value_g = (GValue *)getPointerFromHandle(env, value);
    g_value_unset (value_g);
}

/*
 * Class:     org.gnu.glib.Value
 * Method:    g_value_set_char
 * Signature: (Lorg/gnu/glib/Handle;B)V
 */
JNIEXPORT void JNICALL Java_org_gnu_glib_Value_g_1value_1set_1char (JNIEnv *env, jclass cls, 
    jobject value, jbyte vChar) 
{
    GValue *value_g = (GValue *)getPointerFromHandle(env, value);
    gchar vChar_g = (gchar) vChar;
    g_value_set_char (value_g, vChar_g);
}

/*
 * Class:     org.gnu.glib.Value
 * Method:    g_value_get_char
 * Signature: (Lorg/gnu/glib/Handle;)B
 */
JNIEXPORT jbyte JNICALL Java_org_gnu_glib_Value_g_1value_1get_1char (JNIEnv *env, jclass cls, 
    jobject value) 
{
    GValue *value_g = (GValue *)getPointerFromHandle(env, value);
    jbyte result_j = (jbyte) (g_value_get_char (value_g));
    return result_j;
}

/*
 * Class:     org.gnu.glib.Value
 * Method:    g_value_set_boolean
 * Signature: (Lorg/gnu/glib/Handle;Z)V
 */
JNIEXPORT void JNICALL Java_org_gnu_glib_Value_g_1value_1set_1boolean (JNIEnv *env, jclass cls, 
    jobject value, jboolean vBoolean) 
{
    GValue *value_g = (GValue *)getPointerFromHandle(env, value);
    gboolean vBoolean_g = (gboolean) vBoolean;
    g_value_set_boolean (value_g, vBoolean_g);
}

/*
 * Class:     org.gnu.glib.Value
 * Method:    g_value_get_boolean
 * Signature: (Lorg/gnu/glib/Handle;)Z
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_glib_Value_g_1value_1get_1boolean (JNIEnv *env, jclass 
    cls, jobject value) 
{
    GValue *value_g = (GValue *)getPointerFromHandle(env, value);
    jboolean result_j = (jboolean) (g_value_get_boolean (value_g));
    return result_j;
}

/*
 * Class:     org.gnu.glib.Value
 * Method:    g_value_set_int
 * Signature: (Lorg/gnu/glib/Handle;I)V
 */
JNIEXPORT void JNICALL Java_org_gnu_glib_Value_g_1value_1set_1int (JNIEnv *env, jclass cls, 
    jobject value, jint vInt) 
{
    GValue *value_g = (GValue *)getPointerFromHandle(env, value);
    gint32 vInt_g = (gint32) vInt;
    g_value_set_int (value_g, vInt_g);
}

/*
 * Class:     org.gnu.glib.Value
 * Method:    g_value_get_int
 * Signature: (Lorg/gnu/glib/Handle;)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_glib_Value_g_1value_1get_1int (JNIEnv *env, jclass cls, 
    jobject value) 
{
    GValue *value_g = (GValue *)getPointerFromHandle(env, value);
    jint result_j;
    if (G_VALUE_HOLDS_INT(value_g)) {
        result_j = (jint) (g_value_get_int (value_g));
    } else if (G_VALUE_HOLDS_UINT(value_g)) {
        result_j = (jint) (g_value_get_uint (value_g));
    } else if (G_VALUE_HOLDS_ENUM(value_g)) {
        result_j = (jint) (g_value_get_enum (value_g));
    } else {
    }
    return result_j;
}

/*
 * Class:     org.gnu.glib.Value
 * Method:    g_value_set_long
 * Signature: (Lorg/gnu/glib/handleJ)V
 */
JNIEXPORT void JNICALL Java_org_gnu_glib_Value_g_1value_1set_1long (JNIEnv *env, jclass cls, 
    jobject value, jlong vLong) 
{
    GValue *value_g = (GValue *)getPointerFromHandle(env, value);
    glong vLong_g = (glong) vLong;
    g_value_set_long (value_g, vLong_g);
}

/*
 * Class:     org.gnu.glib.Value
 * Method:    g_value_get_long
 * Signature: (Lorg/gnu/glib/Handle;)J
 */
JNIEXPORT jlong JNICALL Java_org_gnu_glib_Value_g_1value_1get_1long (JNIEnv *env, jclass cls, 
    jobject value) 
{
    GValue *value_g = (GValue *)getPointerFromHandle(env, value);
    jlong result_j;
    if (G_VALUE_HOLDS_LONG(value_g)) {
        result_j = (jlong) (g_value_get_long (value_g));
    } else if (G_VALUE_HOLDS_ULONG(value_g)) {
        result_j = (jlong) (g_value_get_ulong (value_g));
    } else if (G_VALUE_HOLDS_INT64(value_g)) {
        result_j = (jlong) (g_value_get_int64 (value_g));
    } else if (G_VALUE_HOLDS_UINT64(value_g)) {
        result_j = (jlong) (g_value_get_uint64 (value_g));
    } else {
    }
    return result_j;
}

/*
 * Class:     org.gnu.glib.Value
 * Method:    g_value_set_float
 * Signature: (Lorg/gnu/glib/Handle;D)V
 */
JNIEXPORT void JNICALL Java_org_gnu_glib_Value_g_1value_1set_1float (JNIEnv *env, jclass cls, 
    jobject value, jdouble vFloat) 
{
    GValue *value_g = (GValue *)getPointerFromHandle(env, value);
    gdouble vFloat_g = (gdouble) vFloat;
    g_value_set_float (value_g, vFloat_g);
}

/*
 * Class:     org.gnu.glib.Value
 * Method:    g_value_get_float
 * Signature: (Lorg/gnu/glib/Handle;)D
 */
JNIEXPORT jdouble JNICALL Java_org_gnu_glib_Value_g_1value_1get_1float (JNIEnv *env, jclass 
    cls, jobject value) 
{
    GValue *value_g = (GValue *)getPointerFromHandle(env, value);
    jdouble result_j = (jdouble) (g_value_get_float (value_g));
    return result_j;
}

/*
 * Class:     org.gnu.glib.Value
 * Method:    g_value_set_double
 * Signature: (Lorg/gnu/glib/Handle;D)V
 */
JNIEXPORT void JNICALL Java_org_gnu_glib_Value_g_1value_1set_1double (JNIEnv *env, jclass cls, 
    jobject value, jdouble vDouble) 
{
    GValue *value_g = (GValue *)getPointerFromHandle(env, value);
    gdouble vDouble_g = (gdouble) vDouble;
    g_value_set_double (value_g, vDouble_g);
}

/*
 * Class:     org.gnu.glib.Value
 * Method:    g_value_get_double
 * Signature: (Lorg/gnu/glib/Handle;)D
 */
JNIEXPORT jdouble JNICALL Java_org_gnu_glib_Value_g_1value_1get_1double (JNIEnv *env, jclass 
    cls, jobject value) 
{
    GValue *value_g = (GValue *)getPointerFromHandle(env, value);
    jdouble result_j = (jdouble) (g_value_get_double (value_g));
    return result_j;
}

/*
 * Class:     org.gnu.glib.Value
 * Method:    g_value_set_string
 * Signature: (Lorg/gnu/glib/Handle;Ljava.lang.String)V
 */
JNIEXPORT void JNICALL Java_org_gnu_glib_Value_g_1value_1set_1string (JNIEnv *env, jclass cls, 
    jobject value, jstring vString) 
{
    GValue *value_g = (GValue *)getPointerFromHandle(env, value);
    const gchar* vString_g = (*env)->GetStringUTFChars(env, vString, 0);
    g_value_set_string (value_g, vString_g);
    (*env)->ReleaseStringUTFChars(env, vString, vString_g);
}

/*
 * Class:     org.gnu.glib.Value
 * Method:    g_value_get_string
 * Signature: (Lorg/gnu/glib/Handle;)Ljava.lang.String
 */
JNIEXPORT jstring JNICALL Java_org_gnu_glib_Value_g_1value_1get_1string (JNIEnv *env, jclass 
    cls, jobject value) 
{
    GValue *value_g = (GValue *)getPointerFromHandle(env, value);
    const gchar *result_g = g_value_get_string ((const GValue*)value_g);
    jstring result = (*env)->NewStringUTF(env, result_g);
    return result;
}

/*
 * Class:     org.gnu.glib.Value
 * Method:    g_value_set_pixbuf
 */
JNIEXPORT void JNICALL Java_org_gnu_glib_Value_g_1value_1set_1pixbuf (JNIEnv *env, jclass cls, 
    jobject value, jobject obj) 
{
    g_value_set_object ((GValue*)getPointerFromHandle(env, value), (GdkPixbuf*)getPointerFromHandle(env, obj));
}

/*
 */
JNIEXPORT jobject JNICALL Java_org_gnu_glib_Value_g_1value_1get_1pixbuf (JNIEnv *env, jclass 
    cls, jobject value) 
{
    GValue *value_g = (GValue *)getPointerFromHandle(env, value);
    gpointer pointer_g = (gpointer) (g_value_get_pointer (value_g));
    return getHandleFromPointer(env, pointer_g);
}

/*
 * Class:     org.gnu.glib.Value
 * Method:    g_value_set_java_object
 */
JNIEXPORT void JNICALL Java_org_gnu_glib_Value_g_1value_1set_1java_1object (JNIEnv *env, jclass cls, 
    jobject value, jobject obj) 
{
    GValue *value_g = (GValue *)getPointerFromHandle(env, value);
    gpointer obj_g = (gpointer)getPointerFromHandle(env, obj);
    if ( G_VALUE_HOLDS_OBJECT(value_g) ) {
        g_value_set_object (value_g, obj_g);
    } else if ( G_VALUE_HOLDS_POINTER(value_g) ) {
        g_value_set_pointer (value_g, obj_g);
    } else if ( G_VALUE_HOLDS_BOXED(value_g) ) {
        g_value_set_boxed (value_g, obj_g);
    } else {
        g_value_set_pointer (value_g, obj_g);
    }
}

/*
 * Function used by Java_org_gnu_glib_Value_g_1value_1get_1java_1object
 * to return a new java.lang.Integer object with the value integer_j
 */
jobject createNewIntegerInstance(JNIEnv *env, jint integer_j) {
    jclass integerClass = (*env)->FindClass(env, "java/lang/Integer");
    if (integerClass == NULL)
        return (jobject) NULL;
    jmethodID constructor = (*env)->GetMethodID(env, integerClass,
                    "<init>", "(I)V");
    if (constructor == NULL)
        return (jobject) NULL;
    return (*env)->NewObject(env, integerClass, constructor, integer_j);
}

/*
 * Function used by Java_org_gnu_glib_Value_g_1value_1get_1java_1object
 * to return a new java.lang.Long object with the value long_j
 */
jobject createNewLongInstance(JNIEnv *env, jlong long_j) {
    jclass longClass = (*env)->FindClass(env, "java/lang/Long");
    if (longClass == NULL)
        return (jobject) NULL;
    jmethodID constructor = (*env)->GetMethodID(env, longClass,
                    "<init>", "(J)V");
    if (constructor == NULL)
        return (jobject) NULL;
    return (*env)->NewObject(env, longClass, constructor, long_j);
}

/*
 * Function used by Java_org_gnu_glib_Value_g_1value_1get_1java_1object
 * to return a new java.lang.Float object with the value float_j
 */
jobject createNewFloatInstance(JNIEnv *env, jfloat float_j) {
    jclass floatClass = (*env)->FindClass(env, "java/lang/Float");
    if (floatClass == NULL)
        return (jobject) NULL;
    jmethodID constructor = (*env)->GetMethodID(env, floatClass,
                    "<init>", "(F)V");
    if (constructor == NULL)
        return (jobject) NULL;
    return (*env)->NewObject(env, floatClass, constructor, float_j);
}

/*
 * Function used by Java_org_gnu_glib_Value_g_1value_1get_1java_1object
 * to return a new java.lang.Double object with the value double_j
 */
jobject createNewDoubleInstance(JNIEnv *env, jdouble double_j) {
    jclass doubleClass = (*env)->FindClass(env, "java/lang/Double");
    if (doubleClass == NULL)
        return (jobject) NULL;
    jmethodID constructor = (*env)->GetMethodID(env, doubleClass,
                    "<init>", "(D)V");
    if (constructor == NULL)
        return (jobject) NULL;
    return (*env)->NewObject(env, doubleClass, constructor, double_j);
}

/*
 * Function used by Java_org_gnu_glib_Value_g_1value_1get_1java_1object
 * to return a new java.lang.Boolean object with the value boolean_j
 */
jobject createNewBooleanInstance(JNIEnv *env, jboolean boolean_j) {
    jclass booleanClass = (*env)->FindClass(env, "java/lang/Boolean");
    if (booleanClass == NULL)
        return (jobject) NULL;
    jmethodID constructor = (*env)->GetMethodID(env, booleanClass,
                    "<init>", "(Z)V");
    if (constructor == NULL)
        return (jobject) NULL;
    return (*env)->NewObject(env, booleanClass, constructor, boolean_j);
}

/*
 * Function used by Java_org_gnu_glib_Value_g_1value_1get_1java_1object
 * to return a java.lang.Enum object with the value enum_int
 */
jobject getEnumInstance(JNIEnv *env, GValue *value_g) {
    char *enumClassName = javaobject_from_gtktype(G_VALUE_TYPE(value_g));
    printf("Enum-derived class: %s\n", enumClassName);
    const char *internSignature = g_malloc(64);

    jclass enumClass = (*env)->FindClass(env, enumClassName);
    if (enumClass == NULL)
        return (jobject) NULL;
    sprintf(internSignature, "(I)L%s;", enumClassName);
    jmethodID internMethod = (*env)->GetStaticMethodID(env, enumClass,
                    "intern", internSignature);
    if (internMethod == NULL)
        return (jobject) NULL;
    return (*env)->CallStaticIntMethod(env, enumClass, internMethod,
                    (jint) g_value_get_enum(value_g));
}

/*
 * Class:     org.gnu.glib.Value
 * Method:    g_value_get_java_object
 */
JNIEXPORT jobject JNICALL Java_org_gnu_glib_Value_g_1value_1get_1java_1object (JNIEnv *env, jclass 
    cls, jobject value) 
{
    GValue *value_g = (GValue *)getPointerFromHandle(env, value);
    gpointer pointer_g;
    if ( G_VALUE_HOLDS_OBJECT(value_g) ) {
        pointer_g = (gpointer) (g_value_get_object (value_g));
    } else if ( G_VALUE_HOLDS_POINTER(value_g) ) {
        pointer_g = (gpointer) (g_value_get_pointer (value_g));
    } else if ( G_VALUE_HOLDS_BOXED(value_g) ) {
        pointer_g = (gpointer) (g_value_get_boxed (value_g));

    } else if (G_VALUE_HOLDS_INT(value_g)) {
        /* create a new java.lang.Integer object with the right value */
        jint integer_j = (jint) g_value_get_int(value_g);
        return createNewIntegerInstance(env, integer_j);
    } else if (G_VALUE_HOLDS_UINT(value_g)) {
        /* create a new java.lang.Integer object with the right value */
        jint integer_j = (jint) g_value_get_uint(value_g);
        return createNewIntegerInstance(env, integer_j);
    } else if (G_VALUE_HOLDS_LONG(value_g)) {
        /* create a new java.lang.Long object with the right value */
        jlong long_j = (jlong) g_value_get_long(value_g);
        return createNewLongInstance(env, long_j);
    } else if (G_VALUE_HOLDS_ULONG(value_g)) {
        /* create a new java.lang.Long object with the right value */
        jlong long_j = (jlong) g_value_get_ulong(value_g);
        return createNewLongInstance(env, long_j);
    } else if (G_VALUE_HOLDS_INT64(value_g)) {
        /* create a new java.lang.Long object with the right value */
        jlong long_j = (jlong) g_value_get_uint64(value_g);
        return createNewLongInstance(env, long_j);
    } else if (G_VALUE_HOLDS_FLOAT(value_g)) {
        /* create a new java.lang.Float object with the right value */
        jfloat float_j = (jfloat) g_value_get_float(value_g);
        return createNewFloatInstance(env, float_j);
    } else if (G_VALUE_HOLDS_DOUBLE(value_g)) {
        /* create a new java.lang.Double object with the right value */
        jdouble double_j = (jdouble) g_value_get_double(value_g);
        return createNewDoubleInstance(env, double_j);
    } else if (G_VALUE_HOLDS_BOOLEAN(value_g)) {
        /* create a new java.lang.Boolean object with the right value */
        jboolean boolean_j = (jboolean) g_value_get_boolean(value_g);
        return createNewBooleanInstance(env, boolean_j);
    } else if (G_VALUE_HOLDS_ENUM(value_g)) {
        /* create a new java.lang.Boolean object with the right value */
        jint enum_int_value = (jint) g_value_get_enum(value_g);
        return getEnumInstance(env, value_g);

    } else {
        pointer_g = (gpointer) (g_value_get_pointer (value_g));
    }
    return getHandleFromPointer(env, pointer_g);
}


/*
 * Class:     org.gnu.glib.Value
 * Method:    g_value_set_pointer
 */
JNIEXPORT void JNICALL Java_org_gnu_glib_Value_g_1value_1set_1pointer (JNIEnv *env, jclass cls, jobject value, jobject ptr) 
{
    GValue *value_g = (GValue *)getPointerFromHandle(env, value);
    gpointer ptr_g = (gpointer)getPointerFromHandle(env, ptr);
    g_value_set_pointer (value_g, ptr);
}

/*
 * Class:     org.gnu.glib.Value
 * Method:    g_value_get_pointer
 */
JNIEXPORT jobject JNICALL Java_org_gnu_glib_Value_g_1value_1get_1pointer (JNIEnv *env, jclass cls, jobject value) 
{
    GValue *value_g = (GValue *)getPointerFromHandle(env, value);
    gpointer pointer_g = (gpointer) (g_value_get_pointer (value_g));
    return getHandleFromPointer(env, pointer_g);
}


#ifdef __cplusplus
}

#endif
