'''
Maps the commands registered in L{DefaultPerk} to keys with left Alt-Shift as 
the standard modifier.

@author: Peter Parente
@organization: IBM Corporation
@copyright: Copyright (c) 2005, 2006 IBM Corporation
@license: Common Public License 1.0

All rights reserved. This program and the accompanying materials are made 
available under the terms of the Common Public License v1.0 which accompanies
this distribution, and is available at
U{http://www.opensource.org/licenses/cpl1.0.php}
'''
import Perk

class AltShiftPerk(Perk.Perk):
  '''
  Defines a mapping from the named commands registered in the L{DefaultPerk} to
  key combos on a standard keyboard starting with the modifiers Alt and Shift
  and ending with a non-modifier.
  '''
  def init(self):
    '''    
    Gets a reference to the L{Keyboard} device. Sets the Alt and Shift keys as
    modifier keys. Registers named L{Task}s in the L{DefaultPerk} as commands.
    '''
    # get the Keyboard device and register modifiers and commands
    kbd = self.getInputDevice('Keyboard')
    kbd.addModifier(kbd.AEK_ALT_L)
    kbd.addModifier(kbd.AEK_SHIFT_L)
    kbd.addModifier(kbd.AEK_ALT_R)
    kbd.addModifier(kbd.AEK_SHIFT_R)
    kbd.addModifier(kbd.AEK_CONTROL_L)
    kbd.addModifier(kbd.AEK_CONTROL_R)
  
    self.registerCommandTask(kbd, [[kbd.AEK_CONTROL_R, kbd.AEK_CONTROL_L]], 
                             'Mute/Unmute now', False)
    self.registerCommandTask(kbd, [[kbd.AEK_CONTROL_R]], 
                             'Stop now', False)
    self.registerCommandTask(kbd, [[kbd.AEK_CONTROL_L]], 
                             'Stop now', False)
    
    # register commands for either left Alt-Shift or right Alt-Shift
    pairs = [[kbd.AEK_ALT_L, kbd.AEK_SHIFT_L], 
             [kbd.AEK_ALT_R, kbd.AEK_SHIFT_R]]
    for pair in pairs:
      self.registerCommandTask(kbd, [pair+[kbd.AEK_PAGE_UP]], 
                               'Increase rate')
      self.registerCommandTask(kbd, [pair+[kbd.AEK_PAGE_DOWN]], 
                               'Decrease rate')
      self.registerCommandTask(kbd, [pair+[kbd.AEK_U]], 
                               'Previous item')
      self.registerCommandTask(kbd, [pair+[kbd.AEK_I]], 
                               'Current item')
      self.registerCommandTask(kbd, [pair+[kbd.AEK_O]], 
                               'Next item')
      self.registerCommandTask(kbd, [pair+[kbd.AEK_J]], 
                               'Previous word')
      self.registerCommandTask(kbd, [pair+[kbd.AEK_K]], 
                               'Current word')
      self.registerCommandTask(kbd, [pair+[kbd.AEK_L]], 
                               'Next word')
      self.registerCommandTask(kbd, [pair+[kbd.AEK_M]], 
                               'Previous char')
      self.registerCommandTask(kbd, [pair+[kbd.AEK_COMMA]], 
                               'Current char')
      self.registerCommandTask(kbd, [pair+[kbd.AEK_PERIOD]], 
                               'Next char')
      self.registerCommandTask(kbd, [pair+[kbd.AEK_F1]], 
                               'Where am I')
      self.registerCommandTask(kbd, [pair+[kbd.AEK_5]],
                               'Focus to pointer')
      self.registerCommandTask(kbd, [pair+[kbd.AEK_3]],
                               'Pointer to focus')
      self.registerCommandTask(kbd, [pair+[kbd.AEK_Y]], 
                               'Read top')
      self.registerCommandTask(kbd, [pair+[kbd.AEK_B]], 
                               'Read text attributes')