'''
Defines L{Tools} for getting input.

@author: Peter Parente
@organization: IBM Corporation
@copyright: Copyright (c) 2005, 2006 IBM Corporation
@license: Common Public License 1.0

All rights reserved. This program and the accompanying materials are made 
available under the terms of the Common Public License v1.0 which accompanies
this distribution, and is available at
U{http://www.opensource.org/licenses/cpl1.0.php}
'''

import Base
from Error import *

class Input(Base.TaskTools):
  '''
  Provides methods for getting input on any L{AEInput} device.
  '''
  def getInputDevice(self, name):
    '''
    Gets an L{AEInput} device from the L{DeviceManager} given its name.
    
    @param name: Name of the L{AEInput} device to get
    @type name: string
    @return: The named input device
    @rtype: L{AEInput}
    @raise InvalidDeviceError: When the requested input device is not loaded
    '''
    dev = self.device_man.getInputByName(name)
    if dev is None:
      raise InvalidDeviceError
    return dev