'''
Profile constants.

@var DEFAULT_PROFILE: Name of the default profile to use when none is specified
@type DEFAULT_PROFILE: string
@var BUILTIN_PROFILES: Names of built-in, protected profiles
@type BUILTIN_PROFILES: list of string
@var DEFAULT_ASSOCIATIONS: Mapping from built-in profile name to L{UIElement}s
  that ship with LSR that should be part of the profile by default
@type DEFAULT_ASSOCIATIONS: dictionary
@var GENERATE_PROFILES: Names of profiles to which generated L{Perk}s should be
  added automatically
@type GENERATE_PROFILES: list of string

@author: Peter Parente
@organization: IBM Corporation
@copyright: Copyright (c) 2005, 2007 IBM Corporation
@license: The BSD License

All rights reserved. This program and the accompanying materials are made 
available under the terms of the BSD license which accompanies
this distribution, and is available at
U{http://www.opensource.org/licenses/bsd-license.php}
'''
# associations for default profiles that ship with LSR
DEFAULT_ASSOCIATIONS = {
  'user': ['Keyboard', 'CliqueAudio', 'IBMSpeech', 'DECtalkSpeech',
           'SpeechDispatcher', 'FestivalSpeech', 'BrlAPIDevice', 'ReviewPerk',
           'BasicSpeechPerk', 'BasicBraillePerk', 'DefaultDialogPerk', 
           'AltShiftPerk', 'MetacityPerk', 'GaimPerk', 'GTerminalPerk', 
           'FirefoxPerk'],
  'developer' :
          ['RawEventMonitor','TaskMonitor', 'IOMonitor', 'Keyboard',
           'CliqueAudio', 'IBMSpeech', 'DECtalkSpeech', 'SpeechDispatcher',
           'FestivalSpeech', 'BrlAPIDevice', 'ReviewPerk', 'BasicSpeechPerk',
           'BasicBraillePerk', 'DefaultDialogPerk', 'AltShiftPerk', 
           'DeveloperPerk', 'MetacityPerk', 'GaimPerk', 'GTerminalPerk', 
           'FirefoxPerk'],
  'monitors' :
          ['RawEventMonitor','TaskMonitor', 'IOMonitor', 'Keyboard',
           'ReviewPerk', 'BasicSpeechPerk', 'BasicBraillePerk', 
           'DefaultDialogPerk', 'AltShiftPerk', 'DeveloperPerk', 
           'MetacityPerk', 'GaimPerk', 'GTerminalPerk', 'FirefoxPerk'],
  'autotest' :
          ['TestLogMonitor','Keyboard', 'ReviewPerk', 'BasicSpeechPerk', 
           'DefaultDialogPerk', 'AltShiftPerk', 'MetacityPerk', 'GaimPerk', 
           'GTerminalPerk'],
  'login' :
          ['Keyboard', 'CliqueAudio', 'IBMSpeech', 'DECtalkSpeech', 
           'SpeechDispatcher', 'FestivalSpeech', 'BrlAPIDevice', 'ReviewPerk', 
           'BasicSpeechPerk', 'BasicBraillePerk', 'AltShiftPerk', 'GdmPerk'],
  'mag' :
          ['Keyboard', 'GnomeMagDevice', 'BasicMagPerk', 'DefaultDialogPerk',
           'AltShiftPerk']
        }
# names of built-in and default LSR profiles
BUILTIN_PROFILES = DEFAULT_ASSOCIATIONS.keys()
DEFAULT_PROFILE = 'user'
GENERATE_PROFILES = ['user', 'developer']