/* data-grid.c
 *
 * Copyright (C) 2002 Vivien Malerba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "data-grid.h"
#include "marshal.h"
#include "data-entry.h"

typedef enum   _DataGridMode   DataGridMode;

enum _DataGridMode {
	DATA_GRID_EDIT_MODE,   /* edition of data from a query */
	DATA_GRID_INSERT_MODE, /* data insertion from a query's model */
	DATA_GRID_ENTER_MODE,  /* data entering without any query model */
	DATA_GRID_BROWSE_MODE  /* same as EDIT but no modification allowed */
};


struct _DataGridPrivate {
	DataGridMode mode;

};


static void data_grid_class_init (DataGridClass * class);
static void data_grid_init (DataGrid * grid);
static void data_grid_finalize (GObject   * object);
static void data_grid_initialize (DataGrid * grid);

enum
{
	ACTION_REFRESH,
	ACTION_INSERT,
	ACTION_EDIT,
	ACTION_DELETE,
	ACTION_CHOOSE,
	LAST_SIGNAL
};

static gint data_grid_signals[LAST_SIGNAL] = { 0, 0, 0, 0, 0 };

/* get a pointer to the parents to be able to call their destructor */
static GObjectClass *parent_class = NULL;

guint
data_grid_get_type (void)
{
	static GType type = 0;

	if (!type) {
		static const GTypeInfo info = {
			sizeof (DataGridClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) data_grid_class_init,
			NULL,
			NULL,
			sizeof (DataGrid),
			0,
			(GInstanceInitFunc) data_grid_init
		};		

		type = g_type_register_static (GTK_TYPE_VBOX, "DataGrid", &info, 0);
	}

	return type;
}

static void
data_grid_class_init (DataGridClass * class)
{
	GObjectClass   *object_class = G_OBJECT_CLASS (class);
	
	parent_class = g_type_class_peek_parent (class);

	data_grid_signals[ACTION_REFRESH] =
		g_signal_new ("action_refresh",
			      G_TYPE_FROM_CLASS (object_class),
			      G_SIGNAL_RUN_FIRST,
			      G_STRUCT_OFFSET (DataGridClass, action_refresh),
			      NULL, NULL,
			      marshal_VOID__VOID, G_TYPE_NONE,
			      0);
	data_grid_signals[ACTION_INSERT] =
		g_signal_new ("action_insert",
			      G_TYPE_FROM_CLASS (object_class),
			      G_SIGNAL_RUN_FIRST,
			      G_STRUCT_OFFSET (DataGridClass, action_insert),
			      NULL, NULL,
			      marshal_VOID__VOID, G_TYPE_NONE,
			      0);
	data_grid_signals[ACTION_EDIT] =
		g_signal_new ("action_edit",
			      G_TYPE_FROM_CLASS (object_class),
			      G_SIGNAL_RUN_FIRST,
			      G_STRUCT_OFFSET (DataGridClass, action_edit),
			      NULL, NULL,
			      marshal_VOID__ULONG, G_TYPE_NONE, 1,
			      G_TYPE_ULONG);
	data_grid_signals[ACTION_DELETE] =
		g_signal_new ("action_delete",
			      G_TYPE_FROM_CLASS (object_class),
			      G_SIGNAL_RUN_FIRST,
			      G_STRUCT_OFFSET (DataGridClass, action_delete),
			      NULL, NULL,
			      marshal_VOID__ULONG, G_TYPE_NONE, 1,
			      G_TYPE_ULONG);
	data_grid_signals[ACTION_CHOOSE] =
		g_signal_new ("action_choose",
			      G_TYPE_FROM_CLASS (object_class),
			      G_SIGNAL_RUN_FIRST,
			      G_STRUCT_OFFSET (DataGridClass, action_choose),
			      NULL, NULL,
			      marshal_VOID__ULONG, G_TYPE_NONE, 1,
			      G_TYPE_ULONG);

	class->action_refresh = NULL;
	class->action_insert = NULL;
	class->action_edit = NULL;
	class->action_delete = NULL;
	class->action_choose = NULL;
	object_class->finalize = data_grid_finalize;
}

static void
data_grid_init (DataGrid * grid)
{
	/* grid->priv = g_new0 (DataGridPrivate, 1); */
}

GtkWidget *
data_grid_new (QueryExec *qx, gulong numrow)
{
	GObject   *obj;
	DataGrid *grid;

	g_return_val_if_fail (qx && IS_QUERY_EXEC (qx), NULL);

	/* FIXME: how to set the parameters for the GtkVBox? */
	obj = g_object_new (DATA_GRID_TYPE, NULL);
	grid = DATA_GRID (obj);

	grid->qx = qx;

	data_grid_initialize (grid);

	return GTK_WIDGET (obj);
}


static void
data_grid_finalize (GObject   * object)
{
	DataGrid *grid;

	g_return_if_fail (object != NULL);
	g_return_if_fail (IS_DATA_GRID (object));

	grid = DATA_GRID (object);

	/* if (grid->priv) { */
/* 		if (grid->priv->value_references) { */
/* 			GSList *list; */
/* 			list = grid->priv->value_references; */
/* 			while (list) { */
/* 				g_free (list->data); */
/* 				list = g_slist_next (list); */
/* 			} */
/* 			g_slist_free (grid->priv->value_references); */
/* 			grid->priv->value_references = NULL; */
/* 		} */
		
/* 		if (grid->priv->entries) { */
/* 			GSList *list; */
/* 			list = grid->priv->entries; */
/* 			while (list) { */
/* 				g_free (list->data); */
/* 				list = g_slist_next (list); */
/* 			} */
/* 			g_slist_free (grid->priv->entries); */
/* 			grid->priv->entries = NULL; */
/* 		} */
		
/* 		g_free (grid->priv); */
/* 		grid->priv = NULL; */
/* 	} */

	/* for the parent class */
	parent_class->finalize (object);
}

static void 
data_grid_initialize (DataGrid * grid)
{
	GtkWidget *wid;

	if (!query_exec_get_data_set (grid->qx)) 
		wid = gtk_label_new (_("No Data!"));
	else {
		wid = gtk_label_new ("Grid to load");
	}

	gtk_widget_show_all (wid);
	gtk_box_pack_start_defaults (GTK_BOX (grid), wid);
}

void
data_grid_refresh (DataGrid *grid)
{

}
