%{

/*
 This file is part of pybliographer
 
 Copyright (C) 1998 Frederic GOBRY
 Email : gobry@idiap.ch
 	   
 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2 
 of the License, or (at your option) any later version.
   
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details. 
 
 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 
 $Id: biblex.l,v 1.8 1998/10/29 12:12:08 gobry Exp $
*/


#include "bibtex.h"
#include "bibparse.h"

static bibtex_file * current_file;

#define YY_USER_ACTION   current_file->offset += yyleng;

void bibtex_parser_initialize (bibtex_file * file) {
  g_return_if_fail (file != NULL);

  /* Destroy old buffer */
  if (file->buffer)
    yy_delete_buffer ((YY_BUFFER_STATE) file->buffer);

  file->buffer = (gpointer) yy_create_buffer (file->file, 1024);
}


void bibtex_parser_continue (bibtex_file * file) { 
  g_return_if_fail (file != NULL);

  current_file = file;

  yy_switch_to_buffer ((YY_BUFFER_STATE) file->buffer);
  BEGIN(INITIAL); 
}

void bibtex_parser_finish (bibtex_file * file) {
  g_return_if_fail (file != NULL);

  if (file->buffer)
    yy_delete_buffer ((YY_BUFFER_STATE) file->buffer);

  file->buffer = NULL;
}

extern void bibtex_next_line (void);

%}

DIGIT    [0-9]+
NAME     [^ \\\t{}"@(),=%#\n]+

%option noyywrap
%x comment entry

%%
		if (YY_START == INITIAL) { BEGIN(comment); }

<comment>^@		BEGIN(entry); return ('@');

<comment>\n		bibtex_next_line ();
<comment>.


<comment,entry><<EOF>>  {  return (end_of_file); }


<entry>[ \t]*\\. { yylval.text = g_strdup (yytext); tmp_string (yylval.text); return (L_QUOTED); }

<entry>[ \t\n]*[@(){},=%#"][ \t\n]* { 
  char * tmp;
  char value;
  char * before, * after;
  char sym [2];

  tmp = yytext;

  before = after = "";

  while (* tmp == ' ' || * tmp == '\t' || * tmp == '\n') {
    if (* tmp == '\n') { bibtex_next_line ();}
    tmp ++;
    before = " ";
  }
  value = * tmp;
  tmp ++;

  while (* tmp) {
    if (* tmp == '\n') {  bibtex_next_line ();}
    tmp ++;
    after = " ";
  }

  sym [0] = value;
  sym [1] = '\0';

  yylval.text = g_strconcat (before, sym, after, NULL); 
  tmp_string (yylval.text); 

  return (value); 
}

<entry>{DIGIT}	 { yylval.text = g_strdup (yytext); tmp_string (yylval.text); return (L_DIGIT); }

<entry>{NAME}	 { yylval.text = g_strdup (yytext); tmp_string (yylval.text); return (L_NAME); }

<entry>[ \t]+\n*[ \t]* {   
  char * tmp = yytext;

  while (* tmp) {
    if (* tmp == '\n') bibtex_next_line ();
    tmp ++;
  }
return ' '; 
}

<entry>\n+ {
  char * tmp = yytext;

  while (* tmp) {
    if (* tmp == '\n') bibtex_next_line ();
    tmp ++;
  }
return ' '; 
}

%%

