/*
 This file is part of pybliographer
 
 Copyright (C) 1998-1999 Frederic GOBRY
 Email : gobry@idiap.ch
 	   
 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2 
 of the License, or (at your option) any later version.
   
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details. 
 
 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 
 $Id: recodemodule.c,v 1.4 1999/08/16 09:38:31 gobry Exp $
*/

#ifdef HAVE_CONFIG_H
#include "pyblioconf.h"
#endif

#ifdef HAVE_STDBOOL_H
#include <stdbool.h>
#else /* ! HAVE_STDBOOL_H */

/* stdbool.h for GNU.  */

/* The type `bool' must promote to `int' or `unsigned int'.  The constants
   `true' and `false' must have the value 0 and 1 respectively.  */
typedef enum
  {
    false = 0,
    true = 1
  } bool;

/* The names `true' and `false' must also be made available as macros.  */
#define false	false
#define true	true

/* Signal that all the definitions are present.  */
#define __bool_true_false_are_defined	1

#endif /* HAVE_STDBOOL_H */

#include <stdio.h>

#ifdef USE_RECODE
#include <recode.h>
#endif

#include <Python.h>

#ifdef USE_RECODE
static RECODE_OUTER outer;
char * program_name = "pyrecode";
#endif

static void
py_delete_recoder (void * recoder) {
#ifdef USE_RECODE
    RECODE_REQUEST request = (RECODE_REQUEST) recoder;

    recode_delete_request (request);
#endif
}

static PyObject *
py_new_recoder (PyObject * self, PyObject * args) {
#ifdef USE_RECODE
    char * string;
    RECODE_REQUEST request;

    if (! PyArg_ParseTuple(args, "s", & string))
	return NULL;

    request = recode_new_request (outer);
    if (request == NULL) {
	PyErr_SetString (PyExc_IOError, "can't initialize new request");
	return NULL;
    }

    if (! recode_scan_request (request, string)) {
	PyErr_SetString (PyExc_IOError, "can't initialize request");
	return NULL;
    }

    return PyCObject_FromVoidPtr (request, py_delete_recoder);
#else
    Py_INCREF (Py_None);
    return Py_None;
#endif
}

static PyObject *
py_recode (PyObject * self, PyObject * args) {
#ifdef USE_RECODE
    char * string;
    RECODE_REQUEST request;
    PyObject * tmp;

    if (! PyArg_ParseTuple(args, "Os", & request, & string))
	return NULL;

    request = (RECODE_REQUEST) PyCObject_AsVoidPtr ((void *) request);

    string = recode_string (request, string);
    if (string == NULL) {
	PyErr_SetString (PyExc_IOError, "can't convert");
	return NULL;
    }

    tmp = PyString_FromString (string);
    free (string);

    return tmp;
#else
    Py_INCREF (Py_None);
    return Py_None;
#endif
}

static PyMethodDef recodeMeth [] = {
    { "request", py_new_recoder, METH_VARARGS },
    { "recode", py_recode, METH_VARARGS },
    {NULL, NULL, 0},
};


void initrecode ()
{
#ifdef USE_RECODE
    outer = recode_new_outer (false);
    if (outer == NULL) return;
#else
    fprintf (stderr, "warning: module recode is currently disabled.\n");
    fprintf (stderr, "warning: to enable it, install GNU Recode and recompile.\n");
#endif

    (void) Py_InitModule ("recode", recodeMeth);
}

