#! @bin_dir@/pybliographer -q
# -*- python -*-
# This file is part of pybliographer
# 
# Copyright (C) 1998 Frederic GOBRY
# Email : gobry@idiap.ch
# 	   
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2 
# of the License, or (at your option) any later version.
#   
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details. 
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
# 
# $Id: pybcheck.py,v 1.1 1999/08/16 09:38:32 gobry Exp $

import os, sys, string

if len (sys.argv) < 2:
    print "usage: pybcheck <file | directory>..."
    sys.exit (1)

broken = []

for dir in sys.argv [1:]:

    if os.path.isdir (dir):
        files = map (lambda x, dir = dir: \
                     os.path.join (dir, x), os.listdir (dir))
    else:
        files = [dir]


    for f in files:
        
        if os.path.splitext (f) [1] == '.bib':
            try:
                print bibopen (f)
            except (IOError, KeyError), err:
                broken.append (str (err))
            
print string.join (broken, "\n")
