/* -*- Mode: C; c-basic-offset: 4 -*- */

#include <Python.h>



#line 4 "atk.override"
#include <Python.h>

#include "pygobject.h"
#include <atk/atk.h>
#include <atk/atknoopobjectfactory.h>
#include <atk/atknoopobject.h>
#line 15 "atk.c"


/* ---------- types from other modules ---------- */
static PyTypeObject *_PyGObject_Type;
#define PyGObject_Type (*_PyGObject_Type)


/* ---------- forward type declarations ---------- */
PyTypeObject PyAtkHyperlink_Type;
PyTypeObject PyAtkObject_Type;
PyTypeObject PyAtkNoOpObject_Type;
PyTypeObject PyAtkObjectFactory_Type;
PyTypeObject PyAtkNoOpObjectFactory_Type;
PyTypeObject PyAtkRegistry_Type;
PyTypeObject PyAtkRelation_Type;
PyTypeObject PyAtkRelationSet_Type;
PyTypeObject PyAtkStateSet_Type;
PyTypeObject PyAtkUtil_Type;


/* ----------- AtkHyperlink ----------- */

static int
pygobject_no_constructor(PyObject *self, PyObject *args, PyObject *kwargs)
{
    gchar buf[512];

    g_snprintf(buf, sizeof(buf), "%s is an abstract widget", self->ob_type->tp_name);
    PyErr_SetString(PyExc_NotImplementedError, buf);
    return -1;
}

static PyObject *
_wrap_atk_hyperlink_get_uri(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    int i;
    static char *kwlist[] = { "i", NULL };
    gchar *ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "i:AtkHyperlink.get_uri", kwlist, &i))
        return NULL;

    ret = atk_hyperlink_get_uri(ATK_HYPERLINK(self->obj), i);
    if (0)
        g_free(ret);

    if (ret) {
        PyObject *py_ret = PyString_FromString(ret);
        g_free(ret);
        return py_ret;
    }
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_atk_hyperlink_get_object(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    int i;
    static char *kwlist[] = { "i", NULL };
    GObject * ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "i:AtkHyperlink.get_object", kwlist, &i))
        return NULL;

    ret = (GObject *)atk_hyperlink_get_object(ATK_HYPERLINK(self->obj), i);

    /* pygobject_new handles NULL checking */
    return pygobject_new(ret);
}

static PyObject *
_wrap_atk_hyperlink_get_end_index(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    int ret;
    static char *kwlist[] = { NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":AtkHyperlink.get_end_index", kwlist))
        return NULL;

    ret = atk_hyperlink_get_end_index(ATK_HYPERLINK(self->obj));

    return PyInt_FromLong(ret);
}

static PyObject *
_wrap_atk_hyperlink_get_start_index(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    int ret;
    static char *kwlist[] = { NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":AtkHyperlink.get_start_index", kwlist))
        return NULL;

    ret = atk_hyperlink_get_start_index(ATK_HYPERLINK(self->obj));

    return PyInt_FromLong(ret);
}

static PyObject *
_wrap_atk_hyperlink_is_valid(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    int ret;
    static char *kwlist[] = { NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":AtkHyperlink.is_valid", kwlist))
        return NULL;

    ret = atk_hyperlink_is_valid(ATK_HYPERLINK(self->obj));

    return PyInt_FromLong(ret);
}

static PyObject *
_wrap_atk_hyperlink_get_n_anchors(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    int ret;
    static char *kwlist[] = { NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":AtkHyperlink.get_n_anchors", kwlist))
        return NULL;

    ret = atk_hyperlink_get_n_anchors(ATK_HYPERLINK(self->obj));

    return PyInt_FromLong(ret);
}

static PyMethodDef _PyAtkHyperlink_methods[] = {
    { "get_uri", (PyCFunction)_wrap_atk_hyperlink_get_uri, METH_VARARGS|METH_KEYWORDS },
    { "get_object", (PyCFunction)_wrap_atk_hyperlink_get_object, METH_VARARGS|METH_KEYWORDS },
    { "get_end_index", (PyCFunction)_wrap_atk_hyperlink_get_end_index, METH_VARARGS|METH_KEYWORDS },
    { "get_start_index", (PyCFunction)_wrap_atk_hyperlink_get_start_index, METH_VARARGS|METH_KEYWORDS },
    { "is_valid", (PyCFunction)_wrap_atk_hyperlink_is_valid, METH_VARARGS|METH_KEYWORDS },
    { "get_n_anchors", (PyCFunction)_wrap_atk_hyperlink_get_n_anchors, METH_VARARGS|METH_KEYWORDS },
    { NULL, NULL, 0 }
};

PyTypeObject PyAtkHyperlink_Type = {
    PyObject_HEAD_INIT(NULL)
    0,				/* ob_size */
    "Hyperlink",		/* tp_name */
    sizeof(PyGObject),		/* tp_basicsize */
    0,				/* tp_itemsize */
    /* methods */
    (destructor)0,			/* tp_dealloc */
    (printfunc)0,			/* tp_print */
    (getattrfunc)0,			/* tp_getattr */
    (setattrfunc)0,			/* tp_setattr */
    (cmpfunc)0,			/* tp_compare */
    (reprfunc)0,			/* tp_repr */
    0,				/* tp_as_number */
    0,				/* tp_as_sequence */
    0,				/* tp_as_mapping */
    (hashfunc)0,			/* tp_hash */
    (ternaryfunc)0,			/* tp_call */
    (reprfunc)0,			/* tp_str */
    (getattrofunc)0,		/* tp_getattro */
    (setattrofunc)0,		/* tp_setattro */
    0,				/* tp_as_buffer */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /* tp_flags */
    NULL, /* Documentation string */
    (traverseproc)0,		/* tp_traverse */
    (inquiry)0,			/* tp_clear */
    (richcmpfunc)0,			/* tp_richcompare */
    offsetof(PyGObject, weakreflist), /* tp_weaklistoffset */
    (getiterfunc)0,			/* tp_iter */
    (iternextfunc)0,		/* tp_iternext */
    _PyAtkHyperlink_methods,			/* tp_methods */
    0,				/* tp_members */
    0,			/* tp_getset */
    NULL,				/* tp_base */
    NULL,				/* tp_dict */
    (descrgetfunc)0,		/* tp_descr_get */
    (descrsetfunc)0,		/* tp_descr_set */
    offsetof(PyGObject, inst_dict),	/* tp_dictoffset */
    (initproc)pygobject_no_constructor,		/* tp_init */
};



/* ----------- AtkObject ----------- */

static PyObject *
_wrap_atk_object_get_name(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { NULL };
    const gchar *ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":AtkObject.get_name", kwlist))
        return NULL;

    ret = atk_object_get_name(ATK_OBJECT(self->obj));

    if (ret)
        return PyString_FromString(ret);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_atk_object_get_description(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { NULL };
    const gchar *ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":AtkObject.get_description", kwlist))
        return NULL;

    ret = atk_object_get_description(ATK_OBJECT(self->obj));

    if (ret)
        return PyString_FromString(ret);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_atk_object_get_parent(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { NULL };
    GObject * ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":AtkObject.get_parent", kwlist))
        return NULL;

    ret = (GObject *)atk_object_get_parent(ATK_OBJECT(self->obj));

    /* pygobject_new handles NULL checking */
    return pygobject_new(ret);
}

static PyObject *
_wrap_atk_object_get_n_accessible_children(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    int ret;
    static char *kwlist[] = { NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":AtkObject.get_n_accessible_children", kwlist))
        return NULL;

    ret = atk_object_get_n_accessible_children(ATK_OBJECT(self->obj));

    return PyInt_FromLong(ret);
}

static PyObject *
_wrap_atk_object_ref_accessible_child(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    int i;
    static char *kwlist[] = { "i", NULL };
    GObject * ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "i:AtkObject.ref_accessible_child", kwlist, &i))
        return NULL;

    ret = (GObject *)atk_object_ref_accessible_child(ATK_OBJECT(self->obj), i);

    /* pygobject_new handles NULL checking */
    return pygobject_new(ret);
}

static PyObject *
_wrap_atk_object_ref_relation_set(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { NULL };
    GObject * ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":AtkObject.ref_relation_set", kwlist))
        return NULL;

    ret = (GObject *)atk_object_ref_relation_set(ATK_OBJECT(self->obj));

    /* pygobject_new handles NULL checking */
    return pygobject_new(ret);
}

static PyObject *
_wrap_atk_object_get_role(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    int ret;
    static char *kwlist[] = { NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":AtkObject.get_role", kwlist))
        return NULL;

    ret = (int) atk_object_get_role(ATK_OBJECT(self->obj));

    return PyInt_FromLong(ret);
}

static PyObject *
_wrap_atk_object_get_layer(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    int ret;
    static char *kwlist[] = { NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":AtkObject.get_layer", kwlist))
        return NULL;

    ret = (int) atk_object_get_layer(ATK_OBJECT(self->obj));

    return PyInt_FromLong(ret);
}

static PyObject *
_wrap_atk_object_get_mdi_zorder(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    int ret;
    static char *kwlist[] = { NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":AtkObject.get_mdi_zorder", kwlist))
        return NULL;

    ret = atk_object_get_mdi_zorder(ATK_OBJECT(self->obj));

    return PyInt_FromLong(ret);
}

static PyObject *
_wrap_atk_object_ref_state_set(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { NULL };
    GObject * ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":AtkObject.ref_state_set", kwlist))
        return NULL;

    ret = (GObject *)atk_object_ref_state_set(ATK_OBJECT(self->obj));

    /* pygobject_new handles NULL checking */
    return pygobject_new(ret);
}

static PyObject *
_wrap_atk_object_get_index_in_parent(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    int ret;
    static char *kwlist[] = { NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":AtkObject.get_index_in_parent", kwlist))
        return NULL;

    ret = atk_object_get_index_in_parent(ATK_OBJECT(self->obj));

    return PyInt_FromLong(ret);
}

static PyObject *
_wrap_atk_object_set_name(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    char *name;
    static char *kwlist[] = { "name", NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s:AtkObject.set_name", kwlist, &name))
        return NULL;

    atk_object_set_name(ATK_OBJECT(self->obj), name);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_atk_object_set_description(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    char *description;
    static char *kwlist[] = { "description", NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s:AtkObject.set_description", kwlist, &description))
        return NULL;

    atk_object_set_description(ATK_OBJECT(self->obj), description);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_atk_object_set_parent(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    PyGObject *parent;
    static char *kwlist[] = { "parent", NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:AtkObject.set_parent", kwlist, &parent))
        return NULL;
    if (!pygobject_check(parent, &PyAtkObject_Type)) {
        PyErr_SetString(PyExc_TypeError, "parent should be a AtkObject");
        return NULL;
    }

    atk_object_set_parent(ATK_OBJECT(self->obj), ATK_OBJECT(parent->obj));
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_atk_object_set_role(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_role = NULL;
    AtkRole role;
    static char *kwlist[] = { "role", NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:AtkObject.set_role", kwlist, &py_role))
        return NULL;
    if (pyg_enum_get_value(G_TYPE_NONE, py_role, (gint *)&role))
        return NULL;

    atk_object_set_role(ATK_OBJECT(self->obj), role);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_atk_object_remove_property_change_handler(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    int handler_id;
    static char *kwlist[] = { "handler_id", NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "i:AtkObject.remove_property_change_handler", kwlist, &handler_id))
        return NULL;

    atk_object_remove_property_change_handler(ATK_OBJECT(self->obj), handler_id);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyMethodDef _PyAtkObject_methods[] = {
    { "get_name", (PyCFunction)_wrap_atk_object_get_name, METH_VARARGS|METH_KEYWORDS },
    { "get_description", (PyCFunction)_wrap_atk_object_get_description, METH_VARARGS|METH_KEYWORDS },
    { "get_parent", (PyCFunction)_wrap_atk_object_get_parent, METH_VARARGS|METH_KEYWORDS },
    { "get_n_accessible_children", (PyCFunction)_wrap_atk_object_get_n_accessible_children, METH_VARARGS|METH_KEYWORDS },
    { "ref_accessible_child", (PyCFunction)_wrap_atk_object_ref_accessible_child, METH_VARARGS|METH_KEYWORDS },
    { "ref_relation_set", (PyCFunction)_wrap_atk_object_ref_relation_set, METH_VARARGS|METH_KEYWORDS },
    { "get_role", (PyCFunction)_wrap_atk_object_get_role, METH_VARARGS|METH_KEYWORDS },
    { "get_layer", (PyCFunction)_wrap_atk_object_get_layer, METH_VARARGS|METH_KEYWORDS },
    { "get_mdi_zorder", (PyCFunction)_wrap_atk_object_get_mdi_zorder, METH_VARARGS|METH_KEYWORDS },
    { "ref_state_set", (PyCFunction)_wrap_atk_object_ref_state_set, METH_VARARGS|METH_KEYWORDS },
    { "get_index_in_parent", (PyCFunction)_wrap_atk_object_get_index_in_parent, METH_VARARGS|METH_KEYWORDS },
    { "set_name", (PyCFunction)_wrap_atk_object_set_name, METH_VARARGS|METH_KEYWORDS },
    { "set_description", (PyCFunction)_wrap_atk_object_set_description, METH_VARARGS|METH_KEYWORDS },
    { "set_parent", (PyCFunction)_wrap_atk_object_set_parent, METH_VARARGS|METH_KEYWORDS },
    { "set_role", (PyCFunction)_wrap_atk_object_set_role, METH_VARARGS|METH_KEYWORDS },
    { "remove_property_change_handler", (PyCFunction)_wrap_atk_object_remove_property_change_handler, METH_VARARGS|METH_KEYWORDS },
    { NULL, NULL, 0 }
};

PyTypeObject PyAtkObject_Type = {
    PyObject_HEAD_INIT(NULL)
    0,				/* ob_size */
    "Object",		/* tp_name */
    sizeof(PyGObject),		/* tp_basicsize */
    0,				/* tp_itemsize */
    /* methods */
    (destructor)0,			/* tp_dealloc */
    (printfunc)0,			/* tp_print */
    (getattrfunc)0,			/* tp_getattr */
    (setattrfunc)0,			/* tp_setattr */
    (cmpfunc)0,			/* tp_compare */
    (reprfunc)0,			/* tp_repr */
    0,				/* tp_as_number */
    0,				/* tp_as_sequence */
    0,				/* tp_as_mapping */
    (hashfunc)0,			/* tp_hash */
    (ternaryfunc)0,			/* tp_call */
    (reprfunc)0,			/* tp_str */
    (getattrofunc)0,		/* tp_getattro */
    (setattrofunc)0,		/* tp_setattro */
    0,				/* tp_as_buffer */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /* tp_flags */
    NULL, /* Documentation string */
    (traverseproc)0,		/* tp_traverse */
    (inquiry)0,			/* tp_clear */
    (richcmpfunc)0,			/* tp_richcompare */
    offsetof(PyGObject, weakreflist), /* tp_weaklistoffset */
    (getiterfunc)0,			/* tp_iter */
    (iternextfunc)0,		/* tp_iternext */
    _PyAtkObject_methods,			/* tp_methods */
    0,				/* tp_members */
    0,			/* tp_getset */
    NULL,				/* tp_base */
    NULL,				/* tp_dict */
    (descrgetfunc)0,		/* tp_descr_get */
    (descrsetfunc)0,		/* tp_descr_set */
    offsetof(PyGObject, inst_dict),	/* tp_dictoffset */
    (initproc)pygobject_no_constructor,		/* tp_init */
};



/* ----------- AtkNoOpObject ----------- */

static int
_wrap_atk_no_op_object_new(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    PyGObject *obj;
    static char *kwlist[] = { "obj", NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:AtkNoOpObject.__init__", kwlist, &obj))
        return -1;
    if (!pygobject_check(obj, &PyGObject_Type)) {
        PyErr_SetString(PyExc_TypeError, "obj should be a GObject");
        return -1;
    }

    self->obj = (GObject *)atk_no_op_object_new(G_OBJECT(obj->obj));
    if (!self->obj) {
        PyErr_SetString(PyExc_RuntimeError, "could not create AtkNoOpObject object");
        return -1;
    }
    pygobject_register_wrapper((PyObject *)self);
    return 0;
}

static PyMethodDef _PyAtkNoOpObject_methods[] = {
    { NULL, NULL, 0 }
};

PyTypeObject PyAtkNoOpObject_Type = {
    PyObject_HEAD_INIT(NULL)
    0,				/* ob_size */
    "NoOpObject",		/* tp_name */
    sizeof(PyGObject),		/* tp_basicsize */
    0,				/* tp_itemsize */
    /* methods */
    (destructor)0,			/* tp_dealloc */
    (printfunc)0,			/* tp_print */
    (getattrfunc)0,			/* tp_getattr */
    (setattrfunc)0,			/* tp_setattr */
    (cmpfunc)0,			/* tp_compare */
    (reprfunc)0,			/* tp_repr */
    0,				/* tp_as_number */
    0,				/* tp_as_sequence */
    0,				/* tp_as_mapping */
    (hashfunc)0,			/* tp_hash */
    (ternaryfunc)0,			/* tp_call */
    (reprfunc)0,			/* tp_str */
    (getattrofunc)0,		/* tp_getattro */
    (setattrofunc)0,		/* tp_setattro */
    0,				/* tp_as_buffer */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /* tp_flags */
    NULL, /* Documentation string */
    (traverseproc)0,		/* tp_traverse */
    (inquiry)0,			/* tp_clear */
    (richcmpfunc)0,			/* tp_richcompare */
    offsetof(PyGObject, weakreflist), /* tp_weaklistoffset */
    (getiterfunc)0,			/* tp_iter */
    (iternextfunc)0,		/* tp_iternext */
    _PyAtkNoOpObject_methods,			/* tp_methods */
    0,				/* tp_members */
    0,			/* tp_getset */
    NULL,				/* tp_base */
    NULL,				/* tp_dict */
    (descrgetfunc)0,		/* tp_descr_get */
    (descrsetfunc)0,		/* tp_descr_set */
    offsetof(PyGObject, inst_dict),	/* tp_dictoffset */
    (initproc)_wrap_atk_no_op_object_new,		/* tp_init */
};



/* ----------- AtkObjectFactory ----------- */

static PyObject *
_wrap_atk_object_factory_create_accessible(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    PyGObject *obj;
    static char *kwlist[] = { "obj", NULL };
    GObject * ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:AtkObjectFactory.create_accessible", kwlist, &obj))
        return NULL;
    if (!pygobject_check(obj, &PyGObject_Type)) {
        PyErr_SetString(PyExc_TypeError, "obj should be a GObject");
        return NULL;
    }

    ret = (GObject *)atk_object_factory_create_accessible(ATK_OBJECT_FACTORY(self->obj), G_OBJECT(obj->obj));

    /* pygobject_new handles NULL checking */
    return pygobject_new(ret);
}

static PyObject *
_wrap_atk_object_factory_invalidate(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":AtkObjectFactory.invalidate", kwlist))
        return NULL;

    atk_object_factory_invalidate(ATK_OBJECT_FACTORY(self->obj));
    Py_INCREF(Py_None);
    return Py_None;
}

static PyMethodDef _PyAtkObjectFactory_methods[] = {
    { "create_accessible", (PyCFunction)_wrap_atk_object_factory_create_accessible, METH_VARARGS|METH_KEYWORDS },
    { "invalidate", (PyCFunction)_wrap_atk_object_factory_invalidate, METH_VARARGS|METH_KEYWORDS },
    { NULL, NULL, 0 }
};

PyTypeObject PyAtkObjectFactory_Type = {
    PyObject_HEAD_INIT(NULL)
    0,				/* ob_size */
    "ObjectFactory",		/* tp_name */
    sizeof(PyGObject),		/* tp_basicsize */
    0,				/* tp_itemsize */
    /* methods */
    (destructor)0,			/* tp_dealloc */
    (printfunc)0,			/* tp_print */
    (getattrfunc)0,			/* tp_getattr */
    (setattrfunc)0,			/* tp_setattr */
    (cmpfunc)0,			/* tp_compare */
    (reprfunc)0,			/* tp_repr */
    0,				/* tp_as_number */
    0,				/* tp_as_sequence */
    0,				/* tp_as_mapping */
    (hashfunc)0,			/* tp_hash */
    (ternaryfunc)0,			/* tp_call */
    (reprfunc)0,			/* tp_str */
    (getattrofunc)0,		/* tp_getattro */
    (setattrofunc)0,		/* tp_setattro */
    0,				/* tp_as_buffer */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /* tp_flags */
    NULL, /* Documentation string */
    (traverseproc)0,		/* tp_traverse */
    (inquiry)0,			/* tp_clear */
    (richcmpfunc)0,			/* tp_richcompare */
    offsetof(PyGObject, weakreflist), /* tp_weaklistoffset */
    (getiterfunc)0,			/* tp_iter */
    (iternextfunc)0,		/* tp_iternext */
    _PyAtkObjectFactory_methods,			/* tp_methods */
    0,				/* tp_members */
    0,			/* tp_getset */
    NULL,				/* tp_base */
    NULL,				/* tp_dict */
    (descrgetfunc)0,		/* tp_descr_get */
    (descrsetfunc)0,		/* tp_descr_set */
    offsetof(PyGObject, inst_dict),	/* tp_dictoffset */
    (initproc)pygobject_no_constructor,		/* tp_init */
};



/* ----------- AtkNoOpObjectFactory ----------- */

static PyMethodDef _PyAtkNoOpObjectFactory_methods[] = {
    { NULL, NULL, 0 }
};

PyTypeObject PyAtkNoOpObjectFactory_Type = {
    PyObject_HEAD_INIT(NULL)
    0,				/* ob_size */
    "NoOpObjectFactory",		/* tp_name */
    sizeof(PyGObject),		/* tp_basicsize */
    0,				/* tp_itemsize */
    /* methods */
    (destructor)0,			/* tp_dealloc */
    (printfunc)0,			/* tp_print */
    (getattrfunc)0,			/* tp_getattr */
    (setattrfunc)0,			/* tp_setattr */
    (cmpfunc)0,			/* tp_compare */
    (reprfunc)0,			/* tp_repr */
    0,				/* tp_as_number */
    0,				/* tp_as_sequence */
    0,				/* tp_as_mapping */
    (hashfunc)0,			/* tp_hash */
    (ternaryfunc)0,			/* tp_call */
    (reprfunc)0,			/* tp_str */
    (getattrofunc)0,		/* tp_getattro */
    (setattrofunc)0,		/* tp_setattro */
    0,				/* tp_as_buffer */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /* tp_flags */
    NULL, /* Documentation string */
    (traverseproc)0,		/* tp_traverse */
    (inquiry)0,			/* tp_clear */
    (richcmpfunc)0,			/* tp_richcompare */
    offsetof(PyGObject, weakreflist), /* tp_weaklistoffset */
    (getiterfunc)0,			/* tp_iter */
    (iternextfunc)0,		/* tp_iternext */
    _PyAtkNoOpObjectFactory_methods,			/* tp_methods */
    0,				/* tp_members */
    0,			/* tp_getset */
    NULL,				/* tp_base */
    NULL,				/* tp_dict */
    (descrgetfunc)0,		/* tp_descr_get */
    (descrsetfunc)0,		/* tp_descr_set */
    offsetof(PyGObject, inst_dict),	/* tp_dictoffset */
    (initproc)pygobject_no_constructor,		/* tp_init */
};



/* ----------- AtkRegistry ----------- */

static PyObject *
_wrap_atk_registry_set_factory_type(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_type = NULL, *py_factory_type = NULL;
    static char *kwlist[] = { "type", "factory_type", NULL };
    GType type, factory_type;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:AtkRegistry.set_factory_type", kwlist, &py_type, &py_factory_type))
        return NULL;
    if ((type = pyg_type_from_object(py_type)) == 0)
        return NULL;
    if ((factory_type = pyg_type_from_object(py_factory_type)) == 0)
        return NULL;

    atk_registry_set_factory_type(ATK_REGISTRY(self->obj), type, factory_type);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_atk_registry_get_factory_type(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_type = NULL;
    static char *kwlist[] = { "type", NULL };
    GType type;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:AtkRegistry.get_factory_type", kwlist, &py_type))
        return NULL;
    if ((type = pyg_type_from_object(py_type)) == 0)
        return NULL;

    return pyg_type_wrapper_new(atk_registry_get_factory_type(ATK_REGISTRY(self->obj), type));
}

static PyObject *
_wrap_atk_registry_get_factory(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_type = NULL;
    static char *kwlist[] = { "type", NULL };
    GType type;
    GObject * ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:AtkRegistry.get_factory", kwlist, &py_type))
        return NULL;
    if ((type = pyg_type_from_object(py_type)) == 0)
        return NULL;

    ret = (GObject *)atk_registry_get_factory(ATK_REGISTRY(self->obj), type);

    /* pygobject_new handles NULL checking */
    return pygobject_new(ret);
}

static PyMethodDef _PyAtkRegistry_methods[] = {
    { "set_factory_type", (PyCFunction)_wrap_atk_registry_set_factory_type, METH_VARARGS|METH_KEYWORDS },
    { "get_factory_type", (PyCFunction)_wrap_atk_registry_get_factory_type, METH_VARARGS|METH_KEYWORDS },
    { "get_factory", (PyCFunction)_wrap_atk_registry_get_factory, METH_VARARGS|METH_KEYWORDS },
    { NULL, NULL, 0 }
};

PyTypeObject PyAtkRegistry_Type = {
    PyObject_HEAD_INIT(NULL)
    0,				/* ob_size */
    "Registry",		/* tp_name */
    sizeof(PyGObject),		/* tp_basicsize */
    0,				/* tp_itemsize */
    /* methods */
    (destructor)0,			/* tp_dealloc */
    (printfunc)0,			/* tp_print */
    (getattrfunc)0,			/* tp_getattr */
    (setattrfunc)0,			/* tp_setattr */
    (cmpfunc)0,			/* tp_compare */
    (reprfunc)0,			/* tp_repr */
    0,				/* tp_as_number */
    0,				/* tp_as_sequence */
    0,				/* tp_as_mapping */
    (hashfunc)0,			/* tp_hash */
    (ternaryfunc)0,			/* tp_call */
    (reprfunc)0,			/* tp_str */
    (getattrofunc)0,		/* tp_getattro */
    (setattrofunc)0,		/* tp_setattro */
    0,				/* tp_as_buffer */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /* tp_flags */
    NULL, /* Documentation string */
    (traverseproc)0,		/* tp_traverse */
    (inquiry)0,			/* tp_clear */
    (richcmpfunc)0,			/* tp_richcompare */
    offsetof(PyGObject, weakreflist), /* tp_weaklistoffset */
    (getiterfunc)0,			/* tp_iter */
    (iternextfunc)0,		/* tp_iternext */
    _PyAtkRegistry_methods,			/* tp_methods */
    0,				/* tp_members */
    0,			/* tp_getset */
    NULL,				/* tp_base */
    NULL,				/* tp_dict */
    (descrgetfunc)0,		/* tp_descr_get */
    (descrsetfunc)0,		/* tp_descr_set */
    offsetof(PyGObject, inst_dict),	/* tp_dictoffset */
    (initproc)pygobject_no_constructor,		/* tp_init */
};



/* ----------- AtkRelation ----------- */

static PyObject *
_wrap_atk_relation_get_relation_type(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    int ret;
    static char *kwlist[] = { NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":AtkRelation.get_relation_type", kwlist))
        return NULL;

    ret = (int) atk_relation_get_relation_type(ATK_RELATION(self->obj));

    return PyInt_FromLong(ret);
}

static PyMethodDef _PyAtkRelation_methods[] = {
    { "get_relation_type", (PyCFunction)_wrap_atk_relation_get_relation_type, METH_VARARGS|METH_KEYWORDS },
    { NULL, NULL, 0 }
};

PyTypeObject PyAtkRelation_Type = {
    PyObject_HEAD_INIT(NULL)
    0,				/* ob_size */
    "Relation",		/* tp_name */
    sizeof(PyGObject),		/* tp_basicsize */
    0,				/* tp_itemsize */
    /* methods */
    (destructor)0,			/* tp_dealloc */
    (printfunc)0,			/* tp_print */
    (getattrfunc)0,			/* tp_getattr */
    (setattrfunc)0,			/* tp_setattr */
    (cmpfunc)0,			/* tp_compare */
    (reprfunc)0,			/* tp_repr */
    0,				/* tp_as_number */
    0,				/* tp_as_sequence */
    0,				/* tp_as_mapping */
    (hashfunc)0,			/* tp_hash */
    (ternaryfunc)0,			/* tp_call */
    (reprfunc)0,			/* tp_str */
    (getattrofunc)0,		/* tp_getattro */
    (setattrofunc)0,		/* tp_setattro */
    0,				/* tp_as_buffer */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /* tp_flags */
    NULL, /* Documentation string */
    (traverseproc)0,		/* tp_traverse */
    (inquiry)0,			/* tp_clear */
    (richcmpfunc)0,			/* tp_richcompare */
    offsetof(PyGObject, weakreflist), /* tp_weaklistoffset */
    (getiterfunc)0,			/* tp_iter */
    (iternextfunc)0,		/* tp_iternext */
    _PyAtkRelation_methods,			/* tp_methods */
    0,				/* tp_members */
    0,			/* tp_getset */
    NULL,				/* tp_base */
    NULL,				/* tp_dict */
    (descrgetfunc)0,		/* tp_descr_get */
    (descrsetfunc)0,		/* tp_descr_set */
    offsetof(PyGObject, inst_dict),	/* tp_dictoffset */
    (initproc)pygobject_no_constructor,		/* tp_init */
};



/* ----------- AtkRelationSet ----------- */

static int
_wrap_atk_relation_set_new(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":AtkRelationSet.__init__", kwlist))
        return -1;

    self->obj = (GObject *)atk_relation_set_new();
    if (!self->obj) {
        PyErr_SetString(PyExc_RuntimeError, "could not create AtkRelationSet object");
        return -1;
    }
    pygobject_register_wrapper((PyObject *)self);
    return 0;
}

static PyObject *
_wrap_atk_relation_set_contains(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_relationship = NULL;
    AtkRelationType relationship;
    int ret;
    static char *kwlist[] = { "relationship", NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:AtkRelationSet.contains", kwlist, &py_relationship))
        return NULL;
    if (pyg_enum_get_value(G_TYPE_NONE, py_relationship, (gint *)&relationship))
        return NULL;

    ret = atk_relation_set_contains(ATK_RELATION_SET(self->obj), relationship);

    return PyInt_FromLong(ret);
}

static PyObject *
_wrap_atk_relation_set_remove(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    PyGObject *relation;
    static char *kwlist[] = { "relation", NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:AtkRelationSet.remove", kwlist, &relation))
        return NULL;
    if (!pygobject_check(relation, &PyAtkRelation_Type)) {
        PyErr_SetString(PyExc_TypeError, "relation should be a AtkRelation");
        return NULL;
    }

    atk_relation_set_remove(ATK_RELATION_SET(self->obj), ATK_RELATION(relation->obj));
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_atk_relation_set_add(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    PyGObject *relation;
    static char *kwlist[] = { "relation", NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:AtkRelationSet.add", kwlist, &relation))
        return NULL;
    if (!pygobject_check(relation, &PyAtkRelation_Type)) {
        PyErr_SetString(PyExc_TypeError, "relation should be a AtkRelation");
        return NULL;
    }

    atk_relation_set_add(ATK_RELATION_SET(self->obj), ATK_RELATION(relation->obj));
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_atk_relation_set_get_n_relations(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    int ret;
    static char *kwlist[] = { NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":AtkRelationSet.get_n_relations", kwlist))
        return NULL;

    ret = atk_relation_set_get_n_relations(ATK_RELATION_SET(self->obj));

    return PyInt_FromLong(ret);
}

static PyObject *
_wrap_atk_relation_set_get_relation(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    int i;
    static char *kwlist[] = { "i", NULL };
    GObject * ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "i:AtkRelationSet.get_relation", kwlist, &i))
        return NULL;

    ret = (GObject *)atk_relation_set_get_relation(ATK_RELATION_SET(self->obj), i);

    /* pygobject_new handles NULL checking */
    return pygobject_new(ret);
}

static PyObject *
_wrap_atk_relation_set_get_relation_by_type(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_relationship = NULL;
    AtkRelationType relationship;
    GObject * ret;
    static char *kwlist[] = { "relationship", NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:AtkRelationSet.get_relation_by_type", kwlist, &py_relationship))
        return NULL;
    if (pyg_enum_get_value(G_TYPE_NONE, py_relationship, (gint *)&relationship))
        return NULL;

    ret = (GObject *)atk_relation_set_get_relation_by_type(ATK_RELATION_SET(self->obj), relationship);

    /* pygobject_new handles NULL checking */
    return pygobject_new(ret);
}

static PyMethodDef _PyAtkRelationSet_methods[] = {
    { "contains", (PyCFunction)_wrap_atk_relation_set_contains, METH_VARARGS|METH_KEYWORDS },
    { "remove", (PyCFunction)_wrap_atk_relation_set_remove, METH_VARARGS|METH_KEYWORDS },
    { "add", (PyCFunction)_wrap_atk_relation_set_add, METH_VARARGS|METH_KEYWORDS },
    { "get_n_relations", (PyCFunction)_wrap_atk_relation_set_get_n_relations, METH_VARARGS|METH_KEYWORDS },
    { "get_relation", (PyCFunction)_wrap_atk_relation_set_get_relation, METH_VARARGS|METH_KEYWORDS },
    { "get_relation_by_type", (PyCFunction)_wrap_atk_relation_set_get_relation_by_type, METH_VARARGS|METH_KEYWORDS },
    { NULL, NULL, 0 }
};

PyTypeObject PyAtkRelationSet_Type = {
    PyObject_HEAD_INIT(NULL)
    0,				/* ob_size */
    "RelationSet",		/* tp_name */
    sizeof(PyGObject),		/* tp_basicsize */
    0,				/* tp_itemsize */
    /* methods */
    (destructor)0,			/* tp_dealloc */
    (printfunc)0,			/* tp_print */
    (getattrfunc)0,			/* tp_getattr */
    (setattrfunc)0,			/* tp_setattr */
    (cmpfunc)0,			/* tp_compare */
    (reprfunc)0,			/* tp_repr */
    0,				/* tp_as_number */
    0,				/* tp_as_sequence */
    0,				/* tp_as_mapping */
    (hashfunc)0,			/* tp_hash */
    (ternaryfunc)0,			/* tp_call */
    (reprfunc)0,			/* tp_str */
    (getattrofunc)0,		/* tp_getattro */
    (setattrofunc)0,		/* tp_setattro */
    0,				/* tp_as_buffer */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /* tp_flags */
    NULL, /* Documentation string */
    (traverseproc)0,		/* tp_traverse */
    (inquiry)0,			/* tp_clear */
    (richcmpfunc)0,			/* tp_richcompare */
    offsetof(PyGObject, weakreflist), /* tp_weaklistoffset */
    (getiterfunc)0,			/* tp_iter */
    (iternextfunc)0,		/* tp_iternext */
    _PyAtkRelationSet_methods,			/* tp_methods */
    0,				/* tp_members */
    0,			/* tp_getset */
    NULL,				/* tp_base */
    NULL,				/* tp_dict */
    (descrgetfunc)0,		/* tp_descr_get */
    (descrsetfunc)0,		/* tp_descr_set */
    offsetof(PyGObject, inst_dict),	/* tp_dictoffset */
    (initproc)_wrap_atk_relation_set_new,		/* tp_init */
};



/* ----------- AtkStateSet ----------- */

static PyObject *
_wrap_atk_state_set_is_empty(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    int ret;
    static char *kwlist[] = { NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":AtkStateSet.is_empty", kwlist))
        return NULL;

    ret = atk_state_set_is_empty(ATK_STATE_SET(self->obj));

    return PyInt_FromLong(ret);
}

static PyObject *
_wrap_atk_state_set_add_state(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_type = NULL;
    AtkStateType type;
    int ret;
    static char *kwlist[] = { "type", NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:AtkStateSet.add_state", kwlist, &py_type))
        return NULL;
    if (pyg_enum_get_value(G_TYPE_NONE, py_type, (gint *)&type))
        return NULL;

    ret = atk_state_set_add_state(ATK_STATE_SET(self->obj), type);

    return PyInt_FromLong(ret);
}

static PyObject *
_wrap_atk_state_set_clear_states(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":AtkStateSet.clear_states", kwlist))
        return NULL;

    atk_state_set_clear_states(ATK_STATE_SET(self->obj));
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_atk_state_set_contains_state(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_type = NULL;
    AtkStateType type;
    int ret;
    static char *kwlist[] = { "type", NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:AtkStateSet.contains_state", kwlist, &py_type))
        return NULL;
    if (pyg_enum_get_value(G_TYPE_NONE, py_type, (gint *)&type))
        return NULL;

    ret = atk_state_set_contains_state(ATK_STATE_SET(self->obj), type);

    return PyInt_FromLong(ret);
}

static PyObject *
_wrap_atk_state_set_remove_state(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_type = NULL;
    AtkStateType type;
    int ret;
    static char *kwlist[] = { "type", NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:AtkStateSet.remove_state", kwlist, &py_type))
        return NULL;
    if (pyg_enum_get_value(G_TYPE_NONE, py_type, (gint *)&type))
        return NULL;

    ret = atk_state_set_remove_state(ATK_STATE_SET(self->obj), type);

    return PyInt_FromLong(ret);
}

static PyObject *
_wrap_atk_state_set_and_sets(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    PyGObject *compare_set;
    static char *kwlist[] = { "compare_set", NULL };
    GObject * ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:AtkStateSet.and_sets", kwlist, &compare_set))
        return NULL;
    if (!pygobject_check(compare_set, &PyAtkStateSet_Type)) {
        PyErr_SetString(PyExc_TypeError, "compare_set should be a AtkStateSet");
        return NULL;
    }

    ret = (GObject *)atk_state_set_and_sets(ATK_STATE_SET(self->obj), ATK_STATE_SET(compare_set->obj));

    /* pygobject_new handles NULL checking */
    return pygobject_new(ret);
}

static PyObject *
_wrap_atk_state_set_or_sets(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    PyGObject *compare_set;
    static char *kwlist[] = { "compare_set", NULL };
    GObject * ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:AtkStateSet.or_sets", kwlist, &compare_set))
        return NULL;
    if (!pygobject_check(compare_set, &PyAtkStateSet_Type)) {
        PyErr_SetString(PyExc_TypeError, "compare_set should be a AtkStateSet");
        return NULL;
    }

    ret = (GObject *)atk_state_set_or_sets(ATK_STATE_SET(self->obj), ATK_STATE_SET(compare_set->obj));

    /* pygobject_new handles NULL checking */
    return pygobject_new(ret);
}

static PyObject *
_wrap_atk_state_set_xor_sets(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    PyGObject *compare_set;
    static char *kwlist[] = { "compare_set", NULL };
    GObject * ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:AtkStateSet.xor_sets", kwlist, &compare_set))
        return NULL;
    if (!pygobject_check(compare_set, &PyAtkStateSet_Type)) {
        PyErr_SetString(PyExc_TypeError, "compare_set should be a AtkStateSet");
        return NULL;
    }

    ret = (GObject *)atk_state_set_xor_sets(ATK_STATE_SET(self->obj), ATK_STATE_SET(compare_set->obj));

    /* pygobject_new handles NULL checking */
    return pygobject_new(ret);
}

static PyMethodDef _PyAtkStateSet_methods[] = {
    { "is_empty", (PyCFunction)_wrap_atk_state_set_is_empty, METH_VARARGS|METH_KEYWORDS },
    { "add_state", (PyCFunction)_wrap_atk_state_set_add_state, METH_VARARGS|METH_KEYWORDS },
    { "clear_states", (PyCFunction)_wrap_atk_state_set_clear_states, METH_VARARGS|METH_KEYWORDS },
    { "contains_state", (PyCFunction)_wrap_atk_state_set_contains_state, METH_VARARGS|METH_KEYWORDS },
    { "remove_state", (PyCFunction)_wrap_atk_state_set_remove_state, METH_VARARGS|METH_KEYWORDS },
    { "and_sets", (PyCFunction)_wrap_atk_state_set_and_sets, METH_VARARGS|METH_KEYWORDS },
    { "or_sets", (PyCFunction)_wrap_atk_state_set_or_sets, METH_VARARGS|METH_KEYWORDS },
    { "xor_sets", (PyCFunction)_wrap_atk_state_set_xor_sets, METH_VARARGS|METH_KEYWORDS },
    { NULL, NULL, 0 }
};

PyTypeObject PyAtkStateSet_Type = {
    PyObject_HEAD_INIT(NULL)
    0,				/* ob_size */
    "StateSet",		/* tp_name */
    sizeof(PyGObject),		/* tp_basicsize */
    0,				/* tp_itemsize */
    /* methods */
    (destructor)0,			/* tp_dealloc */
    (printfunc)0,			/* tp_print */
    (getattrfunc)0,			/* tp_getattr */
    (setattrfunc)0,			/* tp_setattr */
    (cmpfunc)0,			/* tp_compare */
    (reprfunc)0,			/* tp_repr */
    0,				/* tp_as_number */
    0,				/* tp_as_sequence */
    0,				/* tp_as_mapping */
    (hashfunc)0,			/* tp_hash */
    (ternaryfunc)0,			/* tp_call */
    (reprfunc)0,			/* tp_str */
    (getattrofunc)0,		/* tp_getattro */
    (setattrofunc)0,		/* tp_setattro */
    0,				/* tp_as_buffer */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /* tp_flags */
    NULL, /* Documentation string */
    (traverseproc)0,		/* tp_traverse */
    (inquiry)0,			/* tp_clear */
    (richcmpfunc)0,			/* tp_richcompare */
    offsetof(PyGObject, weakreflist), /* tp_weaklistoffset */
    (getiterfunc)0,			/* tp_iter */
    (iternextfunc)0,		/* tp_iternext */
    _PyAtkStateSet_methods,			/* tp_methods */
    0,				/* tp_members */
    0,			/* tp_getset */
    NULL,				/* tp_base */
    NULL,				/* tp_dict */
    (descrgetfunc)0,		/* tp_descr_get */
    (descrsetfunc)0,		/* tp_descr_set */
    offsetof(PyGObject, inst_dict),	/* tp_dictoffset */
    (initproc)pygobject_no_constructor,		/* tp_init */
};



/* ----------- AtkUtil ----------- */

static PyMethodDef _PyAtkUtil_methods[] = {
    { NULL, NULL, 0 }
};

PyTypeObject PyAtkUtil_Type = {
    PyObject_HEAD_INIT(NULL)
    0,				/* ob_size */
    "Util",		/* tp_name */
    sizeof(PyGObject),		/* tp_basicsize */
    0,				/* tp_itemsize */
    /* methods */
    (destructor)0,			/* tp_dealloc */
    (printfunc)0,			/* tp_print */
    (getattrfunc)0,			/* tp_getattr */
    (setattrfunc)0,			/* tp_setattr */
    (cmpfunc)0,			/* tp_compare */
    (reprfunc)0,			/* tp_repr */
    0,				/* tp_as_number */
    0,				/* tp_as_sequence */
    0,				/* tp_as_mapping */
    (hashfunc)0,			/* tp_hash */
    (ternaryfunc)0,			/* tp_call */
    (reprfunc)0,			/* tp_str */
    (getattrofunc)0,		/* tp_getattro */
    (setattrofunc)0,		/* tp_setattro */
    0,				/* tp_as_buffer */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /* tp_flags */
    NULL, /* Documentation string */
    (traverseproc)0,		/* tp_traverse */
    (inquiry)0,			/* tp_clear */
    (richcmpfunc)0,			/* tp_richcompare */
    offsetof(PyGObject, weakreflist), /* tp_weaklistoffset */
    (getiterfunc)0,			/* tp_iter */
    (iternextfunc)0,		/* tp_iternext */
    _PyAtkUtil_methods,			/* tp_methods */
    0,				/* tp_members */
    0,			/* tp_getset */
    NULL,				/* tp_base */
    NULL,				/* tp_dict */
    (descrgetfunc)0,		/* tp_descr_get */
    (descrsetfunc)0,		/* tp_descr_set */
    offsetof(PyGObject, inst_dict),	/* tp_dictoffset */
    (initproc)pygobject_no_constructor,		/* tp_init */
};



/* ----------- functions ----------- */

static PyObject *
_wrap_atk_no_op_object_factory_new(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { NULL };
    GObject * ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":atk_no_op_object_factory_new", kwlist))
        return NULL;

    ret = (GObject *)atk_no_op_object_factory_new();

    /* pygobject_new handles NULL checking */
    return pygobject_new(ret);
}

static PyObject *
_wrap_atk_get_default_registry(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { NULL };
    GObject * ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":get_default_registry", kwlist))
        return NULL;

    ret = (GObject *)atk_get_default_registry();

    /* pygobject_new handles NULL checking */
    return pygobject_new(ret);
}

static PyObject *
_wrap_atk_relation_type_register(PyObject *self, PyObject *args, PyObject *kwargs)
{
    char *name;
    static char *kwlist[] = { "name", NULL };
    int ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s:relation_type_register", kwlist, &name))
        return NULL;

    ret = (int) atk_relation_type_register(name);

    return PyInt_FromLong(ret);
}

static PyObject *
_wrap_atk_relation_type_for_name(PyObject *self, PyObject *args, PyObject *kwargs)
{
    char *name;
    static char *kwlist[] = { "name", NULL };
    int ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s:relation_type_for_name", kwlist, &name))
        return NULL;

    ret = (int) atk_relation_type_for_name(name);

    return PyInt_FromLong(ret);
}

#line 17 "atk.override"
static PyObject *
_wrap_atk_relation_new(PyGBoxed *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "targets", "relationship", NULL };
    AtkObject **targets;
    AtkRelation *ret;
    int relationship, count, i;
    PyObject *py_targets;
    
    if (!PyArg_ParseTupleAndKeywords(args, kwargs,
				     "Oi#:relation_new", kwlist,
				     &py_targets, &relationship))
	return NULL;

    if (!PySequence_Check(py_targets)) {
	PyErr_SetString(PyExc_TypeError, "targets argument must be a sequence");
	return NULL;
    }

    count = PySequence_Length(py_targets);
    targets = g_new(AtkObject *, count);
    for (i = 0; i < count; i++) {
	PyObject *item = PySequence_GetItem(py_targets, i);
	Py_DECREF(item); /* PySequence_GetItem INCREF's */
	if (!pygobject_check(item, &PyAtkObject_Type)) {
	    PyErr_SetString(PyExc_TypeError, "targets argument must be a sequence of AtkObjects.");
	    g_free(targets);
	    return NULL;
	}
	    
	targets[i] = (AtkObject *) pygobject_get(item);
    }

    ret = atk_relation_new(targets, count, relationship);
    g_free(targets);
    
    return pygobject_new((GObject *) ret);
}
#line 1399 "atk.c"


static PyObject *
_wrap_atk_state_type_for_name(PyObject *self, PyObject *args, PyObject *kwargs)
{
    char *name;
    static char *kwlist[] = { "name", NULL };
    int ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s:state_type_for_name", kwlist, &name))
        return NULL;

    ret = (int) atk_state_type_for_name(name);

    return PyInt_FromLong(ret);
}

static PyObject *
_wrap_atk_attribute_get_name(PyObject *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_attr = NULL;
    AtkTextAttribute attr;
    const gchar *ret;
    static char *kwlist[] = { "attr", NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:attribute_get_name", kwlist, &py_attr))
        return NULL;
    if (pyg_enum_get_value(G_TYPE_NONE, py_attr, (gint *)&attr))
        return NULL;

    ret = atk_attribute_get_name(attr);

    if (ret)
        return PyString_FromString(ret);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_atk_attribute_get_value(PyObject *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_attr = NULL;
    AtkTextAttribute attr;
    int index;
    const gchar *ret;
    static char *kwlist[] = { "attr", "index", NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "Oi:attribute_get_value", kwlist, &py_attr, &index))
        return NULL;
    if (pyg_enum_get_value(G_TYPE_NONE, py_attr, (gint *)&attr))
        return NULL;

    ret = atk_attribute_get_value(attr, index);

    if (ret)
        return PyString_FromString(ret);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_atk_remove_focus_tracker(PyObject *self, PyObject *args, PyObject *kwargs)
{
    int tracker_id;
    static char *kwlist[] = { "tracker_id", NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "i:remove_focus_tracker", kwlist, &tracker_id))
        return NULL;

    atk_remove_focus_tracker(tracker_id);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_atk_focus_tracker_notify(PyObject *self, PyObject *args, PyObject *kwargs)
{
    PyGObject *object;
    static char *kwlist[] = { "object", NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:focus_tracker_notify", kwlist, &object))
        return NULL;
    if (!pygobject_check(object, &PyAtkObject_Type)) {
        PyErr_SetString(PyExc_TypeError, "object should be a AtkObject");
        return NULL;
    }

    atk_focus_tracker_notify(ATK_OBJECT(object->obj));
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_atk_remove_global_event_listener(PyObject *self, PyObject *args, PyObject *kwargs)
{
    int listener_id;
    static char *kwlist[] = { "listener_id", NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "i:remove_global_event_listener", kwlist, &listener_id))
        return NULL;

    atk_remove_global_event_listener(listener_id);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_atk_remove_key_event_listener(PyObject *self, PyObject *args, PyObject *kwargs)
{
    int listener_id;
    static char *kwlist[] = { "listener_id", NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "i:remove_key_event_listener", kwlist, &listener_id))
        return NULL;

    atk_remove_key_event_listener(listener_id);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_atk_get_root(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { NULL };
    GObject * ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":get_root", kwlist))
        return NULL;

    ret = (GObject *)atk_get_root();

    /* pygobject_new handles NULL checking */
    return pygobject_new(ret);
}

static PyObject *
_wrap_atk_get_toolkit_name(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { NULL };
    const gchar *ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":get_toolkit_name", kwlist))
        return NULL;

    ret = atk_get_toolkit_name();

    if (ret)
        return PyString_FromString(ret);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_atk_get_toolkit_version(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { NULL };
    const gchar *ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":get_toolkit_version", kwlist))
        return NULL;

    ret = atk_get_toolkit_version();

    if (ret)
        return PyString_FromString(ret);
    Py_INCREF(Py_None);
    return Py_None;
}

PyMethodDef pyatk_functions[] = {
    { "atk_no_op_object_factory_new", (PyCFunction)_wrap_atk_no_op_object_factory_new, METH_VARARGS|METH_KEYWORDS },
    { "get_default_registry", (PyCFunction)_wrap_atk_get_default_registry, METH_VARARGS|METH_KEYWORDS },
    { "relation_type_register", (PyCFunction)_wrap_atk_relation_type_register, METH_VARARGS|METH_KEYWORDS },
    { "relation_type_for_name", (PyCFunction)_wrap_atk_relation_type_for_name, METH_VARARGS|METH_KEYWORDS },
    { "relation_new", (PyCFunction)_wrap_atk_relation_new, METH_VARARGS|METH_KEYWORDS },
    { "state_type_for_name", (PyCFunction)_wrap_atk_state_type_for_name, METH_VARARGS|METH_KEYWORDS },
    { "attribute_get_name", (PyCFunction)_wrap_atk_attribute_get_name, METH_VARARGS|METH_KEYWORDS },
    { "attribute_get_value", (PyCFunction)_wrap_atk_attribute_get_value, METH_VARARGS|METH_KEYWORDS },
    { "remove_focus_tracker", (PyCFunction)_wrap_atk_remove_focus_tracker, METH_VARARGS|METH_KEYWORDS },
    { "focus_tracker_notify", (PyCFunction)_wrap_atk_focus_tracker_notify, METH_VARARGS|METH_KEYWORDS },
    { "remove_global_event_listener", (PyCFunction)_wrap_atk_remove_global_event_listener, METH_VARARGS|METH_KEYWORDS },
    { "remove_key_event_listener", (PyCFunction)_wrap_atk_remove_key_event_listener, METH_VARARGS|METH_KEYWORDS },
    { "get_root", (PyCFunction)_wrap_atk_get_root, METH_VARARGS|METH_KEYWORDS },
    { "get_toolkit_name", (PyCFunction)_wrap_atk_get_toolkit_name, METH_VARARGS|METH_KEYWORDS },
    { "get_toolkit_version", (PyCFunction)_wrap_atk_get_toolkit_version, METH_VARARGS|METH_KEYWORDS },
    { NULL, NULL, 0 }
};


/* ----------- enums and flags ----------- */

void
pyatk_add_constants(PyObject *module, const gchar *strip_prefix)
{
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_ROLE_INVALID", strip_prefix), ATK_ROLE_INVALID);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_ROLE_ACCEL_LABEL", strip_prefix), ATK_ROLE_ACCEL_LABEL);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_ROLE_ALERT", strip_prefix), ATK_ROLE_ALERT);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_ROLE_ANIMATION", strip_prefix), ATK_ROLE_ANIMATION);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_ROLE_ARROW", strip_prefix), ATK_ROLE_ARROW);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_ROLE_CALENDAR", strip_prefix), ATK_ROLE_CALENDAR);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_ROLE_CANVAS", strip_prefix), ATK_ROLE_CANVAS);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_ROLE_CHECK_BOX", strip_prefix), ATK_ROLE_CHECK_BOX);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_ROLE_CHECK_MENU_ITEM", strip_prefix), ATK_ROLE_CHECK_MENU_ITEM);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_ROLE_COLOR_CHOOSER", strip_prefix), ATK_ROLE_COLOR_CHOOSER);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_ROLE_COLUMN_HEADER", strip_prefix), ATK_ROLE_COLUMN_HEADER);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_ROLE_COMBO_BOX", strip_prefix), ATK_ROLE_COMBO_BOX);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_ROLE_DATE_EDITOR", strip_prefix), ATK_ROLE_DATE_EDITOR);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_ROLE_DESKTOP_ICON", strip_prefix), ATK_ROLE_DESKTOP_ICON);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_ROLE_DESKTOP_FRAME", strip_prefix), ATK_ROLE_DESKTOP_FRAME);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_ROLE_DIAL", strip_prefix), ATK_ROLE_DIAL);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_ROLE_DIALOG", strip_prefix), ATK_ROLE_DIALOG);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_ROLE_DIRECTORY_PANE", strip_prefix), ATK_ROLE_DIRECTORY_PANE);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_ROLE_DRAWING_AREA", strip_prefix), ATK_ROLE_DRAWING_AREA);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_ROLE_FILE_CHOOSER", strip_prefix), ATK_ROLE_FILE_CHOOSER);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_ROLE_FILLER", strip_prefix), ATK_ROLE_FILLER);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_ROLE_FONT_CHOOSER", strip_prefix), ATK_ROLE_FONT_CHOOSER);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_ROLE_FRAME", strip_prefix), ATK_ROLE_FRAME);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_ROLE_GLASS_PANE", strip_prefix), ATK_ROLE_GLASS_PANE);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_ROLE_HTML_CONTAINER", strip_prefix), ATK_ROLE_HTML_CONTAINER);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_ROLE_ICON", strip_prefix), ATK_ROLE_ICON);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_ROLE_IMAGE", strip_prefix), ATK_ROLE_IMAGE);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_ROLE_INTERNAL_FRAME", strip_prefix), ATK_ROLE_INTERNAL_FRAME);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_ROLE_LABEL", strip_prefix), ATK_ROLE_LABEL);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_ROLE_LAYERED_PANE", strip_prefix), ATK_ROLE_LAYERED_PANE);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_ROLE_LIST", strip_prefix), ATK_ROLE_LIST);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_ROLE_LIST_ITEM", strip_prefix), ATK_ROLE_LIST_ITEM);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_ROLE_MENU", strip_prefix), ATK_ROLE_MENU);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_ROLE_MENU_BAR", strip_prefix), ATK_ROLE_MENU_BAR);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_ROLE_MENU_ITEM", strip_prefix), ATK_ROLE_MENU_ITEM);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_ROLE_OPTION_PANE", strip_prefix), ATK_ROLE_OPTION_PANE);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_ROLE_PAGE_TAB", strip_prefix), ATK_ROLE_PAGE_TAB);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_ROLE_PAGE_TAB_LIST", strip_prefix), ATK_ROLE_PAGE_TAB_LIST);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_ROLE_PANEL", strip_prefix), ATK_ROLE_PANEL);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_ROLE_PASSWORD_TEXT", strip_prefix), ATK_ROLE_PASSWORD_TEXT);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_ROLE_POPUP_MENU", strip_prefix), ATK_ROLE_POPUP_MENU);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_ROLE_PROGRESS_BAR", strip_prefix), ATK_ROLE_PROGRESS_BAR);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_ROLE_PUSH_BUTTON", strip_prefix), ATK_ROLE_PUSH_BUTTON);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_ROLE_RADIO_BUTTON", strip_prefix), ATK_ROLE_RADIO_BUTTON);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_ROLE_RADIO_MENU_ITEM", strip_prefix), ATK_ROLE_RADIO_MENU_ITEM);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_ROLE_ROOT_PANE", strip_prefix), ATK_ROLE_ROOT_PANE);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_ROLE_ROW_HEADER", strip_prefix), ATK_ROLE_ROW_HEADER);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_ROLE_SCROLL_BAR", strip_prefix), ATK_ROLE_SCROLL_BAR);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_ROLE_SCROLL_PANE", strip_prefix), ATK_ROLE_SCROLL_PANE);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_ROLE_SEPARATOR", strip_prefix), ATK_ROLE_SEPARATOR);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_ROLE_SLIDER", strip_prefix), ATK_ROLE_SLIDER);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_ROLE_SPLIT_PANE", strip_prefix), ATK_ROLE_SPLIT_PANE);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_ROLE_SPIN_BUTTON", strip_prefix), ATK_ROLE_SPIN_BUTTON);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_ROLE_STATUSBAR", strip_prefix), ATK_ROLE_STATUSBAR);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_ROLE_TABLE", strip_prefix), ATK_ROLE_TABLE);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_ROLE_TABLE_CELL", strip_prefix), ATK_ROLE_TABLE_CELL);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_ROLE_TABLE_COLUMN_HEADER", strip_prefix), ATK_ROLE_TABLE_COLUMN_HEADER);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_ROLE_TABLE_ROW_HEADER", strip_prefix), ATK_ROLE_TABLE_ROW_HEADER);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_ROLE_TEAR_OFF_MENU_ITEM", strip_prefix), ATK_ROLE_TEAR_OFF_MENU_ITEM);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_ROLE_TERMINAL", strip_prefix), ATK_ROLE_TERMINAL);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_ROLE_TEXT", strip_prefix), ATK_ROLE_TEXT);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_ROLE_TOGGLE_BUTTON", strip_prefix), ATK_ROLE_TOGGLE_BUTTON);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_ROLE_TOOL_BAR", strip_prefix), ATK_ROLE_TOOL_BAR);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_ROLE_TOOL_TIP", strip_prefix), ATK_ROLE_TOOL_TIP);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_ROLE_TREE", strip_prefix), ATK_ROLE_TREE);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_ROLE_TREE_TABLE", strip_prefix), ATK_ROLE_TREE_TABLE);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_ROLE_UNKNOWN", strip_prefix), ATK_ROLE_UNKNOWN);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_ROLE_VIEWPORT", strip_prefix), ATK_ROLE_VIEWPORT);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_ROLE_WINDOW", strip_prefix), ATK_ROLE_WINDOW);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_ROLE_LAST_DEFINED", strip_prefix), ATK_ROLE_LAST_DEFINED);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_LAYER_INVALID", strip_prefix), ATK_LAYER_INVALID);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_LAYER_BACKGROUND", strip_prefix), ATK_LAYER_BACKGROUND);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_LAYER_CANVAS", strip_prefix), ATK_LAYER_CANVAS);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_LAYER_WIDGET", strip_prefix), ATK_LAYER_WIDGET);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_LAYER_MDI", strip_prefix), ATK_LAYER_MDI);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_LAYER_POPUP", strip_prefix), ATK_LAYER_POPUP);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_LAYER_OVERLAY", strip_prefix), ATK_LAYER_OVERLAY);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_RELATION_NULL", strip_prefix), ATK_RELATION_NULL);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_RELATION_CONTROLLED_BY", strip_prefix), ATK_RELATION_CONTROLLED_BY);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_RELATION_CONTROLLER_FOR", strip_prefix), ATK_RELATION_CONTROLLER_FOR);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_RELATION_LABEL_FOR", strip_prefix), ATK_RELATION_LABEL_FOR);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_RELATION_LABELLED_BY", strip_prefix), ATK_RELATION_LABELLED_BY);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_RELATION_MEMBER_OF", strip_prefix), ATK_RELATION_MEMBER_OF);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_RELATION_NODE_CHILD_OF", strip_prefix), ATK_RELATION_NODE_CHILD_OF);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_RELATION_LAST_DEFINED", strip_prefix), ATK_RELATION_LAST_DEFINED);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_STATE_INVALID", strip_prefix), ATK_STATE_INVALID);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_STATE_ACTIVE", strip_prefix), ATK_STATE_ACTIVE);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_STATE_ARMED", strip_prefix), ATK_STATE_ARMED);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_STATE_BUSY", strip_prefix), ATK_STATE_BUSY);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_STATE_CHECKED", strip_prefix), ATK_STATE_CHECKED);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_STATE_DEFUNCT", strip_prefix), ATK_STATE_DEFUNCT);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_STATE_EDITABLE", strip_prefix), ATK_STATE_EDITABLE);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_STATE_ENABLED", strip_prefix), ATK_STATE_ENABLED);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_STATE_EXPANDABLE", strip_prefix), ATK_STATE_EXPANDABLE);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_STATE_EXPANDED", strip_prefix), ATK_STATE_EXPANDED);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_STATE_FOCUSABLE", strip_prefix), ATK_STATE_FOCUSABLE);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_STATE_FOCUSED", strip_prefix), ATK_STATE_FOCUSED);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_STATE_HORIZONTAL", strip_prefix), ATK_STATE_HORIZONTAL);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_STATE_ICONIFIED", strip_prefix), ATK_STATE_ICONIFIED);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_STATE_MODAL", strip_prefix), ATK_STATE_MODAL);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_STATE_MULTI_LINE", strip_prefix), ATK_STATE_MULTI_LINE);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_STATE_MULTISELECTABLE", strip_prefix), ATK_STATE_MULTISELECTABLE);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_STATE_OPAQUE", strip_prefix), ATK_STATE_OPAQUE);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_STATE_PRESSED", strip_prefix), ATK_STATE_PRESSED);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_STATE_RESIZABLE", strip_prefix), ATK_STATE_RESIZABLE);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_STATE_SELECTABLE", strip_prefix), ATK_STATE_SELECTABLE);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_STATE_SELECTED", strip_prefix), ATK_STATE_SELECTED);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_STATE_SENSITIVE", strip_prefix), ATK_STATE_SENSITIVE);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_STATE_SHOWING", strip_prefix), ATK_STATE_SHOWING);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_STATE_SINGLE_LINE", strip_prefix), ATK_STATE_SINGLE_LINE);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_STATE_STALE", strip_prefix), ATK_STATE_STALE);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_STATE_TRANSIENT", strip_prefix), ATK_STATE_TRANSIENT);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_STATE_VERTICAL", strip_prefix), ATK_STATE_VERTICAL);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_STATE_VISIBLE", strip_prefix), ATK_STATE_VISIBLE);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_STATE_LAST_DEFINED", strip_prefix), ATK_STATE_LAST_DEFINED);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_TEXT_ATTR_LEFT_MARGIN", strip_prefix), ATK_TEXT_ATTR_LEFT_MARGIN);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_TEXT_ATTR_RIGHT_MARGIN", strip_prefix), ATK_TEXT_ATTR_RIGHT_MARGIN);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_TEXT_ATTR_INDENT", strip_prefix), ATK_TEXT_ATTR_INDENT);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_TEXT_ATTR_INVISIBLE", strip_prefix), ATK_TEXT_ATTR_INVISIBLE);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_TEXT_ATTR_EDITABLE", strip_prefix), ATK_TEXT_ATTR_EDITABLE);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_TEXT_ATTR_PIXELS_ABOVE_LINES", strip_prefix), ATK_TEXT_ATTR_PIXELS_ABOVE_LINES);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_TEXT_ATTR_PIXELS_BELOW_LINES", strip_prefix), ATK_TEXT_ATTR_PIXELS_BELOW_LINES);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_TEXT_ATTR_PIXELS_INSIDE_WRAP", strip_prefix), ATK_TEXT_ATTR_PIXELS_INSIDE_WRAP);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_TEXT_ATTR_BG_FULL_HEIGHT", strip_prefix), ATK_TEXT_ATTR_BG_FULL_HEIGHT);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_TEXT_ATTR_RISE", strip_prefix), ATK_TEXT_ATTR_RISE);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_TEXT_ATTR_UNDERLINE", strip_prefix), ATK_TEXT_ATTR_UNDERLINE);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_TEXT_ATTR_STRIKETHROUGH", strip_prefix), ATK_TEXT_ATTR_STRIKETHROUGH);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_TEXT_ATTR_SIZE", strip_prefix), ATK_TEXT_ATTR_SIZE);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_TEXT_ATTR_SCALE", strip_prefix), ATK_TEXT_ATTR_SCALE);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_TEXT_ATTR_WEIGHT", strip_prefix), ATK_TEXT_ATTR_WEIGHT);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_TEXT_ATTR_LANGUAGE", strip_prefix), ATK_TEXT_ATTR_LANGUAGE);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_TEXT_ATTR_FAMILY_NAME", strip_prefix), ATK_TEXT_ATTR_FAMILY_NAME);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_TEXT_ATTR_BG_COLOR", strip_prefix), ATK_TEXT_ATTR_BG_COLOR);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_TEXT_ATTR_FG_COLOR", strip_prefix), ATK_TEXT_ATTR_FG_COLOR);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_TEXT_ATTR_BG_STIPPLE", strip_prefix), ATK_TEXT_ATTR_BG_STIPPLE);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_TEXT_ATTR_FG_STIPPLE", strip_prefix), ATK_TEXT_ATTR_FG_STIPPLE);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_TEXT_ATTR_WRAP_MODE", strip_prefix), ATK_TEXT_ATTR_WRAP_MODE);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_TEXT_ATTR_DIRECTION", strip_prefix), ATK_TEXT_ATTR_DIRECTION);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_TEXT_ATTR_JUSTIFICATION", strip_prefix), ATK_TEXT_ATTR_JUSTIFICATION);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_TEXT_ATTR_STRETCH", strip_prefix), ATK_TEXT_ATTR_STRETCH);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_TEXT_ATTR_VARIANT", strip_prefix), ATK_TEXT_ATTR_VARIANT);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_TEXT_ATTR_STYLE", strip_prefix), ATK_TEXT_ATTR_STYLE);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_TEXT_BOUNDARY_CHAR", strip_prefix), ATK_TEXT_BOUNDARY_CHAR);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_TEXT_BOUNDARY_WORD_START", strip_prefix), ATK_TEXT_BOUNDARY_WORD_START);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_TEXT_BOUNDARY_WORD_END", strip_prefix), ATK_TEXT_BOUNDARY_WORD_END);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_TEXT_BOUNDARY_SENTENCE_START", strip_prefix), ATK_TEXT_BOUNDARY_SENTENCE_START);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_TEXT_BOUNDARY_SENTENCE_END", strip_prefix), ATK_TEXT_BOUNDARY_SENTENCE_END);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_TEXT_BOUNDARY_LINE_START", strip_prefix), ATK_TEXT_BOUNDARY_LINE_START);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_TEXT_BOUNDARY_LINE_END", strip_prefix), ATK_TEXT_BOUNDARY_LINE_END);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_KEY_EVENT_PRESS", strip_prefix), ATK_KEY_EVENT_PRESS);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_KEY_EVENT_RELEASE", strip_prefix), ATK_KEY_EVENT_RELEASE);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_KEY_EVENT_LAST_DEFINED", strip_prefix), ATK_KEY_EVENT_LAST_DEFINED);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_XY_SCREEN", strip_prefix), ATK_XY_SCREEN);
    PyModule_AddIntConstant(module, pyg_constant_strip_prefix("ATK_XY_WINDOW", strip_prefix), ATK_XY_WINDOW);
}

/* intialise stuff extension classes */
void
pyatk_register_classes(PyObject *d)
{
    PyObject *module;

    if ((module = PyImport_ImportModule("gobject")) != NULL) {
        PyObject *moddict = PyModule_GetDict(module);

        _PyGObject_Type = (PyTypeObject *)PyDict_GetItemString(moddict, "GObject");
    } else {
        Py_FatalError("could not import gobject");
        return;
    }


#line 1766 "atk.c"
    pygobject_register_class(d, "AtkHyperlink", ATK_TYPE_HYPERLINK, &PyAtkHyperlink_Type, Py_BuildValue("(O)", &PyGObject_Type));
    pygobject_register_class(d, "AtkObject", ATK_TYPE_OBJECT, &PyAtkObject_Type, Py_BuildValue("(O)", &PyGObject_Type));
    pygobject_register_class(d, "AtkNoOpObject", ATK_TYPE_NO_OP_OBJECT, &PyAtkNoOpObject_Type, Py_BuildValue("(O)", &PyAtkObject_Type));
    pygobject_register_class(d, "AtkObjectFactory", ATK_TYPE_OBJECT_FACTORY, &PyAtkObjectFactory_Type, Py_BuildValue("(O)", &PyGObject_Type));
    pygobject_register_class(d, "AtkNoOpObjectFactory", ATK_TYPE_NO_OP_OBJECT_FACTORY, &PyAtkNoOpObjectFactory_Type, Py_BuildValue("(O)", &PyAtkObjectFactory_Type));
    pygobject_register_class(d, "AtkRegistry", ATK_TYPE_REGISTRY, &PyAtkRegistry_Type, Py_BuildValue("(O)", &PyGObject_Type));
    pygobject_register_class(d, "AtkRelation", ATK_TYPE_RELATION, &PyAtkRelation_Type, Py_BuildValue("(O)", &PyGObject_Type));
    pygobject_register_class(d, "AtkRelationSet", ATK_TYPE_RELATION_SET, &PyAtkRelationSet_Type, Py_BuildValue("(O)", &PyGObject_Type));
    pygobject_register_class(d, "AtkStateSet", ATK_TYPE_STATE_SET, &PyAtkStateSet_Type, Py_BuildValue("(O)", &PyGObject_Type));
    pygobject_register_class(d, "AtkUtil", ATK_TYPE_UTIL, &PyAtkUtil_Type, Py_BuildValue("(O)", &PyGObject_Type));
}
