/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 2009, Nokia
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 *
 * Author: Philip Van Hoof <philip@codeminded.be>
 */

#include <glib.h>
#include <glib-object.h>
#include <tracker-miner-fs/tracker-config.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>
#include <config.h>
#include <stdio.h>

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_list_free_gtk_tree_path_free0(var) ((var == NULL) ? NULL : (var = (_g_list_free_gtk_tree_path_free (var), NULL)))
#define _gtk_tree_path_free0(var) ((var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL)))
#define __g_slist_free_g_free0(var) ((var == NULL) ? NULL : (var = (_g_slist_free_g_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))


extern TrackerConfig* config;
TrackerConfig* config = NULL;
extern GtkWindow* window;
GtkWindow* window = NULL;
extern GtkCheckButton* checkbutton_enable_index_on_battery_first_time;
GtkCheckButton* checkbutton_enable_index_on_battery_first_time = NULL;
extern GtkCheckButton* checkbutton_enable_index_on_battery;
GtkCheckButton* checkbutton_enable_index_on_battery = NULL;
extern GtkSpinButton* spinbutton_delay;
GtkSpinButton* spinbutton_delay = NULL;
extern GtkCheckButton* checkbutton_enable_monitoring;
GtkCheckButton* checkbutton_enable_monitoring = NULL;
extern GtkCheckButton* checkbutton_enable_thumbnails;
GtkCheckButton* checkbutton_enable_thumbnails = NULL;
extern GtkCheckButton* checkbutton_index_mounted_directories;
GtkCheckButton* checkbutton_index_mounted_directories = NULL;
extern GtkCheckButton* checkbutton_index_removable_media;
GtkCheckButton* checkbutton_index_removable_media = NULL;
extern GtkScale* hscale_disk_space_limit;
GtkScale* hscale_disk_space_limit = NULL;
extern GtkScale* hscale_throttle;
GtkScale* hscale_throttle = NULL;
extern GtkListStore* liststore_index_recursively;
GtkListStore* liststore_index_recursively = NULL;
extern GtkListStore* liststore_index_single;
GtkListStore* liststore_index_single = NULL;
extern GtkListStore* liststore_ignored_directories;
GtkListStore* liststore_ignored_directories = NULL;
extern GtkListStore* liststore_ignored_files;
GtkListStore* liststore_ignored_files = NULL;
extern GtkListStore* liststore_gnored_directories_with_content;
GtkListStore* liststore_gnored_directories_with_content = NULL;
extern GtkTreeView* treeview_index_recursively;
GtkTreeView* treeview_index_recursively = NULL;
extern GtkTreeView* treeview_index_single;
GtkTreeView* treeview_index_single = NULL;
extern GtkTreeView* treeview_ignored_directories;
GtkTreeView* treeview_ignored_directories = NULL;
extern GtkTreeView* treeview_ignored_directories_with_content;
GtkTreeView* treeview_ignored_directories_with_content = NULL;
extern GtkTreeView* treeview_ignored_files;
GtkTreeView* treeview_ignored_files = NULL;
extern GtkToggleButton* togglebutton_home;
GtkToggleButton* togglebutton_home = NULL;

#define HOME_STRING "$HOME"
void spinbutton_delay_value_changed_cb (GtkSpinButton* source);
void checkbutton_enable_monitoring_toggled_cb (GtkCheckButton* source);
void checkbutton_enable_thumbnails_toggled_cb (GtkCheckButton* source);
void checkbutton_enable_index_on_battery_toggled_cb (GtkCheckButton* source);
void checkbutton_enable_index_on_battery_first_time_toggled_cb (GtkCheckButton* source);
void checkbutton_index_mounted_directories_toggled_cb (GtkCheckButton* source);
void checkbutton_index_removable_media_toggled_cb (GtkCheckButton* source);
char* hscale_disk_space_limit_format_value_cb (GtkScale* source, double value);
char* hscale_throttle_format_value_cb (GtkScale* source, double value);
void add_freevalue (GtkListStore* model);
void add_dir (GtkListStore* model);
static void _g_list_free_gtk_tree_path_free (GList* self);
void del_dir (GtkTreeView* view);
void button_index_recursively_add_clicked_cb (GtkButton* source);
void button_index_recursively_remove_clicked_cb (GtkButton* source);
void button_index_single_remove_clicked_cb (GtkButton* source);
void button_index_single_add_clicked_cb (GtkButton* source);
void button_ignored_directories_add_clicked_cb (GtkButton* source);
void button_ignored_directories_remove_clicked_cb (GtkButton* source);
void button_ignored_directories_with_content_add_clicked_cb (GtkButton* source);
void button_ignored_directories_with_content_remove_clicked_cb (GtkButton* source);
void button_ignored_files_add_clicked_cb (GtkButton* source);
void button_ignored_files_remove_clicked_cb (GtkButton* source);
static void _g_slist_free_g_free (GSList* self);
GSList* model_to_slist (GtkListStore* model);
gboolean model_contains (GtkTreeModel* model, const char* needle);
void button_apply_clicked_cb (GtkButton* source);
void button_close_clicked_cb (GtkButton* source);
void togglebutton_home_toggled_cb (GtkToggleButton* source);
void fill_in_model (GtkListStore* model, GSList* list);
void setup_standard_treeview (GtkTreeView* view, const char* title);
gint _main (char** args, int args_length1);
static int _vala_strcmp0 (const char * str1, const char * str2);



void spinbutton_delay_value_changed_cb (GtkSpinButton* source) {
	g_return_if_fail (source != NULL);
	tracker_config_set_initial_sleep (config, gtk_spin_button_get_value_as_int (source));
}


void checkbutton_enable_monitoring_toggled_cb (GtkCheckButton* source) {
	g_return_if_fail (source != NULL);
	tracker_config_set_enable_monitors (config, gtk_toggle_button_get_active ((GtkToggleButton*) source));
}


void checkbutton_enable_thumbnails_toggled_cb (GtkCheckButton* source) {
	g_return_if_fail (source != NULL);
	tracker_config_set_enable_thumbnails (config, gtk_toggle_button_get_active ((GtkToggleButton*) source));
}


void checkbutton_enable_index_on_battery_toggled_cb (GtkCheckButton* source) {
	g_return_if_fail (source != NULL);
	tracker_config_set_index_on_battery (config, gtk_toggle_button_get_active ((GtkToggleButton*) source));
	gtk_widget_set_sensitive ((GtkWidget*) checkbutton_enable_index_on_battery_first_time, !gtk_toggle_button_get_active ((GtkToggleButton*) source));
}


void checkbutton_enable_index_on_battery_first_time_toggled_cb (GtkCheckButton* source) {
	g_return_if_fail (source != NULL);
	tracker_config_set_index_on_battery_first_time (config, gtk_toggle_button_get_active ((GtkToggleButton*) source));
}


void checkbutton_index_mounted_directories_toggled_cb (GtkCheckButton* source) {
	g_return_if_fail (source != NULL);
	tracker_config_set_index_mounted_directories (config, gtk_toggle_button_get_active ((GtkToggleButton*) source));
}


void checkbutton_index_removable_media_toggled_cb (GtkCheckButton* source) {
	g_return_if_fail (source != NULL);
	tracker_config_set_index_removable_devices (config, gtk_toggle_button_get_active ((GtkToggleButton*) source));
}


char* hscale_disk_space_limit_format_value_cb (GtkScale* source, double value) {
	char* result;
	g_return_val_if_fail (source != NULL, NULL);
	tracker_config_set_low_disk_space_limit (config, (gint) value);
	if (((gint) value) == (-1)) {
		result = g_strdup (_ ("Disabled"));
		return result;
	}
	result = g_strdup_printf (_ ("%d%%"), (gint) value);
	return result;
}


char* hscale_throttle_format_value_cb (GtkScale* source, double value) {
	char* result;
	g_return_val_if_fail (source != NULL, NULL);
	tracker_config_set_throttle (config, (gint) value);
	result = g_strdup_printf (_ ("%d/20"), (gint) value);
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void add_freevalue (GtkListStore* model) {
	GtkDialog* dialog;
	GtkEntry* entry;
	GtkContainer* content_area;
	GtkDialog* _tmp0_;
	GtkContainer* _tmp1_;
	GtkEntry* _tmp2_;
	g_return_if_fail (model != NULL);
	dialog = NULL;
	entry = NULL;
	content_area = NULL;
	dialog = (_tmp0_ = g_object_ref_sink ((GtkDialog*) gtk_dialog_new_with_buttons (_ ("Enter value"), window, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_OK, GTK_RESPONSE_ACCEPT, NULL)), _g_object_unref0 (dialog), _tmp0_);
	content_area = (_tmp1_ = _g_object_ref0 (GTK_CONTAINER (gtk_dialog_get_content_area (dialog))), _g_object_unref0 (content_area), _tmp1_);
	entry = (_tmp2_ = g_object_ref_sink ((GtkEntry*) gtk_entry_new ()), _g_object_unref0 (entry), _tmp2_);
	gtk_widget_show ((GtkWidget*) entry);
	gtk_container_add (content_area, (GtkWidget*) entry);
	if (gtk_dialog_run (dialog) == GTK_RESPONSE_ACCEPT) {
		char* text;
		gboolean _tmp3_;
		text = g_strdup (gtk_entry_get_text (entry));
		_tmp3_ = FALSE;
		if (text != NULL) {
			_tmp3_ = _vala_strcmp0 (text, "") != 0;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			GtkTreeIter iter = {0};
			GValue _tmp4_ = {0};
			GValue v;
			gtk_list_store_append (model, &iter);
			v = (g_value_init (&_tmp4_, G_TYPE_STRING), _tmp4_);
			g_value_set_string (&v, text);
			gtk_list_store_set_value (model, &iter, 0, &v);
			G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
		}
		_g_free0 (text);
	}
	gtk_object_destroy ((GtkObject*) dialog);
	_g_object_unref0 (dialog);
	_g_object_unref0 (entry);
	_g_object_unref0 (content_area);
}


void add_dir (GtkListStore* model) {
	GtkFileChooserDialog* dialog;
	g_return_if_fail (model != NULL);
	dialog = g_object_ref_sink ((GtkFileChooserDialog*) gtk_file_chooser_dialog_new (_ ("Select directory"), window, GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_OK, GTK_RESPONSE_ACCEPT, NULL));
	if (gtk_dialog_run ((GtkDialog*) dialog) == GTK_RESPONSE_ACCEPT) {
		GtkTreeIter iter = {0};
		GFile* dir;
		GFile* _tmp0_;
		GValue _tmp1_ = {0};
		GValue v;
		char* _tmp2_;
		dir = NULL;
		dir = (_tmp0_ = _g_object_ref0 (gtk_file_chooser_get_file ((GtkFileChooser*) dialog)), _g_object_unref0 (dir), _tmp0_);
		gtk_list_store_append (model, &iter);
		v = (g_value_init (&_tmp1_, G_TYPE_STRING), _tmp1_);
		g_value_set_string (&v, _tmp2_ = g_file_get_path (dir));
		_g_free0 (_tmp2_);
		gtk_list_store_set_value (model, &iter, 0, &v);
		_g_object_unref0 (dir);
		G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
	}
	gtk_object_destroy ((GtkObject*) dialog);
	_g_object_unref0 (dialog);
}


static void _g_list_free_gtk_tree_path_free (GList* self) {
	g_list_foreach (self, (GFunc) gtk_tree_path_free, NULL);
	g_list_free (self);
}


static gpointer _gtk_tree_path_copy0 (gpointer self) {
	return self ? gtk_tree_path_copy (self) : NULL;
}


void del_dir (GtkTreeView* view) {
	GList* list;
	GtkListStore* store;
	GtkTreeModel* model;
	GtkTreeSelection* selection;
	GList* _tmp3_;
	GtkTreeModel* _tmp2_;
	GList* _tmp1_;
	GtkTreeModel* _tmp0_;
	GtkListStore* _tmp4_;
	g_return_if_fail (view != NULL);
	list = NULL;
	store = NULL;
	model = NULL;
	selection = _g_object_ref0 (gtk_tree_view_get_selection (view));
	_tmp0_ = NULL;
	list = (_tmp3_ = (_tmp1_ = gtk_tree_selection_get_selected_rows (selection, &_tmp0_), model = (_tmp2_ = _g_object_ref0 (_tmp0_), _g_object_unref0 (model), _tmp2_), _tmp1_), __g_list_free_gtk_tree_path_free0 (list), _tmp3_);
	store = (_tmp4_ = _g_object_ref0 (GTK_LIST_STORE (model)), _g_object_unref0 (store), _tmp4_);
	{
		GList* path_collection;
		GList* path_it;
		path_collection = list;
		for (path_it = path_collection; path_it != NULL; path_it = path_it->next) {
			GtkTreePath* path;
			path = _gtk_tree_path_copy0 ((const GtkTreePath*) path_it->data);
			{
				GtkTreeIter iter = {0};
				if (gtk_tree_model_get_iter (model, &iter, path)) {
					gtk_list_store_remove (store, &iter);
				}
				_gtk_tree_path_free0 (path);
			}
		}
	}
	__g_list_free_gtk_tree_path_free0 (list);
	_g_object_unref0 (store);
	_g_object_unref0 (model);
	_g_object_unref0 (selection);
}


void button_index_recursively_add_clicked_cb (GtkButton* source) {
	g_return_if_fail (source != NULL);
	add_dir (liststore_index_recursively);
}


void button_index_recursively_remove_clicked_cb (GtkButton* source) {
	g_return_if_fail (source != NULL);
	del_dir (treeview_index_recursively);
}


void button_index_single_remove_clicked_cb (GtkButton* source) {
	g_return_if_fail (source != NULL);
	del_dir (treeview_index_single);
}


void button_index_single_add_clicked_cb (GtkButton* source) {
	g_return_if_fail (source != NULL);
	add_dir (liststore_index_single);
}


void button_ignored_directories_add_clicked_cb (GtkButton* source) {
	g_return_if_fail (source != NULL);
	add_freevalue (liststore_ignored_directories);
}


void button_ignored_directories_remove_clicked_cb (GtkButton* source) {
	g_return_if_fail (source != NULL);
	del_dir (treeview_ignored_directories);
}


void button_ignored_directories_with_content_add_clicked_cb (GtkButton* source) {
	g_return_if_fail (source != NULL);
	add_freevalue (liststore_gnored_directories_with_content);
}


void button_ignored_directories_with_content_remove_clicked_cb (GtkButton* source) {
	g_return_if_fail (source != NULL);
	del_dir (treeview_ignored_directories_with_content);
}


void button_ignored_files_add_clicked_cb (GtkButton* source) {
	g_return_if_fail (source != NULL);
	add_freevalue (liststore_ignored_files);
}


void button_ignored_files_remove_clicked_cb (GtkButton* source) {
	g_return_if_fail (source != NULL);
	del_dir (treeview_ignored_files);
}


static void _g_slist_free_g_free (GSList* self) {
	g_slist_foreach (self, (GFunc) g_free, NULL);
	g_slist_free (self);
}


GSList* model_to_slist (GtkListStore* model) {
	GSList* result;
	gboolean valid;
	GSList* list;
	GtkTreeIter iter = {0};
	g_return_val_if_fail (model != NULL, NULL);
	valid = FALSE;
	list = NULL;
	valid = gtk_tree_model_get_iter_first ((GtkTreeModel*) model, &iter);
	while (TRUE) {
		GValue value = {0};
		GValue _tmp1_;
		GValue _tmp0_ = {0};
		if (!valid) {
			break;
		}
		gtk_tree_model_get_value ((GtkTreeModel*) model, &iter, 0, &_tmp0_);
		value = (_tmp1_ = _tmp0_, G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL, _tmp1_);
		list = g_slist_append (list, g_strdup (g_value_get_string (&value)));
		valid = gtk_tree_model_iter_next ((GtkTreeModel*) model, &iter);
		G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
	}
	result = list;
	return result;
}


gboolean model_contains (GtkTreeModel* model, const char* needle) {
	gboolean result;
	gboolean valid;
	GtkTreeIter iter = {0};
	g_return_val_if_fail (model != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	valid = FALSE;
	valid = gtk_tree_model_get_iter_first (model, &iter);
	while (TRUE) {
		GValue value = {0};
		GValue _tmp1_;
		GValue _tmp0_ = {0};
		if (!valid) {
			break;
		}
		gtk_tree_model_get_value (model, &iter, 0, &_tmp0_);
		value = (_tmp1_ = _tmp0_, G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL, _tmp1_);
		if (_vala_strcmp0 (g_value_get_string (&value), needle) == 0) {
			result = TRUE;
			G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
			return result;
		}
		valid = gtk_tree_model_iter_next (model, &iter);
		G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
	}
	result = FALSE;
	return result;
}


void button_apply_clicked_cb (GtkButton* source) {
	GSList* _tmp0_;
	GSList* _tmp1_;
	GSList* _tmp2_;
	GSList* _tmp3_;
	GSList* _tmp4_;
	g_return_if_fail (source != NULL);
	tracker_config_set_index_single_directories (config, _tmp0_ = model_to_slist (liststore_index_single));
	__g_slist_free_g_free0 (_tmp0_);
	tracker_config_set_ignored_directories (config, _tmp1_ = model_to_slist (liststore_ignored_directories));
	__g_slist_free_g_free0 (_tmp1_);
	tracker_config_set_ignored_files (config, _tmp2_ = model_to_slist (liststore_ignored_files));
	__g_slist_free_g_free0 (_tmp2_);
	tracker_config_set_ignored_directories_with_content (config, _tmp3_ = model_to_slist (liststore_gnored_directories_with_content));
	__g_slist_free_g_free0 (_tmp3_);
	tracker_config_set_index_recursive_directories (config, _tmp4_ = model_to_slist (liststore_index_recursively));
	__g_slist_free_g_free0 (_tmp4_);
	tracker_config_save (config);
}


void button_close_clicked_cb (GtkButton* source) {
	g_return_if_fail (source != NULL);
	gtk_main_quit ();
}


void togglebutton_home_toggled_cb (GtkToggleButton* source) {
	gboolean _tmp0_;
	gboolean _tmp2_;
	g_return_if_fail (source != NULL);
	_tmp0_ = FALSE;
	if (gtk_toggle_button_get_active (source)) {
		_tmp0_ = !model_contains ((GtkTreeModel*) liststore_index_recursively, HOME_STRING);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkTreeIter iter = {0};
		GValue _tmp1_ = {0};
		GValue v;
		gtk_list_store_append (liststore_index_recursively, &iter);
		v = (g_value_init (&_tmp1_, G_TYPE_STRING), _tmp1_);
		g_value_set_string (&v, HOME_STRING);
		gtk_list_store_set_value (liststore_index_recursively, &iter, 0, &v);
		G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
	}
	_tmp2_ = FALSE;
	if (!gtk_toggle_button_get_active (source)) {
		_tmp2_ = model_contains ((GtkTreeModel*) liststore_index_recursively, HOME_STRING);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gboolean valid;
		GtkTreeIter iter = {0};
		valid = FALSE;
		valid = gtk_tree_model_get_iter_first ((GtkTreeModel*) liststore_index_recursively, &iter);
		while (TRUE) {
			GValue value = {0};
			GValue _tmp4_;
			GValue _tmp3_ = {0};
			if (!valid) {
				break;
			}
			gtk_tree_model_get_value ((GtkTreeModel*) liststore_index_recursively, &iter, 0, &_tmp3_);
			value = (_tmp4_ = _tmp3_, G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL, _tmp4_);
			if (_vala_strcmp0 (g_value_get_string (&value), HOME_STRING) == 0) {
				gtk_list_store_remove (liststore_index_recursively, &iter);
				valid = gtk_tree_model_get_iter_first ((GtkTreeModel*) liststore_index_recursively, &iter);
			} else {
				valid = gtk_tree_model_iter_next ((GtkTreeModel*) liststore_index_recursively, &iter);
			}
			G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
		}
	}
}


void fill_in_model (GtkListStore* model, GSList* list) {
	gint position;
	g_return_if_fail (model != NULL);
	position = 0;
	{
		GSList* str_collection;
		GSList* str_it;
		str_collection = list;
		for (str_it = str_collection; str_it != NULL; str_it = str_it->next) {
			char* str;
			str = g_strdup ((const char*) str_it->data);
			{
				gtk_list_store_insert_with_values (model, NULL, position++, 0, str, -1);
				_g_free0 (str);
			}
		}
	}
}


void setup_standard_treeview (GtkTreeView* view, const char* title) {
	GtkCellRendererText* _tmp0_;
	GtkTreeViewColumn* _tmp1_;
	GtkTreeViewColumn* column;
	g_return_if_fail (view != NULL);
	g_return_if_fail (title != NULL);
	column = (_tmp1_ = g_object_ref_sink (gtk_tree_view_column_new_with_attributes (title, (GtkCellRenderer*) (_tmp0_ = g_object_ref_sink ((GtkCellRendererText*) gtk_cell_renderer_text_new ())), "text", 0, NULL)), _g_object_unref0 (_tmp0_), _tmp1_);
	gtk_tree_view_append_column (view, column);
	_g_object_unref0 (column);
}


gint _main (char** args, int args_length1) {
	gint result;
	GError * _inner_error_;
	_inner_error_ = NULL;
	gtk_init (&args_length1, &args);
	{
		TrackerConfig* _tmp0_;
		GtkBuilder* builder;
		GtkWindow* _tmp2_;
		GObject* _tmp1_;
		GtkCheckButton* _tmp4_;
		GObject* _tmp3_;
		GtkCheckButton* _tmp6_;
		GObject* _tmp5_;
		GtkSpinButton* _tmp8_;
		GObject* _tmp7_;
		GtkCheckButton* _tmp10_;
		GObject* _tmp9_;
		GtkCheckButton* _tmp12_;
		GObject* _tmp11_;
		GtkCheckButton* _tmp14_;
		GObject* _tmp13_;
		GtkCheckButton* _tmp16_;
		GObject* _tmp15_;
		GtkScale* _tmp18_;
		GObject* _tmp17_;
		GtkScale* _tmp20_;
		GObject* _tmp19_;
		GtkToggleButton* _tmp22_;
		GObject* _tmp21_;
		GtkTreeView* _tmp24_;
		GObject* _tmp23_;
		GtkTreeView* _tmp26_;
		GObject* _tmp25_;
		GtkTreeView* _tmp28_;
		GObject* _tmp27_;
		GtkTreeView* _tmp30_;
		GObject* _tmp29_;
		GtkTreeView* _tmp32_;
		GObject* _tmp31_;
		GtkListStore* _tmp34_;
		GObject* _tmp33_;
		GtkListStore* _tmp36_;
		GObject* _tmp35_;
		GtkListStore* _tmp38_;
		GObject* _tmp37_;
		GtkListStore* _tmp40_;
		GObject* _tmp39_;
		GtkListStore* _tmp42_;
		GObject* _tmp41_;
		config = (_tmp0_ = tracker_config_new_with_domain ("tracker-miner-fs"), _g_object_unref0 (config), _tmp0_);
		builder = gtk_builder_new ();
		gtk_builder_add_from_file (builder, TRACKER_DATADIR G_DIR_SEPARATOR_S "tracker-preferences.ui", &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (builder);
			goto __catch0_g_error;
			goto __finally0;
		}
		window = (_tmp2_ = _g_object_ref0 ((_tmp1_ = gtk_builder_get_object (builder, "tracker-preferences"), GTK_IS_WINDOW (_tmp1_) ? ((GtkWindow*) _tmp1_) : NULL)), _g_object_unref0 (window), _tmp2_);
		checkbutton_enable_index_on_battery = (_tmp4_ = _g_object_ref0 ((_tmp3_ = gtk_builder_get_object (builder, "checkbutton_enable_index_on_battery"), GTK_IS_CHECK_BUTTON (_tmp3_) ? ((GtkCheckButton*) _tmp3_) : NULL)), _g_object_unref0 (checkbutton_enable_index_on_battery), _tmp4_);
		checkbutton_enable_index_on_battery_first_time = (_tmp6_ = _g_object_ref0 ((_tmp5_ = gtk_builder_get_object (builder, "checkbutton_enable_index_on_battery_first_time"), GTK_IS_CHECK_BUTTON (_tmp5_) ? ((GtkCheckButton*) _tmp5_) : NULL)), _g_object_unref0 (checkbutton_enable_index_on_battery_first_time), _tmp6_);
		gtk_toggle_button_set_active ((GtkToggleButton*) checkbutton_enable_index_on_battery, tracker_config_get_index_on_battery (config));
		gtk_widget_set_sensitive ((GtkWidget*) checkbutton_enable_index_on_battery_first_time, !gtk_toggle_button_get_active ((GtkToggleButton*) checkbutton_enable_index_on_battery));
		gtk_toggle_button_set_active ((GtkToggleButton*) checkbutton_enable_index_on_battery_first_time, tracker_config_get_index_on_battery_first_time (config));
		spinbutton_delay = (_tmp8_ = _g_object_ref0 ((_tmp7_ = gtk_builder_get_object (builder, "spinbutton_delay"), GTK_IS_SPIN_BUTTON (_tmp7_) ? ((GtkSpinButton*) _tmp7_) : NULL)), _g_object_unref0 (spinbutton_delay), _tmp8_);
		gtk_spin_button_set_increments (spinbutton_delay, (double) 1, (double) 1);
		gtk_spin_button_set_value (spinbutton_delay, (double) tracker_config_get_initial_sleep (config));
		checkbutton_enable_monitoring = (_tmp10_ = _g_object_ref0 ((_tmp9_ = gtk_builder_get_object (builder, "checkbutton_enable_monitoring"), GTK_IS_CHECK_BUTTON (_tmp9_) ? ((GtkCheckButton*) _tmp9_) : NULL)), _g_object_unref0 (checkbutton_enable_monitoring), _tmp10_);
		gtk_toggle_button_set_active ((GtkToggleButton*) checkbutton_enable_monitoring, tracker_config_get_enable_monitors (config));
		checkbutton_enable_thumbnails = (_tmp12_ = _g_object_ref0 ((_tmp11_ = gtk_builder_get_object (builder, "checkbutton_enable_thumbnails"), GTK_IS_CHECK_BUTTON (_tmp11_) ? ((GtkCheckButton*) _tmp11_) : NULL)), _g_object_unref0 (checkbutton_enable_thumbnails), _tmp12_);
		gtk_toggle_button_set_active ((GtkToggleButton*) checkbutton_enable_thumbnails, tracker_config_get_enable_thumbnails (config));
		checkbutton_index_mounted_directories = (_tmp14_ = _g_object_ref0 ((_tmp13_ = gtk_builder_get_object (builder, "checkbutton_index_mounted_directories"), GTK_IS_CHECK_BUTTON (_tmp13_) ? ((GtkCheckButton*) _tmp13_) : NULL)), _g_object_unref0 (checkbutton_index_mounted_directories), _tmp14_);
		gtk_toggle_button_set_active ((GtkToggleButton*) checkbutton_index_mounted_directories, tracker_config_get_index_mounted_directories (config));
		checkbutton_index_removable_media = (_tmp16_ = _g_object_ref0 ((_tmp15_ = gtk_builder_get_object (builder, "checkbutton_index_removable_media"), GTK_IS_CHECK_BUTTON (_tmp15_) ? ((GtkCheckButton*) _tmp15_) : NULL)), _g_object_unref0 (checkbutton_index_removable_media), _tmp16_);
		gtk_toggle_button_set_active ((GtkToggleButton*) checkbutton_index_removable_media, tracker_config_get_index_removable_devices (config));
		hscale_disk_space_limit = (_tmp18_ = _g_object_ref0 ((_tmp17_ = gtk_builder_get_object (builder, "hscale_disk_space_limit"), GTK_IS_SCALE (_tmp17_) ? ((GtkScale*) _tmp17_) : NULL)), _g_object_unref0 (hscale_disk_space_limit), _tmp18_);
		gtk_range_set_value ((GtkRange*) hscale_disk_space_limit, (double) tracker_config_get_low_disk_space_limit (config));
		hscale_throttle = (_tmp20_ = _g_object_ref0 ((_tmp19_ = gtk_builder_get_object (builder, "hscale_throttle"), GTK_IS_SCALE (_tmp19_) ? ((GtkScale*) _tmp19_) : NULL)), _g_object_unref0 (hscale_throttle), _tmp20_);
		gtk_range_set_value ((GtkRange*) hscale_throttle, (double) tracker_config_get_throttle (config));
		togglebutton_home = (_tmp22_ = _g_object_ref0 ((_tmp21_ = gtk_builder_get_object (builder, "togglebutton_home"), GTK_IS_TOGGLE_BUTTON (_tmp21_) ? ((GtkToggleButton*) _tmp21_) : NULL)), _g_object_unref0 (togglebutton_home), _tmp22_);
		treeview_index_recursively = (_tmp24_ = _g_object_ref0 ((_tmp23_ = gtk_builder_get_object (builder, "treeview_index_recursively"), GTK_IS_TREE_VIEW (_tmp23_) ? ((GtkTreeView*) _tmp23_) : NULL)), _g_object_unref0 (treeview_index_recursively), _tmp24_);
		treeview_index_single = (_tmp26_ = _g_object_ref0 ((_tmp25_ = gtk_builder_get_object (builder, "treeview_index_single"), GTK_IS_TREE_VIEW (_tmp25_) ? ((GtkTreeView*) _tmp25_) : NULL)), _g_object_unref0 (treeview_index_single), _tmp26_);
		treeview_ignored_directories = (_tmp28_ = _g_object_ref0 ((_tmp27_ = gtk_builder_get_object (builder, "treeview_ignored_directories"), GTK_IS_TREE_VIEW (_tmp27_) ? ((GtkTreeView*) _tmp27_) : NULL)), _g_object_unref0 (treeview_ignored_directories), _tmp28_);
		treeview_ignored_directories_with_content = (_tmp30_ = _g_object_ref0 ((_tmp29_ = gtk_builder_get_object (builder, "treeview_ignored_directories_with_content"), GTK_IS_TREE_VIEW (_tmp29_) ? ((GtkTreeView*) _tmp29_) : NULL)), _g_object_unref0 (treeview_ignored_directories_with_content), _tmp30_);
		treeview_ignored_files = (_tmp32_ = _g_object_ref0 ((_tmp31_ = gtk_builder_get_object (builder, "treeview_ignored_files"), GTK_IS_TREE_VIEW (_tmp31_) ? ((GtkTreeView*) _tmp31_) : NULL)), _g_object_unref0 (treeview_ignored_files), _tmp32_);
		setup_standard_treeview (treeview_index_recursively, _ ("Directory"));
		setup_standard_treeview (treeview_index_single, _ ("Directory"));
		setup_standard_treeview (treeview_ignored_directories, _ ("Directory"));
		setup_standard_treeview (treeview_ignored_directories_with_content, _ ("Directory"));
		setup_standard_treeview (treeview_ignored_files, _ ("File"));
		liststore_index_recursively = (_tmp34_ = _g_object_ref0 ((_tmp33_ = gtk_builder_get_object (builder, "liststore_index_recursively"), GTK_IS_LIST_STORE (_tmp33_) ? ((GtkListStore*) _tmp33_) : NULL)), _g_object_unref0 (liststore_index_recursively), _tmp34_);
		fill_in_model (liststore_index_recursively, tracker_config_get_index_recursive_directories (config));
		gtk_toggle_button_set_active (togglebutton_home, model_contains ((GtkTreeModel*) liststore_index_recursively, HOME_STRING));
		liststore_index_single = (_tmp36_ = _g_object_ref0 ((_tmp35_ = gtk_builder_get_object (builder, "liststore_index_single"), GTK_IS_LIST_STORE (_tmp35_) ? ((GtkListStore*) _tmp35_) : NULL)), _g_object_unref0 (liststore_index_single), _tmp36_);
		fill_in_model (liststore_index_single, tracker_config_get_index_single_directories (config));
		liststore_ignored_directories = (_tmp38_ = _g_object_ref0 ((_tmp37_ = gtk_builder_get_object (builder, "liststore_ignored_directories"), GTK_IS_LIST_STORE (_tmp37_) ? ((GtkListStore*) _tmp37_) : NULL)), _g_object_unref0 (liststore_ignored_directories), _tmp38_);
		fill_in_model (liststore_ignored_directories, tracker_config_get_ignored_directories (config));
		liststore_ignored_files = (_tmp40_ = _g_object_ref0 ((_tmp39_ = gtk_builder_get_object (builder, "liststore_ignored_files"), GTK_IS_LIST_STORE (_tmp39_) ? ((GtkListStore*) _tmp39_) : NULL)), _g_object_unref0 (liststore_ignored_files), _tmp40_);
		fill_in_model (liststore_ignored_files, tracker_config_get_ignored_files (config));
		liststore_gnored_directories_with_content = (_tmp42_ = _g_object_ref0 ((_tmp41_ = gtk_builder_get_object (builder, "liststore_gnored_directories_with_content"), GTK_IS_LIST_STORE (_tmp41_) ? ((GtkListStore*) _tmp41_) : NULL)), _g_object_unref0 (liststore_gnored_directories_with_content), _tmp42_);
		fill_in_model (liststore_gnored_directories_with_content, tracker_config_get_ignored_directories_with_content (config));
		gtk_builder_connect_signals (builder, NULL);
		gtk_widget_show_all ((GtkWidget*) window);
		gtk_main ();
		_g_object_unref0 (builder);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			fprintf (stderr, "Could not load UI: %s\n", e->message);
			result = 1;
			_g_error_free0 (e);
			return result;
		}
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
		g_clear_error (&_inner_error_);
		return 0;
	}
	result = 0;
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return _main (argv, argc);
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




