/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.geometry.btree.unboxed;

import com.sun.electric.database.geometry.btree.unboxed.UnboxedComparable;

public class UnboxedFloat
implements UnboxedComparable<Float> {
    @Override
    public int getSize() {
        return 4;
    }

    @Override
    public Float deserialize(byte[] buf, int ofs) {
        return Float.valueOf(this.deserializeFloat(buf, ofs));
    }

    @Override
    public void serialize(Float k, byte[] buf, int ofs) {
        this.serialize(Float.valueOf(k.floatValue()), buf, ofs);
    }

    public float deserializeFloat(byte[] buf, int ofs) {
        return Float.intBitsToFloat((buf[ofs + 0] & 0xFF) << 0 | (buf[ofs + 1] & 0xFF) << 8 | (buf[ofs + 2] & 0xFF) << 16 | (buf[ofs + 3] & 0xFF) << 24);
    }

    public void serializeFloat(float f, byte[] buf, int ofs) {
        int i = Float.floatToRawIntBits(f);
        buf[ofs + 0] = (byte)(i >> 0 & 0xFF);
        buf[ofs + 1] = (byte)(i >> 8 & 0xFF);
        buf[ofs + 2] = (byte)(i >> 16 & 0xFF);
        buf[ofs + 3] = (byte)(i >> 24 & 0xFF);
    }

    @Override
    public int compare(byte[] buf1, int ofs1, byte[] buf2, int ofs2) {
        float f1 = this.deserializeFloat(buf1, ofs1);
        float f2 = this.deserializeFloat(buf2, ofs2);
        return Float.compare(f1, f2);
    }
}

