/*
 * Decompiled with CFR 0.152.
 */
package com.freiheit.gnupg;

import com.freiheit.gnupg.GnuPGPeer;

public class GnuPGSignature
extends GnuPGPeer {
    protected GnuPGSignature(int ptr) {
        this.setInternalRepresentation(ptr);
    }

    public boolean isRevoked() {
        return this.gpgmeGetRevoked(this.getInternalRepresentation());
    }

    public boolean isExpired() {
        return this.gpgmeGetExpired(this.getInternalRepresentation());
    }

    public boolean isInvalid() {
        return this.gpgmeGetInvalid(this.getInternalRepresentation());
    }

    public boolean isExportable() {
        return this.gpgmeGetExportable(this.getInternalRepresentation());
    }

    public String getKeyID() {
        return this.gpgmeGetKeyID(this.getInternalRepresentation());
    }

    public String getUserID() {
        return this.gpgmeGetUserID(this.getInternalRepresentation());
    }

    public String getName() {
        return this.gpgmeGetName(this.getInternalRepresentation());
    }

    public String getEmail() {
        return this.gpgmeGetEmail(this.getInternalRepresentation());
    }

    public String getComment() {
        return this.gpgmeGetComment(this.getInternalRepresentation());
    }

    public boolean hasDetails() {
        return !this.getName().equals("");
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getKeyID());
        if (this.hasDetails()) {
            buf.append(", ");
            buf.append(this.getName());
            buf.append(", ");
            buf.append(this.getComment());
            buf.append(", ");
            buf.append(this.getEmail());
        } else {
            buf.append(" <No details available.>");
        }
        return buf.toString();
    }

    protected GnuPGSignature getNextSignature() {
        GnuPGSignature result = null;
        int next = this.gpgmeGetNextSignature(this.getInternalRepresentation());
        if (next != 0) {
            result = new GnuPGSignature(next);
        }
        return result;
    }

    private native boolean gpgmeGetRevoked(int var1);

    private native boolean gpgmeGetExpired(int var1);

    private native boolean gpgmeGetInvalid(int var1);

    private native boolean gpgmeGetExportable(int var1);

    private native String gpgmeGetKeyID(int var1);

    private native String gpgmeGetUserID(int var1);

    private native String gpgmeGetName(int var1);

    private native String gpgmeGetEmail(int var1);

    private native String gpgmeGetComment(int var1);

    private native int gpgmeGetNextSignature(int var1);
}

