/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.tool;

import gnu.crypto.jce.GnuCrypto;
import gnu.crypto.prng.IRandom;
import gnu.crypto.prng.LimitReachedException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Iterator;

public class Ent {
    private static final int MC_XY_BYTES = 6;
    private static final double INSIDE_CIRCLE = Math.pow(Math.pow(256.0, 3.0) - 1.0, 2.0);
    private static final double[][] CHI_SQUARE_P = new double[][]{{0.5, 0.25, 0.1, 0.05, 0.025, 0.01, 0.005, 0.001, 5.0E-4, 1.0E-4}, {0.0, 0.6745, 1.2816, 1.6449, 1.96, 2.3263, 2.5758, 3.0902, 3.2905, 3.719}};
    private static final double PI = Math.PI;
    private String name;
    private IRandom prng;
    private SecureRandom rand;
    private byte[] buffer = new byte[1024];
    private long duration;
    private long[] counters = new long[2];
    private long totalBits;
    private byte[] mcBuffer = new byte[6];
    private int mcBufferNdx;
    private double mcCount;
    private double mcInside;
    private boolean sccFirst;
    private double scc;
    private double sccLast;
    private double sccU0;
    private double sccUn;
    private double sccT1;
    private double sccT2;
    private double sccT3;
    private double chiSquare;
    private double mean;
    private double pi;

    public Ent(IRandom prng) {
        this.prng = prng;
        this.rand = null;
        this.name = prng.name();
        this.initInternal();
    }

    public Ent(String name, SecureRandom prng) {
        this.prng = null;
        this.rand = prng;
        this.name = name;
        this.initInternal();
    }

    public static void main(String[] args) {
        Provider gnu = Security.getProvider("GNU-CRYPTO");
        if (gnu == null) {
            Security.addProvider(new GnuCrypto());
        }
        try {
            Ent cmd;
            SecureRandom prng;
            String name = null;
            int i = 0;
            while (i < args.length) {
                String option;
                String arg = args[i];
                if (arg.startsWith("-") && (option = arg.substring(1)).equals("h")) {
                    Ent.printUsage();
                } else if (name == null) {
                    name = args[i++];
                }
                ++i;
            }
            if (name != null) {
                prng = SecureRandom.getInstance(name, "GNU-CRYPTO");
                cmd = new Ent(name, prng);
                cmd.computeIndices();
                cmd.printResults();
            } else {
                Iterator it = GnuCrypto.getSecureRandomNames().iterator();
                while (it.hasNext()) {
                    name = (String)it.next();
                    prng = SecureRandom.getInstance(name, "GNU-CRYPTO");
                    cmd = new Ent(name, prng);
                    cmd.computeIndices();
                    cmd.printResults();
                }
            }
        }
        catch (Exception x) {
            x.printStackTrace(System.err);
        }
    }

    private static final void printUsage() {
        System.err.println();
        System.err.println("Usage:");
        System.err.println("   gnu.crypto.tool.Ent (options) [algorithm]");
        System.err.println();
        System.err.println("Where:");
        System.err.println("   algorithm");
        System.err.println("      The canonical name of a PRNG algorithm. If omitted, then all");
        System.err.println("      PRNG implementations are exercised, one at a time.");
        System.err.println();
        System.err.println("Options:");
        System.err.println("   -h");
        System.err.println("      Print this help page.");
        System.err.println();
    }

    public void computeIndices() throws LimitReachedException {
        this.duration = -System.currentTimeMillis();
        if (this.prng != null) {
            int i = 0;
            while (i < 1024) {
                this.prng.nextBytes(this.buffer, 0, 1024);
                this.update(this.buffer);
                ++i;
            }
        } else {
            int i = 0;
            while (i < 1024) {
                this.rand.nextBytes(this.buffer);
                this.update(this.buffer);
                ++i;
            }
        }
        this.computeResults();
        this.duration += System.currentTimeMillis();
    }

    public long getDuration() {
        return this.duration;
    }

    public long getTotalBits() {
        return this.totalBits;
    }

    public long getSetBits() {
        return this.counters[1];
    }

    public double getMean() {
        return this.mean;
    }

    public double getMeanPercentDeviation() {
        return 100.0 * (Math.abs(0.5 - this.mean) / 0.5);
    }

    public double getChiSquare() {
        return this.chiSquare;
    }

    public double getChiSquareProbability() {
        double chip = Math.sqrt(2.0 * this.chiSquare) - 1.0;
        double a = Math.abs(chip);
        int i = 10;
        while (--i >= 0) {
            if (CHI_SQUARE_P[1][i] < a) break;
        }
        chip = chip >= 0.0 ? CHI_SQUARE_P[0][i] : 1.0 - CHI_SQUARE_P[0][i];
        return chip * 100.0;
    }

    public double getSerialCorrelationCoefficient() {
        return this.scc;
    }

    public double getPi() {
        return this.pi;
    }

    public double getPiPercentDeviation() {
        return 100.0 * (Math.abs(Math.PI - this.pi) / Math.PI);
    }

    private void initInternal() {
        this.totalBits = 0L;
        this.counters[1] = 0L;
        this.counters[0] = 0L;
        this.initMonteCarloBuffer();
        this.sccFirst = true;
        this.chiSquare = 0.0;
        this.mcCount = 0.0;
        this.mcInside = 0.0;
    }

    private void initMonteCarloBuffer() {
        int i = 0;
        while (i < this.mcBuffer.length) {
            this.mcBuffer[i++] = 0;
        }
        this.mcBufferNdx = 0;
    }

    private void update(byte[] buffer) {
        int i = 0;
        while (i < buffer.length) {
            int b = buffer[i] & 0xFF;
            this.updateBitCountAndSCC(b);
            this.updateMonteCarloPI(b);
            ++i;
        }
    }

    private void updateBitCountAndSCC(int b) {
        int limit = (int)Math.min(8.0, Double.MAX_VALUE - (double)this.totalBits);
        int i = 0;
        while (i < limit) {
            ++this.totalBits;
            int n = b >>> 7 & 1;
            this.counters[n] = this.counters[n] + 1L;
            this.sccUn = b & 0x80;
            if (this.sccFirst) {
                this.sccFirst = false;
                this.sccLast = 0.0;
                this.sccU0 = this.sccUn;
            } else {
                this.sccT1 += this.sccLast * this.sccUn;
            }
            this.sccT2 += this.sccUn;
            this.sccT3 += this.sccUn * this.sccUn;
            this.sccLast = this.sccUn;
            b <<= 1;
            ++i;
        }
    }

    private void updateMonteCarloPI(int b) {
        this.mcBuffer[this.mcBufferNdx] = (byte)b;
        ++this.mcBufferNdx;
        if (this.mcBufferNdx >= 6) {
            this.computeMonteCarloPI();
            this.initMonteCarloBuffer();
        }
    }

    private void computeMonteCarloPI() {
        this.mcCount += 1.0;
        double x = 0.0;
        double y = 0.0;
        int i = 0;
        while (i < 3) {
            x = x * 256.0 + (double)(this.mcBuffer[i] & 0xFF);
            y = y * 256.0 + (double)(this.mcBuffer[3 + i] & 0xFF);
            ++i;
        }
        if (x * x + y * y <= INSIDE_CIRCLE) {
            this.mcInside += 1.0;
        }
    }

    private void computeResults() {
        this.sccT1 += this.sccLast * this.sccU0;
        this.sccT2 *= this.sccT2;
        this.scc = (double)this.totalBits * this.sccT3 - this.sccT2;
        this.scc = this.scc == 0.0 ? -100000.0 : ((double)this.totalBits * this.sccT1 - this.sccT2) / this.scc;
        double cexp = (double)this.totalBits / 2.0;
        double a = (double)this.counters[0] - cexp;
        double b = (double)this.counters[1] - cexp;
        this.chiSquare = (a * a + b * b) / cexp;
        this.mean = (double)this.counters[1] * 1.0 / (double)this.totalBits;
        this.pi = 4.0 * this.mcInside / this.mcCount;
    }

    private void printResults() {
        System.out.println();
        System.out.println("Total execution time (ms): " + String.valueOf(this.duration));
        System.out.println("Computed indices for " + String.valueOf(this.name) + ":");
        System.out.println("                  Total bit count: " + String.valueOf(this.getTotalBits()));
        System.out.println("           Mean value of set bits: " + String.valueOf(this.getMean()));
        System.out.println("                 Mean % deviation: " + String.valueOf(this.getMeanPercentDeviation()));
        System.out.println("          Chi-square distribution: " + String.valueOf(this.getChiSquare()));
        System.out.println("  Chi-square excess % probability: " + String.valueOf(this.getChiSquareProbability()));
        System.out.println("                      Computed PI: " + String.valueOf(this.getPi()));
        System.out.println("          Computed PI % deviation: " + String.valueOf(this.getPiPercentDeviation()));
        System.out.println("   Serial Correlation Coefficient: " + String.valueOf(this.getSerialCorrelationCoefficient()));
    }
}

