/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.gnu.crypto.sig.rsa;

import gnu.crypto.sig.rsa.RSA;
import gnu.crypto.sig.rsa.RSAKeyPairGenerator;
import gnu.crypto.util.Prime;
import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

public class TestOfRSAKeyGeneration
implements Testlet {
    private static final BigInteger ZERO = BigInteger.ZERO;
    private static final BigInteger ONE = BigInteger.ONE;
    private RSAKeyPairGenerator kpg = new RSAKeyPairGenerator();
    private HashMap map = new HashMap();

    public void test(TestHarness harness) {
        this.testKeyPairGeneration(harness);
        this.testRSAParams(harness);
        this.testRSAPrimitives(harness);
    }

    public void testKeyPairGeneration(TestHarness harness) {
        harness.checkPoint("TestOfRSAKeyGeneration.testKeyPairGeneration");
        try {
            this.setUp();
            this.map.put("gnu.crypto.rsa.L", new Integer(530));
            try {
                this.kpg.setup((Map)this.map);
                harness.fail("L should be >= 1024");
            }
            catch (IllegalArgumentException x) {
                harness.check(true, "L should be >= 1024");
            }
            this.map.put("gnu.crypto.rsa.L", new Integer(1024));
            this.kpg.setup((Map)this.map);
            KeyPair kp = this.kpg.generate();
            BigInteger n1 = ((RSAPublicKey)kp.getPublic()).getModulus();
            BigInteger n2 = ((RSAPrivateKey)kp.getPrivate()).getModulus();
            BigInteger p = ((RSAPrivateCrtKey)kp.getPrivate()).getPrimeP();
            BigInteger q = ((RSAPrivateCrtKey)kp.getPrivate()).getPrimeQ();
            harness.check(n1.equals(p.multiply(q)), "n1 == pq");
            harness.check(n2.equals(p.multiply(q)), "n2 == pq");
        }
        catch (Exception x) {
            harness.debug(x);
            harness.fail("TestOfRSAPSSSignature.testKeyPairGeneration");
        }
    }

    public void testRSAParams(TestHarness harness) {
        harness.checkPoint("TestOfRSAKeyGeneration.testRSAParams");
        try {
            this.setUp();
            this.map.put("gnu.crypto.rsa.L", new Integer(1024));
            this.kpg.setup((Map)this.map);
            KeyPair kp = this.kpg.generate();
            BigInteger n1 = ((RSAPublicKey)kp.getPublic()).getModulus();
            BigInteger e = ((RSAPublicKey)kp.getPublic()).getPublicExponent();
            BigInteger n2 = ((RSAPrivateKey)kp.getPrivate()).getModulus();
            BigInteger d = ((RSAPrivateKey)kp.getPrivate()).getPrivateExponent();
            BigInteger p = ((RSAPrivateCrtKey)kp.getPrivate()).getPrimeP();
            BigInteger q = ((RSAPrivateCrtKey)kp.getPrivate()).getPrimeQ();
            BigInteger dP = ((RSAPrivateCrtKey)kp.getPrivate()).getPrimeExponentP();
            BigInteger dQ = ((RSAPrivateCrtKey)kp.getPrivate()).getPrimeExponentQ();
            BigInteger qInv = ((RSAPrivateCrtKey)kp.getPrivate()).getCrtCoefficient();
            harness.check(n1.bitLength() == 1024, "n1 is a 1024-bit MPI");
            harness.check(n2.bitLength() == 1024, "n2 is a 1024-bit MPI");
            harness.check(n1.equals(n2), "n1 == n2");
            harness.check(Prime.isProbablePrime((BigInteger)p, (boolean)true), "p is prime");
            harness.check(Prime.isProbablePrime((BigInteger)q, (boolean)true), "q is prime");
            harness.check(n1.equals(p.multiply(q)), "n == pq");
            BigInteger p_minus_1 = p.subtract(ONE);
            BigInteger q_minus_1 = q.subtract(ONE);
            harness.check(ZERO.compareTo(dP) < 0 && dP.compareTo(p_minus_1) < 0, "0 < dP < p-1");
            harness.check(ZERO.compareTo(dQ) < 0 && dQ.compareTo(q_minus_1) < 0, "0 < dQ < q-1");
            harness.check(e.multiply(dP).mod(p_minus_1).equals(ONE), "e.dP == 1 (mod p-1)");
            harness.check(e.multiply(dQ).mod(q_minus_1).equals(ONE), "e.dQ == 1 (mod q-1)");
            harness.check(q.multiply(qInv).mod(p).equals(ONE), "q.qInv == 1 (mod p)");
            BigInteger phi = p_minus_1.multiply(q_minus_1);
            harness.check(e.gcd(phi).equals(ONE), "gcd(e, phi) == 1");
            harness.check(e.multiply(d).mod(phi).equals(ONE), "e.d == 1 (mod phi)");
        }
        catch (Exception x) {
            harness.debug(x);
            harness.fail("TestOfRSAPSSSignature.testRSAParams");
        }
    }

    public void testRSAPrimitives(TestHarness harness) {
        harness.checkPoint("TestOfRSAKeyGeneration.testRSAPrimitives");
        try {
            this.setUp();
            this.map.put("gnu.crypto.rsa.L", new Integer(1024));
            this.kpg.setup((Map)this.map);
            KeyPair kp = this.kpg.generate();
            PublicKey pubK = kp.getPublic();
            PrivateKey privK = kp.getPrivate();
            BigInteger n = ((RSAPublicKey)pubK).getModulus();
            BigInteger m = ZERO;
            Random prng = new Random(System.currentTimeMillis());
            while (m.equals(ZERO) || m.compareTo(n) >= 0) {
                m = new BigInteger(1024, prng);
            }
            BigInteger s = RSA.sign((PrivateKey)privK, (BigInteger)m);
            BigInteger cm = RSA.verify((PublicKey)pubK, (BigInteger)s);
            harness.check(cm.equals(m));
        }
        catch (Exception x) {
            harness.debug(x);
            harness.fail("TestOfRSAPSSSignature.testRSAPrimitives");
        }
    }

    private void setUp() {
        this.kpg = new RSAKeyPairGenerator();
        this.map.clear();
    }
}

