/* This file is automatically generated by sql_to_c.awk */

#include "sqlnode.h"
#include "sqlfn.h"
#include "sqltype.h"

/* pop3_svr.sql */

static const char *proc0 = 
"#line 23 \"[executable]/pop3_svr.sql\"\n"
"create procedure\n"
"WS.WS.POP3_SRV (in path any, in params any, in lines any)\n"
"{\n"
"declare in_str varchar;\n"
"declare my_pass, arg, get_user, get_pass varchar;\n"
"declare mode, command, mail_idx, mail_len integer;\n"
"declare stat any;\n"
"\n"
"if (__proc_exists (\'WS.WS.__POP3_SRV_HANDLER\'))\n"
"{\n"
"declare rc int;\n"
"rc := call (\'WS.WS.__POP3_SRV_HANDLER\') ();\n"
"if (rc)\n"
"return NULL;\n"
"}\n"
"\n"
"mode := 1;\n"
"\n"
"pop_write_ok (\'Virtuoso POP3 Server (version 1.0) started\');\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"while (mode = 1)\n"
"{\n"
"in_str := ses_read_line ();\n"
"command := pop_if_command (in_str, vector (\'APOP\', \'USER\', \'QUIT\'), mode, get_user, stat);\n"
"if (not (command))\n"
"pop_write_err (concat (\'Unknown command: \', in_str));\n"
"}\n"
"\n"
"get_user := in_str;\n"
"\n"
"while (mode = 2)\n"
"{\n"
"in_str := ses_read_line ();\n"
"command := pop_if_command ( in_str, vector (\'PASS\', \'QUIT\'), mode, get_user, stat);\n"
"if (not (command))\n"
"pop_write_err (concat (\'Unknown command: \', in_str));\n"
"}\n"
"\n"
"if (mode = 10)\n"
"return NULL;\n"
"\n"
"get_pass := in_str;\n"
"\n"
"if (exists (select 1 from WS.WS.SYS_DAV_USER where U_NAME = get_user))\n"
"select pwd_magic_calc (U_NAME, U_PWD, 1) into my_pass from WS.WS.SYS_DAV_USER\n"
"where U_NAME = get_user and U_ACCOUNT_DISABLED = 0;\n"
"\n"
"commit work;\n"
"\n"
"if (get_pass = my_pass)\n"
"stat := pop_init (get_user);\n"
"else\n"
"{\n"
"pop_write_err (concat (\'Password supplied for \', get_user,\' is incorrect\'));\n"
"mode := 10;\n"
"pop_quit (mode, stat, get_user);\n"
"return;\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"while (mode = 3)\n"
"{\n"
"in_str := ses_read_line ();\n"
"command := pop_if_command ( in_str, vector (\'DELE\', \'LIST\', \'NOOP\', \'RETR\', \'RSET\', \'STAT\',\n"
"\'TOP\', \'UIDL\', \'QUIT\'), mode, get_user, stat);\n"
"\n"
"if (not (command))\n"
"pop_write_err (concat (\'Unknown command: \', in_str));\n"
"\n"
"if (mode = 10)\n"
"return NULL;\n"
"}\n"
"\n"
"return NULL;\n"
"}\n"
"--src pop3_svr.sql:21\n"
;

static const char *proc1 = 
"#line 108 \"[executable]/pop3_svr.sql\"\n"
"create procedure\n"
"pop_if_command (inout _in varchar, in valid any, inout mode integer, in _get_user varchar, inout _stat any)\n"
"{\n"
"declare command, temp varchar;\n"
"declare idx, len integer;\n"
"\n"
"_in := trim (_in);\n"
"\n"
"command := pop_get_command (_in);\n"
"command := ucase (command);\n"
"\n"
"if (command = \'\')\n"
"return 100;\n"
"\n"
"len := length (valid);\n"
"idx := 0;\n"
"temp := \'\';\n"
"\n"
"while (idx < len)\n"
"{\n"
"\n"
"if (aref (valid, idx) = command)\n"
"temp := command;\n"
"idx := idx + 1;\n"
"}\n"
"\n"
"if (temp = \'\')\n"
"return 0;\n"
"\n"
"_in := trim (subseq (_in, length (command)));\n"
"\n"
"\n"
"\n"
"if (temp = \'QUIT\')\n"
"pop_quit (mode, _stat, _get_user);\n"
"\n"
"if (temp = \'APOP\')\n"
"pop_apop ();\n"
"\n"
"if (temp = \'PASS\')\n"
"pop_pass (_in, mode);\n"
"\n"
"if (temp = \'USER\')\n"
"pop_user (_in, mode);\n"
"\n"
"if (temp = \'NOOP\')\n"
"pop_noop ();\n"
"\n"
"if (temp = \'LIST\')\n"
"pop_list (_in, _stat);\n"
"\n"
"if (temp = \'DELE\')\n"
"pop_dele (_in, _stat);\n"
"\n"
"if (temp = \'RSET\')\n"
"pop_rset (_in, _stat);\n"
"\n"
"if (temp = \'UIDL\')\n"
"pop_uidl (_in, _stat);\n"
"\n"
"if (temp = \'STAT\')\n"
"pop_stat (_in, _stat);\n"
"\n"
"if (temp = \'RETR\')\n"
"pop_retr (_in, _stat, _get_user);\n"
"\n"
"return 5;\n"
"}\n"
"--src pop3_svr.sql:106\n"
;

static const char *proc2 = 
"#line 179 \"[executable]/pop3_svr.sql\"\n"
"create procedure\n"
"pop_get_command (in _in_s varchar)\n"
"{\n"
"declare pos integer;\n"
"pos := strstr (_in_s, \' \');\n"
"if (pos = 0)\n"
"return NULL;\n"
"else\n"
"return (subseq (_in_s, 0, pos));\n"
"}\n"
"--src pop3_svr.sql:177\n"
;

static const char *proc3 = 
"#line 192 \"[executable]/pop3_svr.sql\"\n"
"create procedure\n"
"pop_init (in _user varchar)\n"
"{\n"
"declare _idx, mail_idx, mail_len, temp_is_read, temp_id integer;\n"
"declare temp_body, temp_len varchar;\n"
"declare res, uidl, temp_body2 any;\n"
"declare all_mess cursor for select MM_ID, MM_BODY, MM_IS_READED from MAIL_MESSAGE where MM_OWN = _user;\n"
"\n"
"\n"
"mail_idx := pop_messages (_user);\n"
"mail_len := pop_mess_len (_user);\n"
"\n"
"pop_write_ok (sprintf (\'%s has %i messages (%i octets)\', _user, mail_idx, mail_len));\n"
"\n"
"res := make_array (mail_idx + 1, \'any\');\n"
"_idx := 0;\n"
"\n"
"open all_mess (exclusive);\n"
"whenever not found goto _end;\n"
"while ( 1 )\n"
"{\n"
"fetch all_mess into temp_id, temp_body2, temp_is_read;\n"
"temp_body := blob_to_string(coalesce (temp_body2, \' \'));\n"
"\n"
"\n"
"\n"
"uidl := vector (temp_id, length (temp_body), temp_is_read,\n"
"concat (MD5 (concat (temp_body, sprintf (\'%i\',temp_id))), \'v_pop\'));\n"
"_idx := _idx + 1;\n"
"aset (res, _idx, uidl);\n"
"}\n"
"\n"
"_end:\n"
"close all_mess;\n"
"\n"
"return res;\n"
"}\n"
"--src pop3_svr.sql:190\n"
;

static const char *proc4 = 
"#line 231 \"[executable]/pop3_svr.sql\"\n"
"create procedure\n"
"pop_write (in _in_str varchar)\n"
"{\n"
"if (is_http_ctx ())\n"
"ses_write (concat (_in_str, chr(13), chr(10)));\n"
"else\n"
"signal (\'24000\', _in_str, \'ERR:\');\n"
"}\n"
"--src pop3_svr.sql:229\n"
;

static const char *proc5 = 
"#line 242 \"[executable]/pop3_svr.sql\"\n"
"create procedure\n"
"pop_write_ok (in _in_str varchar)\n"
"{\n"
"pop_write (concat (\'+OK \', _in_str));\n"
"}\n"
"--src pop3_svr.sql:240\n"
;

static const char *proc6 = 
"#line 250 \"[executable]/pop3_svr.sql\"\n"
"create procedure\n"
"pop_write_err (in _in_str varchar)\n"
"{\n"
"pop_write (concat (\'-ERR \', _in_str));\n"
"}\n"
"--src pop3_svr.sql:248\n"
;

static const char *proc7 = 
"#line 258 \"[executable]/pop3_svr.sql\"\n"
"create procedure\n"
"pop_is_deleted (in num integer, inout _stat any)\n"
"{\n"
"if (aref (aref (_stat, num), 1) < 0)\n"
"return 1;\n"
"return NULL;\n"
"}\n"
"--src pop3_svr.sql:256\n"
;

static const char *proc8 = 
"#line 268 \"[executable]/pop3_svr.sql\"\n"
"create procedure\n"
"pop_is_ok_ (in num any, inout _stat any)\n"
"{\n"
"declare _idx, _all integer;\n"
"\n"
"_idx := pop_atoi (num);\n"
"_all := length (_stat);\n"
"\n"
"if ((_idx < 1) or (_idx > _all - 1))\n"
"{\n"
"pop_write_err (sprintf (\'Message %i does not exist\', _idx));\n"
"return null;\n"
"}\n"
"if (pop_is_deleted (_idx, _stat))\n"
"{\n"
"pop_write_err (sprintf (\'Message %i has been deleted\', _idx));\n"
"return null;\n"
"}\n"
"\n"
"return 1;\n"
"}\n"
"--src pop3_svr.sql:266\n"
;

static const char *proc9 = 
"#line 292 \"[executable]/pop3_svr.sql\"\n"
"create procedure\n"
"pop_change_stat (in num integer, inout _stat any)\n"
"{\n"
"declare temp any;\n"
"\n"
"temp := aref (_stat, num);\n"
"aset (temp, 1, -aref (temp, 1));\n"
"aset (_stat, num, temp);\n"
"}\n"
"--src pop3_svr.sql:290\n"
;

static const char *proc10 = 
"#line 304 \"[executable]/pop3_svr.sql\"\n"
"create procedure\n"
"pop_messages (in _user varchar)\n"
"{\n"
"return (select count (*) from DB.DBA.MAIL_MESSAGE where MM_OWN = _user);\n"
"}\n"
"--src pop3_svr.sql:302\n"
;

static const char *proc11 = 
"#line 312 \"[executable]/pop3_svr.sql\"\n"
"create procedure\n"
"pop_mess_len (in _user varchar)\n"
"{\n"
"declare mail_len integer;\n"
"\n"
"select sum (length (MM_BODY)) into mail_len from DB.DBA.MAIL_MESSAGE where MM_OWN = _user;\n"
"\n"
"if (mail_len is null)\n"
"mail_len := 0;\n"
"\n"
"return mail_len;\n"
"}\n"
"--src pop3_svr.sql:310\n"
;

static const char *proc12 = 
"#line 333 \"[executable]/pop3_svr.sql\"\n"
"create procedure\n"
"pop_quit (inout mode integer, inout _stat any, in get_user varchar)\n"
"{\n"
"declare mail_all, _idx integer;\n"
"\n"
"if (mode = 3)\n"
"{\n"
"_idx := 1;\n"
"mail_all := length (_stat);\n"
"while (_idx < mail_all)\n"
"{\n"
"if (pop_is_deleted (_idx, _stat))\n"
"delete from DB.DBA.MAIL_MESSAGE where MM_OWN = get_user and MM_ID = aref (aref (_stat, _idx), 0);\n"
"_idx := _idx + 1;\n"
"}\n"
"}\n"
"mode := 10;\n"
"commit work;\n"
"pop_write_ok (\'Virtuoso POP3 server signing off\');\n"
"}\n"
"--src pop3_svr.sql:331\n"
;

static const char *proc13 = 
"#line 356 \"[executable]/pop3_svr.sql\"\n"
"create procedure\n"
"pop_apop ()\n"
"{\n"
"pop_write_err (\'not supported from this version\');\n"
"}\n"
"--src pop3_svr.sql:354\n"
;

static const char *proc14 = 
"#line 364 \"[executable]/pop3_svr.sql\"\n"
"create procedure\n"
"pop_user (inout arg varchar, inout mode integer)\n"
"{\n"
"if (strstr (arg, \' \'))\n"
"pop_write_err (\'Too many arguments for user\');\n"
"else\n"
"{\n"
"if (arg =\'\')\n"
"pop_write_err (\'Too small arguments for user\');\n"
"else\n"
"{\n"
"mode := 2;\n"
"pop_write_ok (concat (\'password required for \', arg));\n"
"}\n"
"}\n"
"}\n"
"--src pop3_svr.sql:362\n"
;

static const char *proc15 = 
"#line 383 \"[executable]/pop3_svr.sql\"\n"
"create procedure\n"
"pop_pass (inout arg varchar, inout mode integer)\n"
"{\n"
"mode := 3;\n"
"}\n"
"--src pop3_svr.sql:381\n"
;

static const char *proc16 = 
"#line 391 \"[executable]/pop3_svr.sql\"\n"
"create procedure\n"
"pop_noop ()\n"
"{\n"
"pop_write_ok (\'\');\n"
"}\n"
"--src pop3_svr.sql:389\n"
;

static const char *proc17 = 
"#line 399 \"[executable]/pop3_svr.sql\"\n"
"create procedure\n"
"pop_list (inout arg varchar, inout _stat any)\n"
"{\n"
"declare _idx, _idx2, mail_all, mail_len, mail_len_temp, arg_int integer;\n"
"\n"
"mail_all := length (_stat);\n"
"arg_int := pop_atoi (arg);\n"
"\n"
"if (arg = \'\')\n"
"{\n"
"mail_len := 0;\n"
"_idx := 1;\n"
"_idx2 := 0;\n"
"while (_idx < mail_all)\n"
"{\n"
"mail_len_temp := aref (aref (_stat, _idx), 1);\n"
"if (mail_len_temp > 0)\n"
"{\n"
"mail_len := mail_len + mail_len_temp;\n"
"_idx2 := _idx2 + 1;\n"
"}\n"
"_idx := _idx + 1;\n"
"}\n"
"pop_write_ok (sprintf (\'%d messages (%d octets)\', _idx2, mail_len));\n"
"_idx := 1;\n"
"while (_idx < mail_all)\n"
"{\n"
"mail_len_temp := aref (aref (_stat, _idx), 1);\n"
"if (mail_len_temp > 0)\n"
"pop_write (sprintf (\'%d %d\', _idx, mail_len_temp));\n"
"_idx := _idx + 1;\n"
"}\n"
"pop_write (\'.\');\n"
"}\n"
"else\n"
"if (pop_is_ok_ (arg, _stat))\n"
"pop_write_ok (sprintf (\'%d %d\', arg_int, aref (aref (_stat, arg_int), 1)));\n"
"}\n"
"--src pop3_svr.sql:397\n"
;

static const char *proc18 = 
"#line 440 \"[executable]/pop3_svr.sql\"\n"
"create procedure\n"
"pop_dele (inout arg varchar, inout _stat any)\n"
"{\n"
"declare mail_idx, mail_all integer;\n"
"declare temp any;\n"
"\n"
"mail_all := length (_stat);\n"
"mail_idx := pop_atoi (arg);\n"
"\n"
"if (arg = \'\')\n"
"pop_write_err (\'Too few arguments for the dele command\');\n"
"else\n"
"{\n"
"if (pop_is_ok_ (arg, _stat) is null)\n"
"return;\n"
"pop_change_stat (mail_idx, _stat);\n"
"pop_write_ok (sprintf (\'Message %i has been deleted\', mail_idx));\n"
"}\n"
"}\n"
"--src pop3_svr.sql:438\n"
;

static const char *proc19 = 
"#line 462 \"[executable]/pop3_svr.sql\"\n"
"create procedure\n"
"pop_rset (inout arg varchar, inout _stat any)\n"
"{\n"
"declare _idx, mail_all, mail_len integer;\n"
"\n"
"if (not (arg = \'\'))\n"
"pop_write_err (\'Too few arguments for the rset command\');\n"
"else\n"
"{\n"
"mail_all := length (_stat);\n"
"mail_len := 0;\n"
"_idx := 1;\n"
"\n"
"while (_idx < mail_all)\n"
"{\n"
"if (pop_is_deleted (_idx, _stat))\n"
"pop_change_stat (_idx, _stat);\n"
"mail_len := mail_len + aref (aref (_stat, _idx), 1);\n"
"_idx := _idx + 1;\n"
"}\n"
"pop_write_ok (sprintf (\'Maildrop has %i messages (%i octets)\', mail_all - 1, mail_len));\n"
"}\n"
"}\n"
"--src pop3_svr.sql:460\n"
;

static const char *proc20 = 
"#line 488 \"[executable]/pop3_svr.sql\"\n"
"create procedure\n"
"pop_uidl (inout arg varchar, inout _stat any)\n"
"{\n"
"declare _idx, mail_all, arg_int integer;\n"
"\n"
"mail_all := length (_stat);\n"
"arg_int := pop_atoi (arg);\n"
"\n"
"if (arg = \'\')\n"
"{\n"
"_idx := 1;\n"
"pop_write_ok (\'uidl command accepted.\');\n"
"while (_idx < mail_all)\n"
"{\n"
"if ((pop_is_deleted (_idx, _stat) is null ))\n"
"pop_write (sprintf (\'%i %s\', _idx, aref (aref (_stat, _idx), 3)));\n"
"_idx := _idx + 1;\n"
"}\n"
"pop_write (\'.\');\n"
"}\n"
"else\n"
"if (pop_is_ok_ (arg, _stat))\n"
"pop_write_ok (sprintf (\'%i %s\', arg_int, aref (aref (_stat, arg_int), 3)));\n"
"}\n"
"--src pop3_svr.sql:486\n"
;

static const char *proc21 = 
"#line 515 \"[executable]/pop3_svr.sql\"\n"
"create procedure\n"
"pop_stat (inout arg varchar, inout _stat any)\n"
"{\n"
"declare _idx, _idx2, mail_all, mail_len, mail_len_temp integer;\n"
"\n"
"mail_all := length (_stat);\n"
"\n"
"if (arg = \'\')\n"
"{\n"
"mail_len := 0;\n"
"_idx := 1;\n"
"_idx2 := 0;\n"
"while (_idx < mail_all)\n"
"{\n"
"mail_len_temp := aref (aref (_stat, _idx), 1);\n"
"if (mail_len_temp > 0)\n"
"{\n"
"mail_len := mail_len + mail_len_temp;\n"
"_idx2 := _idx2 + 1;\n"
"}\n"
"_idx := _idx + 1;\n"
"}\n"
"pop_write_ok (sprintf (\'%i %i\', _idx2, mail_len));\n"
"}\n"
"}\n"
"--src pop3_svr.sql:513\n"
;

static const char *proc22 = 
"#line 543 \"[executable]/pop3_svr.sql\"\n"
"create procedure\n"
"pop_retr (inout arg varchar, inout _stat any, in get_user varchar)\n"
"{\n"
"declare mail_idx, message_id, message_status integer;\n"
"declare temp_body any;\n"
"declare _uidl, _end_line varchar;\n"
"\n"
"_end_line := concat (chr (13), chr (10), chr (46), chr (13), chr (10));\n"
"\n"
"if (arg = \'\')\n"
"pop_write_err (\'Too small arguments for the retr command\');\n"
"else\n"
"{\n"
"mail_idx := pop_atoi (arg);\n"
"if (pop_is_ok_ (arg, _stat))\n"
"{\n"
"message_id := aref (aref (_stat, mail_idx), 0);\n"
"select blob_to_string (coalesce (MM_BODY, \'\')) into temp_body from DB.DBA.MAIL_MESSAGE\n"
"where MM_ID = message_id and MM_OWN = get_user;\n"
"update DB.DBA.MAIL_MESSAGE set MM_IS_READED = 1 where MM_ID = message_id and MM_OWN = get_user;\n"
"pop_write_ok (sprintf (\'%i octets\', length (temp_body)));\n"
"_uidl := substring (mail_header (temp_body, \'X-UIDL\'), 1, 128);\n"
"temp_body := replace (temp_body, _uidl, concat (\'<\', aref (aref (_stat, mail_idx), 3), \'>\'));\n"
"if (registry_get (\'__spam_filtering\') = \'1\')\n"
"{\n"
"declare _uid integer;\n"
"select U_ID into _uid from SYS_USERS where U_NAME = get_user;\n"
"commit work;\n"
"\n"
"spam_change_header (temp_body, _uid);\n"
"}\n"
"ses_write (temp_body);\n"
"if (\"RIGHT\" (temp_body, 5) <> _end_line)\n"
"ses_write (_end_line);\n"
"}\n"
"}\n"
"}\n"
"--src pop3_svr.sql:541\n"
;

static const char *proc23 = 
"#line 582 \"[executable]/pop3_svr.sql\"\n"
"create procedure\n"
"pop_atoi (in arg varchar)\n"
"{\n"
"if (arg <> \'\')\n"
"return atoi (arg);\n"
"\n"
"return 0;\n"
"}\n"
"--src pop3_svr.sql:580\n"
;

static const char *proc24 = 
"#line 598 \"[executable]/pop3_svr.sql\"\n"
"create procedure\n"
"pop_spam_filter_init ()\n"
"{\n"
"declare _from_ini varchar;\n"
"\n"
"_from_ini := virtuoso_ini_item_value (\'HTTPServer\', \'SpamFilter\');\n"
"\n"
"if (_from_ini is NULL or _from_ini <> \'1\')\n"
"registry_set (\'__spam_filtering\', \'0\');\n"
"else\n"
"registry_set (\'__spam_filtering\', \'1\');\n"
"}\n"
"--src pop3_svr.sql:596\n"
;

static const char *other0 = 
"pop_spam_filter_init ()\n";
static const char *tbl0 = 
"CREATE TABLE DB.DBA.MSG_WORDS (\n"
"MW_WORD		varchar not null,\n"
"MW_USER		integer,\n"
"MW_SPAM		integer,\n"
"MW_HAM		integer,\n"
"PRIMARY KEY (MW_WORD, MW_USER))\n";

static const char *tbl1 = 
"CREATE TABLE DB.DBA.MSG_SPAMS_COUNT (\n"
"MS_USER		integer,\n"
"MS_SPAM		integer,\n"
"MS_HAM		integer,\n"
"PRIMARY KEY (MS_USER))\n";

static const char *proc25 = 
"#line 634 \"[executable]/pop3_svr.sql\"\n"
"create procedure\n"
"spam_mw_word_stream (inout msg any, inout vtb any)\n"
"{\n"
"spam_remove_old_header (msg);\n"
"\n"
"vtb := vt_batch(8000);\n"
"vt_batch_feed (vtb, msg, 0);\n"
"vtb := vt_batch_strings_array (vtb);\n"
"}\n"
"--src pop3_svr.sql:632\n"
;

static const char *proc26 = 
"#line 646 \"[executable]/pop3_svr.sql\"\n"
"create procedure\n"
"filter_add_message (in _message any, in _uid any, in _is_spam integer)\n"
"{\n"
"declare len, idx integer;\n"
"declare _word, _u2 varchar;\n"
"declare vtb any;\n"
"\n"
"spam_message_from_id (_message, _uid, _u2);\n"
"spam_mw_word_stream (_message, vtb);\n"
"\n"
"len := length (vtb);\n"
"idx := 0;\n"
"\n"
"while (idx < len)\n"
"{\n"
"_word := vtb[idx];\n"
"\n"
"spam_add_word (_word, _uid, _is_spam, 1);\n"
"idx := idx + 2;\n"
"}\n"
"\n"
"spam_add_headers (_message, _uid, _is_spam);\n"
"\n"
"if (not exists (select 1 from DB.DBA.MSG_SPAMS_COUNT where MS_USER = _uid))\n"
"insert into DB.DBA.MSG_SPAMS_COUNT (MS_USER, MS_SPAM, MS_HAM) values (_uid, 0, 0);\n"
"\n"
"if (_is_spam)\n"
"update DB.DBA.MSG_SPAMS_COUNT set MS_SPAM = MS_SPAM + 1 where MS_USER = _uid;\n"
"else\n"
"update DB.DBA.MSG_SPAMS_COUNT set MS_HAM = MS_HAM + 1 where MS_USER = _uid;\n"
"}\n"
"--src pop3_svr.sql:644\n"
;

static const char *proc27 = 
"#line 680 \"[executable]/pop3_svr.sql\"\n"
"create procedure\n"
"spam_add_headers (inout _msg any, in _uid integer, in _is_spam integer)\n"
"{\n"
"declare _id, _from, _con_t, _x_mailer varchar;\n"
"\n"
"_id := substring (mail_header (_msg, \'message-id\'), 1, 512);\n"
"_from := substring (mail_header (_msg, \'from\'), 1, 512);\n"
"_con_t := substring (mail_header (_msg, \'content-type\'), 1, 512);\n"
"_x_mailer := substring (mail_header (_msg, \'x-mailer\'), 1, 512);\n"
"\n"
"if (_id <> \'\')\n"
"spam_add_word (_id, _uid, _is_spam, 0);\n"
"\n"
"if (_from <> \'\')\n"
"spam_add_word (_from, _uid, _is_spam, 0);\n"
"\n"
"if (_x_mailer <> \'\')\n"
"spam_add_word (_x_mailer, _uid, _is_spam, 0);\n"
"\n"
"if (_con_t <> \'\')\n"
"spam_add_word (_con_t, _uid, _is_spam, 0);\n"
"else\n"
"spam_add_word (\'text/plain\', _uid, _is_spam, 0);\n"
"}\n"
"--src pop3_svr.sql:678\n"
;

static const char *proc28 = 
"#line 707 \"[executable]/pop3_svr.sql\"\n"
"create procedure\n"
"spam_add_word (in _word any, in _uid integer, in _is_spam integer, in _check_len integer)\n"
"{\n"
"declare _spam, _ham integer;\n"
"declare cr cursor for select MW_SPAM, MW_HAM from DB.DBA.MSG_WORDS where MW_WORD = _word and MW_USER = _uid;\n"
"\n"
"if (length (_word) < 3)\n"
"return;\n"
"\n"
"if (length (_word) > 13 and _check_len)\n"
"return;\n"
"\n"
"_word := ucase (_word);\n"
"\n"
"whenever not found goto add_word;\n"
"open cr (prefetch 1);\n"
"fetch cr into _spam, _ham;\n"
"\n"
"if (_is_spam)\n"
"_spam := _spam + 1;\n"
"else\n"
"_ham := _ham + 1;\n"
"\n"
"update DB.DBA.MSG_WORDS set MW_SPAM = _spam, MW_HAM = _ham where current of cr;\n"
"\n"
"close cr;\n"
"return;\n"
"\n"
"add_word:\n"
"\n"
"close cr;\n"
"\n"
"if (_is_spam)\n"
"insert into DB.DBA.MSG_WORDS (MW_WORD, MW_USER, MW_SPAM, MW_HAM) values (_word, _uid, 1, 0);\n"
"else\n"
"insert into DB.DBA.MSG_WORDS (MW_WORD, MW_USER, MW_SPAM, MW_HAM) values (_word, _uid, 0, 1);\n"
"\n"
"return;\n"
"}\n"
"--src pop3_svr.sql:705\n"
;

static const char *proc29 = 
"#line 749 \"[executable]/pop3_svr.sql\"\n"
"create procedure\n"
"spam_remove_headers (inout _msg any, in _uid integer, in _is_spam integer)\n"
"{\n"
"declare _id, _from, _con_t, _x_mailer varchar;\n"
"\n"
"_id := substring (mail_header (_msg, \'message-id\'), 1, 512);\n"
"_from := substring (mail_header (_msg, \'from\'), 1, 512);\n"
"_con_t := substring (mail_header (_msg, \'content-type\'), 1, 512);\n"
"_x_mailer := substring (mail_header (_msg, \'x-mailer\'), 1, 512);\n"
"\n"
"if (_id <> \'\')\n"
"spam_remove_word (_id, _uid, _is_spam);\n"
"\n"
"if (_from <> \'\')\n"
"spam_remove_word (_from, _uid, _is_spam);\n"
"\n"
"if (_x_mailer <> \'\')\n"
"spam_remove_word (_x_mailer, _uid, _is_spam);\n"
"\n"
"if (_con_t <> \'\')\n"
"spam_remove_word (_con_t, _uid, _is_spam);\n"
"else\n"
"spam_remove_word (\'text/plain\', _uid, _is_spam);\n"
"}\n"
"--src pop3_svr.sql:747\n"
;

static const char *proc30 = 
"#line 776 \"[executable]/pop3_svr.sql\"\n"
"create procedure\n"
"filter_remove_message (in _message any, in _uid any, in _is_spam integer)\n"
"{\n"
"declare len, idx integer;\n"
"declare _word, _u2 varchar;\n"
"declare vtb any;\n"
"\n"
"spam_message_from_id (_message, _uid, _u2);\n"
"spam_mw_word_stream (_message, vtb);\n"
"\n"
"len := length (vtb);\n"
"idx := 0;\n"
"\n"
"while (idx < len)\n"
"{\n"
"_word := vtb[idx];\n"
"\n"
"spam_remove_word (_word, _uid, _is_spam);\n"
"idx := idx + 2;\n"
"}\n"
"\n"
"spam_remove_headers (_message, _uid, _is_spam);\n"
"\n"
"if (_is_spam)\n"
"update DB.DBA.MSG_SPAMS_COUNT set MS_SPAM = MS_SPAM - 1 where MS_USER = _uid;\n"
"else\n"
"update DB.DBA.MSG_SPAMS_COUNT set MS_HAM = MS_HAM - 1 where MS_USER = _uid;\n"
"}\n"
"--src pop3_svr.sql:774\n"
;

static const char *proc31 = 
"#line 807 \"[executable]/pop3_svr.sql\"\n"
"create procedure\n"
"spam_remove_word (in _word any, in _uid integer, in _is_spam integer)\n"
"{\n"
"declare _spam, _ham integer;\n"
"declare cr cursor for select MW_SPAM, MW_HAM from DB.DBA.MSG_WORDS where MW_WORD = _word and MW_USER = _uid;\n"
"\n"
"whenever not found goto nf;\n"
"open cr (prefetch 1);\n"
"fetch cr into _spam, _ham;\n"
"\n"
"if (_is_spam)\n"
"_spam := _spam - 1;\n"
"else\n"
"_ham := _ham - 1;\n"
"\n"
"if (_spam < 0) _spam := 0;\n"
"if (_ham < 0) _ham := 0;\n"
"\n"
"if (_spam <= 0 and _ham <= 0)\n"
"delete from DB.DBA.MSG_WORDS where current of cr;\n"
"else\n"
"update DB.DBA.MSG_WORDS set MW_SPAM = _spam, MW_HAM = _ham where current of cr;\n"
"\n"
"close cr;\n"
"return;\n"
"\n"
"nf:\n"
"\n"
"close cr;\n"
"return;\n"
"}\n"
"--src pop3_svr.sql:805\n"
;

static const char *proc32 = 
"#line 841 \"[executable]/pop3_svr.sql\"\n"
"create procedure\n"
"spam_get_word (in _word any, in _uid integer, inout _spam integer, inout _ham integer)\n"
"{\n"
"declare cr cursor for select MW_SPAM, MW_HAM from DB.DBA.MSG_WORDS where MW_WORD = _word and MW_USER = _uid;\n"
"\n"
"_spam := NULL;\n"
"_ham  := NULL;\n"
"\n"
"if (length (_word) < 3)\n"
"return;\n"
"\n"
"whenever not found goto nf;\n"
"open cr (prefetch 1);\n"
"\n"
"fetch cr into _spam, _ham;\n"
"\n"
"nf:\n"
"\n"
"close cr;\n"
"return;\n"
"}\n"
"--src pop3_svr.sql:839\n"
;

static const char *proc33 = 
"#line 865 \"[executable]/pop3_svr.sql\"\n"
"create procedure\n"
"spam_min (in _a any, in _b any)\n"
"{\n"
"if (_a < _b)\n"
"return _a;\n"
"else\n"
"return _b;\n"
"}\n"
"--src pop3_svr.sql:863\n"
;

static const char *proc34 = 
"#line 876 \"[executable]/pop3_svr.sql\"\n"
"create procedure\n"
"spam_probability (in _word varchar, in _uid integer)\n"
"{\n"
"declare _spam, _ham integer;\n"
"declare spamcount, hamcount integer;\n"
"declare experimental_ham_spam_imbalance_adjustment integer;\n"
"declare nham, nspam integer;\n"
"declare s, stimesx, n, prob double precision;\n"
"declare unknown_word_strength, unknown_word_prob double precision;\n"
"declare hamratio, spamratio double precision;\n"
"declare spam2ham, ham2spam double precision;\n"
"\n"
"experimental_ham_spam_imbalance_adjustment := 0;\n"
"unknown_word_strength := 0.45;\n"
"unknown_word_prob := 0.5;\n"
"\n"
"_word := ucase (_word);\n"
"\n"
"spam_get_word (_word, _uid, _spam, _ham);\n"
"\n"
"if (_spam is NULL) return 0.5;\n"
"\n"
"select MS_SPAM, MS_HAM into nspam, nham from DB.DBA.MSG_SPAMS_COUNT where MS_USER = _uid;\n"
"\n"
"nspam := either (nspam, nspam, 1);\n"
"nham := either (nham, nham, 1);\n"
"\n"
"spamcount := _spam;\n"
"hamcount := _ham;\n"
"\n"
"\n"
"spamratio := either (spamcount, spamcount / cast (nspam as double precision), 0);\n"
"\n"
"hamratio := either (hamcount, hamcount / cast (nham as double precision), 0);\n"
"\n"
"prob := spamratio / (hamratio + spamratio);\n"
"\n"
"if (experimental_ham_spam_imbalance_adjustment)\n"
"{\n"
"spam2ham := spam_min(nspam / nham, 1.0);\n"
"ham2spam := spam_min(nham / nspam, 1.0);\n"
"}\n"
"else\n"
"{\n"
"spam2ham := 1.0;\n"
"ham2spam := 1.0;\n"
"}\n"
"\n"
"s := unknown_word_strength;\n"
"stimesx := s * unknown_word_prob;\n"
"\n"
"n := hamcount * spam2ham + spamcount * ham2spam;\n"
"prob := (stimesx + n * prob) / (s + n);\n"
"\n"
"return prob;\n"
"}\n"
"--src pop3_svr.sql:874\n"
;

static const char *proc35 = 
"#line 935 \"[executable]/pop3_svr.sql\"\n"
"create procedure\n"
"spam_filter_message (in _message any, in _uid varchar)\n"
"{\n"
"declare len, idx integer;\n"
"declare _word varchar;\n"
"declare vtb any;\n"
"\n"
"set isolation=\'committed\';\n"
"\n"
"spam_mw_word_stream (_message, vtb);\n"
"\n"
"if (1)\n"
"return spam_chi2_spamprob (vtb, _message, _uid);\n"
"else\n"
"return gary_spamprob (vtb, _message, _uid);\n"
"\n"
"}\n"
"--src pop3_svr.sql:933\n"
;

static const char *proc36 = 
"#line 955 \"[executable]/pop3_svr.sql\"\n"
"create procedure\n"
"spam_chi2_spamprob (inout _word_stream any, inout _message any, in _uid integer)\n"
"{\n"
"declare len, idx, work_obj integer;\n"
"declare h, s, e, prob double precision;\n"
"declare clues, res_frexp any;\n"
"\n"
"h := cast (1.0 as double precision);\n"
"s := cast (1.0 as double precision);\n"
"work_obj := 0;\n"
"\n"
"clues := spam_getclues(_word_stream, _message, _uid);\n"
"\n"
"idx := 1;\n"
"len := clues[0] + 1;\n"
"\n"
"while (idx < len)\n"
"{\n"
"prob := clues[idx][0];\n"
"\n"
"if (prob = 0.5) goto _end;\n"
"\n"
"prob := cast (prob as double precision);\n"
"s := s * (cast (1.0 as double precision) - prob);\n"
"h := h * prob;\n"
"work_obj := work_obj + 1;\n"
"\n"
"res_frexp := frexp(s);\n"
"if (-200 > res_frexp[1])\n"
"idx := idx + 100;\n"
"\n"
"res_frexp := frexp(h);\n"
"if (-200 > res_frexp[1])\n"
"idx := idx + 100;\n"
"\n"
"_end:\n"
"idx := idx + 1;\n"
"}\n"
"\n"
"s := log(s);\n"
"h := log(h);\n"
"\n"
"\n"
"len := len - 1;\n"
"len := work_obj;\n"
"\n"
"if (len)\n"
"{\n"
"s := cast (1.0 as double precision)\n"
"- cast (spam_chi2q(cast (-2.0 as double precision) * s, 2*len) as double precision);\n"
"h := cast (1.0 as double precision)\n"
"- cast (spam_chi2q(cast (-2.0 as double precision) * h, 2*len) as double precision);\n"
"prob := (s-h + cast (1.0 as double precision)) / cast (2.0 as double precision);\n"
"}\n"
"else\n"
"prob := 0.499;\n"
"\n"
"prob := prob + 0.005;\n"
"\n"
"return \"LEFT\" (cast (prob as varchar), 4);\n"
"}\n"
"--src pop3_svr.sql:953\n"
;

static const char *proc37 = 
"#line 1019 \"[executable]/pop3_svr.sql\"\n"
"create procedure\n"
"spam_chi2q (in x2 double precision, in v integer)\n"
"{\n"
"declare m, _sum, term double precision;\n"
"declare idx, len any;\n"
"\n"
"m := x2 / 2e+00;\n"
"_sum := exp((-1e+0) * m);\n"
"term := exp((-1e+0) * m);\n"
"\n"
"idx := 1;\n"
"len := v/2;\n"
"\n"
"while (idx < len)\n"
"{\n"
"term := term * m / idx;\n"
"_sum := _sum + term;\n"
"idx := idx + 1;\n"
"}\n"
"\n"
"return spam_min (_sum, cast (1.0 as double precision));\n"
"}\n"
"--src pop3_svr.sql:1017\n"
;

static const char *proc38 = 
"#line 1044 \"[executable]/pop3_svr.sql\"\n"
"create procedure\n"
"spam_getclues (inout _word_stream any, inout _msg any, in _uid integer)\n"
"{\n"
"declare max_discriminators integer;\n"
"declare _spam, _ham integer;\n"
"declare len, idx, idx_res integer;\n"
"declare mindist, prob, h_prob, distance double precision;\n"
"declare minimum_prob_strength, unknown_word_prob double precision;\n"
"declare _id, _from, _con_t, _x_mailer varchar;\n"
"declare _word varchar;\n"
"declare res any;\n"
"\n"
"max_discriminators := 100;\n"
"minimum_prob_strength := 1e-01;\n"
"\n"
"mindist := minimum_prob_strength;\n"
"\n"
"len := length (_word_stream);\n"
"idx := 0;\n"
"idx_res := 0;\n"
"\n"
"res := make_array (max_discriminators + 6, \'any\');\n"
"\n"
"while (idx < len)\n"
"{\n"
"_word := _word_stream[idx];\n"
"prob := spam_probability (_word, _uid);\n"
"if (prob is NULL) prob := 0e-0;\n"
"distance := abs (prob - 5e-01);\n"
"\n"
"if (distance >= mindist)\n"
"{\n"
"idx_res := idx_res + 1;\n"
"aset (res, idx_res, vector (prob));\n"
"if (idx_res > max_discriminators) idx := len;\n"
"}\n"
"\n"
"idx := idx + 2;\n"
"}\n"
"\n"
"_con_t := substring (mail_header (_msg, \'content-type\'), 1, 512);\n"
"\n"
"if (_con_t = \'\') _con_t := \'text/plain\';\n"
"\n"
"h_prob := spam_probability (_con_t, _uid);\n"
"aset (res, idx_res + 3, vector (h_prob));\n"
"\n"
"_id := substring (mail_header (_msg, \'message-id\'), 1, 512);\n"
"prob := spam_probability (_id, _uid);\n"
"if (prob = 5e-01) prob := h_prob;\n"
"aset (res, idx_res + 1, vector (prob));\n"
"\n"
"_from := substring (mail_header (_msg, \'from\'), 1, 512);\n"
"prob := spam_probability (_from, _uid);\n"
"if (prob = 5e-01) prob := h_prob;\n"
"aset (res, idx_res + 2, vector (prob));\n"
"\n"
"_x_mailer := substring (mail_header (_msg, \'x-mailer\'), 1, 512);\n"
"prob := spam_probability (_x_mailer, _uid);\n"
"if (prob = 5e-01) prob := h_prob;\n"
"aset (res, idx_res + 4, vector (prob));\n"
"\n"
"aset (res, 0, idx_res + 4);\n"
"\n"
"return res;\n"
"\n"
"}\n"
"--src pop3_svr.sql:1042\n"
;

static const char *proc39 = 
"#line 1114 \"[executable]/pop3_svr.sql\"\n"
"create procedure\n"
"spam_classify_mail_box (in _uid any)\n"
"{\n"
"declare temp_body varchar;\n"
"declare idx, _id integer;\n"
"declare all_mess cursor for select MM_ID, blob_to_string (MM_BODY) from DB.DBA.MAIL_MESSAGE where MM_OWN = _uid;\n"
"\n"
"idx := 0;\n"
"\n"
"open all_mess (prefetch 1);\n"
"whenever not found goto _end;\n"
"while ( 1 )\n"
"{\n"
"fetch all_mess into _id, temp_body;\n"
"if (spam_change_header (temp_body, _uid))\n"
"update DB.DBA.MAIL_MESSAGE set MM_BODY = temp_body where current of all_mess;\n"
"idx := idx + 1;\n"
"}\n"
"\n"
"_end:\n"
"close all_mess;\n"
"\n"
"return idx;\n"
"}\n"
"--src pop3_svr.sql:1112\n"
;

static const char *proc40 = 
"#line 1141 \"[executable]/pop3_svr.sql\"\n"
"create procedure\n"
"filter_classify_message (in _msg_id integer)\n"
"{\n"
"declare temp_body, _uid varchar;\n"
"declare message cursor for select blob_to_string (MM_BODY), MM_OWN\n"
"from DB.DBA.MAIL_MESSAGE where MM_ID= _msg_id;\n"
"\n"
"\n"
"open message (prefetch 1);\n"
"whenever not found goto _end;\n"
"\n"
"fetch message into temp_body, _uid;\n"
"\n"
"if (spam_change_header (temp_body, _uid))\n"
"update DB.DBA.MAIL_MESSAGE set MM_BODY = temp_body where current of message;\n"
"\n"
"commit work;\n"
"\n"
"_end:\n"
"close message;\n"
"\n"
"return 1;\n"
"}\n"
"--src pop3_svr.sql:1139\n"
;

static const char *proc41 = 
"#line 1167 \"[executable]/pop3_svr.sql\"\n"
"create procedure\n"
"spam_change_header (inout _msg any, in _uid any)\n"
"{\n"
"declare _old, _new varchar;\n"
"declare msg_score varchar;\n"
"\n"
"if (isstring (_uid))\n"
"{\n"
"select U_ID into _uid from DB.DBA.SYS_USERS where U_NAME = _uid;\n"
"commit work;\n"
"}\n"
"\n"
"msg_score := spam_filter_message (_msg, _uid);\n"
"\n"
"_old := substring (mail_header (_msg, virt_spam_header ()), 1, 512);\n"
"\n"
"_new := spam_make_new_header (msg_score, 0);\n"
"\n"
"if (_old = \'\')\n"
"{\n"
"_msg := concat (_new, \'\\r\\n\', _msg);\n"
"return 1;\n"
"}\n"
"\n"
"if (msg_score = spam_get_score (_old))\n"
"return 0;\n"
"else\n"
"{\n"
"_old := spam_make_new_header (_old, 1);\n"
"_msg := replace (_msg, _old, _new);\n"
"return 1;\n"
"}\n"
"}\n"
"--src pop3_svr.sql:1165\n"
;

static const char *proc42 = 
"#line 1203 \"[executable]/pop3_svr.sql\"\n"
"create procedure\n"
"spam_remove_old_header (inout _msg any)\n"
"{\n"
"declare _old varchar;\n"
"\n"
"_old := substring (mail_header (_msg, virt_spam_header ()), 1, 512);\n"
"_old := concat (spam_make_new_header (_old, 1), \'\\r\\n\');\n"
"_msg := replace (_msg, _old, \'\');\n"
"}\n"
"--src pop3_svr.sql:1201\n"
;

static const char *proc43 = 
"#line 1215 \"[executable]/pop3_svr.sql\"\n"
"create procedure\n"
"spam_classify_from_score (in _score any)\n"
"{\n"
"_score := atod (spam_get_score (_score)) * 1e+02;\n"
"\n"
"if (_score < 15) return \'ham\';\n"
"if (_score > 75) return \'spam\';\n"
"\n"
"return \'unsure\';\n"
"}\n"
"--src pop3_svr.sql:1213\n"
;

static const char *proc44 = 
"#line 1228 \"[executable]/pop3_svr.sql\"\n"
"create procedure\n"
"spam_make_new_header (in _score any, in _mode integer)\n"
"{\n"
"if (_mode)\n"
"return concat (virt_spam_header (), \':\', \' \', _score);\n"
"else\n"
"return concat (virt_spam_header (), \':\', \' \', spam_classify_from_score (_score), \' (\', _score, \')\');\n"
"}\n"
"--src pop3_svr.sql:1226\n"
;

static const char *proc45 = 
"#line 1239 \"[executable]/pop3_svr.sql\"\n"
"create procedure\n"
"virt_spam_header ()\n"
"{\n"
"return \'X-VirtuosoSPAMFilter\';\n"
"}\n"
"--src pop3_svr.sql:1237\n"
;

static const char *proc46 = 
"#line 1247 \"[executable]/pop3_svr.sql\"\n"
"create procedure\n"
"spam_get_score (in _score any)\n"
"{\n"
"declare pos integer;\n"
"\n"
"pos := strstr (_score, \'(\');\n"
"\n"
"if (pos is not NULL)\n"
"_score := subseq (_score, pos + 1);\n"
"\n"
"_score := replace (_score, \')\', \'\');\n"
"\n"
"return _score;\n"
"}\n"
"--src pop3_svr.sql:1245\n"
;

static const char *proc47 = 
"#line 1264 \"[executable]/pop3_svr.sql\"\n"
"create procedure\n"
"spam_message_from_id (inout _message any, inout _uid any, inout _own any)\n"
"{\n"
"if (isinteger (_message))\n"
"select cast (MM_BODY as varchar) into _message from MAIL_MESSAGE where MM_ID = _message;\n"
"\n"
"if (isstring (_uid))\n"
"{\n"
"_own := _uid;\n"
"select U_ID into _uid from SYS_USERS where U_NAME = _uid;\n"
"}\n"
"else\n"
"select U_NAME into _own from SYS_USERS where U_ID = _uid;\n"
"\n"
"commit work;\n"
"}\n"
"--src pop3_svr.sql:1262\n"
;

/* ftp.sql */

static const char *proc48 = 
"#line 30 \"[executable]/ftp.sql\"\n"
"create procedure WS.WS.FTP_SRV (\n"
"in path any,\n"
"in params any,\n"
"in lines any)\n"
"{\n"
"declare ftp_mode, in_str, ftp_user, ftp_pass, dav_pass, command, argument varchar;\n"
"declare data_addr, cur_dir, full_path, file_name, rnfr_name, client_name varchar;\n"
"declare _mode, rest_position, dav_ui integer;\n"
"declare ses, data_ses, home_dir any;\n"
"\n"
"whenever sqlstate \'*\' goto report_bug;\n"
"\n"
"pop_write (\'220 Virtuoso FTP/DAV server is online\');\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"_mode := 1;\n"
"client_name := \'\';\n"
"rest_position := -1;\n"
"\n"
"while (_mode = 1)\n"
"{\n"
"in_str := ses_read_line ();\n"
"FTP_GET_COMMAND (in_str, command, argument);\n"
"\n"
"if (command = \'USER\')\n"
"{\n"
"ftp_user := argument;\n"
"FTP_WRITE (ftp_user, \'331 Password required for \' || ftp_user || \'.\', in_str);\n"
"_mode := 2;\n"
"}\n"
"else if (command = \'HELP\')\n"
"FTP_HELP ();\n"
"\n"
"else if (command = \'QUIT\')\n"
"return;\n"
"\n"
"else\n"
"FTP_WRITE (\'-\', concat (\'500 \', in_str, \' not understood.\'), in_str);\n"
"}\n"
"\n"
"while (_mode = 2)\n"
"{\n"
"in_str := ses_read_line ();\n"
"FTP_GET_COMMAND (in_str, command, argument);\n"
"if (command <> \'PASS\')\n"
"{\n"
"FTP_WRITE (ftp_user, concat (\'500 \', in_str, \' not understood.\'), in_str);\n"
"}\n"
"else\n"
"{\n"
"ftp_pass := argument;\n"
"_mode := 3;\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"if (exists (select 1 from WS.WS.SYS_DAV_USER where U_NAME = ftp_user))\n"
"{\n"
"select pwd_magic_calc (U_NAME, U_PWD, 1), U_ID into dav_pass, dav_ui\n"
"from WS.WS.SYS_DAV_USER\n"
"where U_NAME = ftp_user and U_ACCOUNT_DISABLED = 0;\n"
"}\n"
"\n"
"commit work;\n"
"if (FTP_ANONYMOUS_CHECK (ftp_user))\n"
"{\n"
"if (strstr (ftp_pass, \'@\') is NULL)\n"
"{\n"
"FTP_WRITE (ftp_user, \'530 Please provide e-mail for password.\', in_str);\n"
"return;\n"
"}\n"
"dav_pass := ftp_pass;\n"
"}\n"
"else\n"
"{\n"
"if (upper (ftp_user) = \'ANONYMOUS\')\n"
"{\n"
"FTP_WRITE (ftp_user, \'530 Login incorrect. Anonymous access is not allowed on this server.\', in_str);\n"
"return;\n"
"}\n"
"}\n"
"\n"
"if (ftp_pass = dav_pass)\n"
"{\n"
"FTP_WRITE (ftp_user, \'230 User \' || ftp_user || \' logged in.\', in_str);\n"
"}\n"
"else\n"
"{\n"
"FTP_WRITE (ftp_user, \'530 Login incorrect.\', in_str);\n"
"return;\n"
"}\n"
"\n"
"home_dir := DAV_HOME_DIR (ftp_user);\n"
"if (home_dir = -19 or home_dir = -18 or home_dir = \'\')\n"
"{\n"
"home_dir := \'/DAV/\';\n"
"}\n"
"if (FTP_ANONYMOUS_CHECK (ftp_user))\n"
"{\n"
"home_dir := virtuoso_ini_item_value (\'HTTPServer\', \'FTPServerAnonymousHome\');\n"
"if (home_dir is NULL)\n"
"{\n"
"home_dir := \'/DAV/\';\n"
"}\n"
"else if (DAV_HIDE_ERROR (DAV_SEARCH_ID (home_dir, \'C\')) is null)\n"
"{\n"
"log_message (\'Can\'\'t change Anonymous home dir to \"\' || home_dir || \'\". Will use /DAV/.\');\n"
"home_dir := \'/DAV/\';\n"
"}\n"
"}\n"
"\n"
"cur_dir := \'/\';\n"
"data_ses := NULL;\n"
"\n"
"while (_mode = 3)\n"
"{\n"
"in_str := ses_read_line ();\n"
"FTP_GET_COMMAND (in_str, command, argument);\n"
"\n"
"file_name := argument;\n"
"full_path := home_dir || cur_dir;\n"
"full_path := replace (full_path, \'//\', \'/\');\n"
"\n"
"FTP_PATH (full_path, file_name);\n"
"commit work;\n"
"\n"
"if (command = \'QUIT\') { FTP_QUIT (in_str, ftp_user); return; }\n"
"else if (command = \'RETR\') FTP_RETR (in_str, data_addr, file_name, argument, data_ses, ftp_user, ftp_pass, rest_position);\n"
"else if (command = \'STOR\') FTP_STOR (in_str, data_addr, full_path, argument, ftp_user, ftp_pass, data_ses, rest_position);\n"
"else if (command = \'PWD\')  FTP_PWD (cur_dir);\n"
"else if ((command = \'CWD\') or (command = \'CDUP\')) FTP_CWD (in_str, command, argument, cur_dir, home_dir, ftp_user, ftp_pass, rnfr_name);\n"
"else if (command = \'MKD\')  FTP_MKD (in_str, argument, full_path, ftp_user, ftp_pass);\n"
"else if (command = \'RMD\')  FTP_RMD (in_str, argument, full_path, ftp_user, ftp_pass);\n"
"else if (command = \'TYPE\') FTP_TYPE (argument, ftp_mode);\n"
"else if (command = \'SIZE\') FTP_SIZE (in_str, ftp_user, ftp_pass, file_name, argument);\n"
"else if ((command = \'PORT\') or (command = \'PORPORT\')) data_addr := FTP_PORT (in_str, ftp_user, argument);\n"
"else if (command = \'DELE\') FTP_DELE (in_str, file_name, ftp_user, ftp_pass);\n"
"else if (command = \'LIST\') FTP_LIST (in_str, data_addr, full_path, ftp_user, ftp_pass, argument, data_ses, 0);\n"
"else if (command = \'NLST\') FTP_LIST (in_str, data_addr, full_path, ftp_user, ftp_pass, argument, data_ses, 1);\n"
"else if (command = \'RNTO\') FTP_RNTO (in_str, ftp_user, ftp_pass, full_path, rnfr_name, argument);\n"
"else if (command = \'SYST\') FTP_SYST ();\n"
"else if (command = \'NOOP\') FTP_NOOP ();\n"
"else if (command = \'PASV\') FTP_PASV (in_str, ftp_user, data_ses);\n"
"else if (command = \'RNFR\') rnfr_name := FTP_RNFR (in_str, ftp_user, argument);\n"
"else if (command = \'CLNT\') FTP_CLNT (in_str, ftp_user, client_name, argument);\n"
"else if (command = \'REST\') FTP_REST (in_str, ftp_user, argument, rest_position);\n"
"else if (command = \'HELP\') FTP_HELP ();\n"
"else if (command = \'SITE\')  FTP_SITE (in_str, argument, full_path, ftp_user, ftp_pass);\n"
"else if (\"RIGHT\" (command, 4) = \'ABOR\') { FTP_ABOR (in_str, ftp_user); return; }\n"
"else FTP_WRITE (ftp_user, \'500 \' || in_str || \' not understood.\', in_str);\n"
"commit work;\n"
"}\n"
"\n"
"report_bug:\n"
"FTP_WRITE (ftp_user, \'500 Internal error in \' || in_str || \': \' || __SQL_STATE || \': \' || replace (__SQL_MESSAGE, \'\\n\', \'\\n500 \') , in_str);\n"
"\n"
"}\n"
"--src ftp.sql:28\n"
;

static const char *proc49 = 
"#line 195 \"[executable]/ftp.sql\"\n"
"create procedure FTP_QUIT (\n"
"in in_srt varchar,\n"
"in usr varchar)\n"
"{\n"
"FTP_WRITE (usr, \'211 Virtuoso FTP server signing off.\', in_srt);\n"
"}\n"
"--src ftp.sql:193\n"
;

static const char *proc50 = 
"#line 203 \"[executable]/ftp.sql\"\n"
"create procedure FTP_ABOR (\n"
"in in_srt varchar,\n"
"in usr varchar)\n"
"{\n"
"FTP_WRITE (usr, \'226 ABOR command was successfully processed.\', in_srt);\n"
"}\n"
"--src ftp.sql:201\n"
;

static const char *proc51 = 
"#line 211 \"[executable]/ftp.sql\"\n"
"create procedure FTP_GET_COMMAND (\n"
"in _in varchar,\n"
"inout command varchar,\n"
"inout argument varchar)\n"
"{\n"
"declare len integer;\n"
"\n"
"command := upper (pop_get_command (_in));\n"
"len := length (command) + 1;\n"
"\n"
"if (len <= length (_in))\n"
"argument := subseq (_in, length (command) + 1);\n"
"else\n"
"argument := \'\';\n"
"}\n"
"--src ftp.sql:209\n"
;

static const char *proc52 = 
"#line 228 \"[executable]/ftp.sql\"\n"
"create procedure FTP_ANONYMOUS_CHECK (\n"
"in _user varchar)\n"
"{\n"
"if (upper (_user) = \'ANONYMOUS\' and virtuoso_ini_item_value (\'HTTPServer\', \'FTPServerAnonymousLogin\') = \'1\')\n"
"return 1;\n"
"\n"
"return 0;\n"
"}\n"
"--src ftp.sql:226\n"
;

static const char *proc53 = 
"#line 238 \"[executable]/ftp.sql\"\n"
"create procedure FTP_AUTHENTICATE (\n"
"in id any,\n"
"in what char(1),\n"
"in req varchar,\n"
"in a_uname varchar,\n"
"in a_pwd varchar,\n"
"in a_uid integer := null) returns integer\n"
"{\n"
"\n"
"if (a_uid is null)\n"
"{\n"
"if (upper (a_uname) = \'ANONYMOUS\')\n"
"{\n"
"if (virtuoso_ini_item_value (\'HTTPServer\', \'FTPServerAnonymousLogin\') = \'1\')\n"
"return DAV_AUTHENTICATE (id, what, req, \'anonymous\', a_pwd, 1);\n"
"\n"
"return -12;\n"
"}\n"
"}\n"
"return DAV_AUTHENTICATE (id, what, req, a_uname, a_pwd, a_uid);\n"
"}\n"
"--src ftp.sql:236\n"
;

static const char *proc54 = 
"#line 261 \"[executable]/ftp.sql\"\n"
"create procedure FTP_PWD (\n"
"in home varchar)\n"
"{\n"
"pop_write (\'257 \"\' || home || \'\" is current directory.\');\n"
"}\n"
"--src ftp.sql:259\n"
;

static const char *proc55 = 
"#line 268 \"[executable]/ftp.sql\"\n"
"create procedure FTP_NOOP ()\n"
"{\n"
"pop_write (\'200 OK\');\n"
"}\n"
"--src ftp.sql:266\n"
;

static const char *proc56 = 
"#line 274 \"[executable]/ftp.sql\"\n"
"create procedure FTP_PASV (\n"
"in in_str varchar,\n"
"in usr varchar,\n"
"inout listen any)\n"
"{\n"
"declare _port integer;\n"
"\n"
"_port := FTP_SES_LISTEN (listen);\n"
"\n"
"FTP_WRITE (usr, FTP_MAKE_PORT_COMMAND (_port, 0), in_str);\n"
"}\n"
"--src ftp.sql:272\n"
;

static const char *proc57 = 
"#line 287 \"[executable]/ftp.sql\"\n"
"create procedure FTP_RNTO (\n"
"in in_str varchar,\n"
"in _user varchar,\n"
"in _pass varchar,\n"
"in cur_dir varchar,\n"
"in old_name varchar,\n"
"in new_name varchar)\n"
"{\n"
"declare _uid integer;\n"
"declare st char (1);\n"
"declare old_id, new_id any;\n"
"declare res integer;\n"
"\n"
"_uid := null;\n"
"\n"
"if (new_name = \'\')\n"
"{\n"
"FTP_WRITE (_user, \'550 The new name is empty.\', in_str);\n"
"return;\n"
"}\n"
"\n"
"if (old_name <> \'\')\n"
"{\n"
"if (not FTP_DAV_PATH_FIX (old_name))\n"
"{\n"
"old_name := cur_dir || old_name;\n"
"}\n"
"}\n"
"if (not FTP_DAV_PATH_FIX (new_name))\n"
"{\n"
"new_name := cur_dir || new_name;\n"
"}\n"
"old_id := DAV_SEARCH_SOME_ID (old_name, st);\n"
"if (DAV_HIDE_ERROR (old_id) is null and (\"RIGHT\" (old_name, 1) <> \'/\'))\n"
"{\n"
"old_id := DAV_SEARCH_SOME_ID (old_name || \'/\', st);\n"
"if (DAV_HIDE_ERROR (old_id) is not null)\n"
"{\n"
"old_name := old_name || \'/\';\n"
"}\n"
"else\n"
"{\n"
"FTP_WRITE (_user, \'550 The path (\' || old_name || \') is not valid\', in_str);\n"
"return;\n"
"}\n"
"}\n"
"\n"
"if (\'C\' = st)\n"
"{\n"
"if (\"RIGHT\" (old_name, 1) <> \'/\')\n"
"old_name := old_name || \'/\';\n"
"\n"
"if (\"RIGHT\" (new_name, 1) <> \'/\')\n"
"new_name := new_name || \'/\';\n"
"}\n"
"\n"
"if (DAV_HIDE_ERROR (DAV_AUTHENTICATE (old_id, st, \'1__\', _user, _pass, _uid)) is null)\n"
"{\n"
"FTP_WRITE (_user, \'550 Operation is forbidden.\', in_str);\n"
"return;\n"
"}\n"
"res := DAV_MOVE_INT (old_name, new_name, 1, _user, _pass, 0, 1);\n"
"\n"
"if (DAV_HIDE_ERROR (res) is not null)\n"
"FTP_WRITE (_user, \'250 OK\', in_str);\n"
"else\n"
"FTP_WRITE (_user, \'550 RNTO command failed.\', in_str);\n"
"}\n"
"--src ftp.sql:285\n"
;

static const char *proc58 = 
"#line 357 \"[executable]/ftp.sql\"\n"
"create procedure FTP_REST (\n"
"in in_str varchar,\n"
"in usr varchar,\n"
"in arg varchar,\n"
"inout pos integer)\n"
"{\n"
"pos := atoi (arg);\n"
"FTP_WRITE (usr, \'350 Restart position accepted (\' || arg || \').\', in_str);\n"
"}\n"
"--src ftp.sql:355\n"
;

static const char *proc59 = 
"#line 368 \"[executable]/ftp.sql\"\n"
"create procedure FTP_CLNT (\n"
"in in_str varchar,\n"
"in usr varchar,\n"
"inout c_name varchar,\n"
"in arg varchar)\n"
"{\n"
"c_name := arg;\n"
"FTP_WRITE (usr, \'250 OK\', in_str);\n"
"}\n"
"--src ftp.sql:366\n"
;

static const char *proc60 = 
"#line 379 \"[executable]/ftp.sql\"\n"
"create procedure FTP_RNFR (\n"
"in in_str varchar,\n"
"in usr varchar,\n"
"in new_name varchar)\n"
"{\n"
"FTP_WRITE (usr, \'350 OK\', in_str);\n"
"return new_name;\n"
"}\n"
"--src ftp.sql:377\n"
;

static const char *proc61 = 
"#line 389 \"[executable]/ftp.sql\"\n"
"create procedure FTP_SYST ()\n"
"{\n"
"pop_write (\'215 UNIX \' || sys_stat(\'st_build_opsys_id\') || \' Ver. \' || sys_stat(\'st_dbms_ver\'));\n"
"}\n"
"--src ftp.sql:387\n"
;

static const char *proc62 = 
"#line 395 \"[executable]/ftp.sql\"\n"
"create procedure FTP_MKD (\n"
"in in_str varchar,\n"
"in _new varchar,\n"
"in _home varchar,\n"
"in _user varchar,\n"
"in _pass varchar)\n"
"{\n"
"declare res integer;\n"
"\n"
"FTP_NOR_DIR (_home, _new);\n"
"\n"
"if (FTP_ANONYMOUS_CHECK (_user))\n"
"res := DAV_COL_CREATE (_new, auth_uid=>_user, auth_pwd=>_pass, uid=>_user, permissions=>\'110110110N\');\n"
"else\n"
"res := DAV_COL_CREATE (_new, auth_uid=>_user, auth_pwd=>_pass, uid=>_user, permissions=>\'110100000N\');\n"
"\n"
"if (DAV_HIDE_ERROR (res) is not null)\n"
"FTP_WRITE (_user, \'257 MKD command successful.\', in_str);\n"
"else\n"
"FTP_WRITE (_user, \'550 MKD command failed.\', in_str);\n"
"}\n"
"--src ftp.sql:393\n"
;

static const char *proc63 = 
"#line 418 \"[executable]/ftp.sql\"\n"
"create procedure FTP_RMD (\n"
"in in_str varchar,\n"
"in _new varchar,\n"
"in _home varchar,\n"
"in _user varchar,\n"
"in _pass varchar)\n"
"{\n"
"declare res integer;\n"
"\n"
"FTP_NOR_DIR (_home, _new);\n"
"\n"
"res := DAV_DELETE (_new, 1, _user, _pass);\n"
"if (DAV_HIDE_ERROR (res) is not null)\n"
"FTP_WRITE (_user, \'250 RMD command successful.\', in_str);\n"
"else\n"
"FTP_WRITE (_user, \'550 RMD command failed.\', in_str);\n"
"}\n"
"--src ftp.sql:416\n"
;

static const char *proc64 = 
"#line 437 \"[executable]/ftp.sql\"\n"
"create procedure FTP_DELE (\n"
"in in_str varchar,\n"
"in f_name varchar,\n"
"in _user varchar,\n"
"in _pass varchar)\n"
"{\n"
"declare res integer;\n"
"\n"
"if (f_name is NULL)\n"
"{\n"
"FTP_WRITE (_user, \'550 \' || f_name || \' not found\', in_str);\n"
"return;\n"
"}\n"
"\n"
"res := DAV_DELETE (f_name, 1, _user, _pass);\n"
"if (DAV_HIDE_ERROR (res) is not null)\n"
"FTP_WRITE (_user, \'250 RMD command successful.\', in_str);\n"
"else\n"
"FTP_WRITE (_user, \'550 RMD command failed.\', in_str);\n"
"}\n"
"--src ftp.sql:435\n"
;

static const char *proc65 = 
"#line 459 \"[executable]/ftp.sql\"\n"
"create procedure FTP_CWD (\n"
"in in_str varchar,\n"
"in command varchar,\n"
"in arg varchar,\n"
"inout _old varchar,\n"
"in _home varchar,\n"
"in _user varchar,\n"
"in _pass varchar,\n"
"inout rn_name varchar)\n"
"{\n"
"declare rid integer;\n"
"declare _new, safe_path, perm varchar;\n"
"declare _id, _list any;\n"
"declare _davname varchar;\n"
"_new := arg;\n"
"\n"
"if (\'CDUP\' = command)\n"
"_new := \'..\';\n"
"\n"
"safe_path := _old;\n"
"rn_name := \'\';\n"
"\n"
"if (\"RIGHT\" (_new, 1) <> \'/\')\n"
"_new := _new || \'/\';\n"
"\n"
"if (\"LEFT\" (_new, 2) = \'..\')\n"
"_old := WS.WS.EXPAND_URL (_old, _new);\n"
"\n"
"else if (\"LEFT\" (_new, 1) = \'/\')\n"
"_old := _new;\n"
"\n"
"else\n"
"_old := _old || _new;\n"
"\n"
"if (_new = \'\' or _new = \'/\')\n"
"_old := \'/\';\n"
"\n"
"_old := replace (_old, \'//\', \'/\');\n"
"_new := replace (_new, \'//\', \'/\');\n"
"_davname := replace (_home || _old, \'//\', \'/\');\n"
"_id := DAV_SEARCH_ID (_davname, \'C\');\n"
"if (DAV_HIDE_ERROR (_id) is null)\n"
"rid := _id;\n"
"else\n"
"rid := FTP_AUTHENTICATE (_id, \'C\', \'1__\', _user, _pass);\n"
"\n"
"\n"
"if (DAV_HIDE_ERROR (rid) is null and not (_new = \'/\' and FTP_ANONYMOUS_CHECK (_user)))\n"
"{\n"
"FTP_WRITE (_user, \'550 The path \"\' || arg || \'\" (absolute path \"\' || _old || \'\") is not valid: \' || DAV_PERROR (rid), in_str);\n"
"_old := safe_path;\n"
"return;\n"
"}\n"
"FTP_WRITE (_user, \'250 \' || command || \' command successful.\', in_str);\n"
"}\n"
"--src ftp.sql:457\n"
;

static const char *proc66 = 
"#line 516 \"[executable]/ftp.sql\"\n"
"create procedure FTP_TYPE (\n"
"in mode varchar,\n"
"inout new_mode varchar)\n"
"{\n"
"new_mode := mode;\n"
"pop_write (\'200 Type set to \' || mode);\n"
"}\n"
"--src ftp.sql:514\n"
;

static const char *proc67 = 
"#line 525 \"[executable]/ftp.sql\"\n"
"create procedure FTP_PORT (\n"
"in in_str varchar,\n"
"in ftp_user varchar,\n"
"in addr varchar)\n"
"{\n"
"addr := PARSE_ADR (addr, 0);\n"
"FTP_WRITE (ftp_user, \'200 PORT command successful\', in_str);\n"
"return addr;\n"
"}\n"
"--src ftp.sql:523\n"
;

static const char *proc68 = 
"#line 536 \"[executable]/ftp.sql\"\n"
"create procedure FTP_LIST (\n"
"in in_str varchar,\n"
"in d_addr varchar,\n"
"in cur_dir varchar,\n"
"in _user varchar,\n"
"in _pass varchar,\n"
"in _args varchar,\n"
"inout data_ses any,\n"
"in is_nlist integer)\n"
"{\n"
"declare ses, _list, _line any;\n"
"declare f_perm, _mode, _mask, my_dir, dir_part varchar;\n"
"declare idx, len, lsize integer;\n"
"\n"
"FTP_GET_DIR_PART (_args, dir_part, _args);\n"
"\n"
"my_dir := WS.WS.EXPAND_URL (cur_dir, dir_part);\n"
"\n"
"set isolation=\'uncommitted\';\n"
"\n"
"FTP_MODE_MASK (_args, _mode, _mask);\n"
"\n"
"if (strstr (_mode, \'R\') is NULL)\n"
"_list := DAV_DIR_LIST (my_dir, 0, _user, _pass);\n"
"else\n"
"_list := DAV_DIR_LIST (my_dir, 1, _user, _pass);\n"
"\n"
"if (isinteger (_list))\n"
"{\n"
"FTP_WRITE (_user, \'550 Operation is forbidden (\' || DAV_PERROR (_list) || \').\' , in_str);\n"
"return;\n"
"}\n"
"\n"
"pop_write (\'150 Opening ASCII mode data connection for file list\');\n"
"\n"
"if (data_ses is NULL)\n"
"ses := ses_connect (d_addr);\n"
"else\n"
"FTP_SES_ACCEPT (data_ses, ses);\n"
"\n"
"len := length (_list);\n"
"idx := 0;\n"
"lsize := 0;\n"
"\n"
"while (idx < len)\n"
"{\n"
"declare t_name, t_line, t_time, t_len, t_h, t_m varchar;\n"
"\n"
"_line := _list[idx];\n"
"if (length (_line[0]) < length (my_dir))\n"
"{\n"
"t_name := _line[10];\n"
"}\n"
"else\n"
"{\n"
"t_name := subseq (_line[0], length (my_dir));\n"
"if (\"RIGHT\" (t_name, 1) = \'/\')\n"
"t_name := \"LEFT\" (t_name, length (t_name) - 1);\n"
"}\n"
"\n"
"if (t_name not like _mask and _mask <> \'\')\n"
"goto next;\n"
"\n"
"if (is_nlist)\n"
"{\n"
"ses_write (t_name || \'\\r\\n\', ses);\n"
"goto next;\n"
"}\n"
"\n"
"t_time := cast (dayofmonth (_line[3]) as varchar);\n"
"if (length (t_time) = 1)\n"
"t_time :=  \' \' || t_time;\n"
"\n"
"t_time := \"LEFT\" (monthname (_line[3]), 3) || \' \' || t_time || \' \';\n"
"\n"
"if (year (now()) = year (_line[3]))\n"
"{\n"
"t_h := cast (hour (_line[3]) as varchar);\n"
"t_h := repeat (\'0\', 2 - length (t_h)) || t_h;\n"
"t_m := cast (minute (_line[3]) as varchar);\n"
"t_m := repeat (\'0\', 2 - length (t_m)) || t_m;\n"
"t_time := t_time || t_h || \':\' || t_m;\n"
"}\n"
"else\n"
"{\n"
"t_time := t_time || \' \' || cast (year (_line[3]) as varchar);\n"
"}\n"
"f_perm := FTP_FILE_PERM (_line[5], _line[9]);\n"
"t_len := cast (_line[2] as varchar);\n"
"\n"
"t_len := repeat (\' \', 10 - length (t_len)) || t_len;\n"
"t_line :=  f_perm || \' 1 \' || _user || \' \' || _user || \'\\t\' || t_len || \' \' || t_time || \' \' || t_name || \'\\r\\n\';\n"
"\n"
"ses_write (t_line, ses);\n"
"lsize := lsize + length (t_line);\n"
"next:;\n"
"idx := idx + 1;\n"
"}\n"
"\n"
"ses_disconnect (ses);\n"
"FTP_WRITE (_user, \'226 Transfer complete.\', in_str, len=>lsize);\n"
"}\n"
"--src ftp.sql:534\n"
;

static const char *proc69 = 
"#line 640 \"[executable]/ftp.sql\"\n"
"create procedure FTP_HELP ()\n"
"{\n"
"pop_write (\'214-The following commands are recognized (* =>\'\'s unimplemented).\');\n"
"pop_write (\'USER    PASS    CWD     CDUP    HELP\');\n"
"pop_write (\'QUIT    PORT    PASV    TYPE    NOOP\');\n"
"pop_write (\'STOR    MODE    RETR    SIZE    LIST\');\n"
"pop_write (\'DELE    RMD     MKD     PWD     SYST\');\n"
"pop_write (\'SIZE    LIST    NLST    ABOR    REST\');\n"
"pop_write (\'APPE*\');\n"
"pop_write (\'214 \');\n"
"}\n"
"--src ftp.sql:638\n"
;

static const char *proc70 = 
"#line 653 \"[executable]/ftp.sql\"\n"
"create procedure FTP_FILE_PERM (\n"
"in perm varchar,\n"
"in _type varchar)\n"
"{\n"
"declare perms, allset varchar;\n"
"declare isdir, _ix integer;\n"
"\n"
"\n"
"_ix := 0;\n"
"if (_type = \'dav/unix-directory\')\n"
"{\n"
"isdir := 1;\n"
"\n"
"perms := \'d\\055\\055\\055\\055\\055\\055\\055\\055\\055\';\n"
"}\n"
"else\n"
"{\n"
"isdir := 0;\n"
"\n"
"perms := \'-\\055\\055\\055\\055\\055\\055\\055\\055\\055\';\n"
"}\n"
"allset := \'rwxrwxrwx\';\n"
"while (_ix < 9)\n"
"{\n"
"if (aref (perm, _ix) = 49)\n"
"{\n"
"perms [_ix + 1] := allset [_ix];\n"
"if (isdir and (_ix = 0 or _ix = 3 or _ix = 6))\n"
"perms [_ix + 3] := allset [_ix + 2];\n"
"}\n"
"_ix := _ix + 1;\n"
"}\n"
"return perms;\n"
"}\n"
"--src ftp.sql:651\n"
;

static const char *proc71 = 
"#line 689 \"[executable]/ftp.sql\"\n"
"create procedure FTP_RETR (\n"
"in in_str varchar,\n"
"in d_addr varchar,\n"
"in f_name varchar,\n"
"in wanted_faile varchar,\n"
"inout listen any,\n"
"in auth_uid varchar,\n"
"in auth_pwd varchar,\n"
"inout r_pos integer)\n"
"{\n"
"dbg_obj_princ (\'FTP_RETR (\', in_str, d_addr, f_name, wanted_faile, listen, auth_uid, auth_pwd, r_pos, \')\');\n"
"declare full_cont, sub_cont, data_ses any;\n"
"declare id any;\n"
"declare scrc, rc, uid, int_res, len, writen_size integer;\n"
"declare cont_type varchar;\n"
"\n"
"int_res := r_pos;\n"
"r_pos := -1;\n"
"writen_size := 0;\n"
"\n"
"uid := null;\n"
"\n"
"set isolation=\'uncommitted\';\n"
"\n"
"if (f_name is NULL)\n"
"{\n"
"FTP_WRITE (auth_uid, \'550 \' || wanted_faile || \' not found.\', in_str);\n"
"return;\n"
"}\n"
"\n"
"id := DAV_SEARCH_ID (f_name, \'R\');\n"
"if (DAV_HIDE_ERROR (id) is null)\n"
"{\n"
"FTP_WRITE (auth_uid, \'550 Operation is forbidden.\', in_str);\n"
"return;\n"
"}\n"
"\n"
"if (DAV_HIDE_ERROR (FTP_AUTHENTICATE (id, \'R\', \'1__\', auth_uid, auth_pwd)) is null)\n"
"{\n"
"FTP_WRITE (auth_uid, \'550 Operation is forbidden.\', in_str);\n"
"return;\n"
"}\n"
"\n"
"commit work;\n"
"\n"
"if (isinteger (id))\n"
"len := coalesce ((select length (RES_CONTENT) from WS.WS.SYS_DAV_RES where RES_FULL_PATH = f_name));\n"
"else\n"
"len := null;\n"
"\n"
"if (listen is NULL)\n"
"data_ses := ses_connect (d_addr);\n"
"else\n"
"FTP_SES_ACCEPT (listen, data_ses);\n"
"\n"
"scrc := ses_can_read_char ();\n"
"if (scrc > 2)\n"
"{\n"
"\n"
"ses_disconnect (data_ses);\n"
"return;\n"
"}\n"
"\n"
"if (int_res = -1)\n"
"int_res := 0;\n"
"\n"
"if ((len is not null) and (int_res = -1))\n"
"pop_write (\'150 Opening data connection for \' || subseq (f_name, 5) || \' (\' || cast (len as varchar) || \' bytes).\');\n"
"\n"
"commit work;\n"
"\n"
"declare exit handler for sqlstate \'*\' {\n"
"FTP_WRITE (auth_uid, \'500 Internal error in \' || in_str || \': \' || __SQL_STATE || \': \' || replace (__SQL_MESSAGE, \'\\n\', \'\\n500 \'), in_str);\n"
"\n"
"FTP_WRITE (auth_uid, \'426 Connection closed; transfer aborted.\', in_str, len=>writen_size);\n"
"ses_disconnect (data_ses);\n"
"return;\n"
"};\n"
"\n"
"if (int_res = -1)\n"
"{\n"
"if (len is null)\n"
"pop_write (\'150 Opening data connection for \' || subseq (f_name, 5) || \' .\');\n"
"\n"
"rc := DAV_RES_CONTENT_INT (id, data_ses, cont_type, 1, 0, auth_uid, auth_pwd);\n"
"if (DAV_HIDE_ERROR (rc) is null)\n"
"{\n"
"FTP_WRITE (auth_uid, \'426 Connection closed; transfer aborted (reason: \' || DAV_PERROR (rc) || \').\', in_str, len=>writen_size);\n"
"ses_disconnect (data_ses);\n"
"return;\n"
"}\n"
"}\n"
"else\n"
"{\n"
"declare buf_size integer;\n"
"\n"
"buf_size := 8172*128;\n"
"full_cont := string_output ();\n"
"rc := DAV_RES_CONTENT_INT (id, full_cont, cont_type, 1, 0, auth_uid, auth_pwd);\n"
"if (DAV_HIDE_ERROR (rc) is null)\n"
"{\n"
"FTP_WRITE (auth_uid, \'426 Connection closed; transfer aborted (reason: \' || DAV_PERROR (rc) || \').\', in_str, len=>writen_size);\n"
"ses_disconnect (data_ses);\n"
"return;\n"
"}\n"
"commit work;\n"
"pop_write (\'150 Opening data connection for \' || subseq (f_name, 5) || \' (\' || cast ((len-either(int_res+1, 0, int_res)) as varchar) || \' bytes).\');\n"
"len := length (full_cont) - int_res;\n"
"\n"
"\n"
"while (len > 0)\n"
"{\n"
"sub_cont := subseq (full_cont, int_res, int_res + buf_size);\n"
"\n"
"\n"
"\n"
"ses_write (cast (sub_cont as varchar), data_ses);\n"
"int_res := int_res + buf_size;\n"
"len := len - buf_size;\n"
"writen_size := writen_size + length (sub_cont);\n"
"scrc := ses_can_read_char ();\n"
"if (scrc > 2)\n"
"{\n"
"\n"
"return;\n"
"}\n"
"}\n"
"}\n"
"http_output_flush (data_ses);\n"
"whenever sqlstate \'*\' default;\n"
"FTP_WRITE (auth_uid, \'226 Transfer complete.\', in_str, len=>writen_size);\n"
"ses_disconnect (data_ses);\n"
"}\n"
"--src ftp.sql:687\n"
;

static const char *proc72 = 
"#line 824 \"[executable]/ftp.sql\"\n"
"create procedure FTP_SIZE (\n"
"in in_str varchar,\n"
"in ftp_user varchar,\n"
"in ftp_pass varchar,\n"
"in f_name varchar,\n"
"in wanted_faile varchar)\n"
"{\n"
"declare _len integer;\n"
"declare dir any;\n"
"\n"
"if (f_name is NULL)\n"
"{\n"
"FTP_WRITE (ftp_user, \'550 \' || wanted_faile || \' not found\', in_str);\n"
"return;\n"
"}\n"
"dir := DAV_DIR_LIST (f_name, 0, ftp_user, ftp_pass);\n"
"if (isarray (dir))\n"
"{\n"
"if (1 = length (dir))\n"
"{\n"
"FTP_WRITE (ftp_user, \'213 \' || cast (dir[0][2] as varchar), in_str);\n"
"return;\n"
"}\n"
"}\n"
"FTP_WRITE (ftp_user, \'550 \' || wanted_faile || \' size not retrieved: \' || DAV_PERROR (dir), in_str);\n"
"}\n"
"--src ftp.sql:822\n"
;

static const char *proc73 = 
"#line 852 \"[executable]/ftp.sql\"\n"
"create function FTP_SITE_CHMOD_U2D (\n"
"in unix_chmod varchar,\n"
"in old_perms varchar)\n"
"{\n"
"\n"
"\n"
"if (regexp_like (unix_chmod, \'0?[0-7][0-7][0-7]\'))\n"
"{\n"
"declare v any;\n"
"declare i integer;\n"
"declare res varchar;\n"
"\n"
"v := vector (\'000\', \'001\', \'010\', \'011\', \'100\', \'101\', \'110\', \'111\');\n"
"i := cast (unix_chmod as integer);\n"
"res := subseq (old_perms, 9);\n"
"res := v [mod (i, 10)] || res; i := i / 10;\n"
"res := v [mod (i, 10)] || res; i := i / 10;\n"
"res := v [mod (i, 10)] || res; i := i / 10;\n"
"\n"
"return res;\n"
"}\n"
"return NULL;\n"
"}\n"
"--src ftp.sql:850\n"
;

static const char *proc74 = 
"#line 877 \"[executable]/ftp.sql\"\n"
"create procedure FTP_SITE (\n"
"in in_str varchar,\n"
"in argument varchar,\n"
"in full_path varchar,\n"
"in _user varchar,\n"
"in _pass varchar)\n"
"{\n"
"declare spac integer;\n"
"declare sub, tail, arg1, arg2 varchar;\n"
"argument := trim (replace (argument, \'\\t\', \' \'));\n"
"spac := strchr (argument, \' \');\n"
"if (spac is null)\n"
"goto oblom;\n"
"sub := upper (subseq (argument, 0, spac));\n"
"tail := trim (subseq (argument, spac));\n"
"if (\'CHMOD\' = sub)\n"
"{\n"
"declare old_perms, new_perms any;\n"
"declare file_name varchar;\n"
"declare res integer;\n"
"\n"
"spac := strchr (tail, \' \');\n"
"if (spac is null)\n"
"goto oblom;\n"
"\n"
"arg1 := subseq (tail, 0, spac);\n"
"tail := trim (subseq (tail, spac));\n"
"file_name := tail;\n"
"\n"
"\n"
"FTP_PATH (full_path, file_name);\n"
"\n"
"old_perms := DAV_PROP_GET (file_name, \':virtpermissions\', _user, _pass);\n"
"if (DAV_HIDE_ERROR (old_perms) is null)\n"
"{\n"
"FTP_WRITE (_user, \'550 SITE CHMOD has failed on \"\' || tail || \'\": \' || DAV_PERROR (old_perms), in_str);\n"
"return;\n"
"}\n"
"new_perms := FTP_SITE_CHMOD_U2D (arg1, old_perms);\n"
"if (new_perms is null)\n"
"{\n"
"FTP_WRITE (_user, \'550 SITE CHMOD permission string \"\' || arg1 || \'\" not recognized\', in_str);\n"
"return;\n"
"}\n"
"res := DAV_PROP_SET (file_name, \':virtpermissions\', new_perms, _user, _pass);\n"
"if (DAV_HIDE_ERROR (old_perms) is null)\n"
"{\n"
"FTP_WRITE (_user, \'SITE CHMOD has failed on \"\' || tail || \'\": \' || DAV_PERROR (old_perms), in_str);\n"
"return;\n"
"}\n"
"goto ok;\n"
"}\n"
"goto oblom;\n"
"\n"
"ok:\n"
"FTP_WRITE (_user, \'200 SITE command complete, effective path is \"\' || full_path || \'\"\', in_str);\n"
"return;\n"
"\n"
"oblom:\n"
"FTP_WRITE (_user, \'500 SITE command does not support this form of request: \"\' || argument || \'\"\', in_str);\n"
"}\n"
"--src ftp.sql:875\n"
;

static const char *proc75 = 
"#line 940 \"[executable]/ftp.sql\"\n"
"create procedure FTP_STOR (\n"
"in in_str varchar,\n"
"in d_addr varchar,\n"
"in cur_dir varchar,\n"
"in f_name varchar,\n"
"in _user varchar,\n"
"in _pass varchar,\n"
"inout listen any,\n"
"inout rest_pos integer)\n"
"{\n"
"declare _cont, data_ses any;\n"
"declare permissions varchar;\n"
"declare _upd_res integer;\n"
"\n"
"if (rest_pos <> -1)\n"
"{\n"
"FTP_RES_UPLOAD_FROM_POSITION (in_str, d_addr, cur_dir, f_name, _user, _pass, listen, rest_pos);\n"
"rest_pos := -1;\n"
"return;\n"
"}\n"
"\n"
"if (not FTP_DAV_PATH_FIX (f_name))\n"
"{\n"
"f_name := cur_dir || f_name;\n"
"}\n"
"f_name := replace (f_name, \'//\', \'/\');\n"
"\n"
"if (FTP_ANONYMOUS_CHECK (_user))\n"
"permissions := \'110100110R\';\n"
"else\n"
"permissions := \'110100000R\';\n"
"\n"
"_cont := \'temp\';\n"
"_upd_res := DAV_RES_UPLOAD_STRSES (f_name, _cont, auth_uid=>_user, auth_pwd=>_pass, uid=>_user, permissions=>permissions);\n"
"if (_upd_res = -13)\n"
"{\n"
"FTP_WRITE (_user, \'550 Operation is forbidden.\', in_str);\n"
"return;\n"
"}\n"
"\n"
"if (_upd_res = -8 or _upd_res = -9)\n"
"{\n"
"FTP_WRITE (_user, \'550 Target is locked.\', in_str);\n"
"return;\n"
"}\n"
"\n"
"if (_upd_res = -1)\n"
"{\n"
"FTP_WRITE (_user, \'550 The path (\' || f_name || \') is not valid.\', in_str);\n"
"return;\n"
"}\n"
"\n"
"_cont := string_output (http_strses_memory_size ());\n"
"\n"
"data_ses := NULL;\n"
"\n"
"pop_write (\'150 Opening...\');\n"
"\n"
"if (listen is not NULL)\n"
"FTP_SES_ACCEPT (listen, data_ses);\n"
"else\n"
"data_ses := ses_connect (d_addr);\n"
"\n"
"_cont := __blob_handle_from_session (data_ses);\n"
"\n"
"\n"
"_upd_res := DAV_RES_UPLOAD_STRSES (f_name, _cont, auth_uid=>_user, auth_pwd=>_pass, uid=>_user, permissions=>permissions);\n"
"commit work;\n"
"\n"
"if (DAV_HIDE_ERROR (_upd_res) is not null)\n"
"FTP_WRITE (_user, \'226 Transfer complete.\', in_str, len=>length (_cont));\n"
"else\n"
"FTP_WRITE (_user, \'550 Internal server error:\' || DAV_PERROR (_upd_res), in_str);\n"
"}\n"
"--src ftp.sql:938\n"
;

static const char *proc76 = 
"#line 1016 \"[executable]/ftp.sql\"\n"
"create procedure FTP_PATH (\n"
"in dir varchar,\n"
"inout f_name varchar)\n"
"{\n"
"declare safe_name varchar;\n"
"\n"
"if (not FTP_DAV_PATH_FIX (f_name))\n"
"{\n"
"safe_name := f_name;\n"
"f_name := WS.WS.EXPAND_URL (dir, f_name);\n"
"if (safe_name = f_name and DAV_HIDE_ERROR (DAV_SEARCH_ID (f_name, \'R\')) is null)\n"
"f_name := replace (dir || f_name, \'//\', \'/\');\n"
"}\n"
"\n"
"if (DAV_HIDE_ERROR (f_name, \'R\') is not null)\n"
"return 1;\n"
"\n"
"f_name := NULL;\n"
"return 0;\n"
"}\n"
"--src ftp.sql:1014\n"
;

static const char *proc77 = 
"#line 1038 \"[executable]/ftp.sql\"\n"
"create procedure FTP_MODE_MASK (\n"
"in _all varchar,\n"
"inout _mode varchar,\n"
"inout _mask varchar)\n"
"{\n"
"declare pos integer;\n"
"\n"
"_mode := \'\';\n"
"_mask := \'\';\n"
"_all := trim (_all);\n"
"if (_all = \'\')\n"
"return;\n"
"\n"
"_all := split_and_decode (_all, 0, \'\\0\\0/\');\n"
"if (_all is NULL)\n"
"return;\n"
"\n"
"_all := _all[length (_all) - 1];\n"
"if (\"LEFT\" (_all, 1) <> \'-\')\n"
"{\n"
"_mask := _all;\n"
"}\n"
"else\n"
"{\n"
"pos := strstr (_all, \' \');\n"
"if (pos is NULL)\n"
"{\n"
"_mode := _all;\n"
"}\n"
"else\n"
"{\n"
"_mode := \"LEFT\" (_all, pos);\n"
"_mask := subseq (_all, pos + 1);\n"
"}\n"
"}\n"
"_mask := replace (_mask, \'*\', \'%\');\n"
"}\n"
"--src ftp.sql:1036\n"
;

static const char *proc78 = 
"#line 1077 \"[executable]/ftp.sql\"\n"
"create procedure FTP_GET_DIR_PART (\n"
"in _all varchar,\n"
"inout _dir varchar,\n"
"inout _arg varchar)\n"
"{\n"
"declare temp any;\n"
"\n"
"_dir := \'\';\n"
"_all := trim (_all);\n"
"\n"
"if (_all = \'\')\n"
"return;\n"
"\n"
"if (_all = \'..\')\n"
"_all := \'../\';\n"
"\n"
"if (_all = \'/\')\n"
"_all := \'../\';\n"
"\n"
"temp := split_and_decode (_all, 0, \'\\0\\0/\');\n"
"if (temp is NULL)\n"
"return;\n"
"\n"
"temp := temp[length (temp) - 1];\n"
"\n"
"_dir := \"LEFT\" (_all, length (_all) - length (temp));\n"
"_arg := \"RIGHT\" (_all, length (temp));\n"
"}\n"
"--src ftp.sql:1075\n"
;

static const char *proc79 = 
"#line 1107 \"[executable]/ftp.sql\"\n"
"create procedure FTP_NOR_DIR (\n"
"in dir1 varchar,\n"
"inout dir2 varchar)\n"
"{\n"
"if (not FTP_DAV_PATH_FIX (dir2))\n"
"{\n"
"dir2 := dir1 || dir2 || \'/\';\n"
"}\n"
"dir2 := replace (dir2, \'//\', \'/\');\n"
"}\n"
"--src ftp.sql:1105\n"
;

static const char *proc80 = 
"#line 1123 \"[executable]/ftp.sql\"\n"
"create procedure FTP_GET (\n"
"in _server varchar,\n"
"in _user varchar,\n"
"in _pass varchar,\n"
"in _file varchar,\n"
"in _local varchar,\n"
"in is_pasv integer := 1,\n"
"in dav_user varchar := NULL,\n"
"in dav_pass varchar := NULL,\n"
"in ret_ses int := 0)\n"
"{\n"
"declare ses, listen, data_ses, data_addr, all_at any;\n"
"\n"
"\n"
"\n"
"if (not ret_ses and FTP_FILE_IS_DAV (_local) and (dav_user is NULL or dav_pass is NULL))\n"
"signal (\'22023\', \'Incorrect DAV path / user parameters.\');\n"
"\n"
"data_ses := NULL;\n"
"all_at := string_output (http_strses_memory_size ());\n"
"data_addr := FTP_CONNECT (_server, _user, _pass, ses, is_pasv);\n"
"\n"
"\n"
"\n"
"if (is_pasv = 0)\n"
"FTP_LISTEN (ses, listen);\n"
"else\n"
"data_ses := ses_connect (data_addr);\n"
"\n"
"FTP_COMMAND (ses, concat (\'retr \', _file), vector (150, 125));\n"
"\n"
"if (is_pasv = 0)\n"
"FTP_SES_ACCEPT (listen, data_ses);\n"
"\n"
"FTP_SES_GET (data_addr, all_at, data_ses);\n"
"FTP_COMMAND (ses, \'quit\', NULL);\n"
"ses_disconnect (ses);\n"
"\n"
"if (ret_ses)\n"
"return all_at;\n"
"\n"
"if (FTP_FILE_IS_DAV (_local))\n"
"return FTP_PUT_IN_DAV (_local, all_at, dav_user, dav_pass);\n"
"\n"
"string_to_file (_local, all_at, -2);\n"
"\n"
"return length (all_at);\n"
"}\n"
"--src ftp.sql:1121\n"
;

static const char *proc81 = 
"#line 1173 \"[executable]/ftp.sql\"\n"
"create procedure FTP_PUT (\n"
"in _server varchar,\n"
"in _user varchar,\n"
"in _pass varchar,\n"
"in _file varchar,\n"
"in _remote varchar,\n"
"in is_pasv integer := 1,\n"
"in dav_user varchar := NULL,\n"
"in dav_pass varchar := NULL,\n"
"in _content_mode integer := 0)\n"
"{\n"
"declare ses, listen, data_ses, file_ses any;\n"
"declare data_addr any;\n"
"\n"
"\n"
"if (not _content_mode and FTP_FILE_IS_DAV (_file) and (dav_user is NULL or dav_pass is NULL))\n"
"signal (\'22023\', \'Incorrect DAV path / user parameters.\');\n"
"\n"
"data_ses := NULL;\n"
"data_addr := FTP_CONNECT (_server, _user, _pass, ses, is_pasv);\n"
"\n"
"if (is_pasv = 0)\n"
"FTP_LISTEN (ses, listen);\n"
"else\n"
"data_ses := ses_connect (data_addr);\n"
"\n"
"if (_content_mode)\n"
"{\n"
"file_ses := _file;\n"
"}\n"
"else\n"
"{\n"
"file_ses := FTP_FILE_SES_GET (data_addr, _file, data_ses, dav_user, dav_pass);\n"
"}\n"
"commit work;\n"
"FTP_COMMAND (ses, concat (\'stor \', _remote), vector (150, 125));\n"
"\n"
"if (is_pasv = 0)\n"
"{\n"
"FTP_SES_ACCEPT (listen, data_ses);\n"
"}\n"
"\n"
"FTP_SES_SEND (data_addr, file_ses, data_ses, dav_user, dav_pass);\n"
"FTP_COMMAND (ses, NULL, vector (226, 150));\n"
"FTP_COMMAND (ses, \'quit\', NULL);\n"
"ses_disconnect (ses);\n"
"\n"
"return 1;\n"
"}\n"
"--src ftp.sql:1171\n"
;

static const char *proc82 = 
"#line 1224 \"[executable]/ftp.sql\"\n"
"create procedure FTP_MKDIR (\n"
"in _server varchar,\n"
"in _user varchar,\n"
"in _pass varchar,\n"
"in _remote varchar,\n"
"in is_pasv integer := 1)\n"
"{\n"
"declare ses, listen, data_ses any;\n"
"declare data_addr any;\n"
"\n"
"data_ses := NULL;\n"
"data_addr := FTP_CONNECT (_server, _user, _pass, ses, is_pasv);\n"
"\n"
"if (is_pasv = 0)\n"
"FTP_LISTEN (ses, listen);\n"
"else\n"
"data_ses := ses_connect (data_addr);\n"
"\n"
"commit work;\n"
"FTP_COMMAND (ses, concat (\'mkd \', _remote), vector (257));\n"
"\n"
"if (is_pasv = 0)\n"
"{\n"
"FTP_SES_ACCEPT (listen, data_ses);\n"
"}\n"
"\n"
"FTP_COMMAND (ses, \'quit\', NULL);\n"
"ses_disconnect (ses);\n"
"\n"
"return 1;\n"
"}\n"
"--src ftp.sql:1222\n"
;

static const char *proc83 = 
"#line 1257 \"[executable]/ftp.sql\"\n"
"create procedure FTP_RMDIR (\n"
"in _server varchar,\n"
"in _user varchar,\n"
"in _pass varchar,\n"
"in _remote varchar,\n"
"in is_pasv integer := 1)\n"
"{\n"
"declare ses, listen, data_ses any;\n"
"declare data_addr any;\n"
"\n"
"data_ses := NULL;\n"
"data_addr := FTP_CONNECT (_server, _user, _pass, ses, is_pasv);\n"
"\n"
"if (is_pasv = 0)\n"
"FTP_LISTEN (ses, listen);\n"
"else\n"
"data_ses := ses_connect (data_addr);\n"
"\n"
"commit work;\n"
"FTP_COMMAND (ses, concat (\'rmd \', _remote), vector (250));\n"
"\n"
"if (is_pasv = 0)\n"
"{\n"
"FTP_SES_ACCEPT (listen, data_ses);\n"
"}\n"
"\n"
"FTP_COMMAND (ses, \'quit\', NULL);\n"
"ses_disconnect (ses);\n"
"\n"
"return 1;\n"
"}\n"
"--src ftp.sql:1255\n"
;

static const char *proc84 = 
"#line 1290 \"[executable]/ftp.sql\"\n"
"create procedure FTP_DELETE (\n"
"in _server varchar,\n"
"in _user varchar,\n"
"in _pass varchar,\n"
"in _remote varchar,\n"
"in is_pasv integer := 1)\n"
"{\n"
"declare ses, listen, data_ses any;\n"
"declare data_addr any;\n"
"\n"
"data_ses := NULL;\n"
"data_addr := FTP_CONNECT (_server, _user, _pass, ses, is_pasv);\n"
"\n"
"if (is_pasv = 0)\n"
"FTP_LISTEN (ses, listen);\n"
"else\n"
"data_ses := ses_connect (data_addr);\n"
"\n"
"commit work;\n"
"FTP_COMMAND (ses, concat (\'dele \', _remote), vector (250));\n"
"\n"
"if (is_pasv = 0)\n"
"{\n"
"FTP_SES_ACCEPT (listen, data_ses);\n"
"}\n"
"\n"
"FTP_COMMAND (ses, \'quit\', NULL);\n"
"ses_disconnect (ses);\n"
"\n"
"return 1;\n"
"}\n"
"--src ftp.sql:1288\n"
;

static const char *proc85 = 
"#line 1323 \"[executable]/ftp.sql\"\n"
"create procedure FTP_LS (\n"
"in _server varchar,\n"
"in _user varchar,\n"
"in _pass varchar,\n"
"in _dir varchar,\n"
"in is_pasv integer := 1)\n"
"{\n"
"declare data_addr, ses, readed, listen, data_ses any;\n"
"\n"
"data_addr := FTP_CONNECT (_server, _user, _pass, ses, is_pasv);\n"
"data_ses := NULL;\n"
"FTP_COMMAND (ses, \'type a\', vector (200));\n"
"\n"
"if (is_pasv)\n"
"{\n"
"FTP_MAKE_LIST_CMD (_dir, ses);\n"
"readed := FTP_LIST_GET (data_addr, data_ses);\n"
"}\n"
"else\n"
"{\n"
"FTP_LISTEN (ses, listen);\n"
"FTP_MAKE_LIST_CMD (_dir, ses);\n"
"FTP_SES_ACCEPT (listen, data_ses);\n"
"readed := FTP_LIST_GET (NULL, data_ses);\n"
"}\n"
"\n"
"FTP_COMMAND (ses, \'quit\', NULL);\n"
"ses_disconnect (ses);\n"
"return readed;\n"
"}\n"
"--src ftp.sql:1321\n"
;

static const char *proc86 = 
"#line 1355 \"[executable]/ftp.sql\"\n"
"create procedure PARSE_ADR (\n"
"in _in varchar,\n"
"in mode integer)\n"
"{\n"
"declare t any;\n"
"\n"
"if (mode)\n"
"{\n"
"_in := subseq (_in, strstr (_in, \'(\') + 1, length (_in) - 1);\n"
"_in := trim (_in, \'() \');\n"
"}\n"
"t := split_and_decode (_in, 0, \'\\0\\0,\');\n"
"return concat (t[0], \'.\',t[1], \'.\', t[2], \'.\', t[3], \':\', cast ((atoi(t[4])*256+atoi(t[5])) as varchar));\n"
"}\n"
"--src ftp.sql:1353\n"
;

static const char *proc87 = 
"#line 1371 \"[executable]/ftp.sql\"\n"
"create procedure FTP_COMMAND (\n"
"inout ses any,\n"
"in cmd varchar,\n"
"in is_ok any)\n"
"{\n"
"declare code integer;\n"
"declare _in any;\n"
"\n"
"if (cmd is not NULL)\n"
"ses_write (concat (cmd, \'\\r\\n\'), ses);\n"
"\n"
"if (is_ok is not NULL)\n"
"{\n"
"while (1)\n"
"{\n"
"_in := ses_read_line (ses);\n"
"\n"
"if (length (_in) < 4)\n"
"_in := \'none\';\n"
"\n"
"code := atoi (\"LEFT\"(_in, 3));\n"
"if (subseq (_in,3,4) = \'-\' and FTP_IF_CODE_OK (code, is_ok))\n"
"code := 0;\n"
"\n"
"if (FTP_IF_CODE_OK (code, is_ok))\n"
"return code;\n"
"\n"
"if (code and not FTP_IF_CODE_OK (code, is_ok))\n"
"signal (\'42000\', _in);\n"
"}\n"
"}\n"
"}\n"
"--src ftp.sql:1369\n"
;

static const char *proc88 = 
"#line 1405 \"[executable]/ftp.sql\"\n"
"create procedure FTP_SES_GET (\n"
"in new_addr varchar,\n"
"inout all_at any,\n"
"inout data_ses any)\n"
"{\n"
"declare _read any;\n"
"\n"
"if (data_ses is NULL)\n"
"data_ses := ses_connect (new_addr);\n"
"\n"
"while (1)\n"
"{\n"
"_read := ses_read_line (data_ses, 0, 1);\n"
"if (length (_read) = 0)\n"
"{\n"
"ses_disconnect (data_ses);\n"
"return;\n"
"}\n"
"http (_read, all_at);\n"
"}\n"
"}\n"
"--src ftp.sql:1403\n"
;

static const char *proc89 = 
"#line 1428 \"[executable]/ftp.sql\"\n"
"create procedure FTP_CONNECT (\n"
"in _server varchar,\n"
"in _user varchar,\n"
"in _pass varchar,\n"
"inout ses any,\n"
"in pasv integer)\n"
"{\n"
"declare rc any;\n"
"\n"
"if (strstr (_server, \':\') is NULL)\n"
"_server := concat (_server, \':21\');\n"
"\n"
"_user := concat (\'user \', _user);\n"
"_pass := concat (\'pass \', _pass);\n"
"\n"
"ses := ses_connect (_server);\n"
"\n"
"FTP_COMMAND (ses, NULL, vector (220));\n"
"rc := FTP_COMMAND (ses, _user, vector (331, 230));\n"
"if (rc <> 230)\n"
"FTP_COMMAND (ses, _pass, vector (230));\n"
"\n"
"FTP_COMMAND (ses, \'type i\', vector (200));\n"
"\n"
"if (pasv)\n"
"{\n"
"ses_write (\'pasv\\r\\n\', ses);\n"
"return (PARSE_ADR (ses_read_line (ses), 1));\n"
"}\n"
"\n"
"return NULL;\n"
"}\n"
"--src ftp.sql:1426\n"
;

static const char *proc90 = 
"#line 1462 \"[executable]/ftp.sql\"\n"
"create procedure FTP_LIST_GET (\n"
"in new_addr varchar,\n"
"inout data_ses any)\n"
"{\n"
"declare all_at, _read any;\n"
"declare t any;\n"
"\n"
"if (data_ses is NULL)\n"
"data_ses := ses_connect (new_addr);\n"
"\n"
"all_at := vector ();\n"
"while (1)\n"
"{\n"
"_read := ses_read_line (data_ses, 0);\n"
"if (_read = 0)\n"
"goto end_read;\n"
"\n"
"t := FTP_GET_DIR (_read);\n"
"all_at := vector_concat (vector (t), all_at);\n"
"}\n"
"\n"
"end_read:\n"
"ses_disconnect (data_ses);\n"
"return all_at;\n"
"}\n"
"--src ftp.sql:1460\n"
;

static const char *proc91 = 
"#line 1489 \"[executable]/ftp.sql\"\n"
"create procedure FTP_FILE_SES_GET (\n"
"in new_addr varchar,\n"
"in _file_name varchar,\n"
"inout data_ses any,\n"
"in dav_user varchar,\n"
"in dav_pass varchar)\n"
"{\n"
"declare _all any;\n"
"\n"
"if (FTP_FILE_IS_DAV (_file_name))\n"
"_all := FTP_GET_FROM_DAV (_file_name, dav_user, dav_pass);\n"
"else\n"
"_all := file_to_string_output (_file_name);\n"
"\n"
"return _all;\n"
"}\n"
"--src ftp.sql:1487\n"
;

static const char *proc92 = 
"#line 1507 \"[executable]/ftp.sql\"\n"
"create procedure FTP_SES_SEND (\n"
"in new_addr varchar,\n"
"inout _content any,\n"
"inout data_ses any,\n"
"in dav_user varchar,\n"
"in dav_pass varchar)\n"
"{\n"
"declare _ret any;\n"
"\n"
"if (data_ses is NULL)\n"
"data_ses := ses_connect (new_addr);\n"
"\n"
"_ret := ses_write (_content, data_ses);\n"
"\n"
"ses_disconnect (data_ses);\n"
"return _ret;\n"
"}\n"
"--src ftp.sql:1505\n"
;

static const char *proc93 = 
"#line 1526 \"[executable]/ftp.sql\"\n"
"create procedure FTP_IF_CODE_OK (\n"
"in code integer,\n"
"in is_ok any)\n"
"{\n"
"declare idx integer;\n"
"\n"
"idx := 0;\n"
"\n"
"while (length (is_ok) > idx)\n"
"{\n"
"if (code = is_ok[idx])\n"
"return 1;\n"
"\n"
"idx := idx + 1;\n"
"}\n"
"\n"
"return 0;\n"
"}\n"
"--src ftp.sql:1524\n"
;

static const char *proc94 = 
"#line 1546 \"[executable]/ftp.sql\"\n"
"create procedure FTP_GET_DIR (\n"
"in _all varchar)\n"
"{\n"
"declare idx, pos integer;\n"
"declare ret any;\n"
"\n"
"ret := vector ();\n"
"_all := replace (_all, \'\\011\', \' \');\n"
"_all := trim (_all, \' \');\n"
"\n"
"while (1)\n"
"{\n"
"pos := strstr (_all, \' \');\n"
"if (pos is NULL)\n"
"return vector_concat (ret, vector (_all));\n"
"\n"
"ret := vector_concat (ret, vector (\"LEFT\" (_all, pos)));\n"
"_all := trim (subseq (_all, pos + 1), \' \');\n"
"}\n"
"}\n"
"--src ftp.sql:1544\n"
;

static const char *proc95 = 
"#line 1568 \"[executable]/ftp.sql\"\n"
"create procedure GET_FREE_PORT ()\n"
"{\n"
"declare _last, _min, _max any;\n"
"\n"
"_min := virtuoso_ini_item_value (\'HTTPServer\', \'FTPServerMinFreePort\');\n"
"_max := virtuoso_ini_item_value (\'HTTPServer\', \'FTPServerMaxFreePort\');\n"
"\n"
"if (_min is NULL)\n"
"_min := 20000;\n"
"\n"
"if (_max is NULL)\n"
"_max := 30000;\n"
"\n"
"_last := registry_get (\'__next_free_port\');\n"
"if (isstring (_last))\n"
"_last := atoi (_last);\n"
"\n"
"if (_last = 0 or _last > _max)\n"
"_last := cast (_min as integer);\n"
"\n"
"_last := _last + 1;\n"
"\n"
"registry_set (\'__next_free_port\', cast (_last as varchar), 1);\n"
"\n"
"return _last;\n"
"}\n"
"--src ftp.sql:1566\n"
;

static const char *proc96 = 
"#line 1596 \"[executable]/ftp.sql\"\n"
"create procedure FTP_MAKE_PORT_COMMAND (\n"
"in _port integer,\n"
"in mode integer)\n"
"{\n"
"declare _ip, _port1, _port2 varchar;\n"
"\n"
"_ip := identify_self();\n"
"_ip := _ip[2];\n"
"_ip := replace (_ip, \'.\', \',\');\n"
"\n"
"_port1 := cast (mod (_port, 256) as varchar);\n"
"_port2 := cast (_port / 256 as varchar);\n"
"\n"
"if (mode)\n"
"return \'PORT \' || _ip || \',\' || _port2 || \',\' || _port1;\n"
"\n"
"return \'227 (\' || _ip || \',\' || _port2 || \',\' || _port1 || \')\';\n"
"}\n"
"--src ftp.sql:1594\n"
;

static const char *proc97 = 
"#line 1617 \"[executable]/ftp.sql\"\n"
"create procedure FTP_LISTEN (\n"
"inout ses any,\n"
"inout listen any)\n"
"{\n"
"declare _port integer;\n"
"\n"
"_port := FTP_SES_LISTEN (listen);\n"
"\n"
"FTP_COMMAND (ses, FTP_MAKE_PORT_COMMAND (_port, 1), vector (200));\n"
"}\n"
"--src ftp.sql:1615\n"
;

static const char *proc98 = 
"#line 1629 \"[executable]/ftp.sql\"\n"
"create procedure FTP_MAKE_LIST_CMD (\n"
"in _dir varchar,\n"
"inout ses any)\n"
"{\n"
"declare _list_cmd varchar;\n"
"\n"
"if (trim (_dir) <> \'\')\n"
"_list_cmd := concat (\'LIST \' , _dir);\n"
"else\n"
"_list_cmd := \'LIST\';\n"
"\n"
"FTP_COMMAND (ses, _list_cmd, NULL);\n"
"}\n"
"--src ftp.sql:1627\n"
;

static const char *proc99 = 
"#line 1644 \"[executable]/ftp.sql\"\n"
"create procedure FTP_SES_ACCEPT (\n"
"inout ses1 any,\n"
"inout ses2 any)\n"
"{\n"
"ses2 := ses_accept (ses1);\n"
"ses_disconnect (ses1);\n"
"ses1 := NULL;\n"
"}\n"
"--src ftp.sql:1642\n"
;

static const char *proc100 = 
"#line 1654 \"[executable]/ftp.sql\"\n"
"create procedure FTP_SES_LISTEN (\n"
"inout listen any)\n"
"{\n"
"declare _port, _retray integer;\n"
"\n"
"_retray := 0;\n"
"\n"
"again:\n"
"_port := GET_FREE_PORT();\n"
"listen := ses_listen (cast (_port as varchar));\n"
"\n"
"if (_retray > 10)\n"
"{\n"
"signal (\'22000\', \'FTP Server: Cant get free port range \' || cast ((_port - 10) as varchar) || \' - \' || cast (_port as varchar));\n"
"}\n"
"\n"
"_retray := _retray + 1;\n"
"if (listen = 0)\n"
"goto again;\n"
"\n"
"return _port;\n"
"}\n"
"--src ftp.sql:1652\n"
;

static const char *proc101 = 
"#line 1678 \"[executable]/ftp.sql\"\n"
"create procedure FTP_WRITE (\n"
"in l_user varchar,\n"
"in w_str varchar,\n"
"in command varchar,\n"
"in len integer:=0)\n"
"{\n"
"\n"
"declare log_file varchar;\n"
"\n"
"log_file := virtuoso_ini_item_value (\'HTTPServer\', \'FTPServerLogFile\');\n"
"if (log_file is NULL)\n"
"goto finish;\n"
"\n"
"if (\"LEFT\" (command, 5) = \'PASS \' and upper (l_user) <> \'ANONYMOUS\')\n"
"command := \'PASS <hidden>\';\n"
"\n"
"__ftp_log (FTP_LOG_FILE_NAME (log_file), command, w_str, l_user, len);\n"
"\n"
"finish:\n"
"pop_write (w_str);\n"
"}\n"
"--src ftp.sql:1676\n"
;

static const char *proc102 = 
"#line 1701 \"[executable]/ftp.sql\"\n"
"create procedure FTP_POP_WRITE (\n"
"in str varchar)\n"
"{\n"
"\n"
"pop_write (str);\n"
"}\n"
"--src ftp.sql:1699\n"
;

static const char *proc103 = 
"#line 1709 \"[executable]/ftp.sql\"\n"
"create procedure FTP_LOG_FILE_NAME (\n"
"in in_name varchar)\n"
"{\n"
"declare file_name varchar;\n"
"declare _now datetime;\n"
"\n"
"if (strstr (in_name, \'.log\') is NULL)\n"
"{\n"
"file_name := in_name;\n"
"}\n"
"else\n"
"{\n"
"if (length (in_name) > 12)\n"
"file_name := \"LEFT\" (in_name, length (in_name) - 12);\n"
"else\n"
"file_name := \"LEFT\" (in_name, length (in_name) - 4);\n"
"}\n"
"\n"
"_now := now ();\n"
"file_name := file_name || \"RIGHT\" (\'0\' || cast (dayofmonth (_now) as varchar), 2);\n"
"file_name := file_name || \"RIGHT\" (\'0\' || cast (month (_now) as varchar), 2);\n"
"file_name := file_name || cast (year (_now) as varchar) || \'.log\';\n"
"\n"
"if (in_name <> file_name)\n"
"cfg_write (virtuoso_ini_path(), \'HTTPServer\', \'FTPServerLogFile\', file_name);\n"
"\n"
"return file_name;\n"
"}\n"
"--src ftp.sql:1707\n"
;

static const char *proc104 = 
"#line 1739 \"[executable]/ftp.sql\"\n"
"create procedure FTP_RES_UPLOAD_FROM_POSITION (\n"
"in in_str varchar,\n"
"in d_addr varchar,\n"
"in cur_dir varchar,\n"
"in f_name varchar,\n"
"in _user varchar,\n"
"in _pass varchar,\n"
"inout listen any,\n"
"inout rest_pos integer)\n"
"{\n"
"\n"
"declare _cont, data_ses, temp any;\n"
"declare permissions varchar;\n"
"declare actual_old_len, len, int_res integer;\n"
"declare _upd_res any;\n"
"\n"
"if (FTP_ANONYMOUS_CHECK (_user))\n"
"permissions := \'110100110R\';\n"
"else\n"
"permissions := \'110100000R\';\n"
"\n"
"len := rest_pos;\n"
"int_res := 0;\n"
"\n"
"_cont := string_output (http_strses_memory_size ());\n"
"\n"
"\n"
"_upd_res := DAV_SEARCH_ID (cur_dir || f_name, \'R\');\n"
"if (DAV_HIDE_ERROR (_upd_res) is null)\n"
"{\n"
"if (-1 = _upd_res)\n"
"{\n"
"actual_old_len := 0;\n"
"goto old_cont_ready;\n"
"}\n"
"FTP_WRITE (_user, \'550 Internal server error: \' || DAV_PERROR (_upd_res), in_str);\n"
"return;\n"
"}\n"
"if (isarray (_upd_res))\n"
"{\n"
"declare cont_type varchar;\n"
"declare rc, old_ses any;\n"
"\n"
"rc := DAV_RES_CONTENT_INT (_upd_res, old_ses, cont_type, 1, 0, _user, _pass);\n"
"if (DAV_HIDE_ERROR (rc) is null)\n"
"{\n"
"FTP_WRITE (_user, \'550 Internal server error: \' || DAV_PERROR (_upd_res), in_str);\n"
"return;\n"
"}\n"
"actual_old_len := length (old_ses);\n"
"if (actual_old_len = rest_pos)\n"
"{\n"
"http (temp, _cont);\n"
"}\n"
"else if (actual_old_len > rest_pos)\n"
"{\n"
"http (subseq (temp, 0, rest_pos), _cont);\n"
"}\n"
"}\n"
"else\n"
"{\n"
"actual_old_len := (select length (RES_CONTENT) from WS.WS.SYS_DAV_RES where RES_ID = _upd_res);\n"
"if (actual_old_len = rest_pos)\n"
"{\n"
"http ((select RES_CONTENT from WS.WS.SYS_DAV_RES where RES_ID = _upd_res), _cont);\n"
"}\n"
"else if (actual_old_len > rest_pos)\n"
"{\n"
"http ((select subseq (RES_CONTENT, 0, rest_pos) from WS.WS.SYS_DAV_RES where RES_ID = _upd_res), _cont);\n"
"}\n"
"}\n"
"commit work;\n"
"\n"
"old_cont_ready:\n"
"\n"
"if (actual_old_len < rest_pos)\n"
"{\n"
"FTP_WRITE (_user, sprintf(\'550 Operation is forbidden: the stored part of the resource is only %d bytes long, can not retry from position %d\', actual_old_len, rest_pos), in_str);\n"
"return;\n"
"}\n"
"\n"
"data_ses := NULL;\n"
"\n"
"_upd_res := DAV_RES_UPLOAD_STRSES (cur_dir || f_name, _cont, auth_uid=>_user, auth_pwd=>_pass, uid=>_user, permissions=>permissions);\n"
"commit work;\n"
"\n"
"if (DAV_HIDE_ERROR (_upd_res) is not null)\n"
"{\n"
"pop_write (\'150 Opening...\');\n"
"}\n"
"else\n"
"{\n"
"FTP_WRITE (_user, \'550 Operation is forbidden: \' || DAV_PERROR (_upd_res), in_str);\n"
"return;\n"
"}\n"
"\n"
"if (listen is not NULL)\n"
"FTP_SES_ACCEPT (listen, data_ses);\n"
"else\n"
"data_ses := ses_connect (d_addr);\n"
"\n"
"FTP_SES_GET (d_addr, _cont, data_ses);\n"
"\n"
"_upd_res := DAV_RES_UPLOAD_STRSES (cur_dir || f_name, _cont, auth_uid=>_user, auth_pwd=>_pass, uid=>_user, permissions=>permissions);\n"
"commit work;\n"
"\n"
"if (DAV_HIDE_ERROR (_upd_res) is not null)\n"
"FTP_WRITE (_user, \'226 Transfer complete.\', in_str, len=>length (_cont));\n"
"else\n"
"FTP_WRITE (_user, \'550 Internal server error: \' || DAV_PERROR (_upd_res), in_str);\n"
"}\n"
"--src ftp.sql:1737\n"
;

static const char *proc105 = 
"#line 1852 \"[executable]/ftp.sql\"\n"
"create procedure FTP_PUT_IN_DAV (\n"
"in _local varchar,\n"
"inout all_at any,\n"
"in dav_user varchar,\n"
"in dav_pass varchar)\n"
"{\n"
"declare ret integer;\n"
"\n"
"_local := subseq (_local, 6);\n"
"\n"
"ret := DAV_RES_UPLOAD_STRSES (_local, all_at, auth_uid=>dav_user, auth_pwd=>dav_pass);\n"
"if (DAV_HIDE_ERROR (ret) is null)\n"
"return ret;\n"
"\n"
"return length (all_at);\n"
"}\n"
"--src ftp.sql:1850\n"
;

static const char *proc106 = 
"#line 1871 \"[executable]/ftp.sql\"\n"
"create procedure FTP_GET_FROM_DAV (\n"
"in _local varchar,\n"
"in dav_user varchar,\n"
"in dav_pass varchar) returns any\n"
"{\n"
"declare res, _content any;\n"
"declare mime varchar;\n"
"\n"
"_local := subseq (_local, 6);\n"
"_content := string_output (http_strses_memory_size ());\n"
"res := DAV_RES_CONTENT_STRSES (_local, _content, mime, dav_user, dav_pass);\n"
"if (DAV_HIDE_ERROR (res) is not null)\n"
"{\n"
"commit work;\n"
"return _content;\n"
"}\n"
"if (res in (-5, -12, -24))\n"
"signal (\'22023\', \'Operation is forbidden.\');\n"
"\n"
"if (res in (-1))\n"
"signal (\'22023\', \'The path (target of operation) is not valid.\');\n"
"\n"
"signal (\'22023\', DAV_PERROR (res));\n"
"}\n"
"--src ftp.sql:1869\n"
;

static const char *proc107 = 
"#line 1897 \"[executable]/ftp.sql\"\n"
"create procedure FTP_DAV_PATH_FIX (\n"
"inout f_path varchar)\n"
"{\n"
"if (f_path[0] = ascii (\'/\'))\n"
"{\n"
"if (f_path not like \'/DAV/%\')\n"
"f_path := \'/DAV\' || f_path;\n"
"\n"
"return 1;\n"
"}\n"
"\n"
"return 0;\n"
"}\n"
"--src ftp.sql:1895\n"
;

static const char *proc108 = 
"#line 1912 \"[executable]/ftp.sql\"\n"
"create procedure FTP_FILE_IS_DAV (\n"
"in _f_name varchar)\n"
"{\n"
"if (length (_f_name) > 7 and \"LEFT\" (_f_name, 7) = \'virt://\')\n"
"return 1;\n"
"\n"
"return 0;\n"
"}\n"
"--src ftp.sql:1910\n"
;

/* nn_svr.sql */

static const char *tbl2 = 
"create table NEWS_MSG_NNTP (\n"
"NM_ID		varchar not null,\n"
"NM_REF		varchar,\n"
"NM_READ		integer,\n"
"NM_OWN 		varchar,\n"
"NM_REC_DATE	datetime,\n"
"NM_STAT		integer,\n"
"NM_TRY_POST	integer,\n"
"NM_DELETED	integer,\n"
"NM_HEAD		long varchar,\n"
"NM_BODY		long varchar,\n"
"NM_BODY_ID	integer identity,\n"
"PRIMARY KEY (NM_ID))\n"
"create index NEWS_MSG_NNTP_NM_STAT on DB.DBA.NEWS_MSG_NNTP (NM_STAT)\n";

static const char *view0 = 
"create view NEWS_MSG\n"
"(\n"
"NM_TYPE		,\n"
"NM_ID		,\n"
"NM_REF		,\n"
"NM_READ		,\n"
"NM_OWN 		,\n"
"NM_REC_DATE	,\n"
"NM_STAT		,\n"
"NM_TRY_POST	,\n"
"NM_DELETED	,\n"
"NM_HEAD		,\n"
"NM_BODY		,\n"
"NM_BODY_ID\n"
")\n"
"\n"
"as\n"
"select\n"
"\'NNTP\' as NM_TYPE,\n"
"NM_ID,\n"
"NM_REF,\n"
"NM_READ,\n"
"NM_OWN,\n"
"NM_REC_DATE,\n"
"NM_STAT,\n"
"NM_TRY_POST,\n"
"NM_DELETED,\n"
"NM_HEAD,\n"
"NM_BODY,\n"
"NM_BODY_ID\n"
"from NEWS_MSG_NNTP\n";

static const char *trig0 = 
"#line 95 \"[executable]/nn_svr.sql\"\n"
"create trigger NEWS_MSG_I instead of insert on NEWS_MSG referencing new as N\n"
"{\n"
"declare p_name varchar;\n"
"declare rc int;\n"
"p_name := \'DB.DBA.\'||N.NM_TYPE||\'_NEWS_MSG_I\';\n"
"if (N.NM_TYPE = \'NNTP\')\n"
"{\n"
"insert soft NEWS_MSG_NNTP\n"
"(NM_ID, NM_REF, NM_READ, NM_OWN, NM_REC_DATE, NM_STAT, NM_TRY_POST, NM_DELETED,\n"
"NM_HEAD, NM_BODY)\n"
"values\n"
"(N.NM_ID, N.NM_REF, N.NM_READ, N.NM_OWN, N.NM_REC_DATE, N.NM_STAT, N.NM_TRY_POST, N.NM_DELETED,\n"
"N.NM_HEAD, N.NM_BODY);\n"
"}\n"
"else if (__proc_exists (p_name))\n"
"{\n"
"call (p_name) (N.NM_ID,N.NM_REF,N.NM_READ,N.NM_OWN,N.NM_REC_DATE,N.NM_STAT,N.NM_TRY_POST,N.NM_DELETED,N.NM_HEAD,N.NM_BODY);\n"
"}\n"
"else\n"
"signal (\'CONV9\', \'Post is not allowed\');\n"
"rc := row_count ();\n"
"set_row_count (rc, 1);\n"
"}\n"
"--src nn_svr.sql:93\n";

static const char *trig1 = 
"#line 120 \"[executable]/nn_svr.sql\"\n"
"create trigger NEWS_MSG_U instead of update on NEWS_MSG referencing old as O, new as N\n"
"{\n"
"declare p_name varchar;\n"
"declare rc int;\n"
"p_name := \'DB.DBA.\'||N.NM_TYPE||\'_NEWS_MSG_U\';\n"
"if (N.NM_TYPE = \'NNTP\')\n"
"{\n"
"update NEWS_MSG_NNTP\n"
"set\n"
"NM_ID = N.NM_ID,\n"
"NM_REF = N.NM_REF,\n"
"NM_READ = N.NM_READ,\n"
"NM_OWN = N.NM_OWN,\n"
"NM_REC_DATE = N.NM_REC_DATE,\n"
"NM_STAT = N.NM_STAT,\n"
"NM_TRY_POST = N.NM_TRY_POST,\n"
"NM_DELETED = N.NM_DELETED,\n"
"NM_HEAD = N.NM_HEAD,\n"
"NM_BODY = N.NM_BODY\n"
"where NM_ID = O.NM_ID;\n"
"}\n"
"else if (__proc_exists (p_name))\n"
"{\n"
"call (p_name) (O.NM_ID, N.NM_ID, N.NM_REF, N.NM_READ, N.NM_OWN, N.NM_REC_DATE, N.NM_STAT, N.NM_TRY_POST, N.NM_DELETED, N.NM_HEAD, N.NM_BODY);\n"
"}\n"
"else\n"
"signal (\'CONV9\', \'Update is not allowed\');\n"
"rc := row_count ();\n"
"set_row_count (rc, 1);\n"
"}\n"
"--src nn_svr.sql:118\n";

static const char *trig2 = 
"#line 152 \"[executable]/nn_svr.sql\"\n"
"create trigger NEWS_MSG_D instead of delete on NEWS_MSG referencing old as O\n"
"{\n"
"declare p_name varchar;\n"
"declare rc int;\n"
"p_name := \'DB.DBA.\'||O.NM_TYPE||\'_NEWS_MSG_D\';\n"
"if (O.NM_TYPE = \'NNTP\')\n"
"{\n"
"delete from NEWS_MSG_NNTP where NM_ID = O.NM_ID;\n"
"}\n"
"else if (__proc_exists (p_name))\n"
"{\n"
"call (p_name) (O.NM_ID);\n"
"}\n"
"else\n"
"signal (\'CONV9\', \'Delete is not allowed\');\n"
"rc := row_count ();\n"
"set_row_count (rc, 1);\n"
"}\n"
"--src nn_svr.sql:150\n";

static const char *proc109 = 
"#line 190 \"[executable]/nn_svr.sql\"\n"
"create procedure\n"
"NN_FEED_PART (inout vb any, inout mb any, inout body varchar, inout id integer)\n"
"{\n"
"declare txt varchar;\n"
"declare tp, enc, disp varchar;\n"
"declare i, l integer;\n"
"if (not isarray (mb[0]))\n"
"return;\n"
"tp := get_keyword_ucase (\'CONTENT-TYPE\', mb[0], \'application/octet-stream\');\n"
"enc := get_keyword_ucase (\'CONTENT-TRANSFER-ENCODING\', mb[0], \'\');\n"
"\n"
"\n"
"if (tp like \'text/%\')\n"
"{\n"
"txt := subseq (body, mb[1][0], mb[1][1]);\n"
"if (lower (enc) = \'base64\')\n"
"txt := decode_base64(txt);\n"
"vt_batch_feed (vb, txt, 0);\n"
"}\n"
"\n"
"if (not isarray (mb[2]))\n"
"return;\n"
"\n"
"i := 0; l := length (mb[2]);\n"
"while (i < l)\n"
"{\n"
"DB.DBA.NN_FEED_PART (vb, mb[2][i], body, id);\n"
"i := i + 1;\n"
"}\n"
"}\n"
"--src nn_svr.sql:188\n"
;

static const char *proc110 = 
"#line 223 \"[executable]/nn_svr.sql\"\n"
"create procedure DB.DBA.NEWS_MSG_NNTP_NM_BODY_INDEX_HOOK (inout vtb any, inout d_id integer)\n"
"{\n"
"declare data, own, offset any;\n"
"declare _subj, _from, _to, _trf varchar;\n"
"declare cr cursor for select blob_to_string (NM_BODY) from DB.DBA.NEWS_MSG_NNTP where NM_BODY_ID = d_id;\n"
"whenever not found goto err_exit;\n"
"open cr (prefetch 1);\n"
"fetch cr into data;\n"
"if (data is not null)\n"
"{\n"
"data := DB.DBA.ns_make_index_content (data , 1);\n"
"offset := aref (aref (mime_tree (data), 1), 0);\n"
"if (offset > 1)\n"
"offset := offset - 1;\n"
"_trf := lower (substring (mail_header (data, \'Content-Transfer-Encoding\'), 1, 512));\n"
"if (_trf <> \'base64\')\n"
"{\n"
"declare mtree  any;\n"
"mtree := mime_tree (data);\n"
"DB.DBA.NN_FEED_PART (vtb, mtree, data, d_id);\n"
"\n"
"}\n"
"_subj := substring (mail_header (data, \'Subject\'), 1, 512);\n"
"_from := substring (mail_header (data, \'From\'), 1, 512);\n"
"_to := substring (mail_header (data, \'Newsgroups\'), 1, 512);\n"
"vt_batch_feed (vtb, _subj, 0);\n"
"vt_batch_feed (vtb, _from, 0);\n"
"vt_batch_feed (vtb, _to, 0);\n"
"}\n"
"close cr;\n"
"return 1;\n"
"err_exit:\n"
"close cr;\n"
"return 0;\n"
"}\n"
"--src nn_svr.sql:221\n"
;

static const char *proc111 = 
"#line 260 \"[executable]/nn_svr.sql\"\n"
"create procedure DB.DBA.NEWS_MSG_NNTP_NM_BODY_UNINDEX_HOOK (inout vtb any, inout d_id integer)\n"
"{\n"
"declare data, offset any;\n"
"declare _subj, _from, _to, _trf varchar;\n"
"declare cr cursor for select blob_to_string (NM_BODY) from DB.DBA.NEWS_MSG_NNTP where NM_BODY_ID = d_id;\n"
"whenever not found goto err_exit;\n"
"open cr (prefetch 1);\n"
"fetch cr into data;\n"
"if (data is not null)\n"
"{\n"
"data := DB.DBA.ns_make_index_content (data , 1);\n"
"offset := aref (aref (mime_tree (data), 1), 0);\n"
"if (offset > 1)\n"
"offset := offset - 1;\n"
"_trf := lower (substring (mail_header (data, \'Content-Transfer-Encoding\'), 1, 512));\n"
"if (_trf <> \'base64\')\n"
"{\n"
"declare mtree  any;\n"
"mtree := mime_tree (data);\n"
"DB.DBA.NN_FEED_PART (vtb, mtree, data, d_id);\n"
"\n"
"}\n"
"_subj := substring (mail_header (data, \'Subject\'), 1, 512);\n"
"_from := substring (mail_header (data, \'From\'), 1, 512);\n"
"_to := substring (mail_header (data, \'Newsgroups\'), 1, 512);\n"
"vt_batch_feed (vtb, _subj, 1);\n"
"vt_batch_feed (vtb, _from, 1);\n"
"vt_batch_feed (vtb, _to,   1);\n"
"}\n"
"close cr;\n"
"return 1;\n"
"err_exit:\n"
"close cr;\n"
"return 0;\n"
"}\n"
"--src nn_svr.sql:258\n"
;

static const char *other1 = 
"DB.DBA.vt_create_text_index (\'DB.DBA.NEWS_MSG_NNTP\', \'NM_BODY\', \'NM_BODY_ID\', 2, 0, null, 1, \'*ini*\', \'*ini*\')\n";
static const char *other2 = 
"DB.DBA.vt_create_ftt (\'DB.DBA.NEWS_MSG_NNTP\', null, null, 2)\n";
static const char *tbl3 = 
"create table NEWS_GROUPS (\n"
"NG_GROUP	integer identity,\n"
"NG_NAME		varchar NOT NULL unique,\n"
"NG_DESC		varchar,\n"
"NG_SERVER	integer,\n"
"NG_POST		integer,\n"
"NG_UP_TIME	datetime,\n"
"NG_CREAT	datetime,\n"
"NG_UP_INT	integer,\n"
"NG_CLEAR_INT	integer,\n"
"NG_STAT		integer,\n"
"NG_AUTO		integer,\n"
"NG_PASS		integer,\n"
"NG_SPASS	integer,\n"
"NG_UP_MESS	integer,\n"
"NG_NUM		integer,\n"
"NG_FIRST	integer,\n"
"NG_LAST		integer,\n"
"NG_LAST_OUT	integer,\n"
"NG_NEXT_NUM	integer,\n"
"NG_METHOD	integer,\n"
"NG_TYPE 	varchar default \'NNTP\',\n"
"PRIMARY KEY (NG_GROUP))\n";

static const char *tbl4 = 
"create table NEWS_SERVERS (\n"
"NS_ID		integer identity,\n"
"NS_SERVER	varchar,\n"
"NS_PORT		integer,\n"
"NS_USER		varchar,\n"
"NS_PASS		varchar,\n"
"NS_GROUPS	long varchar,\n"
"PRIMARY KEY (NS_SERVER, NS_PORT, NS_USER))\n";

static const char *tbl5 = 
"create table NEWS_MULTI_MSG (\n"
"NM_KEY_ID	varchar not null,\n"
"NM_GROUP 	integer,\n"
"NM_NUM_GROUP 	integer not null,\n"
"primary key (NM_GROUP, NM_KEY_ID))\n"
"create index \"NM_NUM_GROUP\" on NEWS_MULTI_MSG (\"NM_NUM_GROUP\")\n";

static const char *view1 = 
"create view NEWS_MESSAGES as select * from DB.DBA.NEWS_MSG, DB.DBA.NEWS_MULTI_MSG\n"
"where NM_ID = NM_KEY_ID\n";

static const char *proc112 = 
"#line 375 \"[executable]/nn_svr.sql\"\n"
"create procedure\n"
"WS.WS.NN_SRV (in path any, in params any, in lines any)\n"
"{\n"
"\n"
"declare in_str, command, arg, grp_type varchar;\n"
"declare mode, act_grp, cur, _min, _max, nn_uid, nn_pwd integer;\n"
"\n"
"pop_write (\'200 Virtuoso News Server (version 1.0) ready - posting allowed.\');\n"
"\n"
"connection_set (\'NNTP_SERVER_MODE\', 1);\n"
"\n"
"mode := 1;\n"
"act_grp :=0;\n"
"cur := 1;\n"
"_min := 0;\n"
"_max := 0;\n"
"\n"
"while (mode = 1)\n"
"{\n"
"set isolation=\'committed\';\n"
"in_str := ses_read_line ();\n"
"\n"
"in_str := trim (in_str);\n"
"command := ucase (pop_get_command (in_str));\n"
"arg := trim (subseq (in_str, length (command)));\n"
"\n"
"if (command = \'ARTICLE\')\n"
"{\n"
"ns_article (arg, act_grp, cur);\n"
"goto next;\n"
"}\n"
"\n"
"if (command = \'AUTHINFO\')\n"
"{\n"
"ns_auth (arg);\n"
"goto next;\n"
"}\n"
"\n"
"if (command = \'QUIT\')\n"
"{\n"
"pop_write (\'205 Virtuoso News server signing off.\');\n"
"return;\n"
"}\n"
"\n"
"if (command = \'GROUP\')\n"
"{\n"
"ns_group (arg, act_grp, cur, _min, _max, grp_type);\n"
"goto next;\n"
"}\n"
"\n"
"if (command = \'XOVER\')\n"
"{\n"
"ns_xover (arg, act_grp, cur, grp_type);\n"
"goto next;\n"
"}\n"
"\n"
"if (command = \'HELP\')\n"
"ns_help ();\n"
"\n"
"if (command = \'LIST\')\n"
"ns_list (arg);\n"
"\n"
"if (command = \'NEXT\')\n"
"ns_next (arg, act_grp, cur, _min, _max);\n"
"\n"
"if (command = \'LAST\')\n"
"ns_last (arg, act_grp, cur, _min, _max);\n"
"\n"
"if (command = \'HEAD\')\n"
"ns_head (arg, act_grp, cur, grp_type);\n"
"\n"
"if (command = \'BODY\')\n"
"ns_body (arg, act_grp, cur, grp_type);\n"
"\n"
"if (command = \'POST\')\n"
"ns_post (NULL);\n"
"\n"
"if (command = \'STAT\')\n"
"ns_stat (arg, act_grp, cur);\n"
"\n"
"if (command = \'MODE\')\n"
"pop_write (\'200 Virtuoso News Server (version 1.0) ready - posting allowed.\');\n"
"\n"
"if (command = \'NEWGROUPS\')\n"
"ns_newgroups (arg);\n"
"\n"
"if (command = \'XVIRTID\')\n"
"{\n"
"pop_write (sprintf (\'100 %s\', registry_get (\'NNTP_SERVER_ID\')));\n"
"goto next;\n"
"}\n"
"\n"
"if (position (command, vector (\'QUIT\', \'HELP\', \'LIST\', \'GROUP\', \'NEXT\', \'LAST\', \'HEAD\', \'BODY\',\n"
"\'POST\', \'ARTICLE\', \'STAT\', \'XOVER\', \'MODE\', \'NEWGROUPS\')) = 0)\n"
"pop_write (\'500 command not recognized.\');\n"
"\n"
"next:\n"
"\n"
"commit work;\n"
"\n"
"}\n"
"\n"
"return NULL;\n"
"}\n"
"--src nn_svr.sql:373\n"
;

static const char *proc113 = 
"#line 482 \"[executable]/nn_svr.sql\"\n"
"create procedure\n"
"ns_valid (in arg varchar, inout _activ integer, inout _cur integer,\n"
"inout _min integer, inout _max integer, in comm integer)\n"
"{\n"
"\n"
"if (arg <> \'\')\n"
"{\n"
"pop_write (\'501 Usage error\');\n"
"return 0;\n"
"}\n"
"\n"
"if (_activ = 0)\n"
"{\n"
"pop_write (\'412 Not in a newsgroup\');\n"
"return 0;\n"
"}\n"
"\n"
"if ((_max < _cur + 1) and (comm = 1))\n"
"{\n"
"pop_write (\'421 No next to retrieve.\');\n"
"return 0;\n"
"}\n"
"\n"
"if ( (_min > _cur - 1) and (comm = 2))\n"
"{\n"
"pop_write (\'422 No previous to retrieve.\');\n"
"return 0;\n"
"}\n"
"\n"
"\n"
"\n"
"if (not exists (select 1 from DB.DBA.NEWS_MULTI_MSG where NM_GROUP = _activ and NM_NUM_GROUP = _cur))\n"
"{\n"
"pop_write (\'423 no such article number in this group.\');\n"
"return 0;\n"
"}\n"
"\n"
"return 1;\n"
"}\n"
"--src nn_svr.sql:480\n"
;

static const char *proc114 = 
"#line 524 \"[executable]/nn_svr.sql\"\n"
"create procedure ns_add_msg (in _in_art any, in _group integer, inout my_last integer)\n"
"{\n"
"\n"
"declare _id, _ref varchar;\n"
"declare _parse, _msg_h, _art_path any;\n"
"\n"
"_parse := mime_tree (_in_art);\n"
"if (_parse is NULL or _parse = 0)\n"
"return 0;\n"
"_msg_h := aref (_parse, 0);\n"
"_id := get_keyword_ucase (\'Message-ID\', _msg_h);\n"
"if (_id is NULL or _id = 0)\n"
"return 0;\n"
"_ref := get_keyword_ucase (\'References\', _msg_h);\n"
"_art_path := get_keyword_ucase (\'Path\', _msg_h);\n"
"my_last := my_last + 1;\n"
"\n"
"if (_art_path is not NULL)\n"
"nntp_update_message_path (_in_art, _art_path);\n"
"\n"
"if (not exists (select 1 from DB.DBA.NEWS_MSG where NM_ID = _id))\n"
"{\n"
"insert soft DB.DBA.NEWS_MSG (NM_ID, NM_REF, NM_REC_DATE, NM_BODY,\n"
"NM_HEAD, NM_READ, NM_TYPE)\n"
"values (_id, _ref, now(), _in_art, serialize (_parse), 0, \'NNTP\');\n"
"insert soft DB.DBA.NEWS_MULTI_MSG (NM_KEY_ID, NM_GROUP, NM_NUM_GROUP)\n"
"values ( _id, _group, my_last);\n"
"return 1;\n"
"}\n"
"else\n"
"{\n"
"if (not exists (select 1 from  DB.DBA.NEWS_MULTI_MSG\n"
"where NM_GROUP = _group and NM_KEY_ID = _id))\n"
"{\n"
"insert soft DB.DBA.NEWS_MULTI_MSG (NM_KEY_ID, NM_GROUP, NM_NUM_GROUP)\n"
"values ( _id, _group, my_last);\n"
"return 1;\n"
"}\n"
"}\n"
"\n"
"return 0;\n"
"\n"
"}\n"
"--src nn_svr.sql:522\n"
;

static const char *proc115 = 
"#line 573 \"[executable]/nn_svr.sql\"\n"
"create procedure ns_mirror_news\n"
"(in _server varchar, in _out_name varchar, in _group integer, inout my_last integer,\n"
"in _end integer, in _begin integer, in _user varchar, in _pass varchar)\n"
"{\n"
"declare idx, len, num, min_num, _up, err integer;\n"
"declare state, msg, _id varchar;\n"
"declare _to_try integer;\n"
"declare _in_art any;\n"
"declare _list any;\n"
"declare meta, res any;\n"
"\n"
"select min (NM_NUM_GROUP) into min_num from DB.DBA.NEWS_MULTI_MSG where NM_GROUP = _group;\n"
"commit work;\n"
"\n"
"if (min_num is NULL or min_num = 0)\n"
"min_num := 1;\n"
"\n"
"\n"
"msg := \'\';\n"
"\n"
"if (_user = \'\')\n"
"exec (\'select nntp_get (?, \\\'xover\\\', ?, ?, ?)\', state, msg,\n"
"vector (_server, _out_name, _end, _begin), 100, meta, res);\n"
"else\n"
"exec (\'select nntp_auth_get (?, ?, ?, \\\'xover\\\', ?, ?, ?)\', state, msg,\n"
"vector (_server, _user, _pass, _out_name, _end, _begin), 100, meta, res);\n"
"\n"
"if (msg <> \'\')\n"
"{\n"
"if (strstr (msg, \'423\'))\n"
"{\n"
"update DB.DBA.NEWS_GROUPS set NG_STAT = 3, NG_LAST_OUT = _begin + 1,\n"
"NG_UP_MESS = 0, NG_UP_TIME = now () where NG_GROUP = _group;\n"
"return 0;\n"
"}\n"
"update  DB.DBA.NEWS_GROUPS set  NG_STAT = 11 where NG_GROUP = _group;\n"
"signal (state, msg);\n"
"}\n"
"\n"
"_list := aref (aref (res, 0), 0);\n"
"len := length (_list);\n"
"\n"
"if (len = 0)\n"
"{\n"
"update DB.DBA.NEWS_GROUPS set NG_STAT = 3, NG_LAST_OUT = _begin + 1,\n"
"NG_UP_MESS = 0, NG_UP_TIME = now () where NG_GROUP = _group;\n"
"return 0;\n"
"}\n"
"\n"
"idx := 0;\n"
"err := 0;\n"
"_up := 0;\n"
"\n"
"while (idx < len)\n"
"{\n"
"_to_try := 3;\n"
"num := aref (aref (_list, idx), 0);\n"
"\n"
"if (length (aref (_list, idx)) > 5)\n"
"_id := aref (aref (_list, idx), 4);\n"
"else\n"
"_id := \'\';\n"
"\n"
"if (not exists (select 1 from DB.DBA.NEWS_MSG where NM_ID = _id))\n"
"{\n"
"while (_to_try > 0)\n"
"{\n"
"msg := \'00000\';\n"
"state := \'\';\n"
"if (_user = \'\')\n"
"exec (\'select nntp_get (?, \\\'article\\\', ?, ?, ?)\', state, msg,\n"
"vector (_server, _out_name, num, num), 100, meta, res);\n"
"else\n"
"exec (\'select nntp_auth_get (?, ?, ?, \\\'article\\\', ?, ?, ?)\', state, msg,\n"
"vector (_server, _user, _pass, _out_name, num, num), 100, meta, res);\n"
"\n"
"if (msg <> \'00000\')\n"
"{\n"
"_to_try := _to_try - 1;\n"
"err := err + 1;\n"
"}\n"
"else\n"
"_to_try := -5;\n"
"\n"
"}\n"
"\n"
"_in_art := aref (aref (res, 0), 0);\n"
"\n"
"if (length (_in_art) > 0 and _to_try = -5)\n"
"{\n"
"if (ns_add_msg ((aref (aref (_in_art, 0), 1)) , _group , my_last))\n"
"{\n"
"_up := _up + 1;\n"
"update  DB.DBA.NEWS_GROUPS set\n"
"NG_LAST = NG_NEXT_NUM, NG_NUM = NG_NUM + 1,\n"
"NG_LAST_OUT = num, NG_UP_MESS = _up, NG_STAT = 3, NG_NEXT_NUM = NG_NEXT_NUM + 1,\n"
"NG_FIRST = min_num, NG_UP_TIME = now () where NG_GROUP = _group;\n"
"}\n"
"\n"
"commit work;\n"
"}\n"
"\n"
"if (err > 10)\n"
"{\n"
"update  DB.DBA.NEWS_GROUPS set NG_STAT = 0 where NG_GROUP = _group;\n"
"my_last := num;\n"
"return idx;\n"
"}\n"
"}\n"
"else\n"
"{\n"
"if (not exists (select 1 from  DB.DBA.NEWS_MULTI_MSG\n"
"where NM_GROUP = _group and NM_KEY_ID = _id))\n"
"{\n"
"my_last := my_last + 1;\n"
"insert soft DB.DBA.NEWS_MULTI_MSG (NM_KEY_ID, NM_GROUP, NM_NUM_GROUP)\n"
"values ( _id, _group, my_last);\n"
"update  DB.DBA.NEWS_GROUPS set\n"
"NG_LAST = NG_NEXT_NUM, NG_NUM = NG_NUM + 1,\n"
"NG_LAST_OUT = num, NG_STAT = 3, NG_NEXT_NUM = NG_NEXT_NUM + 1,\n"
"NG_FIRST = min_num, NG_UP_TIME = now () where NG_GROUP = _group;\n"
"\n"
"commit work;\n"
"}\n"
"}\n"
"idx := idx + 1;\n"
"}\n"
"\n"
"\n"
"my_last := num;\n"
"return len;\n"
"}\n"
"--src nn_svr.sql:571\n"
;

static const char *proc116 = 
"#line 711 \"[executable]/nn_svr.sql\"\n"
"create procedure\n"
"new_news (in _group_in any, in _scheduler_grop integer := 0)\n"
"{\n"
"declare _out_name varchar;\n"
"declare _server varchar;\n"
"declare _ns_server, _ns_user, _ns_pass varchar;\n"
"declare _group, new_f, new_l, t_last, t_new, t_stat, _ng_server, _ns_port integer;\n"
"declare old_f, old_l, my_last, pass, _ng_stat integer;\n"
"declare _gr_num, _t_upd any;\n"
"\n"
"\n"
"\n"
"if (_scheduler_grop)\n"
"_group_in := _scheduler_grop;\n"
"\n"
"if (isinteger (_group_in))\n"
"select NG_NAME, NG_FIRST, NG_LAST_OUT, NG_PASS, NG_SERVER, NG_GROUP, NG_LAST, NG_UP_TIME, NG_STAT\n"
"into _out_name, old_f, old_l, pass, _ng_server, _group, my_last, _t_upd, t_stat\n"
"from DB.DBA.NEWS_GROUPS where NG_GROUP = _group_in;\n"
"else\n"
"select NG_NAME, NG_FIRST, NG_LAST_OUT, NG_PASS, NG_SERVER, NG_GROUP, NG_LAST, NG_UP_TIME, NG_STAT\n"
"into _out_name, old_f, old_l, pass, _ng_server, _group, my_last, _t_upd, t_stat\n"
"from DB.DBA.NEWS_GROUPS where NG_NAME = _group_in;\n"
"\n"
"if (_t_upd is not null)\n"
"{\n"
"if ((datediff (\'minute\', _t_upd, now ()) < 1) and (t_stat <> 0))\n"
"return 0;\n"
"}\n"
"\n"
"if (old_f is NULL)\n"
"ns_up_num (_group);\n"
"\n"
"if (_ng_server is NULL)\n"
"{\n"
"update  DB.DBA.NEWS_GROUPS set NG_UP_TIME = now(), NG_UP_MESS = 0,\n"
"NG_STAT = 1 where NG_GROUP = _group;\n"
"return 0;\n"
"}\n"
"\n"
"_ns_server := NULL;\n"
"\n"
"{ declare exit handler for not found { signal (\'42000\', \'Newsserver not found !\'); };\n"
"\n"
"select NS_SERVER, NS_PORT, NS_USER, NS_PASS into _ns_server, _ns_port, _ns_user, _ns_pass\n"
"from DB.DBA.NEWS_SERVERS where NS_ID = _ng_server; }\n"
"\n"
"update DB.DBA.NEWS_GROUPS set NG_STAT = 0 where NG_STAT = 9;\n"
"update DB.DBA.NEWS_GROUPS set NG_STAT = 9 where NG_GROUP = _group;\n"
"\n"
"commit work;\n"
"\n"
"if (_ns_user is NULL)\n"
"_ns_user := \'\';\n"
"\n"
"if (_ns_pass is NULL)\n"
"_ns_pass := \'\';\n"
"\n"
"_ng_stat := 1;\n"
"_server := sprintf (\'%s:%i\', _ns_server, _ns_port);\n"
"\n"
"if (_ns_user = \'\')\n"
"_gr_num := nntp_get (_server, \'group\', _out_name);\n"
"else\n"
"_gr_num := nntp_auth_get (_server, _ns_user, _ns_pass, \'group\', _out_name);\n"
"\n"
"new_f := aref (_gr_num, 1);\n"
"new_l := aref (_gr_num, 2);\n"
"t_last := new_l;\n"
"\n"
"if ((new_l - old_l) <= 0)\n"
"{\n"
"update  DB.DBA.NEWS_GROUPS set NG_UP_TIME = now(), NG_UP_MESS = 0, NG_STAT = 1 where NG_GROUP = _group;\n"
"return 0;\n"
"}\n"
"\n"
"if (old_l = 0 and pass <> 0)\n"
"new_l :=  new_f + pass - 1;\n"
"else\n"
"{\n"
"if (old_l > new_f)\n"
"new_f := old_l + 1;\n"
"else\n"
"new_f := old_l;\n"
"\n"
"if (pass <> 0)\n"
"new_l := old_l + pass;\n"
"}\n"
"\n"
"t_new := ns_mirror_news (_server, _out_name, _group, my_last, new_f, new_l, _ns_user, _ns_pass);\n"
"\n"
"if (my_last >= t_last)\n"
"update DB.DBA.NEWS_GROUPS set NG_STAT = 1 where NG_GROUP = _group;\n"
"\n"
"ns_up_num (_group);\n"
"\n"
"return t_new;\n"
"}\n"
"--src nn_svr.sql:709\n"
;

static const char *proc117 = 
"#line 815 \"[executable]/nn_svr.sql\"\n"
"create procedure\n"
"ns_up_num (in gr_n integer)\n"
"{\n"
"declare all_mess, max_num, min_num, last_num integer;\n"
"\n"
"select count (*), min (NM_NUM_GROUP), max (NM_NUM_GROUP)\n"
"into all_mess, min_num, max_num from DB.DBA.NEWS_MULTI_MSG where NM_GROUP = gr_n;\n"
"\n"
"select NG_NEXT_NUM into last_num from DB.DBA.NEWS_GROUPS where NG_GROUP = gr_n;\n"
"\n"
"if (last_num is NULL) last_num := 0;\n"
"if (min_num is NULL) min_num := last_num;\n"
"if (max_num is NULL) max_num := last_num;\n"
"\n"
"update DB.DBA.NEWS_GROUPS set NG_NUM = all_mess, NG_FIRST = min_num, NG_LAST = max_num\n"
"where NG_GROUP = gr_n;\n"
"\n"
"commit work;\n"
"}\n"
"--src nn_svr.sql:813\n"
;

static const char *proc118 = 
"#line 837 \"[executable]/nn_svr.sql\"\n"
"create procedure\n"
"ns_date (in _in_str varchar)\n"
"{\n"
"declare res varchar;\n"
"\n"
"res := concat (\'20\', \"LEFT\" (_in_str, 2),\'-\');\n"
"res := concat (res, subseq (_in_str, 2, 4),\'-\');\n"
"res := concat (res, subseq (_in_str, 4, 6),\' \');\n"
"res := concat (res, subseq (_in_str, 7, 9),\':\');\n"
"res := concat (res, subseq (_in_str, 9, 11));\n"
"\n"
"return stringdate (res);\n"
"}\n"
"--src nn_svr.sql:835\n"
;

static const char *proc119 = 
"#line 853 \"[executable]/nn_svr.sql\"\n"
"create procedure\n"
"news_auto_update_event ()\n"
"{\n"
"declare _server varchar;\n"
"declare _time integer;\n"
"for (select NG_GROUP, NG_UP_TIME, NG_UP_INT\n"
"from DB.DBA.NEWS_GROUPS where NG_AUTO = 1) do\n"
"{\n"
"_time := NG_UP_INT - datediff (\'minute\', NG_UP_TIME, now ());\n"
"if (_time < 0 )\n"
"new_news (NG_GROUP);\n"
"}\n"
"}\n"
"--src nn_svr.sql:851\n"
;

static const char *proc120 = 
"#line 869 \"[executable]/nn_svr.sql\"\n"
"create procedure\n"
"news_update_admin_vsp ()\n"
"{\n"
"declare _server, _up_group, _del, state, msg, _group_detail varchar;\n"
"declare idx, len integer;\n"
"declare res, groups any;\n"
"\n"
"groups := vector ();\n"
"set isolation=\'committed\';\n"
"\n"
"for (select NG_GROUP from DB.DBA.NEWS_GROUPS where NG_STAT = 7 order by NG_NAME) do\n"
"groups := vector_concat (groups, vector (NG_GROUP));\n"
"\n"
"len := length (groups);\n"
"idx := 0;\n"
"\n"
"while (idx < len)\n"
"{\n"
"state := \'00000\';\n"
"exec (\'select new_news (?)\', state, msg, vector (aref (groups, idx)));\n"
"idx := idx + 1;\n"
"}\n"
"\n"
"delete from DB.DBA.SYS_SCHEDULED_EVENT where SE_SQL = \'news_update_admin_vsp()\';\n"
"}\n"
"--src nn_svr.sql:867\n"
;

static const char *proc121 = 
"#line 903 \"[executable]/nn_svr.sql\"\n"
"create procedure\n"
"ns_quit (inout mode integer)\n"
"{\n"
"pop_write (\'205 Virtuoso News server signing off.\');\n"
"mode := 2;\n"
"}\n"
"--src nn_svr.sql:901\n"
;

static const char *proc122 = 
"#line 912 \"[executable]/nn_svr.sql\"\n"
"create procedure\n"
"ns_help ()\n"
"{\n"
"declare help_text varchar;\n"
"\n"
"help_text :=\n"
"\'100 Legal commands\n"
"article [MessageID|Number]\n"
"body [Number]\n"
"group newsgroup\n"
"head [Number]\n"
"help\n"
"last\n"
"list\n"
"mode reader\n"
"newgroups yymmdd hhmmss\n"
"* newnews newsgroups yymmdd hhmmss [\"GMT\"] [<distributions>]\n"
"next\n"
"post\n"
"xover [range]\n"
"stat [MessageID|Number]\n"
".\';\n"
"\n"
"pop_write (help_text);\n"
"}\n"
"--src nn_svr.sql:910\n"
;

static const char *proc123 = 
"#line 940 \"[executable]/nn_svr.sql\"\n"
"create procedure\n"
"ns_list (in arg varchar)\n"
"{\n"
"declare _type varchar;\n"
"\n"
"if (arg = \'\')\n"
"{\n"
"pop_write (\'215 Newsgroups in form \"group high low flags\".\');\n"
"for (select NG_NAME, NG_LAST, NG_FIRST, NG_POST, NG_GROUP from DB.DBA.NEWS_GROUPS\n"
"where ns_rest (NG_GROUP, 0) = 1 order by NG_NAME) do\n"
"{\n"
"if (NG_POST = 1 and ns_rest (NG_GROUP, 1) = 1)\n"
"_type := \'y\';\n"
"else\n"
"_type := \'n\';\n"
"pop_write (sprintf (\'%s %i %i %s\', NG_NAME, NG_LAST, NG_FIRST, _type));\n"
"}\n"
"pop_write (\'.\');\n"
"}\n"
"else\n"
"pop_write (\'501 command syntax error.\');\n"
"}\n"
"--src nn_svr.sql:938\n"
;

static const char *proc124 = 
"#line 964 \"[executable]/nn_svr.sql\"\n"
"create procedure ns_auth (in arg any)\n"
"{\n"
"declare uid, _user, tmp, data, tok any;\n"
"\n"
"tmp := split_and_decode (arg, 0, \'\\0\\0 \');\n"
"_user := connection_get (\'nntp_uid\');\n"
"\n"
"if (length (tmp) < 1)\n"
"{\n"
"pop_write (\'500 Command not understood\');\n"
"return;\n"
"}\n"
"\n"
"tok := lower (tmp[0]);\n"
"\n"
"if (length (tmp) > 1)\n"
"data := tmp[1];\n"
"else\n"
"data := \'\';\n"
"\n"
"if ((tok = \'user\' and _user is not null and connection_get (\'nntp_authenticated\') is null) or (tok = \'pass\' and _user is null))\n"
"{\n"
"connection_set (\'nntp_uid\', null);\n"
"connection_set (\'nntp_authenticated\', null);\n"
"pop_write (\'482 Authentication rejected\');\n"
"return;\n"
"}\n"
"\n"
"if (tok = \'user\')\n"
"{\n"
"connection_set (\'nntp_uid\', data);\n"
"\n"
"pop_write (\'381 More authentication information required\');\n"
"}\n"
"else if (tok = \'pass\' and _user is not null)\n"
"{\n"
"declare exit handler for not found\n"
"{\n"
"connection_set (\'nntp_uid\', null);\n"
"if (connection_get (\'nntp_authenticated\') is not null)\n"
"pop_write (\'482 Authentication rejected\');\n"
"else\n"
"pop_write (\'502 No permission\');\n"
"connection_set (\'nntp_authenticated\', null);\n"
"return;\n"
"};\n"
"\n"
"select U_ID into uid from SYS_USERS where U_NAME = _user and\n"
"pwd_magic_calc (U_NAME, U_PASSWORD, 1) = data and\n"
"U_IS_ROLE = 0 and U_ACCOUNT_DISABLED = 0 and U_DAV_ENABLE = 1;\n"
"\n"
"connection_set (\'nntp_authenticated\', 1);\n"
"pop_write (\'281 Authentication accepted\');\n"
"}\n"
"else\n"
"{\n"
"connection_set (\'nntp_uid\', null);\n"
"connection_set (\'nntp_authenticated\', null);\n"
"pop_write (\'480 Authentication required\');\n"
"}\n"
"}\n"
"--src nn_svr.sql:962\n"
;

static const char *proc125 = 
"#line 1027 \"[executable]/nn_svr.sql\"\n"
"create procedure\n"
"ns_group (in arg varchar, inout _activ integer, inout _cur integer, inout _min integer, inout _max integer, inout _grp_type varchar)\n"
"{\n"
"declare _num integer;\n"
"\n"
"if (arg = \'\')\n"
"{\n"
"pop_write (\'501 newsgroup\');\n"
"return;\n"
"}\n"
"\n"
"if (exists (select 1 from DB.DBA.NEWS_GROUPS where NG_NAME = arg and ns_rest (NG_GROUP, 0) = 1))\n"
"{\n"
"select NG_GROUP, NG_NUM, NG_FIRST, NG_LAST, NG_TYPE into _activ, _num, _min, _max, _grp_type\n"
"from DB.DBA.NEWS_GROUPS where NG_NAME = arg;\n"
"pop_write (sprintf (\'211 %d %d %d %s\', _num, _min, _max, arg));\n"
"_cur := _min;\n"
"}\n"
"else\n"
"pop_write (sprintf (\'411 No such group %s\', arg));\n"
"\n"
"}\n"
"--src nn_svr.sql:1025\n"
;

static const char *proc126 = 
"#line 1052 \"[executable]/nn_svr.sql\"\n"
"create procedure\n"
"ns_next (in arg varchar, in _activ integer, inout _cur integer, in _min integer, in _max integer)\n"
"{\n"
"declare _id varchar;\n"
"\n"
"if (ns_valid (arg, _activ, _cur, _min, _max, 1) = 0 )\n"
"return;\n"
"\n"
"_cur := _cur + 1;\n"
"\n"
"if (ns_valid (arg, _activ, _cur, _min, _max, 0) = 0 )\n"
"ns_next (arg, _activ, _cur, _min, _max);\n"
"\n"
"select NM_KEY_ID into _id from DB.DBA.NEWS_MULTI_MSG where NM_GROUP = _activ and NM_NUM_GROUP = _cur;\n"
"\n"
"pop_write (sprintf (\'223 %i %s Article retrieved; request text separately.\', _cur, _id));\n"
"\n"
"}\n"
"--src nn_svr.sql:1050\n"
;

static const char *proc127 = 
"#line 1073 \"[executable]/nn_svr.sql\"\n"
"create procedure\n"
"ns_last (in arg varchar, in _activ integer, inout _cur integer, in _min integer, in _max integer)\n"
"{\n"
"declare _id varchar;\n"
"\n"
"if (ns_valid (arg, _activ, _cur, _min, _max, 2) = 0 )\n"
"return;\n"
"\n"
"_cur := _cur - 1;\n"
"\n"
"if (ns_valid (arg, _activ, _cur, _min, _max, 0) = 0 )\n"
"ns_last (arg, _activ, _cur, _min, _max);\n"
"\n"
"select NM_KEY_ID into _id from DB.DBA.NEWS_MULTI_MSG where NM_GROUP = _activ and NM_NUM_GROUP = _cur;\n"
"\n"
"pop_write (sprintf (\'223 %i %s Article retrieved; request text separately.\', _cur, _id));\n"
"\n"
"}\n"
"--src nn_svr.sql:1071\n"
;

static const char *proc128 = 
"#line 1094 \"[executable]/nn_svr.sql\"\n"
"create procedure\n"
"ns_head (in arg varchar, inout _activ integer, inout _cur integer, inout _grp_type varchar)\n"
"{\n"
"declare _body_beg, _body_end integer;\n"
"declare _id varchar;\n"
"declare _head, _body any;\n"
"\n"
"if (arg <> \'\')\n"
"_cur := atoi (arg);\n"
"\n"
"declare cr cursor for select NM_KEY_ID from DB.DBA.NEWS_MULTI_MSG\n"
"where NM_GROUP = _activ and NM_NUM_GROUP = _cur or NM_KEY_ID = arg;\n"
"\n"
"whenever not found goto nf;\n"
"open cr (prefetch 1);\n"
"fetch cr into _id;\n"
"goto next;\n"
"nf:\n"
"close cr;\n"
"pop_write (\'423 no such article number in group\');\n"
"return;\n"
"next:\n"
"select NM_BODY, NM_HEAD into _body, _head from DB.DBA.NEWS_MSG\n"
"where NM_ID = _id and NM_TYPE = _grp_type;\n"
"\n"
"_head := deserialize (_head);\n"
"_body_beg := aref (aref (_head, 1), 0);\n"
"_body_end := aref (aref (_head, 1), 1);\n"
"_head := subseq (blob_to_string (_body), 0, _body_beg - 1);\n"
"\n"
"pop_write (sprintf (\'221 %i %s head\', _cur, _id));\n"
"ses_write (_head);\n"
"pop_write (\'\');\n"
"pop_write (\'.\');\n"
"\n"
"close cr;\n"
"}\n"
"--src nn_svr.sql:1092\n"
;

static const char *proc129 = 
"#line 1134 \"[executable]/nn_svr.sql\"\n"
"create procedure\n"
"ns_body (in arg varchar, inout _activ integer, inout _cur integer, inout grp_type varchar)\n"
"{\n"
"declare _read, _body_beg, _body_end integer;\n"
"declare _id  varchar;\n"
"declare _body, _head any;\n"
"\n"
"if (arg <> \'\')\n"
"_cur := atoi (arg);\n"
"\n"
"declare cr cursor for select NM_KEY_ID from DB.DBA.NEWS_MULTI_MSG\n"
"where NM_GROUP = _activ and NM_NUM_GROUP = _cur;\n"
"\n"
"whenever not found goto nf;\n"
"open cr (prefetch 1);\n"
"fetch cr into _id;\n"
"goto next;\n"
"nf:\n"
"close cr;\n"
"pop_write (\'423 no such article number in group\');\n"
"return;\n"
"next:\n"
"select NM_BODY, NM_HEAD, NM_READ into _body, _head, _read from DB.DBA.NEWS_MSG\n"
"where NM_ID = _id and NM_TYPE = grp_type;\n"
"close cr;\n"
"\n"
"_head := deserialize (_head);\n"
"_body_beg := aref (aref (_head, 1), 0);\n"
"_body_end := aref (aref (_head, 1), 1);\n"
"_body := subseq (blob_to_string (_body), _body_beg, _body_end + 1);\n"
"\n"
"update DB.DBA.NEWS_MSG set  NM_READ = _read + 1 where NM_ID = _id and NM_TYPE = grp_type;\n"
"\n"
"pop_write (sprintf (\'221 %i %s body\', _cur, _id));\n"
"ses_write (_body);\n"
"}\n"
"--src nn_svr.sql:1132\n"
;

static const char *proc130 = 
"#line 1173 \"[executable]/nn_svr.sql\"\n"
"create procedure\n"
"ns_article (in arg varchar, inout _activ integer, inout _cur integer)\n"
"{\n"
"declare _read integer;\n"
"declare _id, _head varchar;\n"
"declare _body any;\n"
"\n"
"if (arg <> \'\')\n"
"{\n"
"if (\"LEFT\" (arg, 1) = \'<\')\n"
"{\n"
"declare cr cursor for select NM_BODY, NM_READ from DB.DBA.NEWS_MSG\n"
"where NM_ID = arg;\n"
"whenever not found goto nf1;\n"
"open cr (prefetch 1);\n"
"fetch cr into _body, _read;\n"
"goto next1;\n"
"nf1:\n"
"close cr;\n"
"pop_write (\'430 No such article\');\n"
"return;\n"
"next1:\n"
"_id := arg;\n"
"close cr;\n"
"}\n"
"else\n"
"{\n"
"_cur := atoi (arg);\n"
"declare cr cursor for select NM_KEY_ID from DB.DBA.NEWS_MULTI_MSG\n"
"where NM_GROUP = _activ and NM_NUM_GROUP = _cur;\n"
"\n"
"if (ns_rest_rate_read (_activ) > 0)\n"
"{\n"
"pop_write (\'440 Excessive read detected, please try again later.\');\n"
"return;\n"
"}\n"
"\n"
"whenever not found goto nf2;\n"
"open cr (prefetch 1);\n"
"fetch cr into _id;\n"
"goto next2;\n"
"nf2:\n"
"close cr;\n"
"pop_write (\'423 no such article number in group\');\n"
"return;\n"
"next2:\n"
"select NM_BODY, NM_READ into _body, _read from DB.DBA.NEWS_MSG\n"
"where NM_ID = _id;\n"
"close cr;\n"
"}\n"
"}\n"
"else\n"
"{\n"
"if (_activ = 0 and _cur = 1)\n"
"{\n"
"pop_write (\'412 Not in a newsgroup\');\n"
"return 0;\n"
"}\n"
"\n"
"select NM_KEY_ID into _id from DB.DBA.NEWS_MULTI_MSG\n"
"where NM_GROUP = _activ and NM_NUM_GROUP = _cur;\n"
"select NM_BODY, NM_READ into _body, _read from DB.DBA.NEWS_MSG\n"
"where NM_ID = _id;\n"
"}\n"
"\n"
"update DB.DBA.NEWS_MSG set NM_READ = _read + 1 where NM_ID = _id;\n"
"\n"
"pop_write (sprintf (\'220 %i %s article\', _cur, _id));\n"
"ses_write (_body);\n"
"}\n"
"--src nn_svr.sql:1171\n"
;

static const char *proc131 = 
"#line 1246 \"[executable]/nn_svr.sql\"\n"
"create procedure\n"
"ns_xover (in arg varchar, in activ integer, in cur integer, in grp_type varchar)\n"
"{\n"
"declare _id, _subj, _from, _date, _ref, _line, _xref varchar;\n"
"declare _begin, _end, _size_msg, _nm_num_group integer;\n"
"declare _body, _head any;\n"
"\n"
"if (arg <> \'\')\n"
"{\n"
"_begin := atoi (subseq (arg, 0, strstr (arg, \'-\'))) - 1;\n"
"_end := - atoi (subseq (arg, strstr (arg, \'-\') )) + 1;\n"
"if (_begin > _end)\n"
"{\n"
"pop_write (\'501 range\');\n"
"return;\n"
"}\n"
"}\n"
"else\n"
"{\n"
"_begin := cur - 1;\n"
"_end := cur;\n"
"}\n"
"\n"
"pop_write (\'224 data follows\');\n"
"\n"
"declare cr cursor for select NM_BODY, NM_HEAD, NM_ID, NM_NUM_GROUP from DB.DBA.NEWS_MSG, DB.DBA.NEWS_MULTI_MSG\n"
"where NM_ID = NM_KEY_ID and NM_GROUP = activ and NM_TYPE = grp_type and NM_NUM_GROUP > _begin and NM_NUM_GROUP < _end\n"
"order by NM_NUM_GROUP;\n"
"\n"
"whenever not found goto nf;\n"
"open cr (prefetch 1);\n"
"\n"
"while (1)\n"
"{\n"
"fetch cr into _body, _head, _id, _nm_num_group;\n"
"_head := deserialize (blob_to_string (_head));\n"
"if (__tag (_head) <> 193)\n"
"_head := mime_tree (blob_to_string (_body));\n"
"_head := aref (_head, 0);\n"
"_subj := coalesce (get_keyword_ucase (\'Subject\', _head), \'\');\n"
"_from := coalesce (get_keyword_ucase (\'From\', _head), \'\');\n"
"_date := coalesce (get_keyword_ucase (\'Date\', _head), \'\');\n"
"_line := coalesce (get_keyword_ucase (\'Lines\', _head), \'\');\n"
"_xref := coalesce (get_keyword_ucase (\'Xref\', _head), \'\');\n"
"_ref := coalesce (get_keyword_ucase (\'References\', _head), \'\');\n"
"_size_msg := length (_body);\n"
"\n"
"pop_write (concat (cast (_nm_num_group as varchar), \'\\t\', _subj, \'\\t\', _from, \'\\t\',\n"
"_date, \'\\t\', cast (_id as varchar), \'\\t\', _ref, \'\\t\', cast (_size_msg as varchar),\n"
"\'\\t\', cast (_line as varchar), \'\\t\' , _xref));\n"
"}\n"
"\n"
"nf:\n"
"close cr;\n"
"pop_write (\'.\');\n"
"\n"
"return;\n"
"}\n"
"--src nn_svr.sql:1244\n"
;

static const char *proc132 = 
"#line 1307 \"[executable]/nn_svr.sql\"\n"
"create procedure\n"
"ns_newgroups (in arg varchar)\n"
"{\n"
"declare x integer;\n"
"declare _type varchar;\n"
"\n"
"if ((arg = \'\') or (length (arg) < 11))\n"
"{\n"
"pop_write (\'501 yymmdd hhmmss\');\n"
"return;\n"
"}\n"
"\n"
"pop_write (\'231 New newsgroups follow.\');\n"
"\n"
"for (select NG_NAME, NG_FIRST, NG_LAST, NG_POST from DB.DBA.NEWS_GROUPS\n"
"where NG_CREAT > ns_date (arg) and ns_rest (NG_GROUP, 0) = 1) do\n"
"{\n"
"if (NG_POST = 1)\n"
"_type := \'y\';\n"
"else\n"
"_type := \'n\';\n"
"pop_write (sprintf (\'%s %d %d %s\', NG_NAME, NG_LAST, NG_FIRST, _type));\n"
"}\n"
"pop_write (\'.\');\n"
"}\n"
"--src nn_svr.sql:1305\n"
;

static const char *proc133 = 
"#line 1335 \"[executable]/nn_svr.sql\"\n"
"create procedure\n"
"ns_stat (in arg varchar, inout _activ integer, inout _cur integer)\n"
"{\n"
"declare _id varchar;\n"
"\n"
"if (_activ = 0)\n"
"{\n"
"pop_write (\'412 Not in a newsgroup\');\n"
"return 0;\n"
"}\n"
"\n"
"if (arg <> \'\')\n"
"_cur := atoi (arg);\n"
"\n"
"select NM_KEY_ID into _id from DB.DBA.NEWS_MULTI_MSG\n"
"where NM_GROUP = _activ and NM_NUM_GROUP = _cur;\n"
"\n"
"pop_write (sprintf (\'223 %i %s stat\', _cur, _id));\n"
"}\n"
"--src nn_svr.sql:1333\n"
;

static const char *proc134 = 
"#line 1357 \"[executable]/nn_svr.sql\"\n"
"create procedure\n"
"ns_post_write_out (in _text varchar)\n"
"{\n"
"if (connection_get (\'NNTP_SERVER_MODE\') is null)\n"
"signal (\'24000\', _text);\n"
"else\n"
"pop_write (_text);\n"
"}\n"
"--src nn_svr.sql:1355\n"
;

static const char *proc135 = 
"#line 1371 \"[executable]/nn_svr.sql\"\n"
"create procedure\n"
"ns_post (in _message any)\n"
"{\n"
"declare _from, _newsgroups, _ref, _id, _id_old, _news_all, _org, grp_type varchar;\n"
"declare _parse, _head, _body, _nntp_path, _nntp_phost, _news_gr_list any;\n"
"declare _ng_group, _num, _ng_num, _mode, _fng_server, _check_addr, _retr integer;\n"
"\n"
"_mode := 1;\n"
"\n"
"if (isnull (_message))\n"
"{\n"
"_mode := 2;\n"
"_message := \'\';\n"
"}\n"
"\n"
"_head := \'\';\n"
"_ref := \'\';\n"
"_from := \'\';\n"
"\n"
"if (_mode = 2)\n"
"{\n"
"pop_write (\'340 Ok\');\n"
"_message := ns_read_message ();\n"
"}\n"
"\n"
"if (length (_message) > 10000000)\n"
"{\n"
"ns_post_write_out (\'441 posting failed article too big (over 10 MB)\');\n"
"return;\n"
"}\n"
"\n"
"_parse := mime_tree (_message);\n"
"_head := aref (_parse, 0);\n"
"\n"
"if ((isnull (_head)) or (_head = 0))\n"
"{\n"
"ns_post_write_out (\'441 posting failed bad header\');\n"
"return;\n"
"}\n"
"\n"
"_from := get_keyword_ucase (\'From\', _head);\n"
"_ref := get_keyword_ucase (\'References\', _head);\n"
"_id := get_keyword_ucase (\'Message-ID\', _head);\n"
"_nntp_path := get_keyword_ucase (\'Path\', _head);\n"
"_nntp_phost := get_keyword_ucase (\'NNTP-Posting-Host\', _head);\n"
"\n"
"_newsgroups := get_keyword_ucase (\'Newsgroups\', _head);\n"
"_check_addr := strstr (_from, \'@\');\n"
"if (_check_addr = 0)\n"
"_check_addr := NULL;\n"
"\n"
"if (isnull(_from))\n"
"{\n"
"ns_post_write_out (\'441 Required \"From\" header is missing\');\n"
"return;\n"
"}\n"
"\n"
"if (isnull(_check_addr))\n"
"{\n"
"ns_post_write_out (\'441 From: address not in Internet syntax\');\n"
"return;\n"
"}\n"
"\n"
"if (isnull(_newsgroups))\n"
"{\n"
"ns_post_write_out (\'441 Required \"Newsgroups\" header is missing\');\n"
"return;\n"
"}\n"
"\n"
"if (isnull(get_keyword_ucase (\'Subject\', _head)))\n"
"{\n"
"ns_post_write_out (\'441 Required \"Subject\" header is missing\');\n"
"return;\n"
"}\n"
"\n"
"if (not (strstr (_from, \'<\') is NULL))\n"
"_from := subseq (_from, strstr (_from, \'@\') + 1, strstr (_from, \'>\'));\n"
"\n"
"if (strstr (ucase (get_keyword_ucase (\'Control\', _head)), \'CANCEL\') is not NULL)\n"
"{\n"
"pop_write (\'240 Article posted\');\n"
"ns_cancel_message (get_keyword_ucase (\'Control\', _head), _message);\n"
"return;\n"
"}\n"
"\n"
"if (isnull(_id))\n"
"{\n"
"_id := MD5 (concat (_message, cast (now () as varchar)));\n"
"_id := concat (\'<\', _id, \'@\', _from, \'>\');\n"
"_message := concat (\'Message-ID: \', _id, chr (13), chr (10), _message);\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"if (isnull(_nntp_path))\n"
"{\n"
"_nntp_path := concat (registry_get (\'__nntp_from_header\'), \'!not-for-mail\');\n"
"_message := concat (\'Path: \', _nntp_path, chr (13), chr (10), _message);\n"
"}\n"
"else\n"
"nntp_update_message_path (_message, _nntp_path);\n"
"\n"
"_org := registry_get (\'__nntp_organization_header\');\n"
"\n"
"if (_org <> \'\')\n"
"_message := concat (\'Organization: \', _org, chr (13), chr (10), _message);\n"
"\n"
"_parse := mime_tree (_message);\n"
"_body := _message;\n"
"\n"
"set isolation=\'repeatable\';\n"
"\n"
"_news_gr_list := split_and_decode (_newsgroups, 0, \'\\0\\0,\');\n"
"_news_all := concat (_newsgroups, \',\');\n"
"if (exists (select 1 from DB.DBA.NEWS_MSG where NM_ID = _id))\n"
"{\n"
"ns_post_write_out (\'441 435 Duplicate\');\n"
"return;\n"
"}\n"
"\n"
"if (exists (select 1 from DB.DBA.NEWS_GROUPS where\n"
"ns_rest (NG_GROUP, 1) = 0 and position (NG_NAME, _news_gr_list)))\n"
"{\n"
"ns_post_write_out (\'440 Posting not allowed.\');\n"
"return;\n"
"}\n"
"\n"
"if (exists (select 1 from DB.DBA.NEWS_GROUPS where\n"
"ns_rest_rate (NG_GROUP, 1) = -2 and position (NG_NAME, _news_gr_list)))\n"
"{\n"
"ns_post_write_out (\'440 Excessive posting detected, please try again later.\');\n"
"return;\n"
"}\n"
"\n"
"\n"
"\n"
"while (not (strstr (_news_all, \',\') is null))\n"
"{\n"
"_newsgroups := \"LEFT\" (_news_all, strstr (_news_all, \',\'));\n"
"_news_all := subseq (_news_all, length (_newsgroups) + 1 ,length (_news_all));\n"
"whenever not found goto nf;\n"
"\n"
"declare cr cursor for select NG_GROUP, coalesce (NG_NEXT_NUM, 0) + 1,\n"
"coalesce (NG_NUM, 0) + 1, NG_SERVER, NG_TYPE\n"
"from DB.DBA.NEWS_GROUPS where NG_NAME = _newsgroups order by NG_GROUP;\n"
"open cr (exclusive, prefetch 1);\n"
"fetch cr into _ng_group, _num, _ng_num, _fng_server, grp_type;\n"
"goto next;\n"
"nf:\n"
"close cr;\n"
"pop_write (sprintf (\'441 group %s not exist\', _newsgroups));\n"
"rollback work;\n"
"return;\n"
"next:\n"
"\n"
"declare exit handler for sqlstate \'CONV*\' {\n"
"declare msg any;\n"
"msg := regexp_match (\'[^\\r\\n]*\', __SQL_MESSAGE);\n"
"rollback work;\n"
"\n"
"if (__SQL_STATE = \'CONVA\')\n"
"ns_post_write_out (\'480 Authentication required\');\n"
"else\n"
"ns_post_write_out (sprintf (\'441 %s\', msg));\n"
"return;\n"
"};\n"
"\n"
"_retr := registry_get (\'__nntp_self_retr\');\n"
"if (_retr = 0) _retr:= 3;\n"
"\n"
"insert soft DB.DBA.NEWS_MSG (NM_ID, NM_REF, NM_REC_DATE, NM_BODY,\n"
"NM_HEAD, NM_READ, NM_STAT, NM_TYPE, NM_TRY_POST)\n"
"values (_id, _ref, now(), _body, serialize (_parse), 0, 0, grp_type, _retr);\n"
"\n"
"insert soft DB.DBA.NEWS_MULTI_MSG (NM_KEY_ID, NM_GROUP, NM_NUM_GROUP)\n"
"values ( _id, _ng_group, _num);\n"
"\n"
"if (isinteger (registry_get (\'__nntpf_ver\')) = 0)\n"
"nntpf_update_thr_table (_ng_group);\n"
"\n"
"\n"
"if (_fng_server is not null)\n"
"update DB.DBA.NEWS_MSG set NM_STAT = (_ng_group + 1) where NM_ID = _id;\n"
"\n"
"update DB.DBA.NEWS_GROUPS set NG_LAST = NG_NEXT_NUM, NG_NUM = _ng_num, NG_NEXT_NUM = NG_NEXT_NUM + 1\n"
"where current of cr;\n"
"\n"
"close cr;\n"
"ns_up_num (_ng_group);\n"
"}\n"
"\n"
"if (_mode = 2)\n"
"{\n"
"pop_write (\'240 Article posted\');\n"
"ns_post_out ();\n"
"}\n"
"\n"
"if (isinteger (registry_get (\'__nntpf_ver\')) = 0)\n"
"ns_post_out_id (_id);\n"
"\n"
"\n"
"\n"
"\n"
"return _id;\n"
"}\n"
"--src nn_svr.sql:1369\n"
;

static const char *proc136 = 
"#line 1580 \"[executable]/nn_svr.sql\"\n"
"create procedure\n"
"ns_post_out ()\n"
"{\n"
"declare _nm_body, _nm_id, _nm_group any;\n"
"\n"
"whenever not found goto nf;\n"
"\n"
"declare cr cursor for select blob_to_string (NM_BODY), NM_ID\n"
"from DB.DBA.NEWS_MSG where NM_STAT > 0 and NM_TRY_POST is not NULL;\n"
"open cr (exclusive, prefetch 1);\n"
"while (1)\n"
"{\n"
"fetch cr into _nm_body, _nm_id;\n"
"select top 1 NM_GROUP into _nm_group from DB.DBA.NEWS_MULTI_MSG where NM_KEY_ID = _nm_id;\n"
"ns_post_out_core (_nm_body, _nm_id, _nm_group);\n"
"}\n"
"\n"
"nf:\n"
"close cr;\n"
"commit work;\n"
"\n"
"return;\n"
"}\n"
"--src nn_svr.sql:1578\n"
;

static const char *proc137 = 
"#line 1605 \"[executable]/nn_svr.sql\"\n"
"create procedure\n"
"ns_post_out_id (in _nm_id varchar)\n"
"{\n"
"declare _nm_body, _nm_group any;\n"
"\n"
"whenever not found goto nf;\n"
"\n"
"select top 1 NM_GROUP into _nm_group from DB.DBA.NEWS_MULTI_MSG where NM_KEY_ID = _nm_id;\n"
"\n"
"declare cr cursor for select blob_to_string (NM_BODY) from DB.DBA.NEWS_MSG where NM_ID = _nm_id;\n"
"\n"
"open cr (exclusive, prefetch 1);\n"
"\n"
"fetch cr into _nm_body;\n"
"\n"
"ns_post_out_core (_nm_body, _nm_id, _nm_group);\n"
"\n"
"nf:\n"
"close cr;\n"
"commit work;\n"
"\n"
"return;\n"
"}\n"
"--src nn_svr.sql:1603\n"
;

static const char *proc138 = 
"#line 1632 \"[executable]/nn_svr.sql\"\n"
"create procedure\n"
"ns_post_out_core (inout _nm_body any, inout _nm_id varchar, inout _group_in integer)\n"
"{\n"
"declare _ns_server, _ns_user, _ns_pass varchar;\n"
"declare state, msg varchar;\n"
"declare _ns_port, _ng_server integer;\n"
"\n"
"select NG_SERVER into _ng_server from DB.DBA.NEWS_GROUPS where NG_GROUP = _group_in;\n"
"\n"
"select NS_SERVER, NS_PORT, NS_USER, NS_PASS into _ns_server, _ns_port, _ns_user, _ns_pass\n"
"from DB.DBA.NEWS_SERVERS where NS_ID = _ng_server;\n"
"\n"
"_ng_server := sprintf (\'%s:%i\', _ns_server, _ns_port);\n"
"state := \'00000\';\n"
"commit work;\n"
"\n"
"if (_ns_user = \'\')\n"
"exec (\'nntp_post (?,?)\', state, msg, vector (_ng_server, _nm_body));\n"
"else\n"
"exec (\'nntp_auth_post (?,?,?,?)\', state, msg,\n"
"vector (_ng_server, _ns_user, _ns_pass, _nm_body));\n"
"\n"
"if (state = \'00000\' or msg like \'% 441 435 Duplicate%\')\n"
"update DB.DBA.NEWS_MSG set NM_STAT = 0, NM_TRY_POST = NULL where NM_ID= _nm_id;\n"
"else\n"
"update DB.DBA.NEWS_MSG set NM_TRY_POST = either (NM_TRY_POST - 1, NM_TRY_POST - 1, NULL) where NM_ID= _nm_id;\n"
"}\n"
"--src nn_svr.sql:1630\n"
;

static const char *proc139 = 
"#line 1662 \"[executable]/nn_svr.sql\"\n"
"create procedure\n"
"ns_xover_group (in _group varchar)\n"
"{\n"
"declare idx, _all, _nm_read integer;\n"
"declare _subj, _from, _nm_rec, _nm_id varchar;\n"
"declare res, _body, _head, temp any;\n"
"\n"
"select NG_NUM into _all from DB.DBA.NEWS_GROUPS where NG_GROUP = _group;\n"
"\n"
"res := make_array (_all, \'any\');\n"
"idx := 0;\n"
"\n"
"declare cr cursor for select NM_BODY, NM_HEAD, NM_ID, NM_READ\n"
"from DB.DBA.NEWS_MULTI_MSG, DB.DBA.NEWS_MSG\n"
"where NM_ID = NM_KEY_ID and NM_GROUP = _group;\n"
"\n"
"whenever not found goto nf;\n"
"open cr (prefetch 1);\n"
"\n"
"while (1)\n"
"{\n"
"fetch cr into _body, _head, _nm_id, _nm_read;\n"
"_head := deserialize (_head);\n"
"if (__tag (_head) <> 193)\n"
"_head := mime_tree (blob_to_string (_body));\n"
"_head := aref (_head, 0);\n"
"_subj := coalesce (get_keyword_ucase (\'Subject\', _head), \'\');\n"
"_from := coalesce (get_keyword_ucase (\'From\', _head), \'\');\n"
"_nm_rec := coalesce (get_keyword_ucase (\'Date\', _head), \'\');\n"
"\n"
"temp := vector (_nm_id, _subj, _from, _nm_rec, length (_body)/1024 + 1, _nm_read);\n"
"\n"
"aset (res, idx, temp);\n"
"idx := idx + 1;\n"
"}\n"
"\n"
"nf:\n"
"close cr;\n"
"\n"
"return res;\n"
"}\n"
"--src nn_svr.sql:1660\n"
;

static const char *proc140 = 
"#line 1706 \"[executable]/nn_svr.sql\"\n"
"create procedure\n"
"ns_make_index_content (inout _data any, in is_news_msg_body integer)\n"
"{\n"
"declare data, outp any;\n"
"declare line varchar;\n"
"declare in_UU integer;\n"
"\n"
"if (is_news_msg_body < 1)\n"
"return null;\n"
"data := string_output (http_strses_memory_size ());\n"
"http (_data, data);\n"
"\n"
"outp := string_output (http_strses_memory_size ());\n"
"\n"
"in_UU := 0;\n"
"while (1 = 1)\n"
"{\n"
"line := ses_read_line (data, 0);\n"
"if (line is null or isstring (line) = 0)\n"
"return string_output_string (outp);\n"
"\n"
"if (in_UU = 0 and subseq (line, 0, 6) = \'begin \' and length (line) > 6)\n"
"{\n"
"in_UU := 1;\n"
"}\n"
"else if (in_UU = 1 and subseq (line, 0, 3) = \'end\')\n"
"{\n"
"in_UU := 0;\n"
"}\n"
"else if (in_UU = 0)\n"
"{\n"
"http (line, outp);\n"
"http (\'\\n\', outp);\n"
"}\n"
"}\n"
"return string_output_string (outp);\n"
"}\n"
"--src nn_svr.sql:1704\n"
;

static const char *proc141 = 
"#line 1746 \"[executable]/nn_svr.sql\"\n"
"create procedure\n"
"ns_read_message ()\n"
"{\n"
"declare data any;\n"
"declare _read varchar;\n"
"\n"
"data := string_output (http_strses_memory_size ());\n"
"\n"
"while (1 = 1)\n"
"{\n"
"_read := ses_read_line ();\n"
"\n"
"http (_read, data);\n"
"http (\'\\r\\n\', data);\n"
"\n"
"if (_read = \'.\' or _read is null or isstring (_read) = 0)\n"
"return string_output_string (data);\n"
"}\n"
"}\n"
"--src nn_svr.sql:1744\n"
;

static const char *proc142 = 
"#line 1768 \"[executable]/nn_svr.sql\"\n"
"create procedure\n"
"ns_delete_message (in id varchar, in del_out any := NULL)\n"
"{\n"
"declare _nm_group, _ng_port, _ng_server integer;\n"
"declare _ng_last, _ng_first integer;\n"
"declare _ng_name varchar;\n"
"\n"
"declare cr cursor for select NM_GROUP\n"
"from DB.DBA.NEWS_MULTI_MSG where NM_KEY_ID = id;\n"
"\n"
"if (isinteger (registry_get (\'__nntpf_ver\')) = 0)\n"
"nntpf_delete_article_thr_table (id);\n"
"\n"
"whenever not found goto nf;\n"
"open cr (exclusive, prefetch 1);\n"
"while (1)\n"
"{\n"
"\n"
"fetch cr into _nm_group;\n"
"\n"
"select NG_LAST, NG_FIRST, NG_SERVER, NG_NAME\n"
"into _ng_last, _ng_first, _ng_server, _ng_name\n"
"from DB.DBA.NEWS_GROUPS where NG_GROUP = _nm_group;\n"
"\n"
"if (del_out is not NULL)\n"
"{\n"
"declare _ns_server, _ns_user, _ns_pass, state, msg, cancel_msg varchar;\n"
"declare _body, _head, _subj, _from, r_server varchar;\n"
"declare _ns_port integer;\n"
"\n"
"state := \'\';\n"
"msg := \'\';\n"
"\n"
"whenever not found goto del_it_locally;\n"
"\n"
"select NS_SERVER, NS_PORT, NS_USER, NS_PASS\n"
"into _ns_server, _ns_port, _ns_user, _ns_pass\n"
"from DB.DBA.NEWS_SERVERS where NS_ID = _ng_server;\n"
"\n"
"select NM_BODY, NM_HEAD into  _body, _head from DB.DBA.NEWS_MSG where NM_ID = id;\n"
"\n"
"r_server := sprintf (\'%s:%i\', _ns_server, _ns_port);\n"
"\n"
"if (isinteger (del_out))\n"
"{\n"
"_head := deserialize (_head);\n"
"if (__tag (_head) <> 193)\n"
"_head := mime_tree (blob_to_string (_body));\n"
"_head := aref (_head, 0);\n"
"_subj := coalesce (get_keyword_ucase (\'Subject\', _head), \'\');\n"
"_from := coalesce (get_keyword_ucase (\'From\', _head), \'\');\n"
"\n"
"cancel_msg := sprintf (\'From: %s\\nNewsgroups: %s\\nSubject: %s\\nControl: cancel %s\\nLines: 0\\n\\n\\n.\\n\',\n"
"_from, _ng_name, _subj, id);\n"
"\n"
"exec (\'nntp_post (?,?)\', state, msg, vector (r_server, cancel_msg));\n"
"}\n"
"else\n"
"{\n"
"exec (\'nntp_post (?,?)\', state, msg, vector (r_server, del_out));\n"
"}\n"
"\n"
"commit work;\n"
"}\n"
"del_it_locally:\n"
"delete from DB.DBA.NEWS_MULTI_MSG where NM_KEY_ID = id;\n"
"ns_up_num (_nm_group);\n"
"}\n"
"nf:\n"
"close cr;\n"
"delete from DB.DBA.NEWS_MSG where NM_ID = id;\n"
"return;\n"
"}\n"
"--src nn_svr.sql:1766\n"
;

static const char *proc143 = 
"#line 1844 \"[executable]/nn_svr.sql\"\n"
"create procedure\n"
"ns_clear_messages ()\n"
"{\n"
"declare _id varchar;\n"
"declare _nm_rec_date datetime;\n"
"\n"
"for (select NG_GROUP, NG_CLEAR_INT, NM_KEY_ID\n"
"from DB.DBA.NEWS_MULTI_MSG, DB.DBA.NEWS_GROUPS\n"
"where NM_GROUP=NG_GROUP and NG_CLEAR_INT > 0) do\n"
"{\n"
"select NM_ID, NM_REC_DATE into _id, _nm_rec_date from DB.DBA.NEWS_MSG where NM_ID = NM_KEY_ID;\n"
"\n"
"if (datediff (\'day\', _nm_rec_date, now()) > NG_CLEAR_INT)\n"
"ns_delete_message (_id);\n"
"}\n"
"return;\n"
"}\n"
"--src nn_svr.sql:1842\n"
;

static const char *proc144 = 
"#line 1864 \"[executable]/nn_svr.sql\"\n"
"create procedure getMsgField(in fld varchar, in m_id varchar)\n"
"{\n"
"declare msg any;\n"
"\n"
"msg := deserialize ((select NM_HEAD from DB.DBA.NEWS_MSG where NM_ID = m_id));\n"
"\n"
"return (get_keyword(fld,aref(msg, 0), \' - \'));\n"
"}\n"
"--src nn_svr.sql:1862\n"
;

static const char *proc145 = 
"#line 1875 \"[executable]/nn_svr.sql\"\n"
"create procedure\n"
"ns_rest (in gr_num integer, in _read integer)\n"
"{\n"
"\n"
"if (http_acl_get (\'NEWS\', http_client_ip (), null, gr_num, _read) > 0)\n"
"return 0;\n"
"\n"
"return 1;\n"
"}\n"
"--src nn_svr.sql:1873\n"
;

static const char *proc146 = 
"#line 1887 \"[executable]/nn_svr.sql\"\n"
"create procedure\n"
"ns_rest_rate_read (in gr_num integer)\n"
"{\n"
"declare res integer;\n"
"\n"
"res := http_acl_get (\'NEWS\', http_client_ip (), null, gr_num, 0, 1);\n"
"\n"
"if (abs (res) = 1)\n"
"return 0;\n"
"\n"
"return 1;\n"
"}\n"
"--src nn_svr.sql:1885\n"
;

static const char *proc147 = 
"#line 1902 \"[executable]/nn_svr.sql\"\n"
"create procedure\n"
"ns_rest_rate (in gr_num integer, in rw integer := 0)\n"
"{\n"
"return http_acl_get (\'NEWS\', http_client_ip (), null, gr_num, rw, 1);\n"
"}\n"
"--src nn_svr.sql:1900\n"
;

static const char *trig3 = 
"#line 1911 \"[executable]/nn_svr.sql\"\n"
"create trigger scheduled_event_insert_new_newsgroup after insert on DB.DBA.NEWS_GROUPS\n"
"{\n"
"\n"
"if (NG_UP_INT > 0)\n"
"insert into DB.DBA.SYS_SCHEDULED_EVENT (SE_NAME, SE_START, SE_SQL, SE_INTERVAL)\n"
"values (concat (\'UPDATE_NEWSGROUP_\', cast (NG_NAME as varchar), \'__\', cast (NG_GROUP as varchar)), now(),\n"
"concat (\'new_news (\'\'\', cast (NG_NAME as varchar), \'\'\', \', cast (NG_GROUP as varchar), \')\'), NG_UP_INT);\n"
"}\n"
"--src nn_svr.sql:1909\n";

static const char *trig4 = 
"#line 1922 \"[executable]/nn_svr.sql\"\n"
"create trigger scheduled_event_update_new_newsgroup after\n"
"update on DB.DBA.NEWS_GROUPS referencing old as O, new as N\n"
"{\n"
"if (N.NG_UP_INT <> O.NG_UP_INT)\n"
"{\n"
"delete from DB.DBA.SYS_SCHEDULED_EVENT\n"
"where SE_NAME = concat (\'UPDATE_NEWSGROUP_\', cast (N.NG_NAME as varchar),\n"
"\'__\', cast (N.NG_GROUP as varchar));\n"
"if (N.NG_UP_INT > 0)\n"
"insert into DB.DBA.SYS_SCHEDULED_EVENT (SE_NAME, SE_START, SE_SQL, SE_INTERVAL)\n"
"values (concat (\'UPDATE_NEWSGROUP_\', cast (N.NG_NAME as varchar),\n"
"\'__\', cast (N.NG_GROUP as varchar)), now(),\n"
"concat (\'new_news (\'\'\', cast (N.NG_NAME as varchar), \'\'\', \',\n"
"cast (N.NG_GROUP as varchar), \')\'), N.NG_UP_INT);\n"
"}\n"
"}\n"
"--src nn_svr.sql:1920\n";

static const char *trig5 = 
"#line 1941 \"[executable]/nn_svr.sql\"\n"
"create trigger scheduled_event_delete_new_newsgroup after delete on DB.DBA.NEWS_GROUPS\n"
"{\n"
"\n"
"delete from DB.DBA.SYS_SCHEDULED_EVENT\n"
"where SE_NAME = concat (\'UPDATE_NEWSGROUP_\', cast (NG_NAME as varchar), \'__\', cast (NG_GROUP as varchar));\n"
"\n"
"delete from DB.DBA.HTTP_ACL where upper (HA_LIST) = \'NEWS\' and HA_OBJECT = NG_GROUP;\n"
"}\n"
"--src nn_svr.sql:1939\n";

static const char *proc148 = 
"#line 1954 \"[executable]/nn_svr.sql\"\n"
"create procedure\n"
"news_acl_insert (in ng_group integer, in mask varchar, in allow integer, in _mode integer, in _rate double precision := 0)\n"
"{\n"
"declare acl_order integer;\n"
"acl_order := coalesce ((select max (HA_ORDER) from DB.DBA.HTTP_ACL where upper(HA_LIST) = \'NEWS\'), 0);\n"
"acl_order := acl_order + 1;\n"
"insert into DB.DBA.HTTP_ACL (HA_LIST, HA_ORDER, HA_OBJECT, HA_CLIENT_IP, HA_FLAG, HA_RW, HA_RATE)\n"
"values (\'NEWS\', acl_order, ng_group, mask, allow, _mode, _rate);\n"
"}\n"
"--src nn_svr.sql:1952\n"
;

static const char *proc149 = 
"#line 1965 \"[executable]/nn_svr.sql\"\n"
"create procedure nntp_update_message_path (inout _message any, in _ex_path varchar)\n"
"{\n"
"declare _new_path varchar;\n"
"_new_path := registry_get (\'__nntp_from_header\') || \'!\' || _ex_path;\n"
"_message := replace (_message, _ex_path, _new_path, 1);\n"
"}\n"
"--src nn_svr.sql:1963\n"
;

static const char *proc150 = 
"#line 1973 \"[executable]/nn_svr.sql\"\n"
"create procedure nntp_update_org_path_header ()\n"
"{\n"
"declare _org, _from varchar;\n"
"\n"
"_org := virtuoso_ini_item_value (\'HTTPServer\', \'NNTPOrganizationHeader\');\n"
"_from := virtuoso_ini_item_value (\'HTTPServer\', \'NNTPFromHeader\');\n"
"\n"
"if (_org is NULL)\n"
"_org := \'\';\n"
"\n"
"if (_from is NULL)\n"
"_from := identify_self()[0];\n"
"\n"
"registry_set (\'__nntp_from_header\', _from);\n"
"registry_set (\'__nntp_organization_header\', _org);\n"
"}\n"
"--src nn_svr.sql:1971\n"
;

static const char *other3 = 
"nntp_update_org_path_header ()\n";
static const char *proc151 = 
"#line 2019 \"[executable]/nn_svr.sql\"\n"
"create procedure\n"
"ns_cancel_message (in _id varchar, in _all any)\n"
"{\n"
"_id := replace (_id, \'cancel\', \'\');\n"
"_id := trim (_id);\n"
"ns_delete_message (_id, cast (_all as varchar));\n"
"}\n"
"--src nn_svr.sql:2017\n"
;

/* admin_news.sql */

static const char *tbl6 = 
"CREATE TABLE \"DB\".\"DBA\".\"NEWS_GROUPS_AVAILABLE\" (\n"
"\"NS_ID\" INTEGER NOT NULL REFERENCES \"DB\".\"DBA\".\"NEWS_SERVERS\"(\"NS_ID\") on delete cascade,\n"
"\"NG_ID\" INTEGER IDENTITY,\n"
"\"NAME\" VARCHAR NOT NULL,\n"
"\"DESCRIPTION\" VARCHAR,\n"
"\"FIRST\" INTEGER NOT NULL,\n"
"\"LAST\" INTEGER NOT NULL,\n"
"\"POSTING\" VARCHAR,\n"
"\"UPDATED\" VARCHAR,\n"
"PRIMARY KEY (\"NS_ID\", \"NAME\")\n"
")\n"
"CREATE UNIQUE INDEX GROUPS_AVAILABLE ON DB.DBA.NEWS_GROUPS_AVAILABLE(NAME, NS_ID)\n";

static const char *proc152 = 
"#line 39 \"[executable]/admin_news.sql\"\n"
"CREATE PROCEDURE DB.DBA.populate_groups_available (in _ns_id integer)\n"
"{\n"
"declare _list, _row any;\n"
"declare _name, _post, _server, _user, _pass varchar;\n"
"declare idx, len, _port, _last, _first integer;\n"
"\n"
"if (_ns_id IS NULL) return -2;\n"
"_server := \'\';\n"
"_user := \'\';\n"
"_port := 119;\n"
"_pass := \'\';\n"
"\n"
"SELECT \"NS_SERVER\", \"NS_PORT\", \"NS_USER\", \"NS_PASS\" INTO _server, _port, _user, _pass\n"
"FROM \"DB\".\"DBA\".\"NEWS_SERVERS\" WHERE \"NS_ID\" = _ns_id;\n"
"\n"
"commit work;\n"
"\n"
"UPDATE \"DB\".\"DBA\".\"NEWS_GROUPS_AVAILABLE\" SET \"UPDATED\" = \'N\' WHERE \"NS_ID\" = _ns_id;\n"
"\n"
"if (_server = \'\' or _server = \'localhost\')\n"
"return -1;\n"
"if (_user = \'\')\n"
"_list := nntp_get (concat (_server, \':\', cast (_port as varchar)), \'list\');\n"
"else\n"
"_list := nntp_auth_get (concat (_server, \':\', cast (_port as varchar)), _user, _pass, \'list\');\n"
"\n"
"idx := 0;\n"
"len := length (_list);\n"
"while (idx < len)\n"
"{\n"
"_row   := aref (_list, idx);\n"
"_name  := aref (_row, 0);\n"
"_post  := aref (_row, 3);\n"
"_last  := aref (_row, 1);\n"
"_first := aref (_row, 2);\n"
"\n"
"if (EXISTS(SELECT 1 FROM \"DB\".\"DBA\".\"NEWS_GROUPS_AVAILABLE\" WHERE \"NS_ID\" = _ns_id AND \"NAME\" = _name))\n"
"UPDATE \"DB\".\"DBA\".\"NEWS_GROUPS_AVAILABLE\"\n"
"SET \"DESCRIPTION\" = \'\', \"FIRST\" = _first, \"LAST\" = _last, \"POSTING\" = _post, \"UPDATED\" = \'Y\'\n"
"WHERE \"NS_ID\" = _ns_id AND \"NAME\" = _name;\n"
"else\n"
"INSERT INTO \"DB\".\"DBA\".\"NEWS_GROUPS_AVAILABLE\"(\"NS_ID\", \"NAME\", \"DESCRIPTION\", \"FIRST\", \"LAST\", \"POSTING\", \"UPDATED\")\n"
"VALUES (_ns_id, _name, \'\', _first, _last, _post, \'Y\');\n"
"\n"
"idx := idx + 1;\n"
"commit work;\n"
"}\n"
"\n"
"UPDATE \"DB\".\"DBA\".\"NEWS_GROUPS_AVAILABLE\" SET \"UPDATED\" = \'R\' WHERE \"NS_ID\" = _ns_id AND \"UPDATED\" = \'N\';\n"
"return len;\n"
"}\n"
"--src admin_news.sql:37\n"
;

static const char *trig6 = 
"#line 92 \"[executable]/admin_news.sql\"\n"
"CREATE TRIGGER GetGroups AFTER INSERT ON \"DB\".\"DBA\".\"NEWS_SERVERS\"\n"
"{\n"
"INSERT INTO \"DB\".\"DBA\".\"SYS_SCHEDULED_EVENT\"(SE_NAME, SE_START, SE_SQL, SE_INTERVAL)\n"
"VALUES(concat(\'UPD_Avail_Grps_\', NS_SERVER), now(),\n"
"concat(\'\"DB\".\"DBA\".\"populate_groups_available\"(\', cast(\"NS_ID\" as varchar), \')\'), 100);\n"
"\n"
"}\n"
"--src admin_news.sql:90\n";

static const char *trig7 = 
"#line 101 \"[executable]/admin_news.sql\"\n"
"CREATE TRIGGER GetGroupsStop AFTER DELETE ON \"DB\".\"DBA\".\"NEWS_SERVERS\"\n"
"{\n"
"delete from \"DB\".\"DBA\".\"SYS_SCHEDULED_EVENT\"\n"
"where SE_NAME = concat(\'UPD_Avail_Grps_\', NS_SERVER);\n"
"\n"
"}\n"
"--src admin_news.sql:99\n";

static int
sch_proc_def_exists (client_connection_t *cli, const char *proc_name, const int report)
{
  query_t *proc = NULL;
  char *full_name = sch_full_proc_name (isp_schema(NULL), proc_name,
	cli->cli_qualifier, CLI_OWNER (cli));
  if (full_name)
    proc = sch_proc_def (isp_schema(NULL), full_name);
  if (report && proc != NULL)
     log_debug ("built-in procedure \"%s\" overruled by the RDBMS", proc_name);
  return (proc != NULL);
}

#define DEFINE_PROC(name, proc) \
   if (!sch_proc_def_exists (bootstrap_cli, (name), log_proc_overwrite)) \
     ddl_std_proc_1 (proc, 0x0, 1)


#define DEFINE_PUBLIC_PROC(name, proc) \
   if (!sch_proc_def_exists (bootstrap_cli, (name), log_proc_overwrite)) \
     ddl_std_proc_1 (proc, 0x1, 1)


#define DEFINE_OVERWRITE_PROC(name, proc) \
   ddl_std_proc_1 (proc, 0x1, 1)


void
sqls_define_imsg (void)
{
  /* pop3_svr.sql */

  DEFINE_PROC ("WS.WS.POP3_SRV", proc0);
  DEFINE_PROC ("pop_if_command", proc1);
  DEFINE_PROC ("pop_get_command", proc2);
  DEFINE_PROC ("pop_init", proc3);
  DEFINE_PROC ("pop_write", proc4);
  DEFINE_PROC ("pop_write_ok", proc5);
  DEFINE_PROC ("pop_write_err", proc6);
  DEFINE_PROC ("pop_is_deleted", proc7);
  DEFINE_PROC ("pop_is_ok_", proc8);
  DEFINE_PROC ("pop_change_stat", proc9);
  DEFINE_PROC ("pop_messages", proc10);
  DEFINE_PROC ("pop_mess_len", proc11);
  DEFINE_PROC ("pop_quit", proc12);
  DEFINE_PROC ("pop_apop", proc13);
  DEFINE_PROC ("pop_user", proc14);
  DEFINE_PROC ("pop_pass", proc15);
  DEFINE_PROC ("pop_noop", proc16);
  DEFINE_PROC ("pop_list", proc17);
  DEFINE_PROC ("pop_dele", proc18);
  DEFINE_PROC ("pop_rset", proc19);
  DEFINE_PROC ("pop_uidl", proc20);
  DEFINE_PROC ("pop_stat", proc21);
  DEFINE_PROC ("pop_retr", proc22);
  DEFINE_PROC ("pop_atoi", proc23);
  DEFINE_PROC ("pop_spam_filter_init", proc24);
  ddl_ensure_table ("do this always", other0);
  ddl_ensure_table ("DB.DBA.MSG_WORDS", tbl0);
  ddl_ensure_table ("DB.DBA.MSG_SPAMS_COUNT", tbl1);
  DEFINE_PROC ("spam_mw_word_stream", proc25);
  DEFINE_PROC ("filter_add_message", proc26);
  DEFINE_PROC ("spam_add_headers", proc27);
  DEFINE_PROC ("spam_add_word", proc28);
  DEFINE_PROC ("spam_remove_headers", proc29);
  DEFINE_PROC ("filter_remove_message", proc30);
  DEFINE_PROC ("spam_remove_word", proc31);
  DEFINE_PROC ("spam_get_word", proc32);
  DEFINE_PROC ("spam_min", proc33);
  DEFINE_PROC ("spam_probability", proc34);
  DEFINE_PROC ("spam_filter_message", proc35);
  DEFINE_PROC ("spam_chi2_spamprob", proc36);
  DEFINE_PROC ("spam_chi2q", proc37);
  DEFINE_PROC ("spam_getclues", proc38);
  DEFINE_PROC ("spam_classify_mail_box", proc39);
  DEFINE_PROC ("filter_classify_message", proc40);
  DEFINE_PROC ("spam_change_header", proc41);
  DEFINE_PROC ("spam_remove_old_header", proc42);
  DEFINE_PROC ("spam_classify_from_score", proc43);
  DEFINE_PROC ("spam_make_new_header", proc44);
  DEFINE_PROC ("virt_spam_header", proc45);
  DEFINE_PROC ("spam_get_score", proc46);
  DEFINE_PROC ("spam_message_from_id", proc47);

  /* ftp.sql */

  DEFINE_PROC ("WS.WS.FTP_SRV", proc48);
  DEFINE_PROC ("FTP_QUIT", proc49);
  DEFINE_PROC ("FTP_ABOR", proc50);
  DEFINE_PROC ("FTP_GET_COMMAND", proc51);
  DEFINE_PROC ("FTP_ANONYMOUS_CHECK", proc52);
  DEFINE_PROC ("FTP_AUTHENTICATE", proc53);
  DEFINE_PROC ("FTP_PWD", proc54);
  DEFINE_PROC ("FTP_NOOP", proc55);
  DEFINE_PROC ("FTP_PASV", proc56);
  DEFINE_PROC ("FTP_RNTO", proc57);
  DEFINE_PROC ("FTP_REST", proc58);
  DEFINE_PROC ("FTP_CLNT", proc59);
  DEFINE_PROC ("FTP_RNFR", proc60);
  DEFINE_PROC ("FTP_SYST", proc61);
  DEFINE_PROC ("FTP_MKD", proc62);
  DEFINE_PROC ("FTP_RMD", proc63);
  DEFINE_PROC ("FTP_DELE", proc64);
  DEFINE_PROC ("FTP_CWD", proc65);
  DEFINE_PROC ("FTP_TYPE", proc66);
  DEFINE_PROC ("FTP_PORT", proc67);
  DEFINE_PROC ("FTP_LIST", proc68);
  DEFINE_PROC ("FTP_HELP", proc69);
  DEFINE_PROC ("FTP_FILE_PERM", proc70);
  DEFINE_PROC ("FTP_RETR", proc71);
  DEFINE_PROC ("FTP_SIZE", proc72);
  DEFINE_PROC ("FTP_SITE_CHMOD_U2D", proc73);
  DEFINE_PROC ("FTP_SITE", proc74);
  DEFINE_PROC ("FTP_STOR", proc75);
  DEFINE_PROC ("FTP_PATH", proc76);
  DEFINE_PROC ("FTP_MODE_MASK", proc77);
  DEFINE_PROC ("FTP_GET_DIR_PART", proc78);
  DEFINE_PROC ("FTP_NOR_DIR", proc79);
  DEFINE_PROC ("FTP_GET", proc80);
  DEFINE_PROC ("FTP_PUT", proc81);
  DEFINE_PROC ("FTP_MKDIR", proc82);
  DEFINE_PROC ("FTP_RMDIR", proc83);
  DEFINE_PROC ("FTP_DELETE", proc84);
  DEFINE_PROC ("FTP_LS", proc85);
  DEFINE_PROC ("PARSE_ADR", proc86);
  DEFINE_PROC ("FTP_COMMAND", proc87);
  DEFINE_PROC ("FTP_SES_GET", proc88);
  DEFINE_PROC ("FTP_CONNECT", proc89);
  DEFINE_PROC ("FTP_LIST_GET", proc90);
  DEFINE_PROC ("FTP_FILE_SES_GET", proc91);
  DEFINE_PROC ("FTP_SES_SEND", proc92);
  DEFINE_PROC ("FTP_IF_CODE_OK", proc93);
  DEFINE_PROC ("FTP_GET_DIR", proc94);
  DEFINE_PROC ("GET_FREE_PORT", proc95);
  DEFINE_PROC ("FTP_MAKE_PORT_COMMAND", proc96);
  DEFINE_PROC ("FTP_LISTEN", proc97);
  DEFINE_PROC ("FTP_MAKE_LIST_CMD", proc98);
  DEFINE_PROC ("FTP_SES_ACCEPT", proc99);
  DEFINE_PROC ("FTP_SES_LISTEN", proc100);
  DEFINE_PROC ("FTP_WRITE", proc101);
  DEFINE_PROC ("FTP_POP_WRITE", proc102);
  DEFINE_PROC ("FTP_LOG_FILE_NAME", proc103);
  DEFINE_PROC ("FTP_RES_UPLOAD_FROM_POSITION", proc104);
  DEFINE_PROC ("FTP_PUT_IN_DAV", proc105);
  DEFINE_PROC ("FTP_GET_FROM_DAV", proc106);
  DEFINE_PROC ("FTP_DAV_PATH_FIX", proc107);
  DEFINE_PROC ("FTP_FILE_IS_DAV", proc108);

  /* nn_svr.sql */

  ddl_ensure_table ("DB.DBA.NEWS_MSG_NNTP", tbl2);
  ddl_ensure_table ("DB.DBA.NEWS_MSG", view0);
  ddl_std_proc (trig0, 0x0);
  ddl_std_proc (trig1, 0x0);
  ddl_std_proc (trig2, 0x0);
  DEFINE_PROC ("NN_FEED_PART", proc109);
  DEFINE_PROC ("DB.DBA.NEWS_MSG_NNTP_NM_BODY_INDEX_HOOK", proc110);
  DEFINE_PROC ("DB.DBA.NEWS_MSG_NNTP_NM_BODY_UNINDEX_HOOK", proc111);
  ddl_ensure_table ("do this always", other1);
  ddl_ensure_table ("do this always", other2);
  ddl_ensure_table ("DB.DBA.NEWS_GROUPS", tbl3);
  ddl_ensure_table ("DB.DBA.NEWS_SERVERS", tbl4);
  ddl_ensure_table ("DB.DBA.NEWS_MULTI_MSG", tbl5);
  ddl_ensure_table ("DB.DBA.NEWS_MESSAGES", view1);
  DEFINE_PROC ("WS.WS.NN_SRV", proc112);
  DEFINE_PROC ("ns_valid", proc113);
  DEFINE_PROC ("ns_add_msg", proc114);
  DEFINE_PROC ("ns_mirror_news", proc115);
  DEFINE_PROC ("new_news", proc116);
  DEFINE_PROC ("ns_up_num", proc117);
  DEFINE_PROC ("ns_date", proc118);
  DEFINE_PROC ("news_auto_update_event", proc119);
  DEFINE_PROC ("news_update_admin_vsp", proc120);
  DEFINE_PROC ("ns_quit", proc121);
  DEFINE_PROC ("ns_help", proc122);
  DEFINE_PROC ("ns_list", proc123);
  DEFINE_PROC ("ns_auth", proc124);
  DEFINE_PROC ("ns_group", proc125);
  DEFINE_PROC ("ns_next", proc126);
  DEFINE_PROC ("ns_last", proc127);
  DEFINE_PROC ("ns_head", proc128);
  DEFINE_PROC ("ns_body", proc129);
  DEFINE_PROC ("ns_article", proc130);
  DEFINE_PROC ("ns_xover", proc131);
  DEFINE_PROC ("ns_newgroups", proc132);
  DEFINE_PROC ("ns_stat", proc133);
  DEFINE_PROC ("ns_post_write_out", proc134);
  DEFINE_PROC ("ns_post", proc135);
  DEFINE_PROC ("ns_post_out", proc136);
  DEFINE_PROC ("ns_post_out_id", proc137);
  DEFINE_PROC ("ns_post_out_core", proc138);
  DEFINE_PROC ("ns_xover_group", proc139);
  DEFINE_PROC ("ns_make_index_content", proc140);
  DEFINE_PROC ("ns_read_message", proc141);
  DEFINE_PROC ("ns_delete_message", proc142);
  DEFINE_PROC ("ns_clear_messages", proc143);
  DEFINE_PROC ("getMsgField", proc144);
  DEFINE_PROC ("ns_rest", proc145);
  DEFINE_PROC ("ns_rest_rate_read", proc146);
  DEFINE_PROC ("ns_rest_rate", proc147);
  ddl_std_proc (trig3, 0x0);
  ddl_std_proc (trig4, 0x0);
  ddl_std_proc (trig5, 0x0);
  DEFINE_PROC ("news_acl_insert", proc148);
  DEFINE_PROC ("nntp_update_message_path", proc149);
  DEFINE_PROC ("nntp_update_org_path_header", proc150);
  ddl_ensure_table ("do this always", other3);
  DEFINE_PROC ("ns_cancel_message", proc151);

  /* admin_news.sql */

  ddl_ensure_table ("DB.DBA.NEWS_GROUPS_AVAILABLE", tbl6);
  DEFINE_PROC ("DB.DBA.populate_groups_available", proc152);
  ddl_std_proc (trig6, 0x0);
  ddl_std_proc (trig7, 0x0);
}


void
sqls_arfw_define_imsg (void)
{
}
