/* ============================================================
 *
 * This file is a part of digiKam project
 * http://www.digikam.org
 *
 * Date        : 2010-02-19
 * Description : Channel Mixer batch tool.
 *
 * Copyright (C) 2010-2011 by Gilles Caulier <caulier dot gilles at gmail dot com>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

#ifndef CHANNELMIXER_H
#define CHANNELMIXER_H

// Local includes

#include "batchtool.h"

class KComboBox;

namespace Digikam
{

class MixerSettings;

class ChannelMixer : public BatchTool
{
    Q_OBJECT

public:

    ChannelMixer(QObject* parent=0);
    ~ChannelMixer();

    BatchToolSettings defaultSettings();

private:

    bool toolOperations();

private Q_SLOTS:

    void slotAssignSettings2Widget();
    void slotSettingsChanged();

private:

    KComboBox*     m_channelCB;
    MixerSettings* m_settingsView;
};

}  // namespace Digikam

#endif /* CHANNELMIXER_H */
