/* ============================================================
 *
 * This file is a part of kipi-plugins project
 * http://www.digikam.org
 *
 * Date        : 2011-09-01
 * Description : a plugin to create photo layouts by fusion of several images.
 * Acknowledge : based on the expoblending plugin
 *
 * Copyright (C) 2011 by Łukasz Spas <lukasz dot spas at gmail dot com>
 * Copyright (C) 2009-2011 by Gilles Caulier <caulier dot gilles at gmail dot com>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

// This file is generated by kconfig_compiler from photoframeseditor.kcfg.
// All changes you do to this file will be lost.

#include "PFEConfigSkeleton.h"

#include <kglobal.h>
#include <QtCore/QFile>

using namespace KIPIPhotoFramesEditor;

namespace KIPIPhotoFramesEditor {

class PFEConfigSkeletonHelper
{
  public:
    PFEConfigSkeletonHelper() : q(0) {}
    ~PFEConfigSkeletonHelper() { delete q; }
    PFEConfigSkeleton *q;
};
}

K_GLOBAL_STATIC(PFEConfigSkeletonHelper, s_globalPFEConfigSkeleton)
PFEConfigSkeleton *PFEConfigSkeleton::self()
{
  if (!s_globalPFEConfigSkeleton->q) {
    new PFEConfigSkeleton;
    s_globalPFEConfigSkeleton->q->readConfig();
  }

  return s_globalPFEConfigSkeleton->q;
}

PFEConfigSkeleton::PFEConfigSkeleton(  )
  : KConfigSkeleton( QLatin1String( "kipipferc" ) )
{
  Q_ASSERT(!s_globalPFEConfigSkeleton->q);
  s_globalPFEConfigSkeleton->q = this;
  setCurrentGroup( QLatin1String( "Saving" ) );

  KConfigSkeleton::ItemBool  *itemEmbedImages;
  itemEmbedImages = new KConfigSkeleton::ItemBool( currentGroup(), QLatin1String( "EmbedImages" ), mEmbedImages, PFEConfig::embedImagesData() );
  addItem( itemEmbedImages, QLatin1String( "EmbedImages" ) );

  setCurrentGroup( QLatin1String( "View" ) );

  KConfigSkeleton::ItemDouble  *itemHorizontalGrid;
  itemHorizontalGrid = new KConfigSkeleton::ItemDouble( currentGroup(), QLatin1String( "HorizontalGrid" ), mHorizontalGrid, PFEConfig::gridX() );
  addItem( itemHorizontalGrid, QLatin1String( "HorizontalGrid" ) );
  KConfigSkeleton::ItemDouble  *itemVerticalGrid;
  itemVerticalGrid = new KConfigSkeleton::ItemDouble( currentGroup(), QLatin1String( "VerticalGrid" ), mVerticalGrid, PFEConfig::gridY() );
  addItem( itemVerticalGrid, QLatin1String( "VerticalGrid" ) );
}

PFEConfigSkeleton::~PFEConfigSkeleton()
{
  if (!s_globalPFEConfigSkeleton.isDestroyed()) {
    s_globalPFEConfigSkeleton->q = 0;
  }
}

