<?php
/**
 * IMP Configuration File
 *
 * This file contains global configuration settings for IMP. Values
 * may be safely edited by hand. Use conf.php.dist as a reference.
 *
 * Mail servers are defined in 'servers.php'.
 * Default user preferences are defined in 'prefs.php'.
 *
 * Strings should be enclosed in 'quotes'.
 * Integers should be given literally (without quotes).
 * Boolean values may be 'true' or 'false'.
 *
 * $Horde: imp/config/conf.php.dist,v 1.156.2.11 2002/10/30 03:31:58 chuck Exp $
 */


/**
 ** External Utilities
 **/

// If ispell or aspell is available, then we will provide a spelling
// checker. If this is empty (''), null, or false, then spell checking
// will be disabled.
$conf['utils']['spellchecker'] = '';


/**
 ** Menu settings
 **/

// This is an array of applications (using the names defined in
// horde/config/registry.php) to include links to in the menubar. An
// example providing a link to Turba (an addressbook program) would
// be: $conf['menu']['apps'] = array('turba');
$conf['menu']['apps'] = array();


/**
 ** User Capabilities and Constraints
 **/

// Should we allow users to use folders at all? NOTE: setting this to
// false will mean there is no place to save sent-mail or postponed
// messages, along with the obvious affects of restricting the user to
// their INBOX.
$conf['user']['allow_folders'] = true;

// If this is true, then there will be a "Message Source" link in the
// parts list of every message, allowing the user to view the entire
// raw message, or to download it and save it to disk.
$conf['user']['allow_view_source'] = true;

// If this is true, the user will be able to resume any message in any
// mailbox.  Otherwise, only messages marked as 'drafts' can be resumed.
$conf['user']['allow_resume_all'] = false;

// If this is true, the user will be able to resume any message in their
// draft mailbox (to compensate for some clients that don't bother setting
// the draft flag).  Otherwise, only messages marked as 'drafts' can be
// resumed.
$conf['user']['allow_resume_all_in_drafts'] = false;

// If this is anything other than false, then it is assumed to be the
// URL of an alternate login screen which will be used in place of
// IMP's default one.
$conf['user']['alternate_login'] = false;

// If this is anything other than false, it is assumed to be the URL
// of an alternate logout page which users will be sent to when they
// log out.
$conf['user']['redirect_on_logout'] = false;

// If this is true, then users will be given a <select> menu in the
// compose window allowing them to choose which folder to save their
// sent messages to. If this is false, then messages will be saved to
// the folder defined in their preferences.
$conf['user']['select_sentmail_folder'] = false;


/**
 ** Mail Server Settings
 **/

// Should we display a list of servers (defined in config/servers.php)
// for users to choose from? The options are 'shown', 'hidden', and
// 'none'. If the server list is hidden then you can use the
// 'preferred' mechanism to auto-select from it based on an HTTP
// virtualhost or another piece of data. If it is shown, the user will
// be able to pick from any of the options. If none, no server list
// will be shown and the defaults will be used unless another
// mechanism changes them.
$conf['server']['server_list'] = 'none';

// If we are not using the server list, should we allow users to type
// in a mail server?
$conf['server']['change_server'] = false;

// If we are not using the server list, should we allow users to
// select the mail server's port?
$conf['server']['change_port'] = false;

// If we are not using the server list, should we allow users to
// select the mail server's protocol?
$conf['server']['change_protocol'] = false;

// If we are not using the server list, should we allow users to
// select the mail server's folder prefix?
$conf['server']['change_folders'] = false;

// Should we show files that begin with a '.' in the folder lists?
$conf['server']['show_dotfiles'] = false;

// Should we enable any folder hierarchies that aren't shown by
// default? For instance, UW can be configured to serve out #shared/,
// #news/, #ftp/, and #public/ folder hierarchies. Put any of these
// that you want shown into an array entry here.
$conf['server']['hierarchies'] = array();


/**
 ** Mailbox Settings
 **/

// What should we display for the various message flags/types, and
// what styles should we use for different kinds of flagged messages?
$conf['mailbox']['deleted_flag'] = Horde::img('deleted.gif', 'alt="' . _("Deleted") . '"');
$conf['mailbox']['deleted_style'] = 'strike';
$conf['mailbox']['unseen_flag'] = Horde::img('unseen.gif', 'alt="' . _("Unread") . '"');
$conf['mailbox']['unseen_style'] = 'b';
$conf['mailbox']['answered_flag'] = Horde::img('answered.gif', 'alt="' . _("Answered") . '"');
$conf['mailbox']['answered_style'] = '';
$conf['mailbox']['important_flag'] = Horde::img('important.gif', 'alt="' . _("Important") . '"');
$conf['mailbox']['important_style'] = 'i';
$conf['mailbox']['draft_flag'] = Horde::img('draft.gif', 'alt="' . _("Draft") . '"');
$conf['mailbox']['draft_style'] = '';
$conf['mailbox']['personal_flag'] = Horde::img('personal.gif', 'alt="' . _("Personal") . '"');

// What format string should we pass to strftime() for messages sent on
// days other than today?
$conf['mailbox']['date_format'] = '%x';

// What format string should we pass to strftime() for messages sent
// today?
$conf['mailbox']['time_format'] = '%X';

// In the mailbox view, we will chop off From: addresses longer than
// this value.
$conf['mailbox']['max_from_chars'] = 40;

// In the mailbox view, we will chop off Subjects longer than this
// value.
$conf['mailbox']['max_subj_chars'] = 50;

// Where should the link in the From: column go to? Valid values are
// 'message' (read the message) and 'compose' (compose a message to
// that address); anything else will result in no link being generated.
$conf['mailbox']['from_link'] = 'message';

// Should we display attachment information in the mailbox index? This
// is a performance hit, but may be okay on smaller installations.
$conf['mailbox']['show_attachments'] = false;


/**
 ** Message Settings
 **/

// Should we include the contents of imp/config/header.txt in the
// headers of every message sent?
$conf['msg']['prepend_header'] = true;

// Should we append the contents of imp/config/trailer.txt to the end
// of every message sent?
$conf['msg']['append_trailer'] = true;

// If filtering of message content is turned on, where should we find
// the list of words to filter out?
$conf['msg']['filtering']['words'] = './config/filter.txt';

// What should we replace filtered words with?
$conf['msg']['filtering']['replacement'] = '****';


/**
 ** Spam Reporting
 **/

// Should we display a "report this message as spam" link in the
// message view?
$conf['spam']['reporting'] = false;

// If so, where should those messages be reported to?
$conf['spam']['email'] = 'postmaster@' . $GLOBALS['registry']->getParam('server_name');


/**
 ** Compose Settings
 **/

// Should we use the Horde VFS system for storing uploaded
// attachments? NOTE: This option REQUIRES Horde 2.2 or later; setting
// it to true with a version of Horde that does not have VFS support
// will have no effect (attachments will be stored in /tmp as if this
// option were false).
$conf['compose']['use_vfs'] = false;

// Should we allow users to set the Cc: header?
$conf['compose']['allow_cc'] = true;

// Should we allow users to set the Bcc: header?
$conf['compose']['allow_bcc'] = true;

// What format string should be pass to strftime() for the heading of the
// compose window?
$conf['compose']['date_format'] = '%c';

// Can the user request a return receipt?
$conf['compose']['allow_receipts'] = true;

// Should we give the user a pop-up window with special characters in
// it?
$conf['compose']['special_characters'] = true;


/**
 ** Custom Function Hooks
 **/

// If this is set to a function name, that function will be used
// to get the user's email address to use when sending mail.  See
// the 'imp_expand_fromaddress' function below for an example.
$conf['hooks']['from'] = '';

/* Here is an example imp_expand_fromaddress function.  You get passed the
 * $imp array and have access to everything inside it, which should be
 * plenty of information.  You can "global" anything else you need.  Return
 * an address - either just the user@ side or a full address - and it will
 * be used.
 *
 * NB: If users are allowed to change their fromaddresses (not fullnames,
 * though), and they have one set, this will be overridden.
 *
 * NB2: The code assumes that this function will return a reasonable
 * address, so make sure to fall back to $imp['user'] or some such on
 * failure.
 */
// if (!function_exists('imp_expand_fromaddress')) {
//     function imp_expand_fromaddress ($imp) {
//         if ($imp['server'] != 'mail.example.com') {
//             return $imp['user'];
//         }
//
//         $cmd = '/usr/local/bin/ph unix=' . escapeShellCmd($imp['user']) . ' | /bin/grep email | /usr/bin/awk \'{print $2}\'';
//         $name = `$cmd`;
//         return (empty($name) ? $imp['user'] : $name);
//     }
// }

/* This is another example how to get the from address from an ldap server. */
// if (!function_exists('imp_expand_fromaddress')) {
//     function imp_expand_fromaddress($imp) {
//         $ldapServer = 'ldap.example.com';
//         $ldapPort = '389';
//         $searchBase = 'ou=people,o=example.com';
//
//         $ds = @ldap_connect($ldapServer, $ldapPort);
//
//         $searchResult = @ldap_search($ds, $searchBase, 'uid=' . $imp['user']);
//         $information = @ldap_get_entries($ds, $searchResult);
//         $name = $information[0]['mail'][0];
//
//         ldap_close($ds);
//
//         return (empty($name) ? $imp['user'] : $name);
//     }
// }

// If this is set to a function name, that function will be used
// to modify the signature at runtime; See
// the 'imp_set_signature' function below for an example.
$conf['hooks']['signature'] = '';

/* Here is an example imp_set_signature function to set the signature
 * from the system taglines file; the string "%TAG%" (if present in a
 * user's signature) will be replaced by the content of the file
 * "/usr/share/tagline" (generated by the "TaRT" utility).
 */
// if (!function_exists('imp_set_signature')) {
//     function imp_set_signature ($imp, $sig) {
//         if (preg_match('/%TAG%/', $sig)) {
//             $tag = `cat /usr/share/tagline`;
//             $sig = preg_replace('|%TAG%|', $tag, $sig);
//         }
//         return $sig;
//     }
// }

// If this is set to a function name, that function will be used
// to get the user's fullname to use when sending mail.  See
// the 'imp_set_fullname' function below for an example.
$conf['hooks']['fullname'] = '';

/* Here is an example imp_set_fullname function to set the fullname
 * from the GECOS information in the passwd file.
 */
//if (!function_exists('imp_set_fullname')) {
//    function imp_set_fullname ($imp) {
//        $array = posix_getpwnam($imp['user']);
//        $gecos_array = explode(',', $array['gecos']);
//        return (empty($gecos_array) ? $imp['user'] : $gecos_array[0]);
//    }
//}

/* This is another example how to get the user's full name from an ldap server.
 * In this example we look if a Spanish name exists and return this or the
 * standard 'cn' entry if not.
 */
// if (!function_exists('imp_set_fullname')) {
//     function imp_set_fullname($imp) {
//         $ldapServer = 'ldap.example.com';
//         $ldapPort = '389';
//         $searchBase = 'ou=people,o=example.com';
//
//         $ds = @ldap_connect($ldapServer, $ldapPort);
//
//         $searchResult = @ldap_search($ds, $searchBase, 'uid=' . $imp['user']);
//         $information = @ldap_get_entries($ds, $searchResult);
//         if ($information[0]['cn;lang-es'][0] != '') {
//             $name = $information[0]['cn;lang-es'][0];
//         } else {
//             $name = $information[0]['cn'][0];
//         }
//
//         ldap_close($ds);
//
//         return (empty($name) ? $imp['user'] : $name);
//     }
// }

// If this is set to a function name, that function will be used to
// set the $imp['user'] at login time; See the 'imp_get_vinfo'
// function below for an example.
$conf['hooks']['vinfo'] = '';

/* Here is an example imp_get_vinfo function. If $type == 'vdomain',
 * this function returns the HTTP_HOST variable after removing the
 * 'mail.' subdomain.
 *
 * If $type == 'username', this function returns a unique username
 * composed of $imp['user'] + vdomain.
 *
 * ex. $HTTP_HOST = 'mail.mydomain.com', $imp['user'] = 'myname'
 *   $vdomain  = 'mydomain.com'
 *   $username = 'myname_mydomain_com'
 */
// if (!function_exists('imp_get_vinfo')) {
//     function imp_get_vinfo ($type = 'username') {
//         global $conf, $imp;
//
//         $vdomain = getenv('HTTP_HOST');
//         $vdomain = preg_replace('|^mail\.|i', '', $vdomain);
//         $vdomain = strtolower($vdomain);
//
//         if ($type == 'username') {
//             return preg_replace('|\.|', '_', $imp['user'] . '_' . $vdomain);
//         } elseif ($type == "vdomain") {
//             return $vdomain;
//         } else {
//             return new PEAR_Error('invalid type: ' . $type);
//         }
//     }
// }

// If this is set to a function name, that function will be used
// to show the user's quota usage on the mailbox page.
// See the 'imp_show_quota' function below for an example.
$conf['hooks']['quota'] = '';

/* Gets the quota usage from the imap server. $imap_admin &
 * $imap_passwd must be set to fit your own settings. This works
 * with the Cyrus imap server and the Courier imap server > 1.3.12.
 * Note the necessary changes for the Courier server in the comments.
 */
// if (!function_exists('imp_show_quota')) {
//    function imp_show_quota ($imp) {
//         $quota_html = '';
//         $imap_admin = 'admin';
//         $imap_passwd = 'password';
//         // Use the following two lines instead for Courier.
//         // $imap_admin = $imp['user'];
//         // $imap_passwd = Secret::read(Secret::getKey('imp'), $imp['pass']);
//
//         $stream = @imap_open(IMP::serverString(), $imap_admin, $imap_passwd, OP_HALFOPEN);
//         $quota = @imap_get_quota($stream, 'user.' . $imp['user']);
//         // Use the following line instead for Courier.
//         // $quota = @imap_get_quota($stream, 'ROOT');
//         imap_close($stream);
//
//         if (is_array($quota) && $quota['limit'] != 0) {
//             $taken   = $quota['usage'] / 1024.0;
//             $total   = $quota['limit'] / 1024.0;
//             $percent = $taken * 100 / $total;
//             if ($percent >= 90) {
//                 $class = 'quotaalert';
//             } elseif ($percent >= 75) {
//                 $class = 'quotawarn';
//             } else {
//                 $class = 'control';
//             }
//
//             $quota_html = '<table width="100%" border="0" cellpadding="0" cellspacing="0"><tr><td class="item">'
//                           . '<table border="0" cellspacing="2" cellpadding="2" width="100%"><tr><td align="center" class="' . $class . '">'
//                           . sprintf("%.2fMB / %.2fMB  (%.2f%%)", $taken, $total, $percent)
//                           . '</td></tr></table></td></tr></table>';
//         }
//         return $quota_html;
//     }
// }
