<?php
/**
 * IMP external API interface.
 *
 * This file defines IMP's external API interface. Other applications
 * can interact with IMP through this API.
 *
 * $Horde: imp/lib/api.php,v 1.77 2003/08/15 15:58:12 slusarz Exp $
 *
 * See the enclosed file COPYING for license information (GPL). If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

$_services['authenticate'] = array(
    'args' => array('userID', 'credentials', 'params'),
    'type' => 'boolean'
);

$_services['getStream'] = array(
    'args' => array('mailbox', 'flags'),
    'type' => 'resource'
);

$_services['compose'] = array(
    'args' => array('args', 'extra'),
    'type' => 'string'
);

$_services['folderlist'] = array(
    'args' => array(),
    'type' => 'array'
);

$_services['createFolder'] = array(
    'args' => array('folder'),
    'type' => 'string'
);

$_services['block'] = array(
    'args' => array('type', 'params'),
    'type' => 'array'
);

$_services['blocks'] = array(
    'args' => array(),
    'type' => 'array'
);


function &_imp_block($type, $params)
{
    switch ($type) {
    case 'summary':
        require_once dirname(__FILE__) . '/../lib/Block/summary.php';
        return new Imp_Summary_Block($params);
    }
}

function _imp_blocks()
{
    return array('summary' => array('name' => _("Folder Summary")));
}

/**
 * TODO
 *
 * @param string $userID       TODO
 * @param array  $credentials  TODO
 * @param array  $params       TODO
 *
 * @return boolean  Whether IMP authentication was successful.
 */
function _imp_authenticate($userID, $credentials, $params)
{
    $authentication = 'none';
    require_once dirname(__FILE__) . '/base.php';

    if (!empty($params['server'])) {
        $server = $params['server'];
    } else {
        require_once IMP_BASE . '/config/servers.php';
        foreach ($servers as $key => $curServer) {
            if (!isset($server) && substr($key, 0, 1) != '_') {
                $server = $key;
            }
            if (IMP::isPreferredServer($curServer, $key)) {
                $server = $key;
                break;
            }
        }
    }

    require_once IMP_BASE . '/lib/Session.php';
    if (IMP_Session::createSession($userID, $credentials['password'], $server)) {
        global $imp;
        $entry = sprintf('Login success for %s [%s] to {%s:%s}', $imp['uniquser'], $_SERVER['REMOTE_ADDR'], $imp['server'], $imp['port']);
        Horde::logMessage($entry, __FILE__, __LINE__, PEAR_LOG_NOTICE);
        return true;
    }

    return false;
}

/**
 * Attempt to authenticate via IMP and return an IMAP stream.
 *
 * @param optional string $mailbox  The mailbox name.
 * @param optional integet $flags   IMAP connection flags.
 *
 * @return mixed  An IMAP resource on success, false on failure.
 */
function _imp_getStream($mailbox = null, $flags = 0)
{
    $authentication = 'none';
    require_once dirname(__FILE__) . '/base.php';

    if (IMP::checkAuthentication(OP_HALFOPEN, true) === true) {
        require_once IMP_BASE . '/lib/IMAP.php';
        $imap = &IMP_IMAP::singleton();
        if ($imap->changeMbox($mailbox, $flags)) {
            return $_SESSION['imp']['stream'];
        }
    }

    return false;
}

/**
 * Return a compose window link.
 *
 * @param optional mixed $args   List of arguments to pass to compose.php.
 *                               If this is passed in as a string, it will
 *                               be parsed as a
 *                               toaddress?subject=foo&cc=ccaddress
 *                               (mailto-style) string.
 * @param optional array $extra  Hash of extra, non-standard arguments to
 *                               pass to compose.php.
 *
 * @return string  The link to the message composition screen.
 */
function _imp_compose($args = array(), $extra = array())
{
    global $prefs;

    $authentication = 'none';
    require_once dirname(__FILE__) . '/base.php';

    return IMP::composeLink($args, $extra);
}

/**
 * Returns the list of folders.
 *
 * @return array  The list of IMAP folders.
 */
function _imp_folderlist()
{
    $authentication = 'none';
    require_once dirname(__FILE__) . '/base.php';
    require_once IMP_BASE . '/lib/Folder.php';

    $result = false;

    if (IMP::checkAuthentication(OP_HALFOPEN, true) === true) {
        $imp_folder = &IMP_Folder::singleton();
        $result = $imp_folder->flist_IMP();
    }

    // Catch error messages from c-client.
    imap_errors();

    return $result;
}

/**
 * Creates a new folder.
 *
 * @return string  The full folder name created on success, an empty string
 *                 on failure.
 */
function _imp_createFolder($folder)
{
    $authentication = 'none';
    require_once dirname(__FILE__) . '/base.php';
    require_once IMP_BASE . '/lib/Folder.php';

    $foldername = IMP::addPreambleString($folder);
    $result = false;

    if (IMP::checkAuthentication(OP_HALFOPEN, true) === true) {
        $imp_folder = &IMP_Folder::singleton();
        $result = $imp_folder->create($_SESSION['imp']['stream'],
                                      $foldername,
                                      $GLOBALS['prefs']->getValue('subscribe'));
    }

    // Catch error messages from c-client.
    imap_errors();

    return (empty($result)) ? '' : $foldername;
}
