#
# $Horde: imp/packaging/redhat/imp.spec,v 1.10 2003/05/06 16:41:08 bjn Exp $
#
# Copyright 2003 Brent J. Nordquist <bjn@horde.org>
#
# See the enclosed file COPYING for license information (GPL). If you
# did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
#
# This is the SPEC file for the IMP Red Hat 7.x (RPM v4) RPMs/SRPM.
#

%define apachedir /etc/httpd
%define apacheuser apache
%define apachegroup apache
%define contentdir /var/www

Summary: The Internet Messaging Program: webmail access to IMAP/POP3 accounts.
Name: imp
Version: 3.2.1
Release: 1
License: GPL
Group: Applications/Horde
Source: ftp://ftp.horde.org/pub/imp/imp-%{version}.tar.gz
Source1: imp.conf
Vendor: The Horde Project
URL: http://www.horde.org/
Packager: Brent J. Nordquist <bjn@horde.org>
BuildArch: noarch
BuildRoot: %{_tmppath}/imp-root
Requires: php >= 4.2.1
Requires: php-imap >= 4.2.1
Requires: apache >= 1.3.22
Requires: horde >= 2.0
Prereq: /usr/bin/perl

%description
IMP is the Internet Messaging Program, one of the Horde applications.
It provides webmail access to IMAP and POP3 accounts.

The Horde Project writes web applications in PHP and releases them under
Open Source licenses.  For more information (including help with IMP)
please visit http://www.horde.org/.

%prep
%setup -q -n %{name}-%{version}

%build

%install
[ "$RPM_BUILD_ROOT" != "/" ] && rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT%{apachedir}/conf
cp -p %{SOURCE1} $RPM_BUILD_ROOT%{apachedir}/conf
mkdir -p $RPM_BUILD_ROOT%{contentdir}/html/horde/imp
cp -pR * $RPM_BUILD_ROOT%{contentdir}/html/horde/imp
chmod go-rwx $RPM_BUILD_ROOT%{contentdir}/html/horde/imp/test.php
cd $RPM_BUILD_ROOT%{contentdir}/html/horde/imp/config
for d in *.dist; do
	d0=`basename $d .dist`
	if [ ! -f "$d0" ]; then
		cp -p $d $d0
	fi
done

%clean
[ "$RPM_BUILD_ROOT" != "/" ] && rm -rf $RPM_BUILD_ROOT

%pre

%post
perl -pi -e 's/$/ index.php/ if (/DirectoryIndex\s.*index\.html/ && !/index\.php/);' %{apachedir}/conf/httpd.conf
grep -i 'Include.*imp.conf$' %{apachedir}/conf/httpd.conf >/dev/null 2>&1
if [ $? -eq 0 ]; then
	perl -pi -e 's/^#+// if (/Include.*imp.conf$/i);' %{apachedir}/conf/httpd.conf
else
	echo "Include %{apachedir}/conf/imp.conf" >>%{apachedir}/conf/httpd.conf
fi
# post-install instructions:
cat <<_EOF_
You must manually configure IMP!
See "CONFIGURING IMP" in %{contentdir}/html/horde/imp/docs/INSTALL
You must also restart Apache with "service httpd restart"!
_EOF_

%postun
if [ $1 -eq 0 ]; then
	perl -pi -e 's/^/#/ if (/^Include.*imp.conf$/i);' %{apachedir}/conf/httpd.conf
	cat <<_EOF2_
You must restart Apache with "service httpd restart"!
_EOF2_
fi

%files
%defattr(-,root,root)
# Apache imp.conf file
%config %{apachedir}/conf/imp.conf
# Include top level with %dir so not all files are sucked in
%dir %{contentdir}/html/horde/imp
# Include top-level files by hand
%{contentdir}/html/horde/imp/*.php
# Include these dirs so that all files _will_ get sucked in
%{contentdir}/html/horde/imp/download
%{contentdir}/html/horde/imp/graphics
%{contentdir}/html/horde/imp/lib
%{contentdir}/html/horde/imp/locale
%{contentdir}/html/horde/imp/po
%{contentdir}/html/horde/imp/scripts
%{contentdir}/html/horde/imp/templates
# Mark documentation files with %doc and %docdir
%doc %{contentdir}/html/horde/imp/COPYING
%doc %{contentdir}/html/horde/imp/README
%docdir %{contentdir}/html/horde/imp/docs
%{contentdir}/html/horde/imp/docs
# Mark configuration files with %config and use secure permissions
# (note that .dist files are considered software; don't mark %config)
%attr(750,root,%{apachegroup}) %dir %{contentdir}/html/horde/imp/config
%defattr(640,root,%{apachegroup})
%{contentdir}/html/horde/imp/config/.htaccess
%{contentdir}/html/horde/imp/config/*.dist
%config %{contentdir}/html/horde/imp/config/*.php
%config %{contentdir}/html/horde/imp/config/*.txt

%changelog
* Sun Apr 27 2003 Brent J. Nordquist <bjn@horde.org> 3.2.1-1
- Updated for 3.2.1

* Mon Jun 24 2002 Brent J. Nordquist <bjn@horde.org>
- 3.1 release 2

* Thu Jun 13 2002 Brent J. Nordquist <bjn@horde.org>
- 3.1 release 1 (private beta)

* Wed Jan 02 2002 Brent J. Nordquist <bjn@horde.org>
- 3.0 release 1

* Mon Dec 24 2001 Brent J. Nordquist <bjn@horde.org>
- 3.0-RC4 release 1

* Sat Dec 15 2001 Brent J. Nordquist <bjn@horde.org>
- rewritten for IMP 3.0

* Wed Nov 14 2001 Brent J. Nordquist <bjn@horde.org>
- 2.2.7 release 1rh7

* Sat Jul 21 2001 Brent J. Nordquist <bjn@horde.org>
- 2.2.6 release 1rh7

* Tue Feb 06 2001 Brent J. Nordquist <bjn@horde.org>
- 2.2.4 release 1rh7

