<?php
/**
 * $Horde: imp/smime.php,v 2.25 2003/06/17 07:53:46 slusarz Exp $
 *
 * Copyright 2002-2003 Michael Slusarz <slusarz@bigworm.colorado.edu>
 * Copyright 2002-2003 Mike Cochrane <mike@graftonhall.co.nz>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

function _importKeyDialog($target)
{
    global $actionID, $notification, $prefs, $registry, $selfURL;

    $title = _("Import S/MIME Key");
    require IMP_TEMPLATES . '/common-header.inc';
    IMP::status();
    require IMP_TEMPLATES . '/smime/import_key.inc';
}

function _getImportKey()
{
    global $notification;

    $key = Horde::getFormData('import_key');
    if (!empty($key)) return $key;

    require_once HORDE_BASE . '/lib/Server.php';
    $res = Server::wasFileUploaded('upload_key', _("key"));
    if (!is_a($res, 'PEAR_Error')) {
        foreach (file($_FILES['upload_key']['tmp_name']) as $value) {
            $temp_array[] = rtrim($value);
        }
        return implode("\n", $temp_array);
    } else {
        $notification->push($res, 'horde.error');
        return;
    }
}

function _outputPassphraseDialog()
{
    global $notification, $prefs, $registry, $secure_check, $selfURL;

    if (is_a($secure_check, 'PEAR_Error')) {
        $notification->push($secure_check, 'horde.error');
    }

    $title = _("S/MIME Passphrase Input");
    $js_onLoad = 'document.passphrase_dialog.passphrase.focus();';
    require IMP_TEMPLATES . '/common-header.inc';
    $submit_url = Horde::addParameter($selfURL, 'smimeActionID', 'process_passphrase_dialog');
    IMP::status();
    require IMP_TEMPLATES . '/smime/passphrase.inc';
}

function _actionWindow()
{
    require_once HORDE_BASE . '/lib/SessionObjects.php';

    $oid = Horde::getFormData('passphrase_action');
    $cacheSess = &Horde_SessionObjects::singleton();
    $cacheSess->setPruneFlag($oid, true);
    Horde::closeWindowJS($cacheSess->query($oid));
}

function _reloadWindow()
{
    Horde::closeWindowJS('opener.focus();opener.location.href="' . Horde::getFormData('reload') . '";');
}

define('IMP_BASE', dirname(__FILE__));
require_once IMP_BASE . '/lib/base.php';
require_once IMP_BASE . '/lib/SMIME.php';

$imp_smime = &new IMP_SMIME();
$secure_check = $imp_smime->requireSecureConnection();
$selfURL = Horde::applicationUrl('smime.php');

/* Run through the action handlers */
$actionID = Horde::getFormData('smimeActionID');
switch ($actionID) {
case 'open_passphrase_dialog':
    if ($imp_smime->getPassphrase()) {
        Horde::closeWindowJS();
    } else {
        _outputPassphraseDialog();
    }
    exit;

case 'process_passphrase_dialog':
    if (is_a($secure_check, 'PEAR_Error')) {
        _outputPassphraseDialog();
    } elseif (Horde::getFormData('passphrase')) {
        if ($imp_smime->storePassphrase(Horde::getFormData('passphrase'))) {
            if (Horde::getFormData('passphrase_action')) {
                _actionWindow();
            } elseif (Horde::getFormData('reload')) {
                _reloadWindow();
            } else {
                Horde::closeWindowJS();
            }
        } else {
            $notification->push("Invalid passphrase entered.", 'horde.error');
            _outputPassphraseDialog();
        }
    } else {
        $notification->push("No passphrase entered.", 'horde.error');
        _outputPassphraseDialog();
    }
    exit;

case 'delete_key':
    $imp_smime->deletePersonalKeys();
    $notification->push(_("Personal S/MIME keys deleted successfully."), 'horde.success');
    break;

case 'import_additional_cert':
case 'import_personal_public_key':
    _importKeyDialog('import_personal_private_key');
    exit;

case 'import_personal_private_key':
    /* Check the public key. */
    if (!($publicKey = _getImportKey())) {
        $notification->push(_("No personal S/MIME public key imported."), 'horde.error');
        $actionID = 'import_personal_public_key';
        _importKeyDialog('import_personal_private_key');
    } else {
        $imp_smime->addPersonalPublicKey($publicKey);
        _importKeyDialog('process_import_personal_key');
    }
    exit;

case 'process_import_personal_key':
    /* Check the private key. */
    if (!($privateKey = _getImportKey())) {
        $notification->push(_("No personal S/MIME private key imported."), 'horde.error');
        $actionID = 'import_personal_private_key';
        _importKeyDialog('process_import_personal_key');
    } else {
        $imp_smime->addPersonalPrivateKey($privateKey);
        $notification->push(_("S/MIME Public/Private Keypair successfully added."), 'horde.success');
        _reloadWindow();
    }
    exit;

case 'save_attachment_public_key':
    require_once HORDE_BASE . '/lib/SessionObjects.php';

    $cacheSess = &Horde_SessionObjects::singleton();
    $cert = $cacheSess->query(Horde::getFormData('cert'));

    /* Add the public key to the storage system. */
    $cert = $imp_smime->addPublicKey($cert, Horde::getFormData('from'));
    if ($cert == false) {
        $notification->push(_("No Certificate found"), 'horde.error');
    } else {
        Horde::closeWindowJS();
    }
    exit;

case 'unset_passphrase':
    $imp_smime->unsetPassphrase();
    $notification->push(_("Passphrase successfully unloaded."), 'horde.success');
    break;

case 'save_options':
    $prefs->setValue('use_smime', Horde::getFormData('use_smime'));
    $notification->push(_("Preferences successfully updated."), 'horde.success');
    break;
}

/* Get passphrase (if available). */
$passphrase = $imp_smime->getPassphrase();

$title = sprintf(_("%s S/MIME Administration"), _("Mail"));
$js_onLoad = null;
require IMP_TEMPLATES . '/common-header.inc';
IMP::menu();
IMP::status();
require_once HORDE_BASE . '/lib/PrefsUI.php';
require IMP_BASE . '/config/prefs.php';

/* If S/MIME preference not active, or openssl PHP extension not available,
   do NOT show S/MIME Admin screen. */
$openssl_check = $imp_smime->checkForOpenSSL();
if (!is_a($openssl_check, 'PEAR_Error') || $prefs->getValue('use_smime')) {
    $opensmimewin = $imp_smime->getJSOpenWinCode('open_passphrase_dialog');
    require_once IMP_TEMPLATES . '/smime/open_smime_win.js';
    require_once IMP_TEMPLATES . '/smime/open_smime_import.js';
    require IMP_TEMPLATES . '/smime/smime.inc';
} else {
    require IMP_TEMPLATES . '/smime/notactive.inc';
}

require IMP_TEMPLATES . '/common-footer.inc';
