<?php
/**
 * The Auth_mcal class provides an MCAL implementation of the Horde
 * authentication system.
 *
 * MCAL Home Page: http://mcal.chek.com/
 *
 * Required parameters:
 * ====================
 *   'calendar'  --  The MCAL calendar name.
 *
 *
 * $Horde: horde/lib/Auth/mcal.php,v 1.19 2003/07/10 21:42:56 slusarz Exp $
 *
 * Copyright 1999-2003 Chuck Hagenbuch <chuck@horde.org>
 *
 * See the enclosed file COPYING for license information (LGPL). If you
 * did not receive this file, see http://www.fsf.org/copyleft/lgpl.html.
 *
 * @author  Chuck Hagenbuch <chuck@horde.org>
 * @version $Revision: 1.19 $
 * @since   Horde 1.3
 * @package horde.auth
 */
class Auth_mcal extends Auth {

    /**
     * An array of capabilities, so that the driver can report which
     * operations it supports and which it doesn't.
     *
     * @var array $capabilities
     */
    var $capabilities = array('add'         => false,
                              'update'      => false,
                              'remove'      => false,
                              'list'        => true,
                              'transparent' => false,
                              'loginscreen' => false);

    /**
     * Constructs a new MCAL authentication object.
     *
     * @access public
     *
     * @param optional array $params  A hash containing connection parameters.
     */
    function Auth_mcal($params = array())
    {
        if (!Horde::extensionExists('mcal')) {
            Horde::fatal(PEAR::raiseError(_("Auth_mcal: Required MCAL extension not found."), __FILE__, __LINE__));
        }

        if (empty($params['calendar'])) {
            Horde::fatal(PEAR::raiseError(_("No calendar name provided for MCAL authentication.")), __FILE__, __LINE__);
        }

        $this->_params = $params;
    }

    /**
     * Find out if a set of login credentials are valid.
     *
     * @access private
     *
     * @param string $userID      The userID to check.
     * @param array $credentials  An array of login credentials. For MCAL,
     *                            this must contain a password entry.
     *
     * @return boolean  Whether or not the credentials are valid.
     */
    function _authenticate($userID, $credentials)
    {
        $mcal = @mcal_open($this->_params['calendar'], $userID, $credentials['password']);

        if ($mcal) {
            @mcal_close($mcal);
            Auth::setAuth($userID, $credentials);
            return true;
        } else {
            @mcal_close($mcal);
            $this->_setAuthError();
            return false;
        }
    }

    /**
     * List all users in the system.
     *
     * @access public
     *
     * @return mixed  The array of userIDs, or a PEAR_Error object on failure.
     */
    function listUsers()
    {
        $lines = @file('/etc/mpasswd');
        if (!$lines || !is_array($lines)) {
            return PEAR::raiseError('Unable to list users.');
        }

        $users = array();
        foreach ($lines as $line) {
            $users[] = substr($line, 0, strpos($line, ':'));
        }

        return $users;
    }

}
