<?php
/**
 * Horde base inclusion file.
 *
 * This file brings in all of the dependencies that Horde framework-level
 * scripts will need, and sets up objects that all scripts use.
 *
 * NB: this base file does _not_ check authentication, so as to avoid
 * an infinite loop on the Horde login page. You'll need to do it
 * yourself in framework-level pages.
 *
 * $Horde: horde/lib/base.php,v 1.24 2003/08/18 04:02:27 chuck Exp $
 *
 * Copyright 1999-2003 Chuck Hagenbuch <chuck@horde.org>
 *
 * See the enclosed file COPYING for license information (LGPL). If you
 * did not receive this file, see http://www.fsf.org/copyleft/lgpl.html.
 */

// Find the base file path of Horde
@define('HORDE_BASE', dirname(__FILE__) . '/..');

// Horde base libraries
require_once HORDE_BASE . '/lib/Horde.php';
require_once HORDE_BASE . '/lib/Auth.php';
require_once HORDE_BASE . '/lib/String.php';

// Browser detection object
require_once HORDE_BASE . '/lib/Browser.php';
$browser = &Browser::singleton();

// Registry
require_once HORDE_BASE . '/lib/Registry.php';
$registry = &Registry::singleton();
if (is_a($registry->pushApp('horde'), 'PEAR_Error')) {
    Horde::fatal(PEAR::raiseError(_("Horde is not correctly configured or there was an error loading configuration files.")), __FILE__, __LINE__, false);
}
$conf = &$GLOBALS['conf'];
@define('HORDE_TEMPLATES', $registry->getParam('templates'));

// Notification System
require_once HORDE_BASE . '/lib/Notification.php';
$notification = &Notification::singleton();
$notification->attach('status');
