<?php
/*
 * $Horde: turba/config/sources.php.dist,v 1.22.2.17 2003/02/10 01:14:22 jan Exp $
 *
 * This file is where you specify the sources of contacts available to
 * users at your installation. There are a number of properties that you
 * can set for each server, including:
 *
 * title: This is the common (user-visible) name that you want displayed
 * in the contact source drop-down box.
 *
 * type: The types 'ldap', 'sql' and 'prefs' are currently supported.
 *
 * params: These are the connection parameters specific to the contact
 * source. See below for examples of how to set these.
 *
 * map: This is a list of mappings from the standard Turba attribute
 * names (on the left) to the attribute names by which they are known in
 * this contact source (on the right).
 *
 * search: A list of Turba attribute names that can be searched for
 * this source.
 *
 * strict: A list of native field/attribute names that must always be
 * matched exactly in a search.
 *
 * public: If set to true, this source will be available to all users.
 * See also 'readonly' -- public=true readonly=false means writable
 * by all users!
 *
 * readonly: If set to true, this source can only be modified by users
 * on the 'admin' list.
 *
 * admin: A list (array) of users that are allowed to modify this source,
 * if it's marked 'readonly'.
 *
 * export: If set to true, this source will appear on the Export menu,
 * allowing users to export the contacts to a CSV (etc.) file.
 *
 * encoding: Some LDAP servers use UTF8 for encoding. See below for
 * examples.
 *
 * Here are some example configurations:
 */

/**
 * A local address book in an LDAP directory. This implements a public
 * (shared) address book.
 */
 $cfgSources['localldap'] = array(
    'title' => 'Shared Directory',
    'type' => 'ldap',
    'params' => array(
        'server' => $conf['server']['ldaphost'],
        'port' => 389,
        'root' => $conf['server']['ldapbasedn'],
        'dn' => array('cn'),
        'objectclass' => 'inetOrgPerson',
        'version' => 3
    ),
    'map' => array(
        '__key' => 'dn',
        'name' => 'cn',
        'email' => 'mail',
        'homePhone' => 'homephone',
        'workPhone' => 'telephonenumber',
        'cellPhone' => 'mobiletelephonenumber',
        'homeAddress' => 'homepostaladdress'
    ),
    'search' => array(
        'name',
        'email',
        'homePhone',
        'workPhone',
        'cellPhone',
        'homeAddress'
    ),
    'strict' => array(
        'dn'
    ),
    'public' => true,
    'readonly' => true,
    'admin' => array(),
    'export' => true
);

$cfgSources['kolab'] = array(
    'title' => 'Kolab server',
    'type' => 'kolab',
    'params' => array(
        'folder' => 'INBOX/Contacts',
        'server' => $conf['server']['name']
    ),
    'map' => array(
        '__key' => 'uid',
        'name' => 'fn',
        'alias' => 'nickname',
        'email' => 'email',
        'company' => 'org',
        'homeAddress' => 'home_street',
        'homeBox' => 'home_postalbox',
        'homeLocality' => 'home_locality',
        'homeRegion' => 'home_region',
        'homePostalCode' => 'home_code',
        'homeCountry' => 'home_country',
        'workAddress' => 'work_street',
        'workBox' => 'work_postalbox',
        'workLocality' => 'work_locality',
        'workRegion' => 'work_region',
        'workPostalCode' => 'work_code',
        'workCountry' => 'work_country',
        'workPhone' => 'work_phone',
        'homePhone' => 'home_phone',
        'cellPhone' => 'cell_phone',
        'fax' => 'fax',
        'notes' => 'note'
    ),
    'search' => array(
        'name',
        'email'
    ),
    'strict' => array(
        'uid'
    ),
    'public' => false,
    'readonly' => false,
    'admin' => array(),
    'export' => true
);
