<?php
/**
 * Turba base inclusion file.
 *
 * $Horde: turba/lib/base.php,v 1.45 2003/04/20 20:51:24 chuck Exp $
 *
 * This file brings in all of the dependencies that every Turba script
 * will need, and sets up objects that all scripts use.
 */

// Find the base file path of Horde
@define('HORDE_BASE', dirname(__FILE__) . '/../..');

// Find the base file path of Turba
@define('TURBA_BASE', dirname(__FILE__) . '/..');

// Browser detection library
require_once HORDE_BASE . '/lib/Browser.php';
$browser = &Browser::singleton();

// Registry
require_once HORDE_BASE . '/lib/Registry.php';
$registry = &Registry::singleton();
$registry->pushApp('turba');
$conf = &$GLOBALS['conf'];
@define('TURBA_TEMPLATES', $registry->getParam('templates'));

// Horde base libraries
require_once HORDE_BASE . '/lib/Horde.php';
require_once HORDE_BASE . '/lib/Auth.php';
require_once HORDE_BASE . '/lib/Secret.php';

// Create a share instance.
require_once HORDE_BASE . '/lib/Share.php';
$GLOBALS['shares'] = &Horde_Share::singleton($registry->getApp());

// Turba base library
require_once TURBA_BASE . '/lib/Turba.php';

// Turba sources configuration
require TURBA_BASE . '/config/sources.php';
$GLOBALS['cfgSources'] = &$cfgSources;

// Help
require_once HORDE_BASE . '/lib/Help.php';

// Notification system.
require_once HORDE_BASE . '/lib/Notification.php';
$notification = &Notification::singleton();
$notification->attach('status');

// Don't allow access unless there is a Horde login, or guests are
// allowed.
if (!(Auth::isAuthenticated() || $registry->allowGuests())) {
    Horde::authenticationFailureRedirect();
}

/* Start compression, if requested. */
Horde::compressOutput();
