<?php
/**
 * $Horde: vacation/main.php,v 1.35 2003/09/24 15:23:07 chuck Exp $
 *
 * Copyright 2001-2003 Eric Rostetter <eric.rostetter@physics.utexas.edu>
 *
 * See the enclosed file LICENSE for license information (BSD). If you
 * did not receive this file, see http://www.horde.org/licenses/bsdl.php.
 */

define('VACATION_BASE', dirname(__FILE__));
require_once VACATION_BASE . '/lib/base.php';

// Create a driver.
require_once VACATION_BASE . '/lib/Driver.php';
$driver = &Vacation_Driver::factory();

// Get the current login username and realm.
$split = explode('@', Auth::getAuth());
$user = @$split[0];
$realm = @$split[1];
if (empty($realm)) {
    $realm = 'default';
}

$submit = Horde::getFormData('submit', false);

if ($submit) {
    $vacationmode = Horde::getFormData('mode', 'error');
    if ($vacationmode === 'error') {
        $notification->push(_("You must specify the mode (set or remove)"),
                            'horde.warning');
    }

    // Check for refused usernames, using current horde username.
    if (in_array($user, $conf['user']['refused'])) {
        $notification->push(sprintf(_("You can't change the vacation notice for %s."), $user), 'horde.error');
        $vacationmode = 'error';
    }

    if ($driver->getParam('hordeauth', $realm)) {
        $password = Auth::getCredential('password');
    } else {
        $password = Horde::getFormData('password', false);
        if (empty($password)) {
            $notification->push(_("You must give your password"), 'horde.warning');
            $vacationmode = 'error';
        }
    }

    // Call the requested function.
    switch ($vacationmode) {
    case 'set':
        $alias = Horde::getFormData('alias', '');
        $vacationmsg = Horde::getFormData('mess', false);
        if (!$vacationmsg) {
            $notification->push(_("You must give a vacation message."),
                                'horde.warning');
        } elseif (!empty($conf['vacation']['validation_pattern']) &&
                  !@preg_match($conf['vacation']['validation_pattern'], $vacationmsg)) {
            // Validation is required, and wasn't matched.
            $notification->push(_("Your vacation message is not in the proper format."),
                                'horde.warning');
        } else {
            // Try and make sure to send Unix linefeeds.
            $vacationmsg = str_replace("\r\n", "\n", $vacationmsg);
            $vacationmsg = str_replace("\r", "\n", $vacationmsg);

            // Wrap at 75 characters.
            $vacationmsg = wordwrap($vacationmsg);

            if ($driver->setVacation($user, $realm, $password,
                                     $vacationmsg, $alias)) {
                $notification->push(_("Vacation notice successfully enabled."), 'horde.success');
            } else {
                $notification->push(_("Failure in modifying vacation notice: ")
                                   . $driver->err_str, 'horde.error');
            }
        }
        break;

    case 'unset':
        if ($driver->unsetVacation($user, $realm, $password)) {
            $notification->push(_("Vacation notice successfully removed."), 'horde.success');
        } else {
            $notification->push(_("Failure in removing vacation notice: ") .
                                $driver->err_str, 'horde.error');
        }
        break;
    }
}

// If we can tell if vacation notices are enabled, then say so. But if
// this fails, it could be because it is disabled, or just because we
// can't tell, so just be quiet about it.
$pass = Auth::getCredential('password');
if ($driver->isEnabled($user, $realm, $pass)) {
    $curmessage = $driver->currentMessage($user, $realm, $pass);
    $notification->push(_("Your vacation notice is currently enabled."), 'horde.success');
} else {
    $curmessage = $conf['vacation']['default'];
}

$title = _("Change Vacation Notices");
require VACATION_TEMPLATES . '/common-header.inc';
Vacation::menu();
require VACATION_TEMPLATES . '/main/main.inc';
require VACATION_TEMPLATES . '/common-footer.inc';
