/* Signal handling function for threaded programs.
   Copyright (C) 1998 Free Software Foundation, Inc.
   This file is part of the GNU C Library.

   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

#ifndef _BITS_SIGTHREAD_H 
#define _BITS_SIGTHREAD_H	1

#if !defined _SIGNAL_H && !defined _PTHREAD_H
# error "Never include this file directly.  Use <pthread.h> instead"
#endif

__BEGIN_DECLS

/* Functions for handling signals. */

/* Modify the signal mask for the calling thread.  The arguments have
   the same meaning as for sigprocmask(2). */
extern int pthread_sigmask __P ((int __how, __const __sigset_t *__newmask,
				 __sigset_t *__oldmask));

/* Send signal SIGNO to the given thread. */
extern int pthread_kill __P ((pthread_t __thread, int __signo));

__END_DECLS

#endif	/* bits/sigthread.h */
