# coding: utf-8

"""
    PeerTube

    # Introduction  The PeerTube API is built on HTTP(S) and is RESTful. You can use your favorite HTTP/REST library for your programming language to use PeerTube. The spec API is fully compatible with [openapi-generator](https://github.com/OpenAPITools/openapi-generator/wiki/API-client-generator-HOWTO) which generates a client SDK in the language of your choice - we generate some client SDKs automatically:  - [Python](https://framagit.org/framasoft/peertube/clients/python) - [Go](https://framagit.org/framasoft/peertube/clients/go) - [Kotlin](https://framagit.org/framasoft/peertube/clients/kotlin)  See the [Quick Start guide](https://docs.joinpeertube.org/#/api-rest-getting-started) so you can play with the PeerTube API.  # Authentication  When you sign up for an account, you are given the possibility to generate sessions, and authenticate using this session token. One session token can currently be used at a time.  ## Roles  Accounts are given permissions based on their role. There are three roles on PeerTube: Administrator, Moderator, and User. See the [roles guide](https://docs.joinpeertube.org/#/admin-managing-users?id=roles) for a detail of their permissions.  # Errors  The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be JSON in the following format.  ``` {   \"code\": \"unauthorized_request\", // example inner error code   \"error\": \"Token is invalid.\" // example exposed error message } ```   # noqa: E501

    The version of the OpenAPI document: 2.4.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from peertube.configuration import Configuration


class AddUser(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'username': 'str',
        'password': 'str',
        'email': 'str',
        'video_quota': 'int',
        'video_quota_daily': 'int',
        'role': 'UserRole'
    }

    attribute_map = {
        'username': 'username',
        'password': 'password',
        'email': 'email',
        'video_quota': 'videoQuota',
        'video_quota_daily': 'videoQuotaDaily',
        'role': 'role'
    }

    def __init__(self, username=None, password=None, email=None, video_quota=None, video_quota_daily=None, role=None, local_vars_configuration=None):  # noqa: E501
        """AddUser - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._username = None
        self._password = None
        self._email = None
        self._video_quota = None
        self._video_quota_daily = None
        self._role = None
        self.discriminator = None

        self.username = username
        self.password = password
        self.email = email
        self.video_quota = video_quota
        self.video_quota_daily = video_quota_daily
        self.role = role

    @property
    def username(self):
        """Gets the username of this AddUser.  # noqa: E501

        The user username  # noqa: E501

        :return: The username of this AddUser.  # noqa: E501
        :rtype: str
        """
        return self._username

    @username.setter
    def username(self, username):
        """Sets the username of this AddUser.

        The user username  # noqa: E501

        :param username: The username of this AddUser.  # noqa: E501
        :type username: str
        """
        if self.local_vars_configuration.client_side_validation and username is None:  # noqa: E501
            raise ValueError("Invalid value for `username`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                username is not None and len(username) > 50):
            raise ValueError("Invalid value for `username`, length must be less than or equal to `50`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                username is not None and len(username) < 1):
            raise ValueError("Invalid value for `username`, length must be greater than or equal to `1`")  # noqa: E501

        self._username = username

    @property
    def password(self):
        """Gets the password of this AddUser.  # noqa: E501

        The user password. If the smtp server is configured, you can leave empty and an email will be sent  # noqa: E501

        :return: The password of this AddUser.  # noqa: E501
        :rtype: str
        """
        return self._password

    @password.setter
    def password(self, password):
        """Sets the password of this AddUser.

        The user password. If the smtp server is configured, you can leave empty and an email will be sent  # noqa: E501

        :param password: The password of this AddUser.  # noqa: E501
        :type password: str
        """
        if self.local_vars_configuration.client_side_validation and password is None:  # noqa: E501
            raise ValueError("Invalid value for `password`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                password is not None and len(password) > 255):
            raise ValueError("Invalid value for `password`, length must be less than or equal to `255`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                password is not None and len(password) < 6):
            raise ValueError("Invalid value for `password`, length must be greater than or equal to `6`")  # noqa: E501

        self._password = password

    @property
    def email(self):
        """Gets the email of this AddUser.  # noqa: E501

        The user email  # noqa: E501

        :return: The email of this AddUser.  # noqa: E501
        :rtype: str
        """
        return self._email

    @email.setter
    def email(self, email):
        """Sets the email of this AddUser.

        The user email  # noqa: E501

        :param email: The email of this AddUser.  # noqa: E501
        :type email: str
        """
        if self.local_vars_configuration.client_side_validation and email is None:  # noqa: E501
            raise ValueError("Invalid value for `email`, must not be `None`")  # noqa: E501

        self._email = email

    @property
    def video_quota(self):
        """Gets the video_quota of this AddUser.  # noqa: E501

        The user video quota  # noqa: E501

        :return: The video_quota of this AddUser.  # noqa: E501
        :rtype: int
        """
        return self._video_quota

    @video_quota.setter
    def video_quota(self, video_quota):
        """Sets the video_quota of this AddUser.

        The user video quota  # noqa: E501

        :param video_quota: The video_quota of this AddUser.  # noqa: E501
        :type video_quota: int
        """
        if self.local_vars_configuration.client_side_validation and video_quota is None:  # noqa: E501
            raise ValueError("Invalid value for `video_quota`, must not be `None`")  # noqa: E501

        self._video_quota = video_quota

    @property
    def video_quota_daily(self):
        """Gets the video_quota_daily of this AddUser.  # noqa: E501

        The user daily video quota  # noqa: E501

        :return: The video_quota_daily of this AddUser.  # noqa: E501
        :rtype: int
        """
        return self._video_quota_daily

    @video_quota_daily.setter
    def video_quota_daily(self, video_quota_daily):
        """Sets the video_quota_daily of this AddUser.

        The user daily video quota  # noqa: E501

        :param video_quota_daily: The video_quota_daily of this AddUser.  # noqa: E501
        :type video_quota_daily: int
        """
        if self.local_vars_configuration.client_side_validation and video_quota_daily is None:  # noqa: E501
            raise ValueError("Invalid value for `video_quota_daily`, must not be `None`")  # noqa: E501

        self._video_quota_daily = video_quota_daily

    @property
    def role(self):
        """Gets the role of this AddUser.  # noqa: E501


        :return: The role of this AddUser.  # noqa: E501
        :rtype: UserRole
        """
        return self._role

    @role.setter
    def role(self, role):
        """Sets the role of this AddUser.


        :param role: The role of this AddUser.  # noqa: E501
        :type role: UserRole
        """
        if self.local_vars_configuration.client_side_validation and role is None:  # noqa: E501
            raise ValueError("Invalid value for `role`, must not be `None`")  # noqa: E501

        self._role = role

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AddUser):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, AddUser):
            return True

        return self.to_dict() != other.to_dict()
