# coding: utf-8

"""
    PeerTube

    # Introduction  The PeerTube API is built on HTTP(S) and is RESTful. You can use your favorite HTTP/REST library for your programming language to use PeerTube. The spec API is fully compatible with [openapi-generator](https://github.com/OpenAPITools/openapi-generator/wiki/API-client-generator-HOWTO) which generates a client SDK in the language of your choice - we generate some client SDKs automatically:  - [Python](https://framagit.org/framasoft/peertube/clients/python) - [Go](https://framagit.org/framasoft/peertube/clients/go) - [Kotlin](https://framagit.org/framasoft/peertube/clients/kotlin)  See the [Quick Start guide](https://docs.joinpeertube.org/#/api-rest-getting-started) so you can play with the PeerTube API.  # Authentication  When you sign up for an account, you are given the possibility to generate sessions, and authenticate using this session token. One session token can currently be used at a time.  ## Roles  Accounts are given permissions based on their role. There are three roles on PeerTube: Administrator, Moderator, and User. See the [roles guide](https://docs.joinpeertube.org/#/admin-managing-users?id=roles) for a detail of their permissions.  # Errors  The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be JSON in the following format.  ``` {   \"code\": \"unauthorized_request\", // example inner error code   \"error\": \"Token is invalid.\" // example exposed error message } ```   # noqa: E501

    The version of the OpenAPI document: 2.4.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from peertube.configuration import Configuration


class ServerConfigCustomTranscoding(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'enabled': 'bool',
        'allow_additional_extensions': 'bool',
        'allow_audio_files': 'bool',
        'threads': 'int',
        'resolutions': 'ServerConfigCustomTranscodingResolutions',
        'hls': 'ServerConfigEmail'
    }

    attribute_map = {
        'enabled': 'enabled',
        'allow_additional_extensions': 'allowAdditionalExtensions',
        'allow_audio_files': 'allowAudioFiles',
        'threads': 'threads',
        'resolutions': 'resolutions',
        'hls': 'hls'
    }

    def __init__(self, enabled=None, allow_additional_extensions=None, allow_audio_files=None, threads=None, resolutions=None, hls=None, local_vars_configuration=None):  # noqa: E501
        """ServerConfigCustomTranscoding - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._enabled = None
        self._allow_additional_extensions = None
        self._allow_audio_files = None
        self._threads = None
        self._resolutions = None
        self._hls = None
        self.discriminator = None

        if enabled is not None:
            self.enabled = enabled
        if allow_additional_extensions is not None:
            self.allow_additional_extensions = allow_additional_extensions
        if allow_audio_files is not None:
            self.allow_audio_files = allow_audio_files
        if threads is not None:
            self.threads = threads
        if resolutions is not None:
            self.resolutions = resolutions
        if hls is not None:
            self.hls = hls

    @property
    def enabled(self):
        """Gets the enabled of this ServerConfigCustomTranscoding.  # noqa: E501


        :return: The enabled of this ServerConfigCustomTranscoding.  # noqa: E501
        :rtype: bool
        """
        return self._enabled

    @enabled.setter
    def enabled(self, enabled):
        """Sets the enabled of this ServerConfigCustomTranscoding.


        :param enabled: The enabled of this ServerConfigCustomTranscoding.  # noqa: E501
        :type enabled: bool
        """

        self._enabled = enabled

    @property
    def allow_additional_extensions(self):
        """Gets the allow_additional_extensions of this ServerConfigCustomTranscoding.  # noqa: E501


        :return: The allow_additional_extensions of this ServerConfigCustomTranscoding.  # noqa: E501
        :rtype: bool
        """
        return self._allow_additional_extensions

    @allow_additional_extensions.setter
    def allow_additional_extensions(self, allow_additional_extensions):
        """Sets the allow_additional_extensions of this ServerConfigCustomTranscoding.


        :param allow_additional_extensions: The allow_additional_extensions of this ServerConfigCustomTranscoding.  # noqa: E501
        :type allow_additional_extensions: bool
        """

        self._allow_additional_extensions = allow_additional_extensions

    @property
    def allow_audio_files(self):
        """Gets the allow_audio_files of this ServerConfigCustomTranscoding.  # noqa: E501


        :return: The allow_audio_files of this ServerConfigCustomTranscoding.  # noqa: E501
        :rtype: bool
        """
        return self._allow_audio_files

    @allow_audio_files.setter
    def allow_audio_files(self, allow_audio_files):
        """Sets the allow_audio_files of this ServerConfigCustomTranscoding.


        :param allow_audio_files: The allow_audio_files of this ServerConfigCustomTranscoding.  # noqa: E501
        :type allow_audio_files: bool
        """

        self._allow_audio_files = allow_audio_files

    @property
    def threads(self):
        """Gets the threads of this ServerConfigCustomTranscoding.  # noqa: E501


        :return: The threads of this ServerConfigCustomTranscoding.  # noqa: E501
        :rtype: int
        """
        return self._threads

    @threads.setter
    def threads(self, threads):
        """Sets the threads of this ServerConfigCustomTranscoding.


        :param threads: The threads of this ServerConfigCustomTranscoding.  # noqa: E501
        :type threads: int
        """

        self._threads = threads

    @property
    def resolutions(self):
        """Gets the resolutions of this ServerConfigCustomTranscoding.  # noqa: E501


        :return: The resolutions of this ServerConfigCustomTranscoding.  # noqa: E501
        :rtype: ServerConfigCustomTranscodingResolutions
        """
        return self._resolutions

    @resolutions.setter
    def resolutions(self, resolutions):
        """Sets the resolutions of this ServerConfigCustomTranscoding.


        :param resolutions: The resolutions of this ServerConfigCustomTranscoding.  # noqa: E501
        :type resolutions: ServerConfigCustomTranscodingResolutions
        """

        self._resolutions = resolutions

    @property
    def hls(self):
        """Gets the hls of this ServerConfigCustomTranscoding.  # noqa: E501


        :return: The hls of this ServerConfigCustomTranscoding.  # noqa: E501
        :rtype: ServerConfigEmail
        """
        return self._hls

    @hls.setter
    def hls(self, hls):
        """Sets the hls of this ServerConfigCustomTranscoding.


        :param hls: The hls of this ServerConfigCustomTranscoding.  # noqa: E501
        :type hls: ServerConfigEmail
        """

        self._hls = hls

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ServerConfigCustomTranscoding):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ServerConfigCustomTranscoding):
            return True

        return self.to_dict() != other.to_dict()
