# coding: utf-8

"""
    PeerTube

    # Introduction  The PeerTube API is built on HTTP(S) and is RESTful. You can use your favorite HTTP/REST library for your programming language to use PeerTube. The spec API is fully compatible with [openapi-generator](https://github.com/OpenAPITools/openapi-generator/wiki/API-client-generator-HOWTO) which generates a client SDK in the language of your choice - we generate some client SDKs automatically:  - [Python](https://framagit.org/framasoft/peertube/clients/python) - [Go](https://framagit.org/framasoft/peertube/clients/go) - [Kotlin](https://framagit.org/framasoft/peertube/clients/kotlin)  See the [Quick Start guide](https://docs.joinpeertube.org/#/api-rest-getting-started) so you can play with the PeerTube API.  # Authentication  When you sign up for an account, you are given the possibility to generate sessions, and authenticate using this session token. One session token can currently be used at a time.  ## Roles  Accounts are given permissions based on their role. There are three roles on PeerTube: Administrator, Moderator, and User. See the [roles guide](https://docs.joinpeertube.org/#/admin-managing-users?id=roles) for a detail of their permissions.  # Errors  The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be JSON in the following format.  ``` {   \"code\": \"unauthorized_request\", // example inner error code   \"error\": \"Token is invalid.\" // example exposed error message } ```   # noqa: E501

    The version of the OpenAPI document: 2.4.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from peertube.configuration import Configuration


class UpdateUser(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'email': 'str',
        'video_quota': 'int',
        'video_quota_daily': 'int',
        'role': 'UserRole'
    }

    attribute_map = {
        'id': 'id',
        'email': 'email',
        'video_quota': 'videoQuota',
        'video_quota_daily': 'videoQuotaDaily',
        'role': 'role'
    }

    def __init__(self, id=None, email=None, video_quota=None, video_quota_daily=None, role=None, local_vars_configuration=None):  # noqa: E501
        """UpdateUser - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._email = None
        self._video_quota = None
        self._video_quota_daily = None
        self._role = None
        self.discriminator = None

        self.id = id
        self.email = email
        self.video_quota = video_quota
        self.video_quota_daily = video_quota_daily
        self.role = role

    @property
    def id(self):
        """Gets the id of this UpdateUser.  # noqa: E501

        The user id  # noqa: E501

        :return: The id of this UpdateUser.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this UpdateUser.

        The user id  # noqa: E501

        :param id: The id of this UpdateUser.  # noqa: E501
        :type id: str
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def email(self):
        """Gets the email of this UpdateUser.  # noqa: E501

        The updated email of the user  # noqa: E501

        :return: The email of this UpdateUser.  # noqa: E501
        :rtype: str
        """
        return self._email

    @email.setter
    def email(self, email):
        """Sets the email of this UpdateUser.

        The updated email of the user  # noqa: E501

        :param email: The email of this UpdateUser.  # noqa: E501
        :type email: str
        """
        if self.local_vars_configuration.client_side_validation and email is None:  # noqa: E501
            raise ValueError("Invalid value for `email`, must not be `None`")  # noqa: E501

        self._email = email

    @property
    def video_quota(self):
        """Gets the video_quota of this UpdateUser.  # noqa: E501

        The updated video quota of the user  # noqa: E501

        :return: The video_quota of this UpdateUser.  # noqa: E501
        :rtype: int
        """
        return self._video_quota

    @video_quota.setter
    def video_quota(self, video_quota):
        """Sets the video_quota of this UpdateUser.

        The updated video quota of the user  # noqa: E501

        :param video_quota: The video_quota of this UpdateUser.  # noqa: E501
        :type video_quota: int
        """
        if self.local_vars_configuration.client_side_validation and video_quota is None:  # noqa: E501
            raise ValueError("Invalid value for `video_quota`, must not be `None`")  # noqa: E501

        self._video_quota = video_quota

    @property
    def video_quota_daily(self):
        """Gets the video_quota_daily of this UpdateUser.  # noqa: E501

        The updated daily video quota of the user  # noqa: E501

        :return: The video_quota_daily of this UpdateUser.  # noqa: E501
        :rtype: int
        """
        return self._video_quota_daily

    @video_quota_daily.setter
    def video_quota_daily(self, video_quota_daily):
        """Sets the video_quota_daily of this UpdateUser.

        The updated daily video quota of the user  # noqa: E501

        :param video_quota_daily: The video_quota_daily of this UpdateUser.  # noqa: E501
        :type video_quota_daily: int
        """
        if self.local_vars_configuration.client_side_validation and video_quota_daily is None:  # noqa: E501
            raise ValueError("Invalid value for `video_quota_daily`, must not be `None`")  # noqa: E501

        self._video_quota_daily = video_quota_daily

    @property
    def role(self):
        """Gets the role of this UpdateUser.  # noqa: E501


        :return: The role of this UpdateUser.  # noqa: E501
        :rtype: UserRole
        """
        return self._role

    @role.setter
    def role(self, role):
        """Sets the role of this UpdateUser.


        :param role: The role of this UpdateUser.  # noqa: E501
        :type role: UserRole
        """
        if self.local_vars_configuration.client_side_validation and role is None:  # noqa: E501
            raise ValueError("Invalid value for `role`, must not be `None`")  # noqa: E501

        self._role = role

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, UpdateUser):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, UpdateUser):
            return True

        return self.to_dict() != other.to_dict()
