# coding: utf-8

"""
    PeerTube

    # Introduction  The PeerTube API is built on HTTP(S) and is RESTful. You can use your favorite HTTP/REST library for your programming language to use PeerTube. The spec API is fully compatible with [openapi-generator](https://github.com/OpenAPITools/openapi-generator/wiki/API-client-generator-HOWTO) which generates a client SDK in the language of your choice - we generate some client SDKs automatically:  - [Python](https://framagit.org/framasoft/peertube/clients/python) - [Go](https://framagit.org/framasoft/peertube/clients/go) - [Kotlin](https://framagit.org/framasoft/peertube/clients/kotlin)  See the [Quick Start guide](https://docs.joinpeertube.org/#/api-rest-getting-started) so you can play with the PeerTube API.  # Authentication  When you sign up for an account, you are given the possibility to generate sessions, and authenticate using this session token. One session token can currently be used at a time.  ## Roles  Accounts are given permissions based on their role. There are three roles on PeerTube: Administrator, Moderator, and User. See the [roles guide](https://docs.joinpeertube.org/#/admin-managing-users?id=roles) for a detail of their permissions.  # Errors  The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be JSON in the following format.  ``` {   \"code\": \"unauthorized_request\", // example inner error code   \"error\": \"Token is invalid.\" // example exposed error message } ```   # noqa: E501

    The version of the OpenAPI document: 2.4.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from peertube.configuration import Configuration


class VideoPlaylist(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'int',
        'created_at': 'datetime',
        'updated_at': 'datetime',
        'description': 'str',
        'uuid': 'str',
        'display_name': 'str',
        'is_local': 'bool',
        'video_length': 'int',
        'thumbnail_path': 'str',
        'privacy': 'VideoPlaylistPrivacyConstant',
        'type': 'VideoPlaylistTypeConstant',
        'owner_account': 'AccountSummary',
        'video_channel': 'VideoChannelSummary'
    }

    attribute_map = {
        'id': 'id',
        'created_at': 'createdAt',
        'updated_at': 'updatedAt',
        'description': 'description',
        'uuid': 'uuid',
        'display_name': 'displayName',
        'is_local': 'isLocal',
        'video_length': 'videoLength',
        'thumbnail_path': 'thumbnailPath',
        'privacy': 'privacy',
        'type': 'type',
        'owner_account': 'ownerAccount',
        'video_channel': 'videoChannel'
    }

    def __init__(self, id=None, created_at=None, updated_at=None, description=None, uuid=None, display_name=None, is_local=None, video_length=None, thumbnail_path=None, privacy=None, type=None, owner_account=None, video_channel=None, local_vars_configuration=None):  # noqa: E501
        """VideoPlaylist - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._created_at = None
        self._updated_at = None
        self._description = None
        self._uuid = None
        self._display_name = None
        self._is_local = None
        self._video_length = None
        self._thumbnail_path = None
        self._privacy = None
        self._type = None
        self._owner_account = None
        self._video_channel = None
        self.discriminator = None

        if id is not None:
            self.id = id
        if created_at is not None:
            self.created_at = created_at
        if updated_at is not None:
            self.updated_at = updated_at
        if description is not None:
            self.description = description
        if uuid is not None:
            self.uuid = uuid
        if display_name is not None:
            self.display_name = display_name
        if is_local is not None:
            self.is_local = is_local
        if video_length is not None:
            self.video_length = video_length
        if thumbnail_path is not None:
            self.thumbnail_path = thumbnail_path
        if privacy is not None:
            self.privacy = privacy
        if type is not None:
            self.type = type
        if owner_account is not None:
            self.owner_account = owner_account
        if video_channel is not None:
            self.video_channel = video_channel

    @property
    def id(self):
        """Gets the id of this VideoPlaylist.  # noqa: E501


        :return: The id of this VideoPlaylist.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this VideoPlaylist.


        :param id: The id of this VideoPlaylist.  # noqa: E501
        :type id: int
        """

        self._id = id

    @property
    def created_at(self):
        """Gets the created_at of this VideoPlaylist.  # noqa: E501


        :return: The created_at of this VideoPlaylist.  # noqa: E501
        :rtype: datetime
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this VideoPlaylist.


        :param created_at: The created_at of this VideoPlaylist.  # noqa: E501
        :type created_at: datetime
        """

        self._created_at = created_at

    @property
    def updated_at(self):
        """Gets the updated_at of this VideoPlaylist.  # noqa: E501


        :return: The updated_at of this VideoPlaylist.  # noqa: E501
        :rtype: datetime
        """
        return self._updated_at

    @updated_at.setter
    def updated_at(self, updated_at):
        """Sets the updated_at of this VideoPlaylist.


        :param updated_at: The updated_at of this VideoPlaylist.  # noqa: E501
        :type updated_at: datetime
        """

        self._updated_at = updated_at

    @property
    def description(self):
        """Gets the description of this VideoPlaylist.  # noqa: E501


        :return: The description of this VideoPlaylist.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this VideoPlaylist.


        :param description: The description of this VideoPlaylist.  # noqa: E501
        :type description: str
        """

        self._description = description

    @property
    def uuid(self):
        """Gets the uuid of this VideoPlaylist.  # noqa: E501


        :return: The uuid of this VideoPlaylist.  # noqa: E501
        :rtype: str
        """
        return self._uuid

    @uuid.setter
    def uuid(self, uuid):
        """Sets the uuid of this VideoPlaylist.


        :param uuid: The uuid of this VideoPlaylist.  # noqa: E501
        :type uuid: str
        """

        self._uuid = uuid

    @property
    def display_name(self):
        """Gets the display_name of this VideoPlaylist.  # noqa: E501


        :return: The display_name of this VideoPlaylist.  # noqa: E501
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """Sets the display_name of this VideoPlaylist.


        :param display_name: The display_name of this VideoPlaylist.  # noqa: E501
        :type display_name: str
        """

        self._display_name = display_name

    @property
    def is_local(self):
        """Gets the is_local of this VideoPlaylist.  # noqa: E501


        :return: The is_local of this VideoPlaylist.  # noqa: E501
        :rtype: bool
        """
        return self._is_local

    @is_local.setter
    def is_local(self, is_local):
        """Sets the is_local of this VideoPlaylist.


        :param is_local: The is_local of this VideoPlaylist.  # noqa: E501
        :type is_local: bool
        """

        self._is_local = is_local

    @property
    def video_length(self):
        """Gets the video_length of this VideoPlaylist.  # noqa: E501


        :return: The video_length of this VideoPlaylist.  # noqa: E501
        :rtype: int
        """
        return self._video_length

    @video_length.setter
    def video_length(self, video_length):
        """Sets the video_length of this VideoPlaylist.


        :param video_length: The video_length of this VideoPlaylist.  # noqa: E501
        :type video_length: int
        """

        self._video_length = video_length

    @property
    def thumbnail_path(self):
        """Gets the thumbnail_path of this VideoPlaylist.  # noqa: E501


        :return: The thumbnail_path of this VideoPlaylist.  # noqa: E501
        :rtype: str
        """
        return self._thumbnail_path

    @thumbnail_path.setter
    def thumbnail_path(self, thumbnail_path):
        """Sets the thumbnail_path of this VideoPlaylist.


        :param thumbnail_path: The thumbnail_path of this VideoPlaylist.  # noqa: E501
        :type thumbnail_path: str
        """

        self._thumbnail_path = thumbnail_path

    @property
    def privacy(self):
        """Gets the privacy of this VideoPlaylist.  # noqa: E501


        :return: The privacy of this VideoPlaylist.  # noqa: E501
        :rtype: VideoPlaylistPrivacyConstant
        """
        return self._privacy

    @privacy.setter
    def privacy(self, privacy):
        """Sets the privacy of this VideoPlaylist.


        :param privacy: The privacy of this VideoPlaylist.  # noqa: E501
        :type privacy: VideoPlaylistPrivacyConstant
        """

        self._privacy = privacy

    @property
    def type(self):
        """Gets the type of this VideoPlaylist.  # noqa: E501


        :return: The type of this VideoPlaylist.  # noqa: E501
        :rtype: VideoPlaylistTypeConstant
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this VideoPlaylist.


        :param type: The type of this VideoPlaylist.  # noqa: E501
        :type type: VideoPlaylistTypeConstant
        """

        self._type = type

    @property
    def owner_account(self):
        """Gets the owner_account of this VideoPlaylist.  # noqa: E501


        :return: The owner_account of this VideoPlaylist.  # noqa: E501
        :rtype: AccountSummary
        """
        return self._owner_account

    @owner_account.setter
    def owner_account(self, owner_account):
        """Sets the owner_account of this VideoPlaylist.


        :param owner_account: The owner_account of this VideoPlaylist.  # noqa: E501
        :type owner_account: AccountSummary
        """

        self._owner_account = owner_account

    @property
    def video_channel(self):
        """Gets the video_channel of this VideoPlaylist.  # noqa: E501


        :return: The video_channel of this VideoPlaylist.  # noqa: E501
        :rtype: VideoChannelSummary
        """
        return self._video_channel

    @video_channel.setter
    def video_channel(self, video_channel):
        """Sets the video_channel of this VideoPlaylist.


        :param video_channel: The video_channel of this VideoPlaylist.  # noqa: E501
        :type video_channel: VideoChannelSummary
        """

        self._video_channel = video_channel

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, VideoPlaylist):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, VideoPlaylist):
            return True

        return self.to_dict() != other.to_dict()
