# coding: utf-8

"""
    PeerTube

    # Introduction  The PeerTube API is built on HTTP(S) and is RESTful. You can use your favorite HTTP/REST library for your programming language to use PeerTube. The spec API is fully compatible with [openapi-generator](https://github.com/OpenAPITools/openapi-generator/wiki/API-client-generator-HOWTO) which generates a client SDK in the language of your choice - we generate some client SDKs automatically:  - [Python](https://framagit.org/framasoft/peertube/clients/python) - [Go](https://framagit.org/framasoft/peertube/clients/go) - [Kotlin](https://framagit.org/framasoft/peertube/clients/kotlin)  See the [Quick Start guide](https://docs.joinpeertube.org/#/api-rest-getting-started) so you can play with the PeerTube API.  # Authentication  When you sign up for an account, you are given the possibility to generate sessions, and authenticate using this session token. One session token can currently be used at a time.  ## Roles  Accounts are given permissions based on their role. There are three roles on PeerTube: Administrator, Moderator, and User. See the [roles guide](https://docs.joinpeertube.org/#/admin-managing-users?id=roles) for a detail of their permissions.  # Errors  The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be JSON in the following format.  ``` {   \"code\": \"unauthorized_request\", // example inner error code   \"error\": \"Token is invalid.\" // example exposed error message } ```   # noqa: E501

    The version of the OpenAPI document: 2.4.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from peertube.configuration import Configuration


class VideoStreamingPlaylists(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'int',
        'type': 'int',
        'playlist_url': 'str',
        'segments_sha256_url': 'str',
        'files': 'list[VideoFile]',
        'redundancies': 'list[VideoStreamingPlaylistsRedundancies]'
    }

    attribute_map = {
        'id': 'id',
        'type': 'type',
        'playlist_url': 'playlistUrl',
        'segments_sha256_url': 'segmentsSha256Url',
        'files': 'files',
        'redundancies': 'redundancies'
    }

    def __init__(self, id=None, type=None, playlist_url=None, segments_sha256_url=None, files=None, redundancies=None, local_vars_configuration=None):  # noqa: E501
        """VideoStreamingPlaylists - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._type = None
        self._playlist_url = None
        self._segments_sha256_url = None
        self._files = None
        self._redundancies = None
        self.discriminator = None

        if id is not None:
            self.id = id
        if type is not None:
            self.type = type
        if playlist_url is not None:
            self.playlist_url = playlist_url
        if segments_sha256_url is not None:
            self.segments_sha256_url = segments_sha256_url
        if files is not None:
            self.files = files
        if redundancies is not None:
            self.redundancies = redundancies

    @property
    def id(self):
        """Gets the id of this VideoStreamingPlaylists.  # noqa: E501


        :return: The id of this VideoStreamingPlaylists.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this VideoStreamingPlaylists.


        :param id: The id of this VideoStreamingPlaylists.  # noqa: E501
        :type id: int
        """

        self._id = id

    @property
    def type(self):
        """Gets the type of this VideoStreamingPlaylists.  # noqa: E501

        Playlist type (HLS = `1`)  # noqa: E501

        :return: The type of this VideoStreamingPlaylists.  # noqa: E501
        :rtype: int
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this VideoStreamingPlaylists.

        Playlist type (HLS = `1`)  # noqa: E501

        :param type: The type of this VideoStreamingPlaylists.  # noqa: E501
        :type type: int
        """
        allowed_values = [1]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and type not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `type` ({0}), must be one of {1}"  # noqa: E501
                .format(type, allowed_values)
            )

        self._type = type

    @property
    def playlist_url(self):
        """Gets the playlist_url of this VideoStreamingPlaylists.  # noqa: E501


        :return: The playlist_url of this VideoStreamingPlaylists.  # noqa: E501
        :rtype: str
        """
        return self._playlist_url

    @playlist_url.setter
    def playlist_url(self, playlist_url):
        """Sets the playlist_url of this VideoStreamingPlaylists.


        :param playlist_url: The playlist_url of this VideoStreamingPlaylists.  # noqa: E501
        :type playlist_url: str
        """

        self._playlist_url = playlist_url

    @property
    def segments_sha256_url(self):
        """Gets the segments_sha256_url of this VideoStreamingPlaylists.  # noqa: E501


        :return: The segments_sha256_url of this VideoStreamingPlaylists.  # noqa: E501
        :rtype: str
        """
        return self._segments_sha256_url

    @segments_sha256_url.setter
    def segments_sha256_url(self, segments_sha256_url):
        """Sets the segments_sha256_url of this VideoStreamingPlaylists.


        :param segments_sha256_url: The segments_sha256_url of this VideoStreamingPlaylists.  # noqa: E501
        :type segments_sha256_url: str
        """

        self._segments_sha256_url = segments_sha256_url

    @property
    def files(self):
        """Gets the files of this VideoStreamingPlaylists.  # noqa: E501

        Video files associated to this playlist. The difference with the root \"files\" property is that these files are fragmented, so they can be used in this streaming playlist (HLS etc)  # noqa: E501

        :return: The files of this VideoStreamingPlaylists.  # noqa: E501
        :rtype: list[VideoFile]
        """
        return self._files

    @files.setter
    def files(self, files):
        """Sets the files of this VideoStreamingPlaylists.

        Video files associated to this playlist. The difference with the root \"files\" property is that these files are fragmented, so they can be used in this streaming playlist (HLS etc)  # noqa: E501

        :param files: The files of this VideoStreamingPlaylists.  # noqa: E501
        :type files: list[VideoFile]
        """

        self._files = files

    @property
    def redundancies(self):
        """Gets the redundancies of this VideoStreamingPlaylists.  # noqa: E501


        :return: The redundancies of this VideoStreamingPlaylists.  # noqa: E501
        :rtype: list[VideoStreamingPlaylistsRedundancies]
        """
        return self._redundancies

    @redundancies.setter
    def redundancies(self, redundancies):
        """Sets the redundancies of this VideoStreamingPlaylists.


        :param redundancies: The redundancies of this VideoStreamingPlaylists.  # noqa: E501
        :type redundancies: list[VideoStreamingPlaylistsRedundancies]
        """

        self._redundancies = redundancies

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, VideoStreamingPlaylists):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, VideoStreamingPlaylists):
            return True

        return self.to_dict() != other.to_dict()
