/* snap_plugin.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from snap_plugin.vala, do not modify */

/*
 *  pamac-vala
 *
 *  Copyright (C) 2019-2023 Guillaume Benoit <guillaume@manjaro.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a get of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "pamac-snap.h"
#include <glib-object.h>
#include <snapd-glib/snapd-glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>
#include <gmodule.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define PAMAC_TYPE_SNAP_PACKAGE_LINKED (pamac_snap_package_linked_get_type ())
#define PAMAC_SNAP_PACKAGE_LINKED(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PAMAC_TYPE_SNAP_PACKAGE_LINKED, PamacSnapPackageLinked))
#define PAMAC_SNAP_PACKAGE_LINKED_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PAMAC_TYPE_SNAP_PACKAGE_LINKED, PamacSnapPackageLinkedClass))
#define PAMAC_IS_SNAP_PACKAGE_LINKED(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PAMAC_TYPE_SNAP_PACKAGE_LINKED))
#define PAMAC_IS_SNAP_PACKAGE_LINKED_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PAMAC_TYPE_SNAP_PACKAGE_LINKED))
#define PAMAC_SNAP_PACKAGE_LINKED_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PAMAC_TYPE_SNAP_PACKAGE_LINKED, PamacSnapPackageLinkedClass))

typedef struct _PamacSnapPackageLinked PamacSnapPackageLinked;
typedef struct _PamacSnapPackageLinkedClass PamacSnapPackageLinkedClass;
typedef struct _PamacSnapPackageLinkedPrivate PamacSnapPackageLinkedPrivate;
enum  {
	PAMAC_SNAP_PACKAGE_LINKED_0_PROPERTY,
	PAMAC_SNAP_PACKAGE_LINKED_NAME_PROPERTY,
	PAMAC_SNAP_PACKAGE_LINKED_ID_PROPERTY,
	PAMAC_SNAP_PACKAGE_LINKED_VERSION_PROPERTY,
	PAMAC_SNAP_PACKAGE_LINKED_INSTALLED_VERSION_PROPERTY,
	PAMAC_SNAP_PACKAGE_LINKED_REPO_PROPERTY,
	PAMAC_SNAP_PACKAGE_LINKED_URL_PROPERTY,
	PAMAC_SNAP_PACKAGE_LINKED_INSTALLED_SIZE_PROPERTY,
	PAMAC_SNAP_PACKAGE_LINKED_DOWNLOAD_SIZE_PROPERTY,
	PAMAC_SNAP_PACKAGE_LINKED_INSTALL_DATE_PROPERTY,
	PAMAC_SNAP_PACKAGE_LINKED_APP_NAME_PROPERTY,
	PAMAC_SNAP_PACKAGE_LINKED_APP_ID_PROPERTY,
	PAMAC_SNAP_PACKAGE_LINKED_DESC_PROPERTY,
	PAMAC_SNAP_PACKAGE_LINKED_LONG_DESC_PROPERTY,
	PAMAC_SNAP_PACKAGE_LINKED_LAUNCHABLE_PROPERTY,
	PAMAC_SNAP_PACKAGE_LINKED_ICON_PROPERTY,
	PAMAC_SNAP_PACKAGE_LINKED_SCREENSHOTS_PROPERTY,
	PAMAC_SNAP_PACKAGE_LINKED_CHANNEL_PROPERTY,
	PAMAC_SNAP_PACKAGE_LINKED_PUBLISHER_PROPERTY,
	PAMAC_SNAP_PACKAGE_LINKED_LICENSE_PROPERTY,
	PAMAC_SNAP_PACKAGE_LINKED_CONFINED_PROPERTY,
	PAMAC_SNAP_PACKAGE_LINKED_CHANNELS_PROPERTY,
	PAMAC_SNAP_PACKAGE_LINKED_NUM_PROPERTIES
};
static GParamSpec* pamac_snap_package_linked_properties[PAMAC_SNAP_PACKAGE_LINKED_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

#define PAMAC_TYPE_SNAP_PLUGIN (pamac_snap_plugin_get_type ())
#define PAMAC_SNAP_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PAMAC_TYPE_SNAP_PLUGIN, PamacSnapPlugin))
#define PAMAC_IS_SNAP_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PAMAC_TYPE_SNAP_PLUGIN))
#define PAMAC_SNAP_PLUGIN_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), PAMAC_TYPE_SNAP_PLUGIN, PamacSnapPluginIface))

typedef struct _PamacSnapPlugin PamacSnapPlugin;
typedef struct _PamacSnapPluginIface PamacSnapPluginIface;

#define PAMAC_TYPE_SNAP (pamac_snap_get_type ())
#define PAMAC_SNAP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PAMAC_TYPE_SNAP, PamacSnap))
#define PAMAC_SNAP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PAMAC_TYPE_SNAP, PamacSnapClass))
#define PAMAC_IS_SNAP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PAMAC_TYPE_SNAP))
#define PAMAC_IS_SNAP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PAMAC_TYPE_SNAP))
#define PAMAC_SNAP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PAMAC_TYPE_SNAP, PamacSnapClass))

typedef struct _PamacSnap PamacSnap;
typedef struct _PamacSnapClass PamacSnapClass;
typedef struct _PamacSnapPrivate PamacSnapPrivate;
enum  {
	PAMAC_SNAP_0_PROPERTY,
	PAMAC_SNAP_NUM_PROPERTIES
};
static GParamSpec* pamac_snap_properties[PAMAC_SNAP_NUM_PROPERTIES];
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _PamacSnapPackageLinked {
	PamacSnapPackage parent_instance;
	PamacSnapPackageLinkedPrivate * priv;
};

struct _PamacSnapPackageLinkedClass {
	PamacSnapPackageClass parent_class;
};

struct _PamacSnapPackageLinkedPrivate {
	SnapdSnap* snap;
	SnapdSnap* store_snap;
	SnapdSnap* installed_snap;
	gchar* _name;
	gchar* _id;
	gchar* _app_id;
	gchar* _launchable;
	GPtrArray* _screenshots;
	gchar* _channel;
	GPtrArray* _channels;
};

struct _PamacSnapPluginIface {
	GTypeInterface parent_iface;
	void (*search_snaps) (PamacSnapPlugin* self, const gchar* search_string, GPtrArray** pkgs);
	void (*search_uninstalled_snaps_sync) (PamacSnapPlugin* self, const gchar* search_string, GPtrArray** pkgs);
	gboolean (*is_installed_snap) (PamacSnapPlugin* self, const gchar* name);
	PamacSnapPackage* (*get_snap) (PamacSnapPlugin* self, const gchar* name);
	PamacSnapPackage* (*get_snap_by_app_id) (PamacSnapPlugin* self, const gchar* app_id);
	void (*get_installed_snaps) (PamacSnapPlugin* self, GPtrArray** pkgs);
	gchar* (*get_installed_snap_icon) (PamacSnapPlugin* self, const gchar* name, GError** error);
	void (*get_category_snaps) (PamacSnapPlugin* self, const gchar* category, GPtrArray** pkgs);
	gboolean (*trans_run) (PamacSnapPlugin* self, const gchar* sender, gchar** to_install, gint to_install_length1, gchar** to_remove, gint to_remove_length1);
	gboolean (*switch_channel) (PamacSnapPlugin* self, const gchar* sender, const gchar* name, const gchar* channel);
	void (*trans_cancel) (PamacSnapPlugin* self, const gchar* sender);
	void (*refresh) (PamacSnapPlugin* self);
};

struct _PamacSnap {
	GObject parent_instance;
	PamacSnapPrivate * priv;
};

struct _PamacSnapClass {
	GObjectClass parent_class;
};

struct _PamacSnapPrivate {
	gchar* sender;
	SnapdClient* client;
	GHashTable* store_snaps_cache;
	GRecMutex __lock_store_snaps_cache;
	GHashTable* search_snaps_cache;
	GRecMutex __lock_search_snaps_cache;
	GHashTable* category_snaps_cache;
	GRecMutex __lock_category_snaps_cache;
	GHashTable* pkgs_cache;
	GRecMutex __lock_pkgs_cache;
	GCancellable* cancellable;
	GTimer* timer;
	gboolean downloading;
	GHashTable* download_files;
	gboolean init_download;
	guint64 download_total;
	guint64 previous_xfered;
	guint64 download_rate;
	guint64 rates_nb;
	gchar* main_action;
	gchar* current_action;
	gchar* current_details;
	gdouble current_progress;
	gchar* current_status;
};

static gint PamacSnapPackageLinked_private_offset;
static gpointer pamac_snap_package_linked_parent_class = NULL;
static gint PamacSnap_private_offset;
static gpointer pamac_snap_parent_class = NULL;
static PamacSnapPluginIface * pamac_snap_pamac_snap_plugin_parent_iface = NULL;

VALA_EXTERN GType pamac_snap_package_linked_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void pamac_package_set_name (PamacPackage* self,
                             const gchar* value);
VALA_EXTERN void pamac_package_set_id (PamacPackage* self,
                           const gchar* value);
VALA_EXTERN void pamac_package_set_version (PamacPackage* self,
                                const gchar* value);
VALA_EXTERN void pamac_package_set_installed_version (PamacPackage* self,
                                          const gchar* value);
VALA_EXTERN void pamac_package_set_repo (PamacPackage* self,
                             const gchar* value);
VALA_EXTERN void pamac_package_set_desc (PamacPackage* self,
                             const gchar* value);
VALA_EXTERN PamacSnapPackageLinked* pamac_snap_package_linked_new (SnapdSnap* snap,
                                                       SnapdSnap* installed_snap,
                                                       SnapdSnap* store_snap);
VALA_EXTERN PamacSnapPackageLinked* pamac_snap_package_linked_construct (GType object_type,
                                                             SnapdSnap* snap,
                                                             SnapdSnap* installed_snap,
                                                             SnapdSnap* store_snap);
VALA_EXTERN PamacSnapPackage* pamac_snap_package_construct (GType object_type);
VALA_EXTERN SnapdApp* pamac_snap_get_primary_app (SnapdSnap* snap);
static gboolean pamac_snap_package_linked_is_banner_image (PamacSnapPackageLinked* self,
                                                    const gchar* filename);
static gboolean pamac_snap_package_linked_is_banner_icon_image (PamacSnapPackageLinked* self,
                                                         const gchar* filename);
static void _g_free0_ (gpointer var);
static void pamac_snap_package_linked_finalize (GObject * obj);
static GType pamac_snap_package_linked_get_type_once (void);
static void _vala_pamac_snap_package_linked_get_property (GObject * object,
                                                   guint property_id,
                                                   GValue * value,
                                                   GParamSpec * pspec);
static void _vala_pamac_snap_package_linked_set_property (GObject * object,
                                                   guint property_id,
                                                   const GValue * value,
                                                   GParamSpec * pspec);
VALA_EXTERN GType pamac_snap_plugin_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType pamac_snap_get_type (void) G_GNUC_CONST ;
VALA_EXTERN PamacSnap* pamac_snap_new (void);
VALA_EXTERN PamacSnap* pamac_snap_construct (GType object_type);
VALA_EXTERN gboolean pamac_snap_app_name_matches_snap_name (SnapdSnap* snap,
                                                SnapdApp* app);
static PamacSnapPackage* pamac_snap_initialize_snap (PamacSnap* self,
                                              SnapdSnap* snap);
static SnapdSnap* pamac_snap_get_store_snap (PamacSnap* self,
                                      const gchar* name);
static SnapdSnap* pamac_snap_get_local_snap (PamacSnap* self,
                                      const gchar* name);
static void pamac_snap_real_search_snaps (PamacSnapPlugin* base,
                                   const gchar* search_string,
                                   GPtrArray** pkgs);
static void pamac_snap_real_search_uninstalled_snaps_sync (PamacSnapPlugin* base,
                                                    const gchar* search_string,
                                                    GPtrArray** pkgs);
static gboolean pamac_snap_real_is_installed_snap (PamacSnapPlugin* base,
                                            const gchar* name);
static PamacSnapPackage* pamac_snap_real_get_snap (PamacSnapPlugin* base,
                                            const gchar* name);
static PamacSnapPackage* pamac_snap_real_get_snap_by_app_id (PamacSnapPlugin* base,
                                                      const gchar* app_id);
static void pamac_snap_real_get_installed_snaps (PamacSnapPlugin* base,
                                          GPtrArray** pkgs);
static gchar* pamac_snap_real_get_installed_snap_icon (PamacSnapPlugin* base,
                                                const gchar* name,
                                                GError** error);
static void pamac_snap_real_get_category_snaps (PamacSnapPlugin* base,
                                         const gchar* category,
                                         GPtrArray** pkgs);
static void pamac_snap_do_start_downloading (PamacSnap* self);
static void pamac_snap_do_stop_downloading (PamacSnap* self);
static void pamac_snap_do_emit_action_progress (PamacSnap* self,
                                         const gchar* action,
                                         const gchar* status,
                                         gdouble progress);
static void pamac_snap_do_emit_download_progress (PamacSnap* self,
                                           const gchar* action,
                                           const gchar* status,
                                           gdouble progress);
static void pamac_snap_do_emit_script_output (PamacSnap* self,
                                       const gchar* message);
static void pamac_snap_do_emit_error (PamacSnap* self,
                               const gchar* message,
                               gchar** details,
                               gint details_length1);
static gboolean pamac_snap_real_trans_run (PamacSnapPlugin* base,
                                    const gchar* sender,
                                    gchar** to_install,
                                    gint to_install_length1,
                                    gchar** to_remove,
                                    gint to_remove_length1);
static gboolean pamac_snap_remove (PamacSnap* self,
                            const gchar* name);
static gboolean pamac_snap_install (PamacSnap* self,
                             const gchar* name,
                             const gchar* channel);
static void pamac_snap_real_refresh (PamacSnapPlugin* base);
static void pamac_snap_real_trans_cancel (PamacSnapPlugin* base,
                                   const gchar* sender);
static void pamac_snap_progress_callback (PamacSnap* self,
                                   SnapdClient* client,
                                   SnapdChange* change,
                                   void* deprecated);
static void _pamac_snap_progress_callback_snapd_progress_callback (SnapdClient* client,
                                                            SnapdChange* change,
                                                            void* deprecated,
                                                            gpointer self);
static gboolean pamac_snap_real_switch_channel (PamacSnapPlugin* base,
                                         const gchar* sender,
                                         const gchar* name,
                                         const gchar* channel);
static void pamac_snap_emit_download (PamacSnap* self,
                               guint64 xfered,
                               guint64 total);
static GObject * pamac_snap_constructor (GType type,
                                  guint n_construct_properties,
                                  GObjectConstructParam * construct_properties);
static void _g_object_unref0_ (gpointer var);
static void _g_ptr_array_unref0_ (gpointer var);
VALA_EXTERN void pamac_snap_plugin_search_snaps (PamacSnapPlugin* self,
                                     const gchar* search_string,
                                     GPtrArray** pkgs);
VALA_EXTERN void pamac_snap_plugin_search_uninstalled_snaps_sync (PamacSnapPlugin* self,
                                                      const gchar* search_string,
                                                      GPtrArray** pkgs);
VALA_EXTERN gboolean pamac_snap_plugin_is_installed_snap (PamacSnapPlugin* self,
                                              const gchar* name);
VALA_EXTERN PamacSnapPackage* pamac_snap_plugin_get_snap (PamacSnapPlugin* self,
                                              const gchar* name);
VALA_EXTERN PamacSnapPackage* pamac_snap_plugin_get_snap_by_app_id (PamacSnapPlugin* self,
                                                        const gchar* app_id);
VALA_EXTERN void pamac_snap_plugin_get_installed_snaps (PamacSnapPlugin* self,
                                            GPtrArray** pkgs);
VALA_EXTERN gchar* pamac_snap_plugin_get_installed_snap_icon (PamacSnapPlugin* self,
                                                  const gchar* name,
                                                  GError** error);
VALA_EXTERN void pamac_snap_plugin_get_category_snaps (PamacSnapPlugin* self,
                                           const gchar* category,
                                           GPtrArray** pkgs);
VALA_EXTERN gboolean pamac_snap_plugin_trans_run (PamacSnapPlugin* self,
                                      const gchar* sender,
                                      gchar** to_install,
                                      gint to_install_length1,
                                      gchar** to_remove,
                                      gint to_remove_length1);
VALA_EXTERN void pamac_snap_plugin_refresh (PamacSnapPlugin* self);
VALA_EXTERN void pamac_snap_plugin_trans_cancel (PamacSnapPlugin* self,
                                     const gchar* sender);
VALA_EXTERN gboolean pamac_snap_plugin_switch_channel (PamacSnapPlugin* self,
                                           const gchar* sender,
                                           const gchar* name,
                                           const gchar* channel);
static void pamac_snap_finalize (GObject * obj);
static GType pamac_snap_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
pamac_snap_package_linked_get_instance_private (PamacSnapPackageLinked* self)
{
	return G_STRUCT_MEMBER_P (self, PamacSnapPackageLinked_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

PamacSnapPackageLinked*
pamac_snap_package_linked_construct (GType object_type,
                                     SnapdSnap* snap,
                                     SnapdSnap* installed_snap,
                                     SnapdSnap* store_snap)
{
	PamacSnapPackageLinked * self = NULL;
	SnapdSnap* _tmp0_;
	SnapdSnap* _tmp1_;
	SnapdSnap* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	SnapdApp* primary_app = NULL;
	SnapdSnap* _tmp9_;
	SnapdApp* _tmp10_;
	SnapdApp* _tmp11_;
	g_return_val_if_fail (snap != NULL, NULL);
	self = (PamacSnapPackageLinked*) pamac_snap_package_construct (object_type);
	_tmp0_ = _g_object_ref0 (snap);
	_g_object_unref0 (self->priv->snap);
	self->priv->snap = _tmp0_;
	_tmp1_ = _g_object_ref0 (store_snap);
	_g_object_unref0 (self->priv->store_snap);
	self->priv->store_snap = _tmp1_;
	_tmp2_ = _g_object_ref0 (installed_snap);
	_g_object_unref0 (self->priv->installed_snap);
	self->priv->installed_snap = _tmp2_;
	_tmp3_ = snapd_snap_get_name (snap);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup (_tmp4_);
	_g_free0 (self->priv->_name);
	self->priv->_name = _tmp5_;
	_tmp6_ = snapd_snap_get_name (snap);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strdup_printf ("Snap/%s", _tmp7_);
	_g_free0 (self->priv->_id);
	self->priv->_id = _tmp8_;
	_tmp9_ = self->priv->snap;
	_tmp10_ = pamac_snap_get_primary_app (_tmp9_);
	primary_app = _tmp10_;
	_tmp11_ = primary_app;
	if (_tmp11_ != NULL) {
		const gchar* desktop_file = NULL;
		SnapdApp* _tmp12_;
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		const gchar* _tmp15_;
		_tmp12_ = primary_app;
		_tmp13_ = snapd_app_get_desktop_file (_tmp12_);
		_tmp14_ = _tmp13_;
		desktop_file = _tmp14_;
		_tmp15_ = desktop_file;
		if (_tmp15_ != NULL) {
			const gchar* _tmp16_;
			gchar* _tmp17_;
			const gchar* _tmp18_;
			gchar* _tmp19_;
			_tmp16_ = desktop_file;
			_tmp17_ = g_path_get_basename (_tmp16_);
			_g_free0 (self->priv->_launchable);
			self->priv->_launchable = _tmp17_;
			_tmp18_ = desktop_file;
			_tmp19_ = g_path_get_basename (_tmp18_);
			_g_free0 (self->priv->_app_id);
			self->priv->_app_id = _tmp19_;
		}
	} else {
		const gchar* _tmp20_;
		const gchar* _tmp21_;
		gchar* _tmp22_;
		_tmp20_ = snapd_snap_get_name (snap);
		_tmp21_ = _tmp20_;
		_tmp22_ = g_strdup (_tmp21_);
		_g_free0 (self->priv->_app_id);
		self->priv->_app_id = _tmp22_;
	}
	return self;
}

PamacSnapPackageLinked*
pamac_snap_package_linked_new (SnapdSnap* snap,
                               SnapdSnap* installed_snap,
                               SnapdSnap* store_snap)
{
	return pamac_snap_package_linked_construct (PAMAC_TYPE_SNAP_PACKAGE_LINKED, snap, installed_snap, store_snap);
}

static gboolean
pamac_snap_package_linked_is_banner_image (PamacSnapPackageLinked* self,
                                           const gchar* filename)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (filename != NULL, FALSE);
	result = g_regex_match_simple ("^banner(?:_[a-zA-Z0-9]{7})?\\.(?:png|jpg)$", filename, 0, 0);
	return result;
}

static gboolean
pamac_snap_package_linked_is_banner_icon_image (PamacSnapPackageLinked* self,
                                                const gchar* filename)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (filename != NULL, FALSE);
	result = g_regex_match_simple ("^banner-icon(?:_[a-zA-Z0-9]{7})?\\.(?:png|jpg)$", filename, 0, 0);
	return result;
}

static const gchar*
pamac_snap_package_linked_real_get_name (PamacPackage* base)
{
	const gchar* result;
	PamacSnapPackageLinked* self;
	const gchar* _tmp0_;
	self = (PamacSnapPackageLinked*) base;
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}

static void
pamac_snap_package_linked_real_set_name (PamacPackage* base,
                                         const gchar* value)
{
	PamacSnapPackageLinked* self;
	self = (PamacSnapPackageLinked*) base;
	g_object_notify_by_pspec ((GObject *) self, pamac_snap_package_linked_properties[PAMAC_SNAP_PACKAGE_LINKED_NAME_PROPERTY]);
}

static const gchar*
pamac_snap_package_linked_real_get_id (PamacPackage* base)
{
	const gchar* result;
	PamacSnapPackageLinked* self;
	const gchar* _tmp0_;
	self = (PamacSnapPackageLinked*) base;
	_tmp0_ = self->priv->_id;
	result = _tmp0_;
	return result;
}

static void
pamac_snap_package_linked_real_set_id (PamacPackage* base,
                                       const gchar* value)
{
	PamacSnapPackageLinked* self;
	self = (PamacSnapPackageLinked*) base;
	g_object_notify_by_pspec ((GObject *) self, pamac_snap_package_linked_properties[PAMAC_SNAP_PACKAGE_LINKED_ID_PROPERTY]);
}

static const gchar*
pamac_snap_package_linked_real_get_version (PamacPackage* base)
{
	const gchar* result;
	PamacSnapPackageLinked* self;
	SnapdSnap* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	self = (PamacSnapPackageLinked*) base;
	_tmp0_ = self->priv->snap;
	_tmp1_ = snapd_snap_get_version (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

static void
pamac_snap_package_linked_real_set_version (PamacPackage* base,
                                            const gchar* value)
{
	PamacSnapPackageLinked* self;
	self = (PamacSnapPackageLinked*) base;
	g_object_notify_by_pspec ((GObject *) self, pamac_snap_package_linked_properties[PAMAC_SNAP_PACKAGE_LINKED_VERSION_PROPERTY]);
}

static const gchar*
pamac_snap_package_linked_real_get_installed_version (PamacPackage* base)
{
	const gchar* result;
	PamacSnapPackageLinked* self;
	SnapdSnap* _tmp0_;
	self = (PamacSnapPackageLinked*) base;
	_tmp0_ = self->priv->installed_snap;
	if (_tmp0_ != NULL) {
		SnapdSnap* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		_tmp1_ = self->priv->installed_snap;
		_tmp2_ = snapd_snap_get_version (_tmp1_);
		_tmp3_ = _tmp2_;
		result = _tmp3_;
		return result;
	}
	result = NULL;
	return result;
}

static void
pamac_snap_package_linked_real_set_installed_version (PamacPackage* base,
                                                      const gchar* value)
{
	PamacSnapPackageLinked* self;
	self = (PamacSnapPackageLinked*) base;
	g_object_notify_by_pspec ((GObject *) self, pamac_snap_package_linked_properties[PAMAC_SNAP_PACKAGE_LINKED_INSTALLED_VERSION_PROPERTY]);
}

static const gchar*
pamac_snap_package_linked_real_get_repo (PamacPackage* base)
{
	const gchar* result;
	PamacSnapPackageLinked* self;
	self = (PamacSnapPackageLinked*) base;
	result = g_dgettext (NULL, "Snap");
	return result;
}

static void
pamac_snap_package_linked_real_set_repo (PamacPackage* base,
                                         const gchar* value)
{
	PamacSnapPackageLinked* self;
	self = (PamacSnapPackageLinked*) base;
	g_object_notify_by_pspec ((GObject *) self, pamac_snap_package_linked_properties[PAMAC_SNAP_PACKAGE_LINKED_REPO_PROPERTY]);
}

static const gchar*
pamac_snap_package_linked_real_get_url (PamacPackage* base)
{
	const gchar* result;
	PamacSnapPackageLinked* self;
	SnapdSnap* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	self = (PamacSnapPackageLinked*) base;
	_tmp0_ = self->priv->snap;
	_tmp1_ = snapd_snap_get_contact (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

static guint64
pamac_snap_package_linked_real_get_installed_size (PamacPackage* base)
{
	guint64 result;
	PamacSnapPackageLinked* self;
	SnapdSnap* _tmp0_;
	self = (PamacSnapPackageLinked*) base;
	_tmp0_ = self->priv->installed_snap;
	if (_tmp0_ != NULL) {
		SnapdSnap* _tmp1_;
		gint64 _tmp2_;
		gint64 _tmp3_;
		_tmp1_ = self->priv->installed_snap;
		_tmp2_ = snapd_snap_get_installed_size (_tmp1_);
		_tmp3_ = _tmp2_;
		result = (guint64) _tmp3_;
		return result;
	}
	result = (guint64) 0;
	return result;
}

static guint64
pamac_snap_package_linked_real_get_download_size (PamacPackage* base)
{
	guint64 result;
	PamacSnapPackageLinked* self;
	SnapdSnap* _tmp0_;
	gint64 _tmp1_;
	gint64 _tmp2_;
	self = (PamacSnapPackageLinked*) base;
	_tmp0_ = self->priv->snap;
	_tmp1_ = snapd_snap_get_download_size (_tmp0_);
	_tmp2_ = _tmp1_;
	result = (guint64) _tmp2_;
	return result;
}

static GDateTime*
pamac_snap_package_linked_real_get_install_date (PamacPackage* base)
{
	GDateTime* result;
	PamacSnapPackageLinked* self;
	SnapdSnap* _tmp0_;
	self = (PamacSnapPackageLinked*) base;
	_tmp0_ = self->priv->installed_snap;
	if (_tmp0_ != NULL) {
		SnapdSnap* _tmp1_;
		GDateTime* _tmp2_;
		GDateTime* _tmp3_;
		_tmp1_ = self->priv->installed_snap;
		_tmp2_ = snapd_snap_get_install_date (_tmp1_);
		_tmp3_ = _tmp2_;
		result = _tmp3_;
		return result;
	}
	result = NULL;
	return result;
}

static const gchar*
pamac_snap_package_linked_real_get_app_name (PamacPackage* base)
{
	const gchar* result;
	PamacSnapPackageLinked* self;
	SnapdSnap* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	self = (PamacSnapPackageLinked*) base;
	_tmp0_ = self->priv->snap;
	_tmp1_ = snapd_snap_get_title (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

static const gchar*
pamac_snap_package_linked_real_get_app_id (PamacPackage* base)
{
	const gchar* result;
	PamacSnapPackageLinked* self;
	const gchar* _tmp0_;
	self = (PamacSnapPackageLinked*) base;
	_tmp0_ = self->priv->_app_id;
	result = _tmp0_;
	return result;
}

static const gchar*
pamac_snap_package_linked_real_get_desc (PamacPackage* base)
{
	const gchar* result;
	PamacSnapPackageLinked* self;
	SnapdSnap* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	self = (PamacSnapPackageLinked*) base;
	_tmp0_ = self->priv->snap;
	_tmp1_ = snapd_snap_get_summary (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

static void
pamac_snap_package_linked_real_set_desc (PamacPackage* base,
                                         const gchar* value)
{
	PamacSnapPackageLinked* self;
	self = (PamacSnapPackageLinked*) base;
	g_object_notify_by_pspec ((GObject *) self, pamac_snap_package_linked_properties[PAMAC_SNAP_PACKAGE_LINKED_DESC_PROPERTY]);
}

static const gchar*
pamac_snap_package_linked_real_get_long_desc (PamacPackage* base)
{
	const gchar* result;
	PamacSnapPackageLinked* self;
	SnapdSnap* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	self = (PamacSnapPackageLinked*) base;
	_tmp0_ = self->priv->snap;
	_tmp1_ = snapd_snap_get_description (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

static const gchar*
pamac_snap_package_linked_real_get_launchable (PamacPackage* base)
{
	const gchar* result;
	PamacSnapPackageLinked* self;
	const gchar* _tmp0_;
	self = (PamacSnapPackageLinked*) base;
	_tmp0_ = self->priv->_launchable;
	result = _tmp0_;
	return result;
}

static const gchar*
pamac_snap_package_linked_real_get_icon (PamacPackage* base)
{
	const gchar* result;
	PamacSnapPackageLinked* self;
	SnapdSnap* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	self = (PamacSnapPackageLinked*) base;
	_tmp0_ = self->priv->snap;
	_tmp1_ = snapd_snap_get_icon (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static GPtrArray*
pamac_snap_package_linked_real_get_screenshots (PamacPackage* base)
{
	GPtrArray* result;
	PamacSnapPackageLinked* self;
	GPtrArray* _tmp0_;
	GPtrArray* _tmp22_;
	self = (PamacSnapPackageLinked*) base;
	_tmp0_ = self->priv->_screenshots;
	if (_tmp0_ == NULL) {
		GPtrArray* _tmp1_;
		SnapdSnap* _tmp2_;
		_tmp1_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
		_g_ptr_array_unref0 (self->priv->_screenshots);
		self->priv->_screenshots = _tmp1_;
		_tmp2_ = self->priv->store_snap;
		if (_tmp2_ != NULL) {
			GPtrArray* medias = NULL;
			SnapdSnap* _tmp3_;
			GPtrArray* _tmp4_;
			GPtrArray* _tmp5_;
			_tmp3_ = self->priv->store_snap;
			_tmp4_ = snapd_snap_get_media (_tmp3_);
			medias = _tmp4_;
			_tmp5_ = medias;
			{
				GPtrArray* media_collection = NULL;
				guint media_index = 0U;
				media_collection = _tmp5_;
				for (media_index = 0; media_index < media_collection->len; media_index = media_index + 1) {
					SnapdMedia* media = NULL;
					media = (SnapdMedia*) g_ptr_array_index (media_collection, media_index);
					{
						SnapdMedia* _tmp6_;
						gchar* _tmp7_;
						gchar* _tmp8_;
						gchar* _tmp9_;
						gboolean _tmp10_;
						_tmp6_ = media;
						g_object_get (_tmp6_, "type", &_tmp7_, NULL);
						_tmp8_ = _tmp7_;
						_tmp9_ = _tmp8_;
						_tmp10_ = g_strcmp0 (_tmp9_, "screenshot") == 0;
						_g_free0 (_tmp9_);
						if (_tmp10_) {
							const gchar* url = NULL;
							SnapdMedia* _tmp11_;
							const gchar* _tmp12_;
							const gchar* _tmp13_;
							gchar* filename = NULL;
							const gchar* _tmp14_;
							gchar* _tmp15_;
							gboolean _tmp16_ = FALSE;
							const gchar* _tmp17_;
							_tmp11_ = media;
							_tmp12_ = snapd_media_get_url (_tmp11_);
							_tmp13_ = _tmp12_;
							url = _tmp13_;
							_tmp14_ = url;
							_tmp15_ = g_path_get_basename (_tmp14_);
							filename = _tmp15_;
							_tmp17_ = filename;
							if (!pamac_snap_package_linked_is_banner_image (self, _tmp17_)) {
								const gchar* _tmp18_;
								_tmp18_ = filename;
								_tmp16_ = !pamac_snap_package_linked_is_banner_icon_image (self, _tmp18_);
							} else {
								_tmp16_ = FALSE;
							}
							if (_tmp16_) {
								GPtrArray* _tmp19_;
								const gchar* _tmp20_;
								gchar* _tmp21_;
								_tmp19_ = self->priv->_screenshots;
								_tmp20_ = url;
								_tmp21_ = g_strdup (_tmp20_);
								g_ptr_array_add (_tmp19_, _tmp21_);
							}
							_g_free0 (filename);
						}
					}
				}
			}
		}
	}
	_tmp22_ = self->priv->_screenshots;
	result = _tmp22_;
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static const gchar*
pamac_snap_package_linked_real_get_channel (PamacSnapPackage* base)
{
	const gchar* result;
	PamacSnapPackageLinked* self;
	const gchar* _tmp0_;
	const gchar* _tmp5_;
	self = (PamacSnapPackageLinked*) base;
	_tmp0_ = self->priv->_channel;
	if (_tmp0_ == NULL) {
		SnapdSnap* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp1_ = self->priv->snap;
		_tmp2_ = snapd_snap_get_channel (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = string_replace (_tmp3_, "latest/", "");
		_g_free0 (self->priv->_channel);
		self->priv->_channel = _tmp4_;
	}
	_tmp5_ = self->priv->_channel;
	result = _tmp5_;
	return result;
}

static const gchar*
pamac_snap_package_linked_real_get_publisher (PamacSnapPackage* base)
{
	const gchar* result;
	PamacSnapPackageLinked* self;
	SnapdSnap* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	self = (PamacSnapPackageLinked*) base;
	_tmp0_ = self->priv->snap;
	_tmp1_ = snapd_snap_get_publisher_display_name (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

static const gchar*
pamac_snap_package_linked_real_get_license (PamacPackage* base)
{
	const gchar* result;
	PamacSnapPackageLinked* self;
	SnapdSnap* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	self = (PamacSnapPackageLinked*) base;
	_tmp0_ = self->priv->snap;
	_tmp1_ = snapd_snap_get_license (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

static const gchar*
pamac_snap_package_linked_real_get_confined (PamacSnapPackage* base)
{
	const gchar* result;
	PamacSnapPackageLinked* self;
	SnapdSnap* _tmp0_;
	SnapdConfinement _tmp1_;
	SnapdConfinement _tmp2_;
	self = (PamacSnapPackageLinked*) base;
	_tmp0_ = self->priv->snap;
	_tmp1_ = snapd_snap_get_confinement (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == SNAPD_CONFINEMENT_STRICT) {
		result = g_dgettext (NULL, "Yes");
		return result;
	} else {
		result = g_dgettext (NULL, "No");
		return result;
	}
}

static GPtrArray*
pamac_snap_package_linked_real_get_channels (PamacSnapPackage* base)
{
	GPtrArray* result;
	PamacSnapPackageLinked* self;
	GPtrArray* _tmp0_;
	GPtrArray* _tmp16_;
	self = (PamacSnapPackageLinked*) base;
	_tmp0_ = self->priv->_channels;
	if (_tmp0_ == NULL) {
		GPtrArray* _tmp1_;
		SnapdSnap* _tmp2_;
		_tmp1_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
		_g_ptr_array_unref0 (self->priv->_channels);
		self->priv->_channels = _tmp1_;
		_tmp2_ = self->priv->store_snap;
		if (_tmp2_ != NULL) {
			GPtrArray* channels = NULL;
			SnapdSnap* _tmp3_;
			GPtrArray* _tmp4_;
			GPtrArray* _tmp5_;
			_tmp3_ = self->priv->store_snap;
			_tmp4_ = snapd_snap_get_channels (_tmp3_);
			channels = _tmp4_;
			_tmp5_ = channels;
			{
				GPtrArray* channel_collection = NULL;
				guint channel_index = 0U;
				channel_collection = _tmp5_;
				for (channel_index = 0; channel_index < channel_collection->len; channel_index = channel_index + 1) {
					SnapdChannel* channel = NULL;
					channel = (SnapdChannel*) g_ptr_array_index (channel_collection, channel_index);
					{
						GPtrArray* _tmp6_;
						SnapdChannel* _tmp7_;
						const gchar* _tmp8_;
						const gchar* _tmp9_;
						gchar* _tmp10_;
						gchar* _tmp11_;
						SnapdChannel* _tmp12_;
						const gchar* _tmp13_;
						const gchar* _tmp14_;
						gchar* _tmp15_;
						_tmp6_ = self->priv->_channels;
						_tmp7_ = channel;
						_tmp8_ = snapd_channel_get_name (_tmp7_);
						_tmp9_ = _tmp8_;
						_tmp10_ = string_replace (_tmp9_, "latest/", "");
						_tmp11_ = _tmp10_;
						_tmp12_ = channel;
						_tmp13_ = snapd_channel_get_version (_tmp12_);
						_tmp14_ = _tmp13_;
						_tmp15_ = g_strdup_printf ("%s : %s", _tmp11_, _tmp14_);
						g_ptr_array_add (_tmp6_, _tmp15_);
						_g_free0 (_tmp11_);
					}
				}
			}
		}
	}
	_tmp16_ = self->priv->_channels;
	result = _tmp16_;
	return result;
}

static void
pamac_snap_package_linked_class_init (PamacSnapPackageLinkedClass * klass,
                                      gpointer klass_data)
{
	pamac_snap_package_linked_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PamacSnapPackageLinked_private_offset);
	PAMAC_PACKAGE_CLASS (klass)->get_name = (const gchar* (*) (PamacPackage*)) pamac_snap_package_linked_real_get_name;
	PAMAC_PACKAGE_CLASS (klass)->set_name = (void (*) (PamacPackage*, const gchar*)) pamac_snap_package_linked_real_set_name;
	PAMAC_PACKAGE_CLASS (klass)->get_id = (const gchar* (*) (PamacPackage*)) pamac_snap_package_linked_real_get_id;
	PAMAC_PACKAGE_CLASS (klass)->set_id = (void (*) (PamacPackage*, const gchar*)) pamac_snap_package_linked_real_set_id;
	PAMAC_PACKAGE_CLASS (klass)->get_version = (const gchar* (*) (PamacPackage*)) pamac_snap_package_linked_real_get_version;
	PAMAC_PACKAGE_CLASS (klass)->set_version = (void (*) (PamacPackage*, const gchar*)) pamac_snap_package_linked_real_set_version;
	PAMAC_PACKAGE_CLASS (klass)->get_installed_version = (const gchar* (*) (PamacPackage*)) pamac_snap_package_linked_real_get_installed_version;
	PAMAC_PACKAGE_CLASS (klass)->set_installed_version = (void (*) (PamacPackage*, const gchar*)) pamac_snap_package_linked_real_set_installed_version;
	PAMAC_PACKAGE_CLASS (klass)->get_repo = (const gchar* (*) (PamacPackage*)) pamac_snap_package_linked_real_get_repo;
	PAMAC_PACKAGE_CLASS (klass)->set_repo = (void (*) (PamacPackage*, const gchar*)) pamac_snap_package_linked_real_set_repo;
	PAMAC_PACKAGE_CLASS (klass)->get_url = (const gchar* (*) (PamacPackage*)) pamac_snap_package_linked_real_get_url;
	PAMAC_PACKAGE_CLASS (klass)->get_installed_size = (guint64 (*) (PamacPackage*)) pamac_snap_package_linked_real_get_installed_size;
	PAMAC_PACKAGE_CLASS (klass)->get_download_size = (guint64 (*) (PamacPackage*)) pamac_snap_package_linked_real_get_download_size;
	PAMAC_PACKAGE_CLASS (klass)->get_install_date = (GDateTime* (*) (PamacPackage*)) pamac_snap_package_linked_real_get_install_date;
	PAMAC_PACKAGE_CLASS (klass)->get_app_name = (const gchar* (*) (PamacPackage*)) pamac_snap_package_linked_real_get_app_name;
	PAMAC_PACKAGE_CLASS (klass)->get_app_id = (const gchar* (*) (PamacPackage*)) pamac_snap_package_linked_real_get_app_id;
	PAMAC_PACKAGE_CLASS (klass)->get_desc = (const gchar* (*) (PamacPackage*)) pamac_snap_package_linked_real_get_desc;
	PAMAC_PACKAGE_CLASS (klass)->set_desc = (void (*) (PamacPackage*, const gchar*)) pamac_snap_package_linked_real_set_desc;
	PAMAC_PACKAGE_CLASS (klass)->get_long_desc = (const gchar* (*) (PamacPackage*)) pamac_snap_package_linked_real_get_long_desc;
	PAMAC_PACKAGE_CLASS (klass)->get_launchable = (const gchar* (*) (PamacPackage*)) pamac_snap_package_linked_real_get_launchable;
	PAMAC_PACKAGE_CLASS (klass)->get_icon = (const gchar* (*) (PamacPackage*)) pamac_snap_package_linked_real_get_icon;
	PAMAC_PACKAGE_CLASS (klass)->get_screenshots = (GPtrArray* (*) (PamacPackage*)) pamac_snap_package_linked_real_get_screenshots;
	PAMAC_SNAP_PACKAGE_CLASS (klass)->get_channel = (const gchar* (*) (PamacSnapPackage*)) pamac_snap_package_linked_real_get_channel;
	PAMAC_SNAP_PACKAGE_CLASS (klass)->get_publisher = (const gchar* (*) (PamacSnapPackage*)) pamac_snap_package_linked_real_get_publisher;
	PAMAC_PACKAGE_CLASS (klass)->get_license = (const gchar* (*) (PamacPackage*)) pamac_snap_package_linked_real_get_license;
	PAMAC_SNAP_PACKAGE_CLASS (klass)->get_confined = (const gchar* (*) (PamacSnapPackage*)) pamac_snap_package_linked_real_get_confined;
	PAMAC_SNAP_PACKAGE_CLASS (klass)->get_channels = (GPtrArray* (*) (PamacSnapPackage*)) pamac_snap_package_linked_real_get_channels;
	G_OBJECT_CLASS (klass)->get_property = _vala_pamac_snap_package_linked_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_pamac_snap_package_linked_set_property;
	G_OBJECT_CLASS (klass)->finalize = pamac_snap_package_linked_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_SNAP_PACKAGE_LINKED_NAME_PROPERTY, pamac_snap_package_linked_properties[PAMAC_SNAP_PACKAGE_LINKED_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_SNAP_PACKAGE_LINKED_ID_PROPERTY, pamac_snap_package_linked_properties[PAMAC_SNAP_PACKAGE_LINKED_ID_PROPERTY] = g_param_spec_string ("id", "id", "id", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_SNAP_PACKAGE_LINKED_VERSION_PROPERTY, pamac_snap_package_linked_properties[PAMAC_SNAP_PACKAGE_LINKED_VERSION_PROPERTY] = g_param_spec_string ("version", "version", "version", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_SNAP_PACKAGE_LINKED_INSTALLED_VERSION_PROPERTY, pamac_snap_package_linked_properties[PAMAC_SNAP_PACKAGE_LINKED_INSTALLED_VERSION_PROPERTY] = g_param_spec_string ("installed-version", "installed-version", "installed-version", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_SNAP_PACKAGE_LINKED_REPO_PROPERTY, pamac_snap_package_linked_properties[PAMAC_SNAP_PACKAGE_LINKED_REPO_PROPERTY] = g_param_spec_string ("repo", "repo", "repo", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_SNAP_PACKAGE_LINKED_URL_PROPERTY, pamac_snap_package_linked_properties[PAMAC_SNAP_PACKAGE_LINKED_URL_PROPERTY] = g_param_spec_string ("url", "url", "url", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_SNAP_PACKAGE_LINKED_INSTALLED_SIZE_PROPERTY, pamac_snap_package_linked_properties[PAMAC_SNAP_PACKAGE_LINKED_INSTALLED_SIZE_PROPERTY] = g_param_spec_uint64 ("installed-size", "installed-size", "installed-size", 0, G_MAXUINT64, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_SNAP_PACKAGE_LINKED_DOWNLOAD_SIZE_PROPERTY, pamac_snap_package_linked_properties[PAMAC_SNAP_PACKAGE_LINKED_DOWNLOAD_SIZE_PROPERTY] = g_param_spec_uint64 ("download-size", "download-size", "download-size", 0, G_MAXUINT64, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_SNAP_PACKAGE_LINKED_INSTALL_DATE_PROPERTY, pamac_snap_package_linked_properties[PAMAC_SNAP_PACKAGE_LINKED_INSTALL_DATE_PROPERTY] = g_param_spec_boxed ("install-date", "install-date", "install-date", G_TYPE_DATE_TIME, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_SNAP_PACKAGE_LINKED_APP_NAME_PROPERTY, pamac_snap_package_linked_properties[PAMAC_SNAP_PACKAGE_LINKED_APP_NAME_PROPERTY] = g_param_spec_string ("app-name", "app-name", "app-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_SNAP_PACKAGE_LINKED_APP_ID_PROPERTY, pamac_snap_package_linked_properties[PAMAC_SNAP_PACKAGE_LINKED_APP_ID_PROPERTY] = g_param_spec_string ("app-id", "app-id", "app-id", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_SNAP_PACKAGE_LINKED_DESC_PROPERTY, pamac_snap_package_linked_properties[PAMAC_SNAP_PACKAGE_LINKED_DESC_PROPERTY] = g_param_spec_string ("desc", "desc", "desc", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_SNAP_PACKAGE_LINKED_LONG_DESC_PROPERTY, pamac_snap_package_linked_properties[PAMAC_SNAP_PACKAGE_LINKED_LONG_DESC_PROPERTY] = g_param_spec_string ("long-desc", "long-desc", "long-desc", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_SNAP_PACKAGE_LINKED_LAUNCHABLE_PROPERTY, pamac_snap_package_linked_properties[PAMAC_SNAP_PACKAGE_LINKED_LAUNCHABLE_PROPERTY] = g_param_spec_string ("launchable", "launchable", "launchable", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_SNAP_PACKAGE_LINKED_ICON_PROPERTY, pamac_snap_package_linked_properties[PAMAC_SNAP_PACKAGE_LINKED_ICON_PROPERTY] = g_param_spec_string ("icon", "icon", "icon", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_SNAP_PACKAGE_LINKED_SCREENSHOTS_PROPERTY, pamac_snap_package_linked_properties[PAMAC_SNAP_PACKAGE_LINKED_SCREENSHOTS_PROPERTY] = g_param_spec_boxed ("screenshots", "screenshots", "screenshots", G_TYPE_PTR_ARRAY, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_SNAP_PACKAGE_LINKED_CHANNEL_PROPERTY, pamac_snap_package_linked_properties[PAMAC_SNAP_PACKAGE_LINKED_CHANNEL_PROPERTY] = g_param_spec_string ("channel", "channel", "channel", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_SNAP_PACKAGE_LINKED_PUBLISHER_PROPERTY, pamac_snap_package_linked_properties[PAMAC_SNAP_PACKAGE_LINKED_PUBLISHER_PROPERTY] = g_param_spec_string ("publisher", "publisher", "publisher", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_SNAP_PACKAGE_LINKED_LICENSE_PROPERTY, pamac_snap_package_linked_properties[PAMAC_SNAP_PACKAGE_LINKED_LICENSE_PROPERTY] = g_param_spec_string ("license", "license", "license", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_SNAP_PACKAGE_LINKED_CONFINED_PROPERTY, pamac_snap_package_linked_properties[PAMAC_SNAP_PACKAGE_LINKED_CONFINED_PROPERTY] = g_param_spec_string ("confined", "confined", "confined", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_SNAP_PACKAGE_LINKED_CHANNELS_PROPERTY, pamac_snap_package_linked_properties[PAMAC_SNAP_PACKAGE_LINKED_CHANNELS_PROPERTY] = g_param_spec_boxed ("channels", "channels", "channels", G_TYPE_PTR_ARRAY, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
pamac_snap_package_linked_instance_init (PamacSnapPackageLinked * self,
                                         gpointer klass)
{
	self->priv = pamac_snap_package_linked_get_instance_private (self);
}

static void
pamac_snap_package_linked_finalize (GObject * obj)
{
	PamacSnapPackageLinked * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PAMAC_TYPE_SNAP_PACKAGE_LINKED, PamacSnapPackageLinked);
	_g_object_unref0 (self->priv->snap);
	_g_object_unref0 (self->priv->store_snap);
	_g_object_unref0 (self->priv->installed_snap);
	_g_free0 (self->priv->_name);
	_g_free0 (self->priv->_id);
	_g_free0 (self->priv->_app_id);
	_g_free0 (self->priv->_launchable);
	_g_ptr_array_unref0 (self->priv->_screenshots);
	_g_free0 (self->priv->_channel);
	_g_ptr_array_unref0 (self->priv->_channels);
	G_OBJECT_CLASS (pamac_snap_package_linked_parent_class)->finalize (obj);
}

static GType
pamac_snap_package_linked_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PamacSnapPackageLinkedClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pamac_snap_package_linked_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PamacSnapPackageLinked), 0, (GInstanceInitFunc) pamac_snap_package_linked_instance_init, NULL };
	GType pamac_snap_package_linked_type_id;
	pamac_snap_package_linked_type_id = g_type_register_static (PAMAC_TYPE_SNAP_PACKAGE, "PamacSnapPackageLinked", &g_define_type_info, 0);
	PamacSnapPackageLinked_private_offset = g_type_add_instance_private (pamac_snap_package_linked_type_id, sizeof (PamacSnapPackageLinkedPrivate));
	return pamac_snap_package_linked_type_id;
}

GType
pamac_snap_package_linked_get_type (void)
{
	static volatile gsize pamac_snap_package_linked_type_id__once = 0;
	if (g_once_init_enter (&pamac_snap_package_linked_type_id__once)) {
		GType pamac_snap_package_linked_type_id;
		pamac_snap_package_linked_type_id = pamac_snap_package_linked_get_type_once ();
		g_once_init_leave (&pamac_snap_package_linked_type_id__once, pamac_snap_package_linked_type_id);
	}
	return pamac_snap_package_linked_type_id__once;
}

static void
_vala_pamac_snap_package_linked_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec)
{
	PamacSnapPackageLinked * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PAMAC_TYPE_SNAP_PACKAGE_LINKED, PamacSnapPackageLinked);
	switch (property_id) {
		case PAMAC_SNAP_PACKAGE_LINKED_NAME_PROPERTY:
		g_value_set_string (value, pamac_package_get_name ((PamacPackage*) self));
		break;
		case PAMAC_SNAP_PACKAGE_LINKED_ID_PROPERTY:
		g_value_set_string (value, pamac_package_get_id ((PamacPackage*) self));
		break;
		case PAMAC_SNAP_PACKAGE_LINKED_VERSION_PROPERTY:
		g_value_set_string (value, pamac_package_get_version ((PamacPackage*) self));
		break;
		case PAMAC_SNAP_PACKAGE_LINKED_INSTALLED_VERSION_PROPERTY:
		g_value_set_string (value, pamac_package_get_installed_version ((PamacPackage*) self));
		break;
		case PAMAC_SNAP_PACKAGE_LINKED_REPO_PROPERTY:
		g_value_set_string (value, pamac_package_get_repo ((PamacPackage*) self));
		break;
		case PAMAC_SNAP_PACKAGE_LINKED_URL_PROPERTY:
		g_value_set_string (value, pamac_package_get_url ((PamacPackage*) self));
		break;
		case PAMAC_SNAP_PACKAGE_LINKED_INSTALLED_SIZE_PROPERTY:
		g_value_set_uint64 (value, pamac_package_get_installed_size ((PamacPackage*) self));
		break;
		case PAMAC_SNAP_PACKAGE_LINKED_DOWNLOAD_SIZE_PROPERTY:
		g_value_set_uint64 (value, pamac_package_get_download_size ((PamacPackage*) self));
		break;
		case PAMAC_SNAP_PACKAGE_LINKED_INSTALL_DATE_PROPERTY:
		g_value_set_boxed (value, pamac_package_get_install_date ((PamacPackage*) self));
		break;
		case PAMAC_SNAP_PACKAGE_LINKED_APP_NAME_PROPERTY:
		g_value_set_string (value, pamac_package_get_app_name ((PamacPackage*) self));
		break;
		case PAMAC_SNAP_PACKAGE_LINKED_APP_ID_PROPERTY:
		g_value_set_string (value, pamac_package_get_app_id ((PamacPackage*) self));
		break;
		case PAMAC_SNAP_PACKAGE_LINKED_DESC_PROPERTY:
		g_value_set_string (value, pamac_package_get_desc ((PamacPackage*) self));
		break;
		case PAMAC_SNAP_PACKAGE_LINKED_LONG_DESC_PROPERTY:
		g_value_set_string (value, pamac_package_get_long_desc ((PamacPackage*) self));
		break;
		case PAMAC_SNAP_PACKAGE_LINKED_LAUNCHABLE_PROPERTY:
		g_value_set_string (value, pamac_package_get_launchable ((PamacPackage*) self));
		break;
		case PAMAC_SNAP_PACKAGE_LINKED_ICON_PROPERTY:
		g_value_set_string (value, pamac_package_get_icon ((PamacPackage*) self));
		break;
		case PAMAC_SNAP_PACKAGE_LINKED_SCREENSHOTS_PROPERTY:
		g_value_set_boxed (value, pamac_package_get_screenshots ((PamacPackage*) self));
		break;
		case PAMAC_SNAP_PACKAGE_LINKED_CHANNEL_PROPERTY:
		g_value_set_string (value, pamac_snap_package_get_channel ((PamacSnapPackage*) self));
		break;
		case PAMAC_SNAP_PACKAGE_LINKED_PUBLISHER_PROPERTY:
		g_value_set_string (value, pamac_snap_package_get_publisher ((PamacSnapPackage*) self));
		break;
		case PAMAC_SNAP_PACKAGE_LINKED_LICENSE_PROPERTY:
		g_value_set_string (value, pamac_package_get_license ((PamacPackage*) self));
		break;
		case PAMAC_SNAP_PACKAGE_LINKED_CONFINED_PROPERTY:
		g_value_set_string (value, pamac_snap_package_get_confined ((PamacSnapPackage*) self));
		break;
		case PAMAC_SNAP_PACKAGE_LINKED_CHANNELS_PROPERTY:
		g_value_set_boxed (value, pamac_snap_package_get_channels ((PamacSnapPackage*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_pamac_snap_package_linked_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec)
{
	PamacSnapPackageLinked * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PAMAC_TYPE_SNAP_PACKAGE_LINKED, PamacSnapPackageLinked);
	switch (property_id) {
		case PAMAC_SNAP_PACKAGE_LINKED_NAME_PROPERTY:
		pamac_package_set_name ((PamacPackage*) self, g_value_get_string (value));
		break;
		case PAMAC_SNAP_PACKAGE_LINKED_ID_PROPERTY:
		pamac_package_set_id ((PamacPackage*) self, g_value_get_string (value));
		break;
		case PAMAC_SNAP_PACKAGE_LINKED_VERSION_PROPERTY:
		pamac_package_set_version ((PamacPackage*) self, g_value_get_string (value));
		break;
		case PAMAC_SNAP_PACKAGE_LINKED_INSTALLED_VERSION_PROPERTY:
		pamac_package_set_installed_version ((PamacPackage*) self, g_value_get_string (value));
		break;
		case PAMAC_SNAP_PACKAGE_LINKED_REPO_PROPERTY:
		pamac_package_set_repo ((PamacPackage*) self, g_value_get_string (value));
		break;
		case PAMAC_SNAP_PACKAGE_LINKED_DESC_PROPERTY:
		pamac_package_set_desc ((PamacPackage*) self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
pamac_snap_get_instance_private (PamacSnap* self)
{
	return G_STRUCT_MEMBER_P (self, PamacSnap_private_offset);
}

PamacSnap*
pamac_snap_construct (GType object_type)
{
	PamacSnap * self = NULL;
	self = (PamacSnap*) g_object_new (object_type, NULL);
	return self;
}

PamacSnap*
pamac_snap_new (void)
{
	return pamac_snap_construct (PAMAC_TYPE_SNAP);
}

gboolean
pamac_snap_app_name_matches_snap_name (SnapdSnap* snap,
                                       SnapdApp* app)
{
	GCompareFunc _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gboolean result;
	g_return_val_if_fail (snap != NULL, FALSE);
	g_return_val_if_fail (app != NULL, FALSE);
	_tmp0_ = ((GCompareFunc) g_strcmp0);
	_tmp1_ = snapd_snap_get_name (snap);
	_tmp2_ = _tmp1_;
	_tmp3_ = snapd_app_get_name (app);
	_tmp4_ = _tmp3_;
	result = _tmp0_ (_tmp2_, _tmp4_) == 0;
	return result;
}

SnapdApp*
pamac_snap_get_primary_app (SnapdSnap* snap)
{
	SnapdApp* primary_app = NULL;
	GPtrArray* apps = NULL;
	GPtrArray* _tmp0_;
	GPtrArray* _tmp1_;
	SnapdApp* _tmp16_;
	SnapdApp* result;
	g_return_val_if_fail (snap != NULL, NULL);
	primary_app = NULL;
	_tmp0_ = snapd_snap_get_apps (snap);
	apps = _tmp0_;
	_tmp1_ = apps;
	{
		GPtrArray* app_collection = NULL;
		guint app_index = 0U;
		app_collection = _tmp1_;
		for (app_index = 0; app_index < app_collection->len; app_index = app_index + 1) {
			SnapdApp* app = NULL;
			app = (SnapdApp*) g_ptr_array_index (app_collection, app_index);
			{
				gboolean _tmp2_ = FALSE;
				gboolean _tmp3_ = FALSE;
				SnapdApp* _tmp4_;
				_tmp4_ = primary_app;
				if (_tmp4_ == NULL) {
					_tmp3_ = TRUE;
				} else {
					gboolean _tmp5_ = FALSE;
					SnapdApp* _tmp6_;
					const gchar* _tmp7_;
					const gchar* _tmp8_;
					_tmp6_ = primary_app;
					_tmp7_ = snapd_app_get_desktop_file (_tmp6_);
					_tmp8_ = _tmp7_;
					if (_tmp8_ == NULL) {
						SnapdApp* _tmp9_;
						const gchar* _tmp10_;
						const gchar* _tmp11_;
						_tmp9_ = app;
						_tmp10_ = snapd_app_get_desktop_file (_tmp9_);
						_tmp11_ = _tmp10_;
						_tmp5_ = _tmp11_ != NULL;
					} else {
						_tmp5_ = FALSE;
					}
					_tmp3_ = _tmp5_;
				}
				if (_tmp3_) {
					_tmp2_ = TRUE;
				} else {
					gboolean _tmp12_ = FALSE;
					SnapdApp* _tmp13_;
					_tmp13_ = primary_app;
					if (!pamac_snap_app_name_matches_snap_name (snap, _tmp13_)) {
						SnapdApp* _tmp14_;
						_tmp14_ = app;
						_tmp12_ = pamac_snap_app_name_matches_snap_name (snap, _tmp14_);
					} else {
						_tmp12_ = FALSE;
					}
					_tmp2_ = _tmp12_;
				}
				if (_tmp2_) {
					SnapdApp* _tmp15_;
					_tmp15_ = app;
					primary_app = _tmp15_;
				}
			}
		}
	}
	_tmp16_ = primary_app;
	result = _tmp16_;
	return result;
}

static PamacSnapPackage*
pamac_snap_initialize_snap (PamacSnap* self,
                            SnapdSnap* snap)
{
	PamacSnapPackageLinked* pkg = NULL;
	PamacSnapPackageLinked* _tmp31_;
	GError* _inner_error0_ = NULL;
	PamacSnapPackage* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (snap != NULL, NULL);
	pkg = NULL;
	{
		GHashTable* _tmp0_;
		_tmp0_ = self->priv->pkgs_cache;
		g_rec_mutex_lock (&self->priv->__lock_pkgs_cache);
		{
			GHashTable* _tmp1_;
			const gchar* _tmp2_;
			const gchar* _tmp3_;
			gchar* _tmp4_;
			gchar* _tmp5_;
			gconstpointer _tmp6_;
			PamacSnapPackageLinked* _tmp7_;
			SnapdSnap* store_snap = NULL;
			SnapdSnap* installed_snap = NULL;
			GDateTime* _tmp10_;
			GDateTime* _tmp11_;
			PamacSnapPackageLinked* new_pkg = NULL;
			SnapdSnap* _tmp20_;
			SnapdSnap* _tmp21_;
			PamacSnapPackageLinked* _tmp22_;
			PamacSnapPackageLinked* _tmp23_;
			GHashTable* _tmp24_;
			PamacSnapPackageLinked* _tmp25_;
			const gchar* _tmp26_;
			const gchar* _tmp27_;
			PamacSnapPackageLinked* _tmp28_;
			PamacSnapPackageLinked* _tmp29_;
			_tmp1_ = self->priv->pkgs_cache;
			_tmp2_ = snapd_snap_get_name (snap);
			_tmp3_ = _tmp2_;
			_tmp4_ = g_strdup_printf ("Snap/%s", _tmp3_);
			_tmp5_ = _tmp4_;
			_tmp6_ = g_hash_table_lookup (_tmp1_, _tmp5_);
			pkg = (PamacSnapPackageLinked*) _tmp6_;
			_g_free0 (_tmp5_);
			_tmp7_ = pkg;
			if (_tmp7_ != NULL) {
				PamacSnapPackageLinked* _tmp8_;
				_tmp8_ = pkg;
				result = (PamacSnapPackage*) _tmp8_;
				{
					GHashTable* _tmp9_;
					_tmp9_ = self->priv->pkgs_cache;
					g_rec_mutex_unlock (&self->priv->__lock_pkgs_cache);
				}
				return result;
			}
			_tmp10_ = snapd_snap_get_install_date (snap);
			_tmp11_ = _tmp10_;
			if (_tmp11_ != NULL) {
				SnapdSnap* _tmp12_;
				const gchar* _tmp13_;
				const gchar* _tmp14_;
				SnapdSnap* _tmp15_;
				_tmp12_ = _g_object_ref0 (snap);
				_g_object_unref0 (installed_snap);
				installed_snap = _tmp12_;
				_tmp13_ = snapd_snap_get_name (snap);
				_tmp14_ = _tmp13_;
				_tmp15_ = pamac_snap_get_store_snap (self, _tmp14_);
				_g_object_unref0 (store_snap);
				store_snap = _tmp15_;
			} else {
				const gchar* _tmp16_;
				const gchar* _tmp17_;
				SnapdSnap* _tmp18_;
				SnapdSnap* _tmp19_;
				_tmp16_ = snapd_snap_get_name (snap);
				_tmp17_ = _tmp16_;
				_tmp18_ = pamac_snap_get_local_snap (self, _tmp17_);
				_g_object_unref0 (installed_snap);
				installed_snap = _tmp18_;
				_tmp19_ = _g_object_ref0 (snap);
				_g_object_unref0 (store_snap);
				store_snap = _tmp19_;
			}
			_tmp20_ = installed_snap;
			_tmp21_ = store_snap;
			_tmp22_ = pamac_snap_package_linked_new (snap, _tmp20_, _tmp21_);
			new_pkg = _tmp22_;
			_tmp23_ = new_pkg;
			pkg = _tmp23_;
			_tmp24_ = self->priv->pkgs_cache;
			_tmp25_ = pkg;
			_tmp26_ = pamac_package_get_id ((PamacPackage*) _tmp25_);
			_tmp27_ = _tmp26_;
			_tmp28_ = new_pkg;
			_tmp29_ = _g_object_ref0 (_tmp28_);
			g_hash_table_insert (_tmp24_, _tmp27_, _tmp29_);
			_g_object_unref0 (new_pkg);
			_g_object_unref0 (installed_snap);
			_g_object_unref0 (store_snap);
		}
		__finally0:
		{
			GHashTable* _tmp30_;
			_tmp30_ = self->priv->pkgs_cache;
			g_rec_mutex_unlock (&self->priv->__lock_pkgs_cache);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp31_ = pkg;
	result = (PamacSnapPackage*) _tmp31_;
	return result;
}

static gpointer
_g_ptr_array_ref0 (gpointer self)
{
	return self ? g_ptr_array_ref (self) : NULL;
}

static void
pamac_snap_real_search_snaps (PamacSnapPlugin* base,
                              const gchar* search_string,
                              GPtrArray** pkgs)
{
	PamacSnap * self;
	GError* _inner_error0_ = NULL;
	self = (PamacSnap*) base;
	g_return_if_fail (search_string != NULL);
	g_return_if_fail (*pkgs != NULL);
	{
		{
			GHashTable* _tmp0_;
			_tmp0_ = self->priv->search_snaps_cache;
			g_rec_mutex_lock (&self->priv->__lock_search_snaps_cache);
			{
				GPtrArray* found = NULL;
				GHashTable* _tmp1_;
				gconstpointer _tmp2_;
				GPtrArray* _tmp3_;
				GPtrArray* _tmp4_;
				GPtrArray* _tmp13_;
				_tmp1_ = self->priv->search_snaps_cache;
				_tmp2_ = g_hash_table_lookup (_tmp1_, search_string);
				_tmp3_ = _g_ptr_array_ref0 ((GPtrArray*) _tmp2_);
				found = _tmp3_;
				_tmp4_ = found;
				if (_tmp4_ == NULL) {
					GPtrArray* _tmp5_ = NULL;
					SnapdClient* _tmp6_;
					GPtrArray* _tmp7_;
					GPtrArray* _tmp8_;
					GHashTable* _tmp9_;
					gchar* _tmp10_;
					GPtrArray* _tmp11_;
					GPtrArray* _tmp12_;
					_tmp6_ = self->priv->client;
					_tmp7_ = snapd_client_find_sync (_tmp6_, SNAPD_FIND_FLAGS_SCOPE_WIDE, search_string, NULL, NULL, &_inner_error0_);
					_tmp5_ = _tmp7_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_ptr_array_unref0 (found);
						goto __catch1_g_error;
					}
					_tmp8_ = _tmp5_;
					_tmp5_ = NULL;
					_g_ptr_array_unref0 (found);
					found = _tmp8_;
					_tmp9_ = self->priv->search_snaps_cache;
					_tmp10_ = g_strdup (search_string);
					_tmp11_ = found;
					_tmp12_ = _g_ptr_array_ref0 (_tmp11_);
					g_hash_table_insert (_tmp9_, _tmp10_, _tmp12_);
					_g_ptr_array_unref0 (_tmp5_);
				}
				_tmp13_ = found;
				{
					GPtrArray* snap_collection = NULL;
					guint snap_index = 0U;
					snap_collection = _tmp13_;
					for (snap_index = 0; snap_index < snap_collection->len; snap_index = snap_index + 1) {
						SnapdSnap* snap = NULL;
						snap = (SnapdSnap*) g_ptr_array_index (snap_collection, snap_index);
						{
							SnapdSnap* _tmp14_;
							SnapdSnapType _tmp15_;
							SnapdSnapType _tmp16_;
							_tmp14_ = snap;
							_tmp15_ = snapd_snap_get_snap_type (_tmp14_);
							_tmp16_ = _tmp15_;
							if (_tmp16_ == SNAPD_SNAP_TYPE_APP) {
								SnapdSnap* _tmp17_;
								PamacSnapPackage* _tmp18_;
								_tmp17_ = snap;
								_tmp18_ = pamac_snap_initialize_snap (self, _tmp17_);
								g_ptr_array_add (*pkgs, _tmp18_);
							}
						}
					}
				}
				_g_ptr_array_unref0 (found);
			}
			goto __finally1;
			__catch1_g_error:
			{
				GError* _lock_error_ = NULL;
				GError* _tmp19_;
				_lock_error_ = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp19_ = _lock_error_;
				_lock_error_ = NULL;
				_inner_error0_ = _tmp19_;
				_g_error_free0 (_lock_error_);
				goto __finally1;
			}
			__finally1:
			{
				GError* _inner_error1_ = NULL;
				GHashTable* _tmp20_;
				_tmp20_ = self->priv->search_snaps_cache;
				g_rec_mutex_unlock (&self->priv->__lock_search_snaps_cache);
			}
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp21_;
		const gchar* _tmp22_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp21_ = e;
		_tmp22_ = _tmp21_->message;
		g_warning ("snap_plugin.vala:291: %s", _tmp22_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
pamac_snap_real_search_uninstalled_snaps_sync (PamacSnapPlugin* base,
                                               const gchar* search_string,
                                               GPtrArray** pkgs)
{
	PamacSnap * self;
	GError* _inner_error0_ = NULL;
	self = (PamacSnap*) base;
	g_return_if_fail (search_string != NULL);
	g_return_if_fail (*pkgs != NULL);
	{
		{
			GHashTable* _tmp0_;
			_tmp0_ = self->priv->search_snaps_cache;
			g_rec_mutex_lock (&self->priv->__lock_search_snaps_cache);
			{
				GPtrArray* found = NULL;
				GHashTable* _tmp1_;
				gconstpointer _tmp2_;
				GPtrArray* _tmp3_;
				GPtrArray* _tmp4_;
				GPtrArray* _tmp13_;
				_tmp1_ = self->priv->search_snaps_cache;
				_tmp2_ = g_hash_table_lookup (_tmp1_, search_string);
				_tmp3_ = _g_ptr_array_ref0 ((GPtrArray*) _tmp2_);
				found = _tmp3_;
				_tmp4_ = found;
				if (_tmp4_ == NULL) {
					GPtrArray* _tmp5_ = NULL;
					SnapdClient* _tmp6_;
					GPtrArray* _tmp7_;
					GPtrArray* _tmp8_;
					GHashTable* _tmp9_;
					gchar* _tmp10_;
					GPtrArray* _tmp11_;
					GPtrArray* _tmp12_;
					_tmp6_ = self->priv->client;
					_tmp7_ = snapd_client_find_sync (_tmp6_, SNAPD_FIND_FLAGS_SCOPE_WIDE, search_string, NULL, NULL, &_inner_error0_);
					_tmp5_ = _tmp7_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_ptr_array_unref0 (found);
						goto __catch1_g_error;
					}
					_tmp8_ = _tmp5_;
					_tmp5_ = NULL;
					_g_ptr_array_unref0 (found);
					found = _tmp8_;
					_tmp9_ = self->priv->search_snaps_cache;
					_tmp10_ = g_strdup (search_string);
					_tmp11_ = found;
					_tmp12_ = _g_ptr_array_ref0 (_tmp11_);
					g_hash_table_insert (_tmp9_, _tmp10_, _tmp12_);
					_g_ptr_array_unref0 (_tmp5_);
				}
				_tmp13_ = found;
				{
					GPtrArray* snap_collection = NULL;
					guint snap_index = 0U;
					snap_collection = _tmp13_;
					for (snap_index = 0; snap_index < snap_collection->len; snap_index = snap_index + 1) {
						SnapdSnap* snap = NULL;
						snap = (SnapdSnap*) g_ptr_array_index (snap_collection, snap_index);
						{
							gboolean _tmp14_ = FALSE;
							SnapdSnap* _tmp15_;
							SnapdSnapType _tmp16_;
							SnapdSnapType _tmp17_;
							_tmp15_ = snap;
							_tmp16_ = snapd_snap_get_snap_type (_tmp15_);
							_tmp17_ = _tmp16_;
							if (_tmp17_ == SNAPD_SNAP_TYPE_APP) {
								SnapdSnap* _tmp18_;
								GDateTime* _tmp19_;
								GDateTime* _tmp20_;
								_tmp18_ = snap;
								_tmp19_ = snapd_snap_get_install_date (_tmp18_);
								_tmp20_ = _tmp19_;
								_tmp14_ = _tmp20_ == NULL;
							} else {
								_tmp14_ = FALSE;
							}
							if (_tmp14_) {
								SnapdSnap* _tmp21_;
								PamacSnapPackage* _tmp22_;
								_tmp21_ = snap;
								_tmp22_ = pamac_snap_initialize_snap (self, _tmp21_);
								g_ptr_array_add (*pkgs, _tmp22_);
							}
						}
					}
				}
				_g_ptr_array_unref0 (found);
			}
			goto __finally1;
			__catch1_g_error:
			{
				GError* _lock_error_ = NULL;
				GError* _tmp23_;
				_lock_error_ = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp23_ = _lock_error_;
				_lock_error_ = NULL;
				_inner_error0_ = _tmp23_;
				_g_error_free0 (_lock_error_);
				goto __finally1;
			}
			__finally1:
			{
				GError* _inner_error1_ = NULL;
				GHashTable* _tmp24_;
				_tmp24_ = self->priv->search_snaps_cache;
				g_rec_mutex_unlock (&self->priv->__lock_search_snaps_cache);
			}
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp25_;
		const gchar* _tmp26_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp25_ = e;
		_tmp26_ = _tmp25_->message;
		g_warning ("snap_plugin.vala:310: %s", _tmp26_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static gboolean
pamac_snap_real_is_installed_snap (PamacSnapPlugin* base,
                                   const gchar* name)
{
	PamacSnap * self;
	SnapdSnap* _tmp0_;
	SnapdSnap* _tmp1_;
	gboolean _tmp2_;
	gboolean result;
	self = (PamacSnap*) base;
	g_return_val_if_fail (name != NULL, FALSE);
	_tmp0_ = pamac_snap_get_local_snap (self, name);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_ != NULL;
	_g_object_unref0 (_tmp1_);
	result = _tmp2_;
	return result;
}

static PamacSnapPackage*
pamac_snap_real_get_snap (PamacSnapPlugin* base,
                          const gchar* name)
{
	PamacSnap * self;
	PamacSnapPackage* pkg = NULL;
	SnapdSnap* found = NULL;
	SnapdSnap* _tmp0_;
	SnapdSnap* _tmp1_;
	SnapdSnap* _tmp3_;
	PamacSnapPackage* _tmp6_;
	PamacSnapPackage* result;
	self = (PamacSnap*) base;
	g_return_val_if_fail (name != NULL, NULL);
	pkg = NULL;
	_tmp0_ = pamac_snap_get_local_snap (self, name);
	found = _tmp0_;
	_tmp1_ = found;
	if (_tmp1_ == NULL) {
		SnapdSnap* _tmp2_;
		_tmp2_ = pamac_snap_get_store_snap (self, name);
		_g_object_unref0 (found);
		found = _tmp2_;
	}
	_tmp3_ = found;
	if (_tmp3_ != NULL) {
		SnapdSnap* _tmp4_;
		PamacSnapPackage* _tmp5_;
		_tmp4_ = found;
		_tmp5_ = pamac_snap_initialize_snap (self, _tmp4_);
		pkg = _tmp5_;
	}
	_tmp6_ = pkg;
	result = _tmp6_;
	_g_object_unref0 (found);
	return result;
}

static PamacSnapPackage*
pamac_snap_real_get_snap_by_app_id (PamacSnapPlugin* base,
                                    const gchar* app_id)
{
	PamacSnap * self;
	PamacSnapPackage* pkg = NULL;
	PamacSnapPackage* _tmp19_;
	GError* _inner_error0_ = NULL;
	PamacSnapPackage* result;
	self = (PamacSnap*) base;
	g_return_val_if_fail (app_id != NULL, NULL);
	pkg = NULL;
	{
		GPtrArray* snaps = NULL;
		SnapdClient* _tmp0_;
		GPtrArray* _tmp1_;
		_tmp0_ = self->priv->client;
		_tmp1_ = snapd_client_get_snaps_sync (_tmp0_, SNAPD_GET_SNAPS_FLAGS_NONE, NULL, NULL, &_inner_error0_);
		snaps = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		{
			GPtrArray* snap_collection = NULL;
			guint snap_index = 0U;
			snap_collection = snaps;
			for (snap_index = 0; snap_index < snap_collection->len; snap_index = snap_index + 1) {
				SnapdSnap* snap = NULL;
				snap = (SnapdSnap*) g_ptr_array_index (snap_collection, snap_index);
				{
					SnapdSnap* _tmp2_;
					SnapdSnapType _tmp3_;
					SnapdSnapType _tmp4_;
					_tmp2_ = snap;
					_tmp3_ = snapd_snap_get_snap_type (_tmp2_);
					_tmp4_ = _tmp3_;
					if (_tmp4_ == SNAPD_SNAP_TYPE_APP) {
						SnapdApp* primary_app = NULL;
						SnapdSnap* _tmp5_;
						SnapdApp* _tmp6_;
						SnapdApp* _tmp7_;
						SnapdApp* _tmp8_;
						_tmp5_ = snap;
						_tmp6_ = pamac_snap_get_primary_app (_tmp5_);
						_tmp7_ = _g_object_ref0 (_tmp6_);
						primary_app = _tmp7_;
						_tmp8_ = primary_app;
						if (_tmp8_ != NULL) {
							const gchar* desktop_file = NULL;
							SnapdApp* _tmp9_;
							const gchar* _tmp10_;
							const gchar* _tmp11_;
							gboolean _tmp12_ = FALSE;
							const gchar* _tmp13_;
							_tmp9_ = primary_app;
							_tmp10_ = snapd_app_get_desktop_file (_tmp9_);
							_tmp11_ = _tmp10_;
							desktop_file = _tmp11_;
							_tmp13_ = desktop_file;
							if (_tmp13_ != NULL) {
								const gchar* _tmp14_;
								_tmp14_ = desktop_file;
								_tmp12_ = g_str_has_suffix (_tmp14_, app_id);
							} else {
								_tmp12_ = FALSE;
							}
							if (_tmp12_) {
								SnapdSnap* _tmp15_;
								PamacSnapPackage* _tmp16_;
								_tmp15_ = snap;
								_tmp16_ = pamac_snap_initialize_snap (self, _tmp15_);
								pkg = _tmp16_;
							}
						}
						_g_object_unref0 (primary_app);
					}
				}
			}
		}
		_g_ptr_array_unref0 (snaps);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp17_;
		const gchar* _tmp18_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp17_ = e;
		_tmp18_ = _tmp17_->message;
		g_warning ("snap_plugin.vala:346: %s", _tmp18_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp19_ = pkg;
	result = _tmp19_;
	return result;
}

static SnapdSnap*
pamac_snap_get_local_snap (PamacSnap* self,
                           const gchar* name)
{
	GError* _inner_error0_ = NULL;
	SnapdSnap* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	{
		SnapdSnap* found = NULL;
		SnapdClient* _tmp0_;
		SnapdSnap* _tmp1_;
		SnapdSnap* _tmp2_;
		SnapdSnapType _tmp3_;
		SnapdSnapType _tmp4_;
		_tmp0_ = self->priv->client;
		_tmp1_ = snapd_client_get_snap_sync (_tmp0_, name, NULL, &_inner_error0_);
		found = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = found;
		_tmp3_ = snapd_snap_get_snap_type (_tmp2_);
		_tmp4_ = _tmp3_;
		if (_tmp4_ == SNAPD_SNAP_TYPE_APP) {
			result = found;
			return result;
		}
		_g_object_unref0 (found);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = NULL;
	return result;
}

static gint
vala_g_ptr_array_get_length (GPtrArray* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = (gint) self->len;
	return result;
}

static SnapdSnap*
pamac_snap_get_store_snap (PamacSnap* self,
                           const gchar* name)
{
	GError* _inner_error0_ = NULL;
	SnapdSnap* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	{
		{
			GHashTable* _tmp0_;
			_tmp0_ = self->priv->store_snaps_cache;
			g_rec_mutex_lock (&self->priv->__lock_store_snaps_cache);
			{
				SnapdSnap* found = NULL;
				GHashTable* _tmp1_;
				gconstpointer _tmp2_;
				SnapdSnap* _tmp3_;
				GPtrArray* founds = NULL;
				SnapdClient* _tmp7_;
				GPtrArray* _tmp8_;
				GPtrArray* _tmp9_;
				gint _tmp10_;
				gint _tmp11_;
				_tmp1_ = self->priv->store_snaps_cache;
				_tmp2_ = g_hash_table_lookup (_tmp1_, name);
				found = (SnapdSnap*) _tmp2_;
				_tmp3_ = found;
				if (_tmp3_ != NULL) {
					SnapdSnap* _tmp4_;
					SnapdSnap* _tmp5_;
					_tmp4_ = found;
					_tmp5_ = _g_object_ref0 (_tmp4_);
					result = _tmp5_;
					{
						GError* _inner_error0_ = NULL;
						GHashTable* _tmp6_;
						_tmp6_ = self->priv->store_snaps_cache;
						g_rec_mutex_unlock (&self->priv->__lock_store_snaps_cache);
					}
					return result;
				}
				_tmp7_ = self->priv->client;
				_tmp8_ = snapd_client_find_sync (_tmp7_, SNAPD_FIND_FLAGS_SCOPE_WIDE | SNAPD_FIND_FLAGS_MATCH_NAME, name, NULL, NULL, &_inner_error0_);
				founds = _tmp8_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch1_g_error;
				}
				_tmp9_ = founds;
				_tmp10_ = vala_g_ptr_array_get_length (_tmp9_);
				_tmp11_ = _tmp10_;
				if (_tmp11_ == 1) {
					GPtrArray* _tmp12_;
					gconstpointer _tmp13_;
					GHashTable* _tmp14_;
					gchar* _tmp15_;
					SnapdSnap* _tmp16_;
					SnapdSnap* _tmp17_;
					SnapdSnap* _tmp18_;
					SnapdSnap* _tmp19_;
					_tmp12_ = founds;
					_tmp13_ = g_ptr_array_index (_tmp12_, (guint) 0);
					found = (SnapdSnap*) _tmp13_;
					_tmp14_ = self->priv->store_snaps_cache;
					_tmp15_ = g_strdup (name);
					_tmp16_ = found;
					_tmp17_ = _g_object_ref0 (_tmp16_);
					g_hash_table_insert (_tmp14_, _tmp15_, _tmp17_);
					_tmp18_ = found;
					_tmp19_ = _g_object_ref0 (_tmp18_);
					result = _tmp19_;
					_g_ptr_array_unref0 (founds);
					{
						GError* _inner_error0_ = NULL;
						GHashTable* _tmp20_;
						_tmp20_ = self->priv->store_snaps_cache;
						g_rec_mutex_unlock (&self->priv->__lock_store_snaps_cache);
					}
					return result;
				}
				_g_ptr_array_unref0 (founds);
			}
			goto __finally1;
			__catch1_g_error:
			{
				GError* _lock_error_ = NULL;
				GError* _tmp21_;
				_lock_error_ = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp21_ = _lock_error_;
				_lock_error_ = NULL;
				_inner_error0_ = _tmp21_;
				_g_error_free0 (_lock_error_);
				goto __finally1;
			}
			__finally1:
			{
				GError* _inner_error1_ = NULL;
				GHashTable* _tmp22_;
				_tmp22_ = self->priv->store_snaps_cache;
				g_rec_mutex_unlock (&self->priv->__lock_store_snaps_cache);
			}
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = NULL;
	return result;
}

static void
pamac_snap_real_get_installed_snaps (PamacSnapPlugin* base,
                                     GPtrArray** pkgs)
{
	PamacSnap * self;
	GError* _inner_error0_ = NULL;
	self = (PamacSnap*) base;
	g_return_if_fail (*pkgs != NULL);
	{
		GPtrArray* snaps = NULL;
		SnapdClient* _tmp0_;
		GPtrArray* _tmp1_;
		_tmp0_ = self->priv->client;
		_tmp1_ = snapd_client_get_snaps_sync (_tmp0_, SNAPD_GET_SNAPS_FLAGS_NONE, NULL, NULL, &_inner_error0_);
		snaps = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		{
			GPtrArray* snap_collection = NULL;
			guint snap_index = 0U;
			snap_collection = snaps;
			for (snap_index = 0; snap_index < snap_collection->len; snap_index = snap_index + 1) {
				SnapdSnap* snap = NULL;
				snap = (SnapdSnap*) g_ptr_array_index (snap_collection, snap_index);
				{
					SnapdSnap* _tmp2_;
					SnapdSnapType _tmp3_;
					SnapdSnapType _tmp4_;
					_tmp2_ = snap;
					_tmp3_ = snapd_snap_get_snap_type (_tmp2_);
					_tmp4_ = _tmp3_;
					if (_tmp4_ == SNAPD_SNAP_TYPE_APP) {
						SnapdSnap* _tmp5_;
						PamacSnapPackage* _tmp6_;
						_tmp5_ = snap;
						_tmp6_ = pamac_snap_initialize_snap (self, _tmp5_);
						g_ptr_array_add (*pkgs, _tmp6_);
					}
				}
			}
		}
		_g_ptr_array_unref0 (snaps);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		g_warning ("snap_plugin.vala:392: %s", _tmp8_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

static gchar*
pamac_snap_real_get_installed_snap_icon (PamacSnapPlugin* base,
                                         const gchar* name,
                                         GError** error)
{
	PamacSnap * self;
	GFile* cached_icon = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp17_;
	gchar* _tmp18_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	self = (PamacSnap*) base;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = g_strdup_printf ("/tmp/pamac-app-icons/%s", name);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_file_new_for_path (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	cached_icon = _tmp3_;
	_tmp4_ = cached_icon;
	if (!g_file_query_exists (_tmp4_, NULL)) {
		{
			SnapdIcon* icon = NULL;
			SnapdClient* _tmp5_;
			SnapdIcon* _tmp6_;
			GMemoryInputStream* input_stream = NULL;
			SnapdIcon* _tmp7_;
			GBytes* _tmp8_;
			GBytes* _tmp9_;
			GMemoryInputStream* _tmp10_;
			GFileOutputStream* output_stream = NULL;
			GFile* _tmp11_;
			GFileOutputStream* _tmp12_;
			GFileOutputStream* _tmp13_;
			GMemoryInputStream* _tmp14_;
			_tmp5_ = self->priv->client;
			_tmp6_ = snapd_client_get_icon_sync (_tmp5_, name, NULL, &_inner_error0_);
			icon = _tmp6_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp7_ = icon;
			_tmp8_ = snapd_icon_get_data (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp10_ = (GMemoryInputStream*) g_memory_input_stream_new_from_bytes (_tmp9_);
			input_stream = _tmp10_;
			_tmp11_ = cached_icon;
			_tmp12_ = g_file_append_to (_tmp11_, G_FILE_CREATE_NONE, NULL, &_inner_error0_);
			output_stream = _tmp12_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (input_stream);
				_g_object_unref0 (icon);
				goto __catch0_g_error;
			}
			_tmp13_ = output_stream;
			_tmp14_ = input_stream;
			g_output_stream_splice ((GOutputStream*) _tmp13_, (GInputStream*) _tmp14_, G_OUTPUT_STREAM_SPLICE_NONE, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (output_stream);
				_g_object_unref0 (input_stream);
				_g_object_unref0 (icon);
				goto __catch0_g_error;
			}
			_g_object_unref0 (output_stream);
			_g_object_unref0 (input_stream);
			_g_object_unref0 (icon);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp15_;
			GError* _tmp16_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp15_ = e;
			_tmp16_ = _g_error_copy0 (_tmp15_);
			_inner_error0_ = _tmp16_;
			_g_error_free0 (e);
			goto __finally0;
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (cached_icon);
			return NULL;
		}
	}
	_tmp17_ = cached_icon;
	_tmp18_ = g_file_get_path (_tmp17_);
	result = _tmp18_;
	_g_object_unref0 (cached_icon);
	return result;
}

static void
pamac_snap_real_get_category_snaps (PamacSnapPlugin* base,
                                    const gchar* category,
                                    GPtrArray** pkgs)
{
	PamacSnap * self;
	GPtrArray* snap_categories = NULL;
	GPtrArray* _tmp0_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	static GQuark _tmp2_label2 = 0;
	static GQuark _tmp2_label3 = 0;
	static GQuark _tmp2_label4 = 0;
	static GQuark _tmp2_label5 = 0;
	static GQuark _tmp2_label6 = 0;
	static GQuark _tmp2_label7 = 0;
	static GQuark _tmp2_label8 = 0;
	GPtrArray* _tmp50_;
	gint _tmp51_;
	gint _tmp52_;
	GError* _inner_error0_ = NULL;
	self = (PamacSnap*) base;
	g_return_if_fail (category != NULL);
	g_return_if_fail (*pkgs != NULL);
	_tmp0_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
	snap_categories = _tmp0_;
	_tmp1_ = category;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("Featured")))) {
		switch (0) {
			default:
			{
				GPtrArray* featured_pkgs = NULL;
				GPtrArray* _tmp4_;
				GPtrArray* _tmp5_;
				gchar* _tmp6_;
				GPtrArray* _tmp7_;
				gchar* _tmp8_;
				GPtrArray* _tmp9_;
				gchar* _tmp10_;
				GPtrArray* _tmp11_;
				_tmp4_ = g_ptr_array_new_full ((guint) 3, _g_free0_);
				featured_pkgs = _tmp4_;
				_tmp5_ = featured_pkgs;
				_tmp6_ = g_strdup ("spotify");
				g_ptr_array_add (_tmp5_, _tmp6_);
				_tmp7_ = featured_pkgs;
				_tmp8_ = g_strdup ("signal-desktop");
				g_ptr_array_add (_tmp7_, _tmp8_);
				_tmp9_ = featured_pkgs;
				_tmp10_ = g_strdup ("discord");
				g_ptr_array_add (_tmp9_, _tmp10_);
				_tmp11_ = featured_pkgs;
				{
					GPtrArray* name_collection = NULL;
					guint name_index = 0U;
					name_collection = _tmp11_;
					for (name_index = 0; name_index < name_collection->len; name_index = name_index + 1) {
						const gchar* name = NULL;
						name = (const gchar*) g_ptr_array_index (name_collection, name_index);
						{
							SnapdSnap* found = NULL;
							const gchar* _tmp12_;
							SnapdSnap* _tmp13_;
							SnapdSnap* _tmp14_;
							SnapdSnap* _tmp17_;
							_tmp12_ = name;
							_tmp13_ = pamac_snap_get_local_snap (self, _tmp12_);
							found = _tmp13_;
							_tmp14_ = found;
							if (_tmp14_ == NULL) {
								const gchar* _tmp15_;
								SnapdSnap* _tmp16_;
								_tmp15_ = name;
								_tmp16_ = pamac_snap_get_store_snap (self, _tmp15_);
								_g_object_unref0 (found);
								found = _tmp16_;
							}
							_tmp17_ = found;
							if (_tmp17_ != NULL) {
								SnapdSnap* _tmp18_;
								PamacSnapPackage* _tmp19_;
								_tmp18_ = found;
								_tmp19_ = pamac_snap_initialize_snap (self, _tmp18_);
								g_ptr_array_add (*pkgs, _tmp19_);
							}
							_g_object_unref0 (found);
						}
					}
				}
				_g_ptr_array_unref0 (featured_pkgs);
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("Photo & Video")))) {
		switch (0) {
			default:
			{
				GPtrArray* _tmp20_;
				gchar* _tmp21_;
				GPtrArray* _tmp22_;
				gchar* _tmp23_;
				_tmp20_ = snap_categories;
				_tmp21_ = g_strdup ("photo-and-video");
				g_ptr_array_add (_tmp20_, _tmp21_);
				_tmp22_ = snap_categories;
				_tmp23_ = g_strdup ("art-and-design");
				g_ptr_array_add (_tmp22_, _tmp23_);
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("Music & Audio")))) {
		switch (0) {
			default:
			{
				GPtrArray* _tmp24_;
				gchar* _tmp25_;
				_tmp24_ = snap_categories;
				_tmp25_ = g_strdup ("music-and-audio");
				g_ptr_array_add (_tmp24_, _tmp25_);
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("Productivity")))) {
		switch (0) {
			default:
			{
				GPtrArray* _tmp26_;
				gchar* _tmp27_;
				GPtrArray* _tmp28_;
				gchar* _tmp29_;
				_tmp26_ = snap_categories;
				_tmp27_ = g_strdup ("productivity");
				g_ptr_array_add (_tmp26_, _tmp27_);
				_tmp28_ = snap_categories;
				_tmp29_ = g_strdup ("finance");
				g_ptr_array_add (_tmp28_, _tmp29_);
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label4) ? _tmp2_label4 : (_tmp2_label4 = g_quark_from_static_string ("Communication & News")))) {
		switch (0) {
			default:
			{
				GPtrArray* _tmp30_;
				gchar* _tmp31_;
				GPtrArray* _tmp32_;
				gchar* _tmp33_;
				GPtrArray* _tmp34_;
				gchar* _tmp35_;
				_tmp30_ = snap_categories;
				_tmp31_ = g_strdup ("social");
				g_ptr_array_add (_tmp30_, _tmp31_);
				_tmp32_ = snap_categories;
				_tmp33_ = g_strdup ("news-and-weather");
				g_ptr_array_add (_tmp32_, _tmp33_);
				_tmp34_ = snap_categories;
				_tmp35_ = g_strdup ("entertainment");
				g_ptr_array_add (_tmp34_, _tmp35_);
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label5) ? _tmp2_label5 : (_tmp2_label5 = g_quark_from_static_string ("Education & Science")))) {
		switch (0) {
			default:
			{
				GPtrArray* _tmp36_;
				gchar* _tmp37_;
				GPtrArray* _tmp38_;
				gchar* _tmp39_;
				_tmp36_ = snap_categories;
				_tmp37_ = g_strdup ("education");
				g_ptr_array_add (_tmp36_, _tmp37_);
				_tmp38_ = snap_categories;
				_tmp39_ = g_strdup ("science");
				g_ptr_array_add (_tmp38_, _tmp39_);
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label6) ? _tmp2_label6 : (_tmp2_label6 = g_quark_from_static_string ("Games")))) {
		switch (0) {
			default:
			{
				GPtrArray* _tmp40_;
				gchar* _tmp41_;
				_tmp40_ = snap_categories;
				_tmp41_ = g_strdup ("games");
				g_ptr_array_add (_tmp40_, _tmp41_);
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label7) ? _tmp2_label7 : (_tmp2_label7 = g_quark_from_static_string ("Utilities")))) {
		switch (0) {
			default:
			{
				GPtrArray* _tmp42_;
				gchar* _tmp43_;
				GPtrArray* _tmp44_;
				gchar* _tmp45_;
				GPtrArray* _tmp46_;
				gchar* _tmp47_;
				_tmp42_ = snap_categories;
				_tmp43_ = g_strdup ("utilities");
				g_ptr_array_add (_tmp42_, _tmp43_);
				_tmp44_ = snap_categories;
				_tmp45_ = g_strdup ("health-and-fitness");
				g_ptr_array_add (_tmp44_, _tmp45_);
				_tmp46_ = snap_categories;
				_tmp47_ = g_strdup ("personalisation");
				g_ptr_array_add (_tmp46_, _tmp47_);
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label8) ? _tmp2_label8 : (_tmp2_label8 = g_quark_from_static_string ("Development")))) {
		switch (0) {
			default:
			{
				GPtrArray* _tmp48_;
				gchar* _tmp49_;
				_tmp48_ = snap_categories;
				_tmp49_ = g_strdup ("development");
				g_ptr_array_add (_tmp48_, _tmp49_);
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				break;
			}
		}
	}
	_tmp50_ = snap_categories;
	_tmp51_ = vala_g_ptr_array_get_length (_tmp50_);
	_tmp52_ = _tmp51_;
	if (_tmp52_ > 0) {
		GPtrArray* _tmp53_;
		_tmp53_ = snap_categories;
		{
			GPtrArray* snap_category_collection = NULL;
			guint snap_category_index = 0U;
			snap_category_collection = _tmp53_;
			for (snap_category_index = 0; snap_category_index < snap_category_collection->len; snap_category_index = snap_category_index + 1) {
				const gchar* snap_category = NULL;
				snap_category = (const gchar*) g_ptr_array_index (snap_category_collection, snap_category_index);
				{
					{
						{
							GHashTable* _tmp54_;
							_tmp54_ = self->priv->category_snaps_cache;
							g_rec_mutex_lock (&self->priv->__lock_category_snaps_cache);
							{
								GPtrArray* found = NULL;
								GHashTable* _tmp55_;
								const gchar* _tmp56_;
								gconstpointer _tmp57_;
								GPtrArray* _tmp58_;
								GPtrArray* _tmp59_;
								GPtrArray* _tmp70_;
								_tmp55_ = self->priv->category_snaps_cache;
								_tmp56_ = snap_category;
								_tmp57_ = g_hash_table_lookup (_tmp55_, _tmp56_);
								_tmp58_ = _g_ptr_array_ref0 ((GPtrArray*) _tmp57_);
								found = _tmp58_;
								_tmp59_ = found;
								if (_tmp59_ == NULL) {
									GPtrArray* _tmp60_ = NULL;
									SnapdClient* _tmp61_;
									const gchar* _tmp62_;
									GPtrArray* _tmp63_;
									GPtrArray* _tmp64_;
									GHashTable* _tmp65_;
									const gchar* _tmp66_;
									gchar* _tmp67_;
									GPtrArray* _tmp68_;
									GPtrArray* _tmp69_;
									_tmp61_ = self->priv->client;
									_tmp62_ = snap_category;
									_tmp63_ = snapd_client_find_section_sync (_tmp61_, SNAPD_FIND_FLAGS_NONE, _tmp62_, NULL, NULL, NULL, &_inner_error0_);
									_tmp60_ = _tmp63_;
									if (G_UNLIKELY (_inner_error0_ != NULL)) {
										_g_ptr_array_unref0 (found);
										goto __catch1_g_error;
									}
									_tmp64_ = _tmp60_;
									_tmp60_ = NULL;
									_g_ptr_array_unref0 (found);
									found = _tmp64_;
									_tmp65_ = self->priv->category_snaps_cache;
									_tmp66_ = snap_category;
									_tmp67_ = g_strdup (_tmp66_);
									_tmp68_ = found;
									_tmp69_ = _g_ptr_array_ref0 (_tmp68_);
									g_hash_table_insert (_tmp65_, _tmp67_, _tmp69_);
									_g_ptr_array_unref0 (_tmp60_);
								}
								_tmp70_ = found;
								{
									GPtrArray* snap_collection = NULL;
									guint snap_index = 0U;
									snap_collection = _tmp70_;
									for (snap_index = 0; snap_index < snap_collection->len; snap_index = snap_index + 1) {
										SnapdSnap* snap = NULL;
										snap = (SnapdSnap*) g_ptr_array_index (snap_collection, snap_index);
										{
											SnapdSnap* _tmp71_;
											SnapdSnapType _tmp72_;
											SnapdSnapType _tmp73_;
											_tmp71_ = snap;
											_tmp72_ = snapd_snap_get_snap_type (_tmp71_);
											_tmp73_ = _tmp72_;
											if (_tmp73_ == SNAPD_SNAP_TYPE_APP) {
												SnapdSnap* _tmp74_;
												PamacSnapPackage* _tmp75_;
												_tmp74_ = snap;
												_tmp75_ = pamac_snap_initialize_snap (self, _tmp74_);
												g_ptr_array_add (*pkgs, _tmp75_);
											}
										}
									}
								}
								_g_ptr_array_unref0 (found);
							}
							goto __finally1;
							__catch1_g_error:
							{
								GError* _lock_error_ = NULL;
								GError* _tmp76_;
								_lock_error_ = _inner_error0_;
								_inner_error0_ = NULL;
								_tmp76_ = _lock_error_;
								_lock_error_ = NULL;
								_inner_error0_ = _tmp76_;
								_g_error_free0 (_lock_error_);
								goto __finally1;
							}
							__finally1:
							{
								GError* _inner_error1_ = NULL;
								GHashTable* _tmp77_;
								_tmp77_ = self->priv->category_snaps_cache;
								g_rec_mutex_unlock (&self->priv->__lock_category_snaps_cache);
							}
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
								goto __catch0_g_error;
							}
						}
					}
					goto __finally0;
					__catch0_g_error:
					{
						GError* e = NULL;
						GError* _tmp78_;
						const gchar* _tmp79_;
						e = _inner_error0_;
						_inner_error0_ = NULL;
						_tmp78_ = e;
						_tmp79_ = _tmp78_->message;
						g_warning ("snap_plugin.vala:480: %s", _tmp79_);
						_g_error_free0 (e);
					}
					__finally0:
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_ptr_array_unref0 (snap_categories);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
				}
			}
		}
	}
	_g_ptr_array_unref0 (snap_categories);
}

static void
pamac_snap_do_start_downloading (PamacSnap* self)
{
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->sender;
	g_signal_emit_by_name ((PamacSnapPlugin*) self, "start-downloading", _tmp0_);
}

static void
pamac_snap_do_stop_downloading (PamacSnap* self)
{
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->sender;
	g_signal_emit_by_name ((PamacSnapPlugin*) self, "stop-downloading", _tmp0_);
}

static void
pamac_snap_do_emit_action_progress (PamacSnap* self,
                                    const gchar* action,
                                    const gchar* status,
                                    gdouble progress)
{
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	g_return_if_fail (status != NULL);
	_tmp0_ = self->priv->sender;
	g_signal_emit_by_name ((PamacSnapPlugin*) self, "emit-action-progress", _tmp0_, action, status, progress);
}

static void
pamac_snap_do_emit_download_progress (PamacSnap* self,
                                      const gchar* action,
                                      const gchar* status,
                                      gdouble progress)
{
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	g_return_if_fail (status != NULL);
	_tmp0_ = self->priv->sender;
	g_signal_emit_by_name ((PamacSnapPlugin*) self, "emit-download-progress", _tmp0_, action, status, progress);
}

static void
pamac_snap_do_emit_script_output (PamacSnap* self,
                                  const gchar* message)
{
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	_tmp0_ = self->priv->sender;
	g_signal_emit_by_name ((PamacSnapPlugin*) self, "emit-script-output", _tmp0_, message);
}

static void
pamac_snap_do_emit_error (PamacSnap* self,
                          const gchar* message,
                          gchar** details,
                          gint details_length1)
{
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	_tmp0_ = self->priv->sender;
	g_signal_emit_by_name ((PamacSnapPlugin*) self, "emit-error", _tmp0_, message, details, (gint) details_length1);
}

static gboolean
pamac_snap_real_trans_run (PamacSnapPlugin* base,
                           const gchar* sender,
                           gchar** to_install,
                           gint to_install_length1,
                           gchar** to_remove,
                           gint to_remove_length1)
{
	PamacSnap * self;
	gchar* _tmp0_;
	GCancellable* _tmp1_;
	gboolean success = FALSE;
	gboolean result;
	self = (PamacSnap*) base;
	g_return_val_if_fail (sender != NULL, FALSE);
	_tmp0_ = g_strdup (sender);
	_g_free0 (self->priv->sender);
	self->priv->sender = _tmp0_;
	_tmp1_ = self->priv->cancellable;
	g_cancellable_reset (_tmp1_);
	success = TRUE;
	{
		gchar** name_collection = NULL;
		gint name_collection_length1 = 0;
		gint _name_collection_size_ = 0;
		gint name_it = 0;
		name_collection = to_remove;
		name_collection_length1 = to_remove_length1;
		for (name_it = 0; name_it < name_collection_length1; name_it = name_it + 1) {
			const gchar* name = NULL;
			name = name_collection[name_it];
			{
				const gchar* _tmp2_;
				GCancellable* _tmp3_;
				_tmp2_ = name;
				success = pamac_snap_remove (self, _tmp2_);
				_tmp3_ = self->priv->cancellable;
				if (g_cancellable_is_cancelled (_tmp3_)) {
					success = FALSE;
				}
				if (!success) {
					break;
				}
			}
		}
	}
	if (!success) {
		result = FALSE;
		return result;
	}
	{
		gchar** name_collection = NULL;
		gint name_collection_length1 = 0;
		gint _name_collection_size_ = 0;
		gint name_it = 0;
		name_collection = to_install;
		name_collection_length1 = to_install_length1;
		for (name_it = 0; name_it < name_collection_length1; name_it = name_it + 1) {
			const gchar* name = NULL;
			name = name_collection[name_it];
			{
				const gchar* _tmp4_;
				GCancellable* _tmp5_;
				_tmp4_ = name;
				success = pamac_snap_install (self, _tmp4_, NULL);
				_tmp5_ = self->priv->cancellable;
				if (g_cancellable_is_cancelled (_tmp5_)) {
					success = FALSE;
				}
				if (!success) {
					break;
				}
			}
		}
	}
	result = success;
	return result;
}

static void
pamac_snap_real_refresh (PamacSnapPlugin* base)
{
	PamacSnap * self;
	GError* _inner_error0_ = NULL;
	self = (PamacSnap*) base;
	{
		GHashTable* _tmp0_;
		_tmp0_ = self->priv->store_snaps_cache;
		g_rec_mutex_lock (&self->priv->__lock_store_snaps_cache);
		{
			GHashTable* _tmp1_;
			_tmp1_ = self->priv->store_snaps_cache;
			g_hash_table_remove_all (_tmp1_);
		}
		__finally0:
		{
			GHashTable* _tmp2_;
			_tmp2_ = self->priv->store_snaps_cache;
			g_rec_mutex_unlock (&self->priv->__lock_store_snaps_cache);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	{
		GHashTable* _tmp3_;
		_tmp3_ = self->priv->search_snaps_cache;
		g_rec_mutex_lock (&self->priv->__lock_search_snaps_cache);
		{
			GHashTable* _tmp4_;
			_tmp4_ = self->priv->search_snaps_cache;
			g_hash_table_remove_all (_tmp4_);
		}
		__finally1:
		{
			GHashTable* _tmp5_;
			_tmp5_ = self->priv->search_snaps_cache;
			g_rec_mutex_unlock (&self->priv->__lock_search_snaps_cache);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	{
		GHashTable* _tmp6_;
		_tmp6_ = self->priv->category_snaps_cache;
		g_rec_mutex_lock (&self->priv->__lock_category_snaps_cache);
		{
			GHashTable* _tmp7_;
			_tmp7_ = self->priv->category_snaps_cache;
			g_hash_table_remove_all (_tmp7_);
		}
		__finally2:
		{
			GHashTable* _tmp8_;
			_tmp8_ = self->priv->category_snaps_cache;
			g_rec_mutex_unlock (&self->priv->__lock_category_snaps_cache);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	{
		GHashTable* _tmp9_;
		_tmp9_ = self->priv->pkgs_cache;
		g_rec_mutex_lock (&self->priv->__lock_pkgs_cache);
		{
			GHashTable* _tmp10_;
			_tmp10_ = self->priv->pkgs_cache;
			g_hash_table_remove_all (_tmp10_);
		}
		__finally3:
		{
			GHashTable* _tmp11_;
			_tmp11_ = self->priv->pkgs_cache;
			g_rec_mutex_unlock (&self->priv->__lock_pkgs_cache);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static void
pamac_snap_real_trans_cancel (PamacSnapPlugin* base,
                              const gchar* sender)
{
	PamacSnap * self;
	const gchar* _tmp0_;
	self = (PamacSnap*) base;
	g_return_if_fail (sender != NULL);
	_tmp0_ = self->priv->sender;
	if (g_strcmp0 (sender, _tmp0_) == 0) {
		GCancellable* _tmp1_;
		_tmp1_ = self->priv->cancellable;
		g_cancellable_cancel (_tmp1_);
	}
}

static void
_pamac_snap_progress_callback_snapd_progress_callback (SnapdClient* client,
                                                       SnapdChange* change,
                                                       void* deprecated,
                                                       gpointer self)
{
	pamac_snap_progress_callback ((PamacSnap*) self, client, change, deprecated);
}

static gboolean
pamac_snap_install (PamacSnap* self,
                    const gchar* name,
                    const gchar* channel)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	{
		gchar* _tmp0_;
		SnapdClient* _tmp1_;
		GCancellable* _tmp2_;
		_tmp0_ = g_strdup_printf (g_dgettext (NULL, "Installing %s"), name);
		_g_free0 (self->priv->main_action);
		self->priv->main_action = _tmp0_;
		self->priv->init_download = TRUE;
		_tmp1_ = self->priv->client;
		_tmp2_ = self->priv->cancellable;
		snapd_client_install2_sync (_tmp1_, SNAPD_INSTALL_FLAGS_NONE, name, channel, NULL, _pamac_snap_progress_callback_snapd_progress_callback, self, _tmp2_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		result = TRUE;
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		if (g_error_matches (_tmp3_, SNAPD_ERROR, SNAPD_ERROR_NEEDS_CLASSIC)) {
			{
				SnapdClient* _tmp4_;
				GCancellable* _tmp5_;
				_tmp4_ = self->priv->client;
				_tmp5_ = self->priv->cancellable;
				snapd_client_install2_sync (_tmp4_, SNAPD_INSTALL_FLAGS_CLASSIC, name, channel, NULL, _pamac_snap_progress_callback_snapd_progress_callback, self, _tmp5_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch1_g_error;
				}
				result = TRUE;
				_g_error_free0 (e);
				return result;
			}
			goto __finally1;
			__catch1_g_error:
			{
				GError* e = NULL;
				GCancellable* _tmp6_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp6_ = self->priv->cancellable;
				if (!g_cancellable_is_cancelled (_tmp6_)) {
					GError* _tmp7_;
					const gchar* _tmp8_;
					gchar* _tmp9_;
					gchar** _tmp10_;
					gchar** _tmp11_;
					gint _tmp11__length1;
					_tmp7_ = e;
					_tmp8_ = _tmp7_->message;
					_tmp9_ = g_strdup (_tmp8_);
					_tmp10_ = g_new0 (gchar*, 1 + 1);
					_tmp10_[0] = _tmp9_;
					_tmp11_ = _tmp10_;
					_tmp11__length1 = 1;
					pamac_snap_do_emit_error (self, "Snap install error", _tmp11_, (gint) 1);
					_tmp11_ = (_vala_array_free (_tmp11_, _tmp11__length1, (GDestroyNotify) g_free), NULL);
				}
				_g_error_free0 (e);
			}
			__finally1:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				gboolean _tmp12_ = FALSE;
				_g_error_free0 (e);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp12_;
			}
		} else {
			GCancellable* _tmp13_;
			_tmp13_ = self->priv->cancellable;
			if (!g_cancellable_is_cancelled (_tmp13_)) {
				GError* _tmp14_;
				const gchar* _tmp15_;
				gchar* _tmp16_;
				gchar** _tmp17_;
				gchar** _tmp18_;
				gint _tmp18__length1;
				_tmp14_ = e;
				_tmp15_ = _tmp14_->message;
				_tmp16_ = g_strdup (_tmp15_);
				_tmp17_ = g_new0 (gchar*, 1 + 1);
				_tmp17_[0] = _tmp16_;
				_tmp18_ = _tmp17_;
				_tmp18__length1 = 1;
				pamac_snap_do_emit_error (self, "Snap install error", _tmp18_, (gint) 1);
				_tmp18_ = (_vala_array_free (_tmp18_, _tmp18__length1, (GDestroyNotify) g_free), NULL);
			}
		}
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp19_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp19_;
	}
	result = FALSE;
	return result;
}

static gboolean
pamac_snap_real_switch_channel (PamacSnapPlugin* base,
                                const gchar* sender,
                                const gchar* name,
                                const gchar* channel)
{
	PamacSnap * self;
	gchar* _tmp0_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = (PamacSnap*) base;
	g_return_val_if_fail (sender != NULL, FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	g_return_val_if_fail (channel != NULL, FALSE);
	_tmp0_ = g_strdup (sender);
	_g_free0 (self->priv->sender);
	self->priv->sender = _tmp0_;
	{
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		SnapdClient* _tmp4_;
		GCancellable* _tmp5_;
		_tmp1_ = g_strdup_printf ("%s (%s)", name, channel);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_strdup_printf (g_dgettext (NULL, "Installing %s"), _tmp2_);
		_g_free0 (self->priv->main_action);
		self->priv->main_action = _tmp3_;
		_g_free0 (_tmp2_);
		self->priv->init_download = TRUE;
		_tmp4_ = self->priv->client;
		_tmp5_ = self->priv->cancellable;
		snapd_client_refresh_sync (_tmp4_, name, channel, _pamac_snap_progress_callback_snapd_progress_callback, self, _tmp5_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		result = TRUE;
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GCancellable* _tmp6_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = self->priv->cancellable;
		if (!g_cancellable_is_cancelled (_tmp6_)) {
			GError* _tmp7_;
			const gchar* _tmp8_;
			gchar* _tmp9_;
			gchar** _tmp10_;
			gchar** _tmp11_;
			gint _tmp11__length1;
			_tmp7_ = e;
			_tmp8_ = _tmp7_->message;
			_tmp9_ = g_strdup (_tmp8_);
			_tmp10_ = g_new0 (gchar*, 1 + 1);
			_tmp10_[0] = _tmp9_;
			_tmp11_ = _tmp10_;
			_tmp11__length1 = 1;
			pamac_snap_do_emit_error (self, "Snap switch error", _tmp11_, (gint) 1);
			_tmp11_ = (_vala_array_free (_tmp11_, _tmp11__length1, (GDestroyNotify) g_free), NULL);
		}
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp12_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp12_;
	}
	result = FALSE;
	return result;
}

static gboolean
pamac_snap_remove (PamacSnap* self,
                   const gchar* name)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	{
		gchar* _tmp0_;
		SnapdClient* _tmp1_;
		GCancellable* _tmp2_;
		_tmp0_ = g_strdup_printf (g_dgettext (NULL, "Removing %s"), name);
		_g_free0 (self->priv->main_action);
		self->priv->main_action = _tmp0_;
		_tmp1_ = self->priv->client;
		_tmp2_ = self->priv->cancellable;
		snapd_client_remove2_sync (_tmp1_, SNAPD_REMOVE_FLAGS_NONE, name, _pamac_snap_progress_callback_snapd_progress_callback, self, _tmp2_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		result = TRUE;
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GCancellable* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = self->priv->cancellable;
		if (!g_cancellable_is_cancelled (_tmp3_)) {
			GError* _tmp4_;
			const gchar* _tmp5_;
			gchar* _tmp6_;
			gchar** _tmp7_;
			gchar** _tmp8_;
			gint _tmp8__length1;
			_tmp4_ = e;
			_tmp5_ = _tmp4_->message;
			_tmp6_ = g_strdup (_tmp5_);
			_tmp7_ = g_new0 (gchar*, 1 + 1);
			_tmp7_[0] = _tmp6_;
			_tmp8_ = _tmp7_;
			_tmp8__length1 = 1;
			pamac_snap_do_emit_error (self, "Snap remove error", _tmp8_, (gint) 1);
			_tmp8_ = (_vala_array_free (_tmp8_, _tmp8__length1, (GDestroyNotify) g_free), NULL);
		}
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp9_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp9_;
	}
	result = FALSE;
	return result;
}

static void
pamac_snap_emit_download (PamacSnap* self,
                          guint64 xfered,
                          guint64 total)
{
	GString* text = NULL;
	GString* _tmp0_;
	gdouble fraction = 0.0;
	GString* _tmp25_;
	const gchar* _tmp26_;
	const gchar* _tmp27_;
	const gchar* _tmp31_;
	const gchar* _tmp32_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_string_new ("");
	text = _tmp0_;
	if (self->priv->init_download) {
		GTimer* _tmp1_;
		pamac_snap_do_start_downloading (self);
		self->priv->init_download = FALSE;
		self->priv->download_rate = (guint64) 0;
		self->priv->rates_nb = (guint64) 0;
		self->priv->current_progress = (gdouble) 0;
		self->priv->previous_xfered = (guint64) 0;
		fraction = (gdouble) 0;
		_tmp1_ = self->priv->timer;
		g_timer_start (_tmp1_);
	} else {
		GTimer* _tmp2_;
		GTimer* _tmp24_;
		_tmp2_ = self->priv->timer;
		if (g_timer_elapsed (_tmp2_, NULL) > 0.1) {
			GTimer* _tmp3_;
			guint64 _tmp4_;
			_tmp3_ = self->priv->timer;
			self->priv->download_rate = ((self->priv->download_rate * self->priv->rates_nb) + ((guint64) ((xfered - self->priv->previous_xfered) / g_timer_elapsed (_tmp3_, NULL)))) / (self->priv->rates_nb + 1);
			_tmp4_ = self->priv->rates_nb;
			self->priv->rates_nb = _tmp4_ + 1;
		} else {
			_g_string_free0 (text);
			return;
		}
		self->priv->previous_xfered = xfered;
		fraction = ((gdouble) xfered) / total;
		if (fraction <= ((gdouble) 1)) {
			GString* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			guint remaining_seconds = 0U;
			gboolean _tmp12_ = FALSE;
			_tmp5_ = text;
			_tmp6_ = g_format_size_full (xfered, G_FORMAT_SIZE_DEFAULT);
			_tmp7_ = _tmp6_;
			_tmp8_ = g_format_size_full (total, G_FORMAT_SIZE_DEFAULT);
			_tmp9_ = _tmp8_;
			_tmp10_ = g_strdup_printf ("%s/%s  ", _tmp7_, _tmp9_);
			_tmp11_ = _tmp10_;
			g_string_append (_tmp5_, _tmp11_);
			_g_free0 (_tmp11_);
			_g_free0 (_tmp9_);
			_g_free0 (_tmp7_);
			remaining_seconds = (guint) 0;
			if (self->priv->download_rate > ((guint64) 0)) {
				remaining_seconds = (guint) roundf (((gfloat) (total - xfered)) / self->priv->download_rate);
			}
			if (remaining_seconds > ((guint) 0)) {
				_tmp12_ = self->priv->rates_nb > ((guint64) 19);
			} else {
				_tmp12_ = FALSE;
			}
			if (_tmp12_) {
				if (remaining_seconds < ((guint) 60)) {
					GString* _tmp13_;
					gchar* _tmp14_;
					gchar* _tmp15_;
					_tmp13_ = text;
					_tmp14_ = g_strdup_printf (g_dngettext (NULL, "About %lu second remaining", "About %lu seconds remaining", (gulong) remaining_seconds), (gulong) remaining_seconds);
					_tmp15_ = _tmp14_;
					g_string_append (_tmp13_, _tmp15_);
					_g_free0 (_tmp15_);
				} else {
					guint remaining_minutes = 0U;
					GString* _tmp16_;
					gchar* _tmp17_;
					gchar* _tmp18_;
					remaining_minutes = (guint) roundf (((gfloat) remaining_seconds) / 60);
					_tmp16_ = text;
					_tmp17_ = g_strdup_printf (g_dngettext (NULL, "About %lu minute remaining", "About %lu minutes remaining", (gulong) remaining_minutes), (gulong) remaining_minutes);
					_tmp18_ = _tmp17_;
					g_string_append (_tmp16_, _tmp18_);
					_g_free0 (_tmp18_);
				}
			}
		} else {
			GString* _tmp19_;
			gchar* _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			_tmp19_ = text;
			_tmp20_ = g_format_size_full (xfered, G_FORMAT_SIZE_DEFAULT);
			_tmp21_ = _tmp20_;
			_tmp22_ = g_strdup_printf ("%s", _tmp21_);
			_tmp23_ = _tmp22_;
			g_string_append (_tmp19_, _tmp23_);
			_g_free0 (_tmp23_);
			_g_free0 (_tmp21_);
		}
		_tmp24_ = self->priv->timer;
		g_timer_start (_tmp24_);
	}
	if (fraction != self->priv->current_progress) {
		self->priv->current_progress = fraction;
	}
	_tmp25_ = text;
	_tmp26_ = _tmp25_->str;
	_tmp27_ = self->priv->current_status;
	if (g_strcmp0 (_tmp26_, _tmp27_) != 0) {
		GString* _tmp28_;
		const gchar* _tmp29_;
		gchar* _tmp30_;
		_tmp28_ = text;
		_tmp29_ = _tmp28_->str;
		_tmp30_ = g_strdup (_tmp29_);
		_g_free0 (self->priv->current_status);
		self->priv->current_status = _tmp30_;
	}
	_tmp31_ = self->priv->current_action;
	_tmp32_ = self->priv->current_status;
	pamac_snap_do_emit_download_progress (self, _tmp31_, _tmp32_, self->priv->current_progress);
	_g_string_free0 (text);
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static void
pamac_snap_progress_callback (PamacSnap* self,
                              SnapdClient* client,
                              SnapdChange* change,
                              void* deprecated)
{
	guint total = 0U;
	guint done = 0U;
	guint64 download_progress = 0ULL;
	GPtrArray* tasks = NULL;
	GPtrArray* _tmp0_;
	GPtrArray* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (client != NULL);
	g_return_if_fail (change != NULL);
	total = (guint) 0;
	done = (guint) 0;
	download_progress = (guint64) 0;
	_tmp0_ = snapd_change_get_tasks (change);
	tasks = _tmp0_;
	_tmp1_ = tasks;
	{
		GPtrArray* task_collection = NULL;
		guint task_index = 0U;
		task_collection = _tmp1_;
		for (task_index = 0; task_index < task_collection->len; task_index = task_index + 1) {
			SnapdTask* task = NULL;
			task = (SnapdTask*) g_ptr_array_index (task_collection, task_index);
			{
				SnapdTask* _tmp2_;
				const gchar* _tmp3_;
				const gchar* _tmp4_;
				_tmp2_ = task;
				_tmp3_ = snapd_task_get_summary (_tmp2_);
				_tmp4_ = _tmp3_;
				if (string_contains (_tmp4_, "Download")) {
					SnapdTask* _tmp5_;
					const gchar* _tmp6_;
					const gchar* _tmp7_;
					_tmp5_ = task;
					_tmp6_ = snapd_task_get_status (_tmp5_);
					_tmp7_ = _tmp6_;
					if (g_strcmp0 (_tmp7_, "Doing") == 0) {
						SnapdTask* _tmp8_;
						gint64 _tmp9_;
						gint64 _tmp10_;
						_tmp8_ = task;
						_tmp9_ = snapd_task_get_progress_total (_tmp8_);
						_tmp10_ = _tmp9_;
						if (_tmp10_ > ((gint64) 1)) {
							gchar* pkgname = NULL;
							SnapdTask* _tmp11_;
							const gchar* _tmp12_;
							const gchar* _tmp13_;
							gchar** _tmp14_;
							gchar** _tmp15_;
							gchar** _tmp16_;
							gint _tmp16__length1;
							const gchar* _tmp17_;
							gchar* _tmp18_;
							gchar* _tmp19_;
							GHashTable* _tmp20_;
							const gchar* _tmp21_;
							SnapdTask* _tmp29_;
							gint64 _tmp30_;
							gint64 _tmp31_;
							_tmp11_ = task;
							_tmp12_ = snapd_task_get_summary (_tmp11_);
							_tmp13_ = _tmp12_;
							_tmp15_ = _tmp14_ = g_strsplit (_tmp13_, "\"", 3);
							_tmp16_ = _tmp15_;
							_tmp16__length1 = _vala_array_length (_tmp14_);
							_tmp17_ = _tmp16_[1];
							_tmp18_ = g_strdup (_tmp17_);
							_tmp19_ = _tmp18_;
							_tmp16_ = (_vala_array_free (_tmp16_, _tmp16__length1, (GDestroyNotify) g_free), NULL);
							pkgname = _tmp19_;
							_tmp20_ = self->priv->download_files;
							_tmp21_ = pkgname;
							if (!g_hash_table_contains (_tmp20_, _tmp21_)) {
								const gchar* _tmp22_;
								gchar* _tmp23_;
								GHashTable* _tmp24_;
								gchar* _tmp25_;
								SnapdTask* _tmp26_;
								gint64 _tmp27_;
								gint64 _tmp28_;
								_tmp22_ = pkgname;
								_tmp23_ = g_strdup_printf (g_dgettext (NULL, "Download of %s started"), _tmp22_);
								_g_free0 (self->priv->current_action);
								self->priv->current_action = _tmp23_;
								_tmp24_ = self->priv->download_files;
								_tmp25_ = pkgname;
								pkgname = NULL;
								g_hash_table_add (_tmp24_, _tmp25_);
								_tmp26_ = task;
								_tmp27_ = snapd_task_get_progress_total (_tmp26_);
								_tmp28_ = _tmp27_;
								self->priv->download_total = self->priv->download_total + _tmp28_;
							}
							self->priv->downloading = TRUE;
							_tmp29_ = task;
							_tmp30_ = snapd_task_get_progress_done (_tmp29_);
							_tmp31_ = _tmp30_;
							download_progress += (guint64) _tmp31_;
							pamac_snap_emit_download (self, download_progress, self->priv->download_total);
							_g_free0 (pkgname);
						}
					} else {
						SnapdTask* _tmp32_;
						const gchar* _tmp33_;
						const gchar* _tmp34_;
						_tmp32_ = task;
						_tmp33_ = snapd_task_get_status (_tmp32_);
						_tmp34_ = _tmp33_;
						if (g_strcmp0 (_tmp34_, "Done") == 0) {
							gchar* pkgname = NULL;
							SnapdTask* _tmp35_;
							const gchar* _tmp36_;
							const gchar* _tmp37_;
							gchar** _tmp38_;
							gchar** _tmp39_;
							gchar** _tmp40_;
							gint _tmp40__length1;
							const gchar* _tmp41_;
							gchar* _tmp42_;
							gchar* _tmp43_;
							GHashTable* _tmp44_;
							const gchar* _tmp45_;
							_tmp35_ = task;
							_tmp36_ = snapd_task_get_summary (_tmp35_);
							_tmp37_ = _tmp36_;
							_tmp39_ = _tmp38_ = g_strsplit (_tmp37_, "\"", 3);
							_tmp40_ = _tmp39_;
							_tmp40__length1 = _vala_array_length (_tmp38_);
							_tmp41_ = _tmp40_[1];
							_tmp42_ = g_strdup (_tmp41_);
							_tmp43_ = _tmp42_;
							_tmp40_ = (_vala_array_free (_tmp40_, _tmp40__length1, (GDestroyNotify) g_free), NULL);
							pkgname = _tmp43_;
							_tmp44_ = self->priv->download_files;
							_tmp45_ = pkgname;
							if (g_hash_table_contains (_tmp44_, _tmp45_)) {
								const gchar* _tmp46_;
								gchar* _tmp47_;
								GHashTable* _tmp48_;
								const gchar* _tmp49_;
								SnapdTask* _tmp50_;
								gint64 _tmp51_;
								gint64 _tmp52_;
								_tmp46_ = pkgname;
								_tmp47_ = g_strdup_printf (g_dgettext (NULL, "Download of %s finished"), _tmp46_);
								_g_free0 (self->priv->current_action);
								self->priv->current_action = _tmp47_;
								_tmp48_ = self->priv->download_files;
								_tmp49_ = pkgname;
								g_hash_table_remove (_tmp48_, _tmp49_);
								_tmp50_ = task;
								_tmp51_ = snapd_task_get_progress_done (_tmp50_);
								_tmp52_ = _tmp51_;
								download_progress += (guint64) _tmp52_;
								pamac_snap_emit_download (self, download_progress, self->priv->download_total);
							}
							_g_free0 (pkgname);
						}
					}
				} else {
					SnapdTask* _tmp53_;
					const gchar* _tmp54_;
					const gchar* _tmp55_;
					_tmp53_ = task;
					_tmp54_ = snapd_task_get_status (_tmp53_);
					_tmp55_ = _tmp54_;
					if (g_strcmp0 (_tmp55_, "Done") == 0) {
						done += (guint) 1;
					} else {
						gboolean _tmp56_ = FALSE;
						SnapdTask* _tmp57_;
						const gchar* _tmp58_;
						const gchar* _tmp59_;
						_tmp57_ = task;
						_tmp58_ = snapd_task_get_status (_tmp57_);
						_tmp59_ = _tmp58_;
						if (g_strcmp0 (_tmp59_, "Doing") == 0) {
							SnapdTask* _tmp60_;
							const gchar* _tmp61_;
							const gchar* _tmp62_;
							const gchar* _tmp63_;
							_tmp60_ = task;
							_tmp61_ = snapd_task_get_summary (_tmp60_);
							_tmp62_ = _tmp61_;
							_tmp63_ = self->priv->current_details;
							_tmp56_ = g_strcmp0 (_tmp62_, _tmp63_) != 0;
						} else {
							_tmp56_ = FALSE;
						}
						if (_tmp56_) {
							SnapdTask* _tmp64_;
							const gchar* _tmp65_;
							const gchar* _tmp66_;
							gchar* _tmp67_;
							const gchar* _tmp68_;
							_tmp64_ = task;
							_tmp65_ = snapd_task_get_summary (_tmp64_);
							_tmp66_ = _tmp65_;
							_tmp67_ = g_strdup (_tmp66_);
							_g_free0 (self->priv->current_details);
							self->priv->current_details = _tmp67_;
							_tmp68_ = self->priv->current_details;
							pamac_snap_do_emit_script_output (self, _tmp68_);
						}
					}
				}
				total += (guint) 1;
			}
		}
	}
	if (self->priv->downloading) {
		GHashTable* _tmp69_;
		guint _tmp70_;
		guint _tmp71_;
		_tmp69_ = self->priv->download_files;
		_tmp70_ = g_hash_table_size (_tmp69_);
		_tmp71_ = _tmp70_;
		if (_tmp71_ == ((guint) 0)) {
			self->priv->downloading = FALSE;
			self->priv->download_total = (guint64) 0;
			pamac_snap_do_stop_downloading (self);
		}
	} else {
		const gchar* _tmp72_;
		_tmp72_ = self->priv->main_action;
		pamac_snap_do_emit_action_progress (self, _tmp72_, "", ((gdouble) done) / total);
	}
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static void
_g_ptr_array_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL));
}

static GObject *
pamac_snap_constructor (GType type,
                        guint n_construct_properties,
                        GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	PamacSnap * self;
	SnapdClient* _tmp0_;
	GHashFunc _tmp1_;
	GEqualFunc _tmp2_;
	GHashTable* _tmp3_;
	GHashFunc _tmp4_;
	GEqualFunc _tmp5_;
	GHashTable* _tmp6_;
	GHashFunc _tmp7_;
	GEqualFunc _tmp8_;
	GHashTable* _tmp9_;
	GHashFunc _tmp10_;
	GEqualFunc _tmp11_;
	GHashTable* _tmp12_;
	GCancellable* _tmp13_;
	GTimer* _tmp14_;
	GHashFunc _tmp15_;
	GEqualFunc _tmp16_;
	GHashTable* _tmp17_;
	parent_class = G_OBJECT_CLASS (pamac_snap_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PAMAC_TYPE_SNAP, PamacSnap);
	_tmp0_ = snapd_client_new ();
	_g_object_unref0 (self->priv->client);
	self->priv->client = _tmp0_;
	_tmp1_ = g_str_hash;
	_tmp2_ = g_str_equal;
	_tmp3_ = g_hash_table_new_full (_tmp1_, _tmp2_, _g_free0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->store_snaps_cache);
	self->priv->store_snaps_cache = _tmp3_;
	_tmp4_ = g_str_hash;
	_tmp5_ = g_str_equal;
	_tmp6_ = g_hash_table_new_full (_tmp4_, _tmp5_, _g_free0_, _g_ptr_array_unref0_);
	_g_hash_table_unref0 (self->priv->search_snaps_cache);
	self->priv->search_snaps_cache = _tmp6_;
	_tmp7_ = g_str_hash;
	_tmp8_ = g_str_equal;
	_tmp9_ = g_hash_table_new_full (_tmp7_, _tmp8_, _g_free0_, _g_ptr_array_unref0_);
	_g_hash_table_unref0 (self->priv->category_snaps_cache);
	self->priv->category_snaps_cache = _tmp9_;
	_tmp10_ = g_str_hash;
	_tmp11_ = g_str_equal;
	_tmp12_ = g_hash_table_new_full (_tmp10_, _tmp11_, NULL, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->pkgs_cache);
	self->priv->pkgs_cache = _tmp12_;
	_tmp13_ = g_cancellable_new ();
	_g_object_unref0 (self->priv->cancellable);
	self->priv->cancellable = _tmp13_;
	_tmp14_ = g_timer_new ();
	_g_timer_destroy0 (self->priv->timer);
	self->priv->timer = _tmp14_;
	self->priv->downloading = FALSE;
	_tmp15_ = g_str_hash;
	_tmp16_ = g_str_equal;
	_tmp17_ = g_hash_table_new_full (_tmp15_, _tmp16_, NULL, _g_free0_);
	_g_hash_table_unref0 (self->priv->download_files);
	self->priv->download_files = _tmp17_;
	return obj;
}

static void
pamac_snap_class_init (PamacSnapClass * klass,
                       gpointer klass_data)
{
	pamac_snap_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PamacSnap_private_offset);
	G_OBJECT_CLASS (klass)->constructor = pamac_snap_constructor;
	G_OBJECT_CLASS (klass)->finalize = pamac_snap_finalize;
}

static void
pamac_snap_pamac_snap_plugin_interface_init (PamacSnapPluginIface * iface,
                                             gpointer iface_data)
{
	pamac_snap_pamac_snap_plugin_parent_iface = g_type_interface_peek_parent (iface);
	iface->search_snaps = (void (*) (PamacSnapPlugin*, const gchar*, GPtrArray**)) pamac_snap_real_search_snaps;
	iface->search_uninstalled_snaps_sync = (void (*) (PamacSnapPlugin*, const gchar*, GPtrArray**)) pamac_snap_real_search_uninstalled_snaps_sync;
	iface->is_installed_snap = (gboolean (*) (PamacSnapPlugin*, const gchar*)) pamac_snap_real_is_installed_snap;
	iface->get_snap = (PamacSnapPackage* (*) (PamacSnapPlugin*, const gchar*)) pamac_snap_real_get_snap;
	iface->get_snap_by_app_id = (PamacSnapPackage* (*) (PamacSnapPlugin*, const gchar*)) pamac_snap_real_get_snap_by_app_id;
	iface->get_installed_snaps = (void (*) (PamacSnapPlugin*, GPtrArray**)) pamac_snap_real_get_installed_snaps;
	iface->get_installed_snap_icon = (gchar* (*) (PamacSnapPlugin*, const gchar*, GError**)) pamac_snap_real_get_installed_snap_icon;
	iface->get_category_snaps = (void (*) (PamacSnapPlugin*, const gchar*, GPtrArray**)) pamac_snap_real_get_category_snaps;
	iface->trans_run = (gboolean (*) (PamacSnapPlugin*, const gchar*, gchar**, gint, gchar**, gint)) pamac_snap_real_trans_run;
	iface->refresh = (void (*) (PamacSnapPlugin*)) pamac_snap_real_refresh;
	iface->trans_cancel = (void (*) (PamacSnapPlugin*, const gchar*)) pamac_snap_real_trans_cancel;
	iface->switch_channel = (gboolean (*) (PamacSnapPlugin*, const gchar*, const gchar*, const gchar*)) pamac_snap_real_switch_channel;
}

static void
pamac_snap_instance_init (PamacSnap * self,
                          gpointer klass)
{
	self->priv = pamac_snap_get_instance_private (self);
	g_rec_mutex_init (&self->priv->__lock_store_snaps_cache);
	g_rec_mutex_init (&self->priv->__lock_search_snaps_cache);
	g_rec_mutex_init (&self->priv->__lock_category_snaps_cache);
	g_rec_mutex_init (&self->priv->__lock_pkgs_cache);
}

static void
pamac_snap_finalize (GObject * obj)
{
	PamacSnap * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PAMAC_TYPE_SNAP, PamacSnap);
	_g_free0 (self->priv->sender);
	_g_object_unref0 (self->priv->client);
	g_rec_mutex_clear (&self->priv->__lock_store_snaps_cache);
	_g_hash_table_unref0 (self->priv->store_snaps_cache);
	g_rec_mutex_clear (&self->priv->__lock_search_snaps_cache);
	_g_hash_table_unref0 (self->priv->search_snaps_cache);
	g_rec_mutex_clear (&self->priv->__lock_category_snaps_cache);
	_g_hash_table_unref0 (self->priv->category_snaps_cache);
	g_rec_mutex_clear (&self->priv->__lock_pkgs_cache);
	_g_hash_table_unref0 (self->priv->pkgs_cache);
	_g_object_unref0 (self->priv->cancellable);
	_g_timer_destroy0 (self->priv->timer);
	_g_hash_table_unref0 (self->priv->download_files);
	_g_free0 (self->priv->main_action);
	_g_free0 (self->priv->current_action);
	_g_free0 (self->priv->current_details);
	_g_free0 (self->priv->current_status);
	G_OBJECT_CLASS (pamac_snap_parent_class)->finalize (obj);
}

static GType
pamac_snap_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PamacSnapClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pamac_snap_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PamacSnap), 0, (GInstanceInitFunc) pamac_snap_instance_init, NULL };
	static const GInterfaceInfo pamac_snap_plugin_info = { (GInterfaceInitFunc) pamac_snap_pamac_snap_plugin_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType pamac_snap_type_id;
	pamac_snap_type_id = g_type_register_static (G_TYPE_OBJECT, "PamacSnap", &g_define_type_info, 0);
	g_type_add_interface_static (pamac_snap_type_id, PAMAC_TYPE_SNAP_PLUGIN, &pamac_snap_plugin_info);
	PamacSnap_private_offset = g_type_add_instance_private (pamac_snap_type_id, sizeof (PamacSnapPrivate));
	return pamac_snap_type_id;
}

GType
pamac_snap_get_type (void)
{
	static volatile gsize pamac_snap_type_id__once = 0;
	if (g_once_init_enter (&pamac_snap_type_id__once)) {
		GType pamac_snap_type_id;
		pamac_snap_type_id = pamac_snap_get_type_once ();
		g_once_init_leave (&pamac_snap_type_id__once, pamac_snap_type_id);
	}
	return pamac_snap_type_id__once;
}

GType
register_plugin (GModule* module)
{
	GType result;
	g_return_val_if_fail (module != NULL, 0UL);
	result = PAMAC_TYPE_SNAP;
	return result;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

