﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSMap.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/fis/FIS_EXPORTS.h>
#include <aws/fis/model/ExperimentOptions.h>
#include <aws/fis/model/ExperimentState.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace FIS {
namespace Model {

/**
 * <p>Provides a summary of an experiment.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/ExperimentSummary">AWS
 * API Reference</a></p>
 */
class ExperimentSummary {
 public:
  AWS_FIS_API ExperimentSummary() = default;
  AWS_FIS_API ExperimentSummary(Aws::Utils::Json::JsonView jsonValue);
  AWS_FIS_API ExperimentSummary& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_FIS_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The ID of the experiment.</p>
   */
  inline const Aws::String& GetId() const { return m_id; }
  inline bool IdHasBeenSet() const { return m_idHasBeenSet; }
  template <typename IdT = Aws::String>
  void SetId(IdT&& value) {
    m_idHasBeenSet = true;
    m_id = std::forward<IdT>(value);
  }
  template <typename IdT = Aws::String>
  ExperimentSummary& WithId(IdT&& value) {
    SetId(std::forward<IdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the experiment.</p>
   */
  inline const Aws::String& GetArn() const { return m_arn; }
  inline bool ArnHasBeenSet() const { return m_arnHasBeenSet; }
  template <typename ArnT = Aws::String>
  void SetArn(ArnT&& value) {
    m_arnHasBeenSet = true;
    m_arn = std::forward<ArnT>(value);
  }
  template <typename ArnT = Aws::String>
  ExperimentSummary& WithArn(ArnT&& value) {
    SetArn(std::forward<ArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ID of the experiment template.</p>
   */
  inline const Aws::String& GetExperimentTemplateId() const { return m_experimentTemplateId; }
  inline bool ExperimentTemplateIdHasBeenSet() const { return m_experimentTemplateIdHasBeenSet; }
  template <typename ExperimentTemplateIdT = Aws::String>
  void SetExperimentTemplateId(ExperimentTemplateIdT&& value) {
    m_experimentTemplateIdHasBeenSet = true;
    m_experimentTemplateId = std::forward<ExperimentTemplateIdT>(value);
  }
  template <typename ExperimentTemplateIdT = Aws::String>
  ExperimentSummary& WithExperimentTemplateId(ExperimentTemplateIdT&& value) {
    SetExperimentTemplateId(std::forward<ExperimentTemplateIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The state of the experiment.</p>
   */
  inline const ExperimentState& GetState() const { return m_state; }
  inline bool StateHasBeenSet() const { return m_stateHasBeenSet; }
  template <typename StateT = ExperimentState>
  void SetState(StateT&& value) {
    m_stateHasBeenSet = true;
    m_state = std::forward<StateT>(value);
  }
  template <typename StateT = ExperimentState>
  ExperimentSummary& WithState(StateT&& value) {
    SetState(std::forward<StateT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The time that the experiment was created.</p>
   */
  inline const Aws::Utils::DateTime& GetCreationTime() const { return m_creationTime; }
  inline bool CreationTimeHasBeenSet() const { return m_creationTimeHasBeenSet; }
  template <typename CreationTimeT = Aws::Utils::DateTime>
  void SetCreationTime(CreationTimeT&& value) {
    m_creationTimeHasBeenSet = true;
    m_creationTime = std::forward<CreationTimeT>(value);
  }
  template <typename CreationTimeT = Aws::Utils::DateTime>
  ExperimentSummary& WithCreationTime(CreationTimeT&& value) {
    SetCreationTime(std::forward<CreationTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The tags for the experiment.</p>
   */
  inline const Aws::Map<Aws::String, Aws::String>& GetTags() const { return m_tags; }
  inline bool TagsHasBeenSet() const { return m_tagsHasBeenSet; }
  template <typename TagsT = Aws::Map<Aws::String, Aws::String>>
  void SetTags(TagsT&& value) {
    m_tagsHasBeenSet = true;
    m_tags = std::forward<TagsT>(value);
  }
  template <typename TagsT = Aws::Map<Aws::String, Aws::String>>
  ExperimentSummary& WithTags(TagsT&& value) {
    SetTags(std::forward<TagsT>(value));
    return *this;
  }
  template <typename TagsKeyT = Aws::String, typename TagsValueT = Aws::String>
  ExperimentSummary& AddTags(TagsKeyT&& key, TagsValueT&& value) {
    m_tagsHasBeenSet = true;
    m_tags.emplace(std::forward<TagsKeyT>(key), std::forward<TagsValueT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The experiment options for the experiment.</p>
   */
  inline const ExperimentOptions& GetExperimentOptions() const { return m_experimentOptions; }
  inline bool ExperimentOptionsHasBeenSet() const { return m_experimentOptionsHasBeenSet; }
  template <typename ExperimentOptionsT = ExperimentOptions>
  void SetExperimentOptions(ExperimentOptionsT&& value) {
    m_experimentOptionsHasBeenSet = true;
    m_experimentOptions = std::forward<ExperimentOptionsT>(value);
  }
  template <typename ExperimentOptionsT = ExperimentOptions>
  ExperimentSummary& WithExperimentOptions(ExperimentOptionsT&& value) {
    SetExperimentOptions(std::forward<ExperimentOptionsT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_id;

  Aws::String m_arn;

  Aws::String m_experimentTemplateId;

  ExperimentState m_state;

  Aws::Utils::DateTime m_creationTime{};

  Aws::Map<Aws::String, Aws::String> m_tags;

  ExperimentOptions m_experimentOptions;
  bool m_idHasBeenSet = false;
  bool m_arnHasBeenSet = false;
  bool m_experimentTemplateIdHasBeenSet = false;
  bool m_stateHasBeenSet = false;
  bool m_creationTimeHasBeenSet = false;
  bool m_tagsHasBeenSet = false;
  bool m_experimentOptionsHasBeenSet = false;
};

}  // namespace Model
}  // namespace FIS
}  // namespace Aws
